/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System;
using System.Text.RegularExpressions;

namespace LocaleInpector
{

internal sealed class Phrases
{


private Phrases()
{
}


public static Status CheckUntranslated(string originalModule, string translatedModule)
{
    Output.OpenH1("Untranslated (ignoring keybindings and accesskeys)");
    Status stat = new Status();

    UntranslatedTest test = new UntranslatedTest();
    stat.Add(test.ParseModule(originalModule, translatedModule, "it"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "ini"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "inc"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "po"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "properties"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "dtd"));

    if (stat.Empty) {
        Output.Clear();
    }

    Output.Close();
    return stat;
}


public static Status CheckMarkup(string originalModule, string translatedModule)
{
    Output.OpenH1("XML Markup");
    Status stat = new Status();

    MarkupTest test = new MarkupTest();
    stat.Add(test.ParseModule(originalModule, translatedModule, "it"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "ini"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "inc"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "po"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "properties"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "dtd"));

    if (stat.Empty) {
        Output.Clear();
    }

    Output.Close();
    return stat;
}


public static Status CheckKeyBinding(string originalModule, string translatedModule)
{
    Output.OpenH1("Keybindings (like Ctrl+X)");
    Status stat = new Status();

    KeyBindingTest test = new KeyBindingTest();
    stat.Add(test.ParseModule(originalModule, translatedModule, "dtd"));

    if (stat.Empty) {
        Output.Clear();
    }

    Output.Close();
    return stat;
}


public static Status CheckCFormat(string originalModule, string translatedModule)
{
    Output.OpenH1("C-format expressions (like %S)");
    Status stat = new Status();

    CStyleFormatTest test = new CStyleFormatTest();

    stat.Add(test.ParseModule(originalModule, translatedModule, "properties"));
    //stat.Add(test.ParseModule(originalModule, translatedModule, "po"));

    if (stat.Empty) {
        Output.Clear();
    }

    Output.Close();
    return stat;
}


public static Status CheckEntities(string originalModule, string translatedModule)
{
    Output.OpenH1("Entities (ignoring: &nbsp; &amp; &quot; &gt; &lt; &apos;)");

    Status stat = new Status();
    stat.Add(new MalformedEntityTest().ParseModule(originalModule, translatedModule, "dtd"));
    stat.Add(new EntityTest().ParseModule(originalModule, translatedModule, "dtd"));
    stat.Add(new EntityTest().ParseModule(originalModule, translatedModule, "po"));

    if (stat.Empty) {
        Output.Clear();
    }

    Output.Close();
    return stat;
}


public static Status CheckPlaceholders(string originalModule, string translatedModule)
{
    Output.OpenH1("Text placeholders (like #2 or %url%)");
    PlaceholderExpressionsTest test = new PlaceholderExpressionsTest();

    Status stat = new Status();
    stat.Add(test.ParseModule(originalModule, translatedModule, "dtd"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "properties"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "it"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "ini"));
    stat.Add(test.ParseModule(originalModule, translatedModule, "inc"));

    if (stat.Empty) {
        Output.Clear();
    }

    Output.Close();
    return stat;
}


}//class
}//ns
