/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace LocaleInpector
{
/*
public sealed class PhraseTestsVars
{

private static PhraseTestsVars m_instance = null;


//private CStyleFormatTest            m_c = new CStyleFormatTest();
//private MalformedEntityTest         m_ent1 = new MalformedEntityTest();
//private EntityTest                  m_ent2 = new EntityTest();
//private PlaceholderExpressionsTest  m_ph = new PlaceholderExpressionsTest();


public PhraseTestsVars GetInstance()
{
    if (m_instance == null) {
        m_instance = new PhraseTestsVars();
    }
    return m_instance;
}

public bool Compare(string ori, string tra)
{
    return CStyleFormatTest.Compare(ori, tra) &&
           EntityTest.Compare(ori, tra) &&
           MalformedEntityTest.Compare(ori, tra) &&
}



}
*/


internal abstract class PhraseTest
{

public abstract string Compare(Dictionary<string, string>.Enumerator originalEntry, string translated); // ComparePhrase

protected Status m_stat;
protected string m_extension;


public Status ParseModule(string originalModule, string translatedModule, string extension)
{
    m_stat = new Status();
    m_extension = extension;

    List<string> originalFiles = BPIO.GetFileList(originalModule, "*");

    for (int idx = 0; idx < originalFiles.Count; idx++) {
        string file = originalFiles[idx];
        if (file.EndsWith("." + extension) == false) {
            continue;
        }

        NameValueFile origFile = NameValueFile.Load(originalModule + file);
        if (origFile == null) {
            // unknown format (binary, html, ...)
            continue;
        }

        m_stat.Files++;
        Dictionary<string, string> originalPhrases = origFile.LoadHashtable();

        NameValueFile transFile = NameValueFile.LoadTranslated(translatedModule + file);
        Dictionary<string, string> translatedPhrases;
        if (transFile == null) {
            // translated file is empty
            translatedPhrases = new Dictionary<string, string>();
        } else {
            translatedPhrases = transFile.LoadHashtable();
        }

        Dictionary<string, string>.Enumerator originalEntry = originalPhrases.GetEnumerator();
        while (originalEntry.MoveNext()) {


            if (translatedPhrases.ContainsKey(originalEntry.Current.Key) == false) {
                // missing translated key
                continue;
            }
            string translated = translatedPhrases[originalEntry.Current.Key];

            m_stat.Comparisons++;
            int errorsQty = m_stat.Errors;
            string error = this.Compare(originalEntry, translated);
            if (error != null) {

                string msg = "  " + error + " at " + file + " => " + originalEntry.Current.Key;

                // hack
                switch (this.Style) {
                    case "untrans":
                        //Output.WriteWarning("  " + error + " at " + file + " => " + originalEntry.Current.Key);
                        Output.WriteLine("Location: " + file + " => " + originalEntry.Current.Key);
                        Output.WriteLine("Value:    " + originalEntry.Current.Value);
                        Output.WriteLine(new string('-', 79));
                        break;

                    case "markup":
                        Output.WriteLine("File:      " + file + " => " + originalEntry.Current.Key);
                        Output.WriteLine("Error:     " + error);
                        Output.WriteLine("ORIGINAL:  " + originalEntry.Current.Value);
                        Output.WriteLine("LOCALIZED: " + translated);
                        Output.WriteLine(new string('-', 79));
                        break;

                    default:
                        bool show = false;
                        if (errorsQty == m_stat.Errors) { // has m_stat.Errors changed? it's warning
                            if (Output.WriteWarning(msg)) {
                                show = true;
                            }
                        } else {
                            // this.Compare found an error
                            Output.WriteLine("ERROR:   " + msg);
                            show = true;
                        }

                        if (show) {
                            Output.WriteLine("ORIGINAL:  " + originalEntry.Current.Value);
                            Output.WriteLine("LOCALIZED: " + translated);
                            Output.WriteLine(new string('-', 79));
                        }
                        break;

                }
            }
        }
    }

    return m_stat;
}


protected virtual string Style
{
    get {
        return null;
    }
}


protected static bool MatchRegex(Regex regex, string originalPhrase, string translatedPhrase, string[] exceptions)
{
    MatchCollection originalMatches = regex.Matches(originalPhrase);
    MatchCollection translatedMatches = regex.Matches(translatedPhrase);

    List<string> original = new List<string>();
    List<string> translated = new List<string>();

    // populate original
    for (int idx = 0; idx < originalMatches.Count; idx++) {
        GroupCollection groups = originalMatches[idx].Groups;
        string ent = groups[groups.Count - 1].Value;
        if (System.Array.IndexOf(exceptions, ent) == -1) {
            original.Add(ent);
        }
    }

    // populate translated
    for (int idx = 0; idx < translatedMatches.Count; idx++) {
        GroupCollection groups = translatedMatches[idx].Groups;
        string ent = groups[groups.Count - 1].Value;
        if (System.Array.IndexOf(exceptions, ent) == -1) {
            translated.Add(ent);
        }
    }

    if (original.Count != translated.Count) {
        return false;
    }

    original.Sort();
    translated.Sort();

    for (int idx = 0; idx < original.Count; idx++) {
        if (original[idx] != translated[idx]) {
            return false;
        }
    }

    return true;
}

}//class
}//ns