/*
 * Decompiled with CFR 0.152.
 */
package mozilla_training_analyzer;

import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mozilla_training_analyzer.AboutBox;
import mozilla_training_analyzer.Globals;
import mozilla_training_analyzer.MozillaSpamToken;
import mozilla_training_analyzer.TableWindow;
import mozilla_training_analyzer.TrainingData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Analyzer {
    private static final int numTokensBeforeTick = 250;
    public static final int OUTPUT_TEXT = 1;
    public static final int OUTPUT_HTML = 2;
    public static final int OUTPUT_XML = 3;
    public static final int OUTPUT_DATA = 4;
    public static final int INVALID_ARG = -3;
    public static final int GEN_ERROR = -1;
    public static final int SUCCESS = 0;
    public static final String VER_STRING = "Bayes Junk Tool Ver. 0.2";
    public static final String PROGRAM_USAGE = "Bayes Junk Tool Ver. 0.2\n\nValid command-line arguments for this program are:\n\n-q, --quiet == silent execution of program\n-g, --gui == start up GUI version of program\n-h, -?, --help == display program usage (this message)\n-v, --version == display program version\n-f, --format [ xml | html | text | data ] == program output format\n-rg, --remove-good [number] == Remove all tokens with a good or bad count\n-rb, --remove-bad [number]  == less than the given number. If both are\nspecified, those tokens which satisfy either one OR the other will be kept.\n-o, --outputfile [filename] == path to program output file\n-m, --merge [filename] == path to XML or .dat file to merge with inputfile\n-i, --inputfile [filename] == path to Mozilla training.dat\n\nPlease note that the input file must include the training.dat\nfilename, e.g. [path-to-profile]/xxxxxxxx.slt/training.dat\n";

    private Analyzer() {
    }

    public static boolean checkHeader(byte[] byArray) {
        return (byArray[0] + 256) % 256 == 254 && (byArray[1] + 256) % 256 == 237 && (byArray[2] + 256) % 256 == 250 && (byArray[3] + 256) % 256 == 206;
    }

    public static MozillaSpamToken readNextToken(InputStream inputStream, byte[] byArray, boolean bl) throws IOException, IllegalArgumentException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inFile cannot be null!");
        }
        if (byArray.length != 4) {
            throw new IllegalArgumentException("inBytes must have a length of 4!");
        }
        inputStream.read(byArray);
        int n = Globals.makeInt(byArray);
        inputStream.read(byArray);
        int n2 = Globals.makeInt(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < n2; ++i) {
            byteArrayOutputStream.write(inputStream.read());
        }
        return new MozillaSpamToken(new String(byteArrayOutputStream.toByteArray(), "UTF-8"), bl ? n : 0, bl ? 0 : n);
    }

    public static TrainingData parseTrainingFile(String string, boolean bl) throws IOException {
        int n;
        if (string == null) {
            return null;
        }
        File file = new File(string);
        FileInputStream fileInputStream = null;
        if (!file.exists()) {
            return null;
        }
        fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[4];
        fileInputStream.read(byArray);
        if (!Analyzer.checkHeader(byArray)) {
            if (bl) {
                System.err.println(string + " is either not a Mozilla Bayesian filter" + " token file or is corrupt.");
            }
            return null;
        }
        TrainingData trainingData = new TrainingData();
        fileInputStream.read(byArray);
        int n2 = Globals.makeInt(byArray);
        fileInputStream.read(byArray);
        int n3 = Globals.makeInt(byArray);
        fileInputStream.read(byArray);
        int n4 = Globals.makeInt(byArray);
        trainingData.setGoodMessageCount(n2);
        trainingData.setBadMessageCount(n3);
        if (bl) {
            System.out.println("The number of good messages processed is " + n2);
            System.out.println("The number of bad messages processed is " + n3);
            System.out.print("Now processing " + n4 + " good tokens");
        }
        TreeSet<MozillaSpamToken> treeSet = new TreeSet<MozillaSpamToken>();
        for (n = 0; n < n4; ++n) {
            treeSet.add(Analyzer.readNextToken(fileInputStream, byArray, true));
            if (!bl || n % 250 != 0) continue;
            System.out.print('.');
        }
        fileInputStream.read(byArray);
        n = Globals.makeInt(byArray);
        if (bl) {
            System.out.print("\nNow processing " + n + " bad tokens");
        }
        TreeSet<MozillaSpamToken> treeSet2 = new TreeSet<MozillaSpamToken>();
        for (int i = 0; i < n; ++i) {
            treeSet2.add(Analyzer.readNextToken(fileInputStream, byArray, false));
            if (!bl || i % 250 != 0) continue;
            System.out.print('.');
        }
        fileInputStream.close();
        if (bl) {
            System.out.println("\nMerging token lists...");
        }
        TreeSet treeSet3 = Analyzer.mergeTokenLists(treeSet, treeSet2);
        trainingData.setTokenSet(treeSet3);
        trainingData.validateTokenCount();
        return trainingData;
    }

    public static TrainingData parseXMLTrainingFile(String string, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        TrainingData trainingData;
        File file;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (string != null) {
            file = new File(string);
            if (!file.exists()) {
                return null;
            }
        } else {
            return null;
        }
        if (bl) {
            System.out.println("Now generating XML DOM document for " + string);
        }
        Document document = documentBuilder.parse(file);
        if (bl) {
            System.out.println("Generation complete. Now parsing DOM tree...");
        }
        if (document.getDoctype().getNodeName().equals("tokenfile")) {
            trainingData = new TrainingData();
            String string2 = document.getElementsByTagName("good_msgs").item(0).getChildNodes().item(0).getNodeValue();
            trainingData.setGoodMessageCount(Integer.parseInt(string2));
            String string3 = document.getElementsByTagName("bad_msgs").item(0).getChildNodes().item(0).getNodeValue();
            trainingData.setBadMessageCount(Integer.parseInt(string3));
            NodeList nodeList = document.getElementsByTagName("token");
            TreeSet<MozillaSpamToken> treeSet = new TreeSet<MozillaSpamToken>();
            String string4 = null;
            int n = -1;
            int n2 = -1;
            MozillaSpamToken mozillaSpamToken = null;
            Node node = null;
            Node node2 = null;
            NodeList nodeList2 = null;
            if (bl) {
                System.out.println("The number of good messages processed is " + trainingData.getGoodMessageCount());
                System.out.println("The number of bad messages processed is " + trainingData.getBadMessageCount());
                System.out.print("Now processing " + nodeList.getLength() + " tokens");
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (bl && i % 250 == 0) {
                    System.out.print('.');
                }
                node = nodeList.item(i);
                nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1) continue;
                    if (node2.getNodeName().equals("good")) {
                        n = Integer.parseInt(node2.getChildNodes().item(0).getNodeValue());
                        continue;
                    }
                    if (node2.getNodeName().equals("bad")) {
                        n2 = Integer.parseInt(node2.getChildNodes().item(0).getNodeValue());
                        continue;
                    }
                    if (!node2.getNodeName().equals("name")) continue;
                    string4 = node2.getChildNodes().item(0).getNodeValue();
                }
                mozillaSpamToken = new MozillaSpamToken(string4, n, n2);
                treeSet.add(mozillaSpamToken);
            }
            if (bl) {
                System.out.println();
            }
            trainingData.setTokenSet(treeSet);
            trainingData.validateTokenCount();
        } else {
            System.err.println(string + " is not a Mozilla Bayesian filter" + " XML file - it has DOCTYPE [" + document.getDoctype().getNodeName() + "], and DOCTYPE [tokenfile] was expected.");
            trainingData = null;
        }
        return trainingData;
    }

    public static TreeSet mergeTokenLists(TreeSet treeSet, TreeSet treeSet2) {
        TreeSet<MozillaSpamToken> treeSet3 = new TreeSet<MozillaSpamToken>(treeSet);
        Iterator iterator = treeSet2.iterator();
        MozillaSpamToken mozillaSpamToken = null;
        MozillaSpamToken mozillaSpamToken2 = null;
        while (iterator.hasNext()) {
            mozillaSpamToken = (MozillaSpamToken)iterator.next();
            if (treeSet3.contains(mozillaSpamToken)) {
                mozillaSpamToken2 = treeSet3.tailSet(mozillaSpamToken).first();
                mozillaSpamToken2.setBadTokenCount(mozillaSpamToken2.getBadTokenCount() + mozillaSpamToken.getBadTokenCount());
                mozillaSpamToken2.setGoodTokenCount(mozillaSpamToken2.getGoodTokenCount() + mozillaSpamToken.getGoodTokenCount());
                continue;
            }
            treeSet3.add(mozillaSpamToken);
        }
        mozillaSpamToken = null;
        mozillaSpamToken2 = null;
        return treeSet3;
    }

    public static void writeOutput(File file, TrainingData trainingData, int n) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 65536);
        switch (n) {
            case 1: {
                trainingData.toTextDocument(bufferedOutputStream);
                break;
            }
            case 2: {
                trainingData.toHTMLDocument(bufferedOutputStream);
                break;
            }
            case 3: {
                trainingData.toXMLDocument(bufferedOutputStream);
                trainingData.writeXMLDTD(new File(file.getParentFile(), "trainer_xml.dtd"));
                break;
            }
            case 4: {
                trainingData.outputTrainingDataFileContents(bufferedOutputStream);
                break;
            }
            default: {
                System.err.println("Unknown format output type: " + n);
            }
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        int n = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = -1;
        int n3 = -1;
        boolean bl5 = false;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-q") || stringArray[i].equalsIgnoreCase("--quiet")) {
                    if (bl) {
                        bl = false;
                    } else {
                        bl5 = true;
                    }
                } else if (stringArray[i].equalsIgnoreCase("-h") || stringArray[i].equalsIgnoreCase("-?") || stringArray[i].equalsIgnoreCase("--help")) {
                    if (bl4) {
                        bl5 = true;
                    } else {
                        bl4 = true;
                    }
                } else if (stringArray[i].equalsIgnoreCase("-v") || stringArray[i].equalsIgnoreCase("--version")) {
                    if (bl3) {
                        bl5 = true;
                    } else {
                        bl3 = true;
                    }
                } else if (stringArray[i].equalsIgnoreCase("-g") || stringArray[i].equalsIgnoreCase("--gui")) {
                    if (bl2) {
                        bl5 = true;
                    } else {
                        bl2 = true;
                    }
                } else if (stringArray[i].equalsIgnoreCase("-f") || stringArray[i].equalsIgnoreCase("--format")) {
                    if (stringArray[i + 1].equalsIgnoreCase("text")) {
                        n = 1;
                    } else if (stringArray[i + 1].equalsIgnoreCase("html")) {
                        n = 2;
                    } else if (stringArray[i + 1].equalsIgnoreCase("xml")) {
                        n = 3;
                    } else if (stringArray[i + 1].equalsIgnoreCase("data")) {
                        n = 4;
                    } else {
                        System.err.println("An invalid output type was specified: " + stringArray[i + 1]);
                        System.err.println("Acceptable values are xml, html, text, and data.");
                        System.err.println(PROGRAM_USAGE);
                        System.exit(-3);
                    }
                    ++i;
                } else if (stringArray[i].equalsIgnoreCase("-o") || stringArray[i].equalsIgnoreCase("--outputfile")) {
                    if (string2 == null) {
                        string2 = stringArray[i + 1];
                    } else {
                        bl5 = true;
                    }
                    ++i;
                } else if (stringArray[i].equalsIgnoreCase("-m") || stringArray[i].equalsIgnoreCase("--merge")) {
                    if (string3 == null) {
                        string3 = stringArray[i + 1];
                    } else {
                        bl5 = true;
                    }
                    ++i;
                } else if (stringArray[i].equalsIgnoreCase("-i") || stringArray[i].equalsIgnoreCase("--inputfile")) {
                    if (string == null) {
                        string = stringArray[i + 1];
                    } else {
                        bl5 = true;
                    }
                    ++i;
                } else if (stringArray[i].equalsIgnoreCase("-rg") || stringArray[i].equalsIgnoreCase("--remove-good")) {
                    if (n2 == -1) {
                        n2 = Integer.parseInt(stringArray[i + 1]);
                    } else {
                        bl5 = true;
                    }
                    ++i;
                } else if (stringArray[i].equalsIgnoreCase("-rb") || stringArray[i].equalsIgnoreCase("--remove-bad")) {
                    if (n3 == -1) {
                        n3 = Integer.parseInt(stringArray[i + 1]);
                    } else {
                        bl5 = true;
                    }
                    ++i;
                } else {
                    System.err.println("An invalid argument was specified: " + stringArray[i]);
                    System.err.println(PROGRAM_USAGE);
                    System.exit(-3);
                }
                if (!bl5) continue;
                System.err.println("An duplicate argument was encountered: " + stringArray[i]);
                System.err.println(PROGRAM_USAGE);
                System.exit(-3);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("An argument was not specified for: " + stringArray[stringArray.length - 1]);
            System.err.println(PROGRAM_USAGE);
            System.exit(-3);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(numberFormatException.getMessage());
            System.err.println(PROGRAM_USAGE);
            System.exit(-3);
        }
        if (bl3) {
            if (bl2) {
                AboutBox.display(null);
            } else {
                System.out.println(VER_STRING);
            }
        }
        if (bl4) {
            if (bl2) {
                JOptionPane.showMessageDialog(null, PROGRAM_USAGE, "Bayes Junk Tool Help", -1);
            } else {
                System.out.println(PROGRAM_USAGE);
            }
        }
        if (bl4 || bl3) {
            System.exit(0);
        }
        if (string2 == null) {
            bl2 = true;
        }
        if (n == -1) {
            n = 1;
        }
        try {
            Serializable serializable;
            TrainingData trainingData;
            block90: {
                JFileChooser jFileChooser;
                File file = null;
                if (string == null) {
                    if (bl2) {
                        jFileChooser = new JFileChooser();
                        jFileChooser.setDialogTitle("Select Mozilla Bayesian Filter training.dat");
                        int n4 = jFileChooser.showOpenDialog(null);
                        if (n4 == 0) {
                            file = jFileChooser.getSelectedFile();
                            string = file.getAbsolutePath();
                        } else {
                            System.err.println("An input file must be specified.");
                            System.exit(-1);
                        }
                    } else {
                        System.out.println("Please specify the location of the Mozilla Bayesian Filter training file:");
                        string = new BufferedReader(new InputStreamReader(System.in)).readLine();
                        file = new File(string);
                    }
                } else {
                    file = new File(string);
                }
                jFileChooser = null;
                if (!file.exists()) {
                    System.err.println(string + " does not exist!");
                    System.exit(-1);
                }
                if (bl) {
                    System.out.println("Checking if " + string + " is a Mozilla token file...");
                }
                if ((trainingData = Analyzer.parseTrainingFile(string, bl)) == null) {
                    if (bl) {
                        System.out.println("Checking if " + string + " is an XML token file...");
                    }
                    try {
                        trainingData = Analyzer.parseXMLTrainingFile(string, bl);
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                    }
                    catch (SAXException sAXException) {
                        // empty catch block
                    }
                    if (trainingData == null) {
                        System.err.println("An error was encountered while reading " + string);
                        System.exit(-1);
                    }
                }
                if (string3 != null) {
                    serializable = new File(string3);
                    String string4 = ((File)serializable).getAbsolutePath();
                    try {
                        TrainingData trainingData2;
                        if (bl) {
                            System.out.println("Checking if " + string4 + " is a Mozilla token file...");
                        }
                        if ((trainingData2 = Analyzer.parseTrainingFile(string4, bl)) == null) {
                            if (bl) {
                                System.out.println("Checking if " + string4 + " is an XML token file...");
                            }
                            trainingData2 = Analyzer.parseXMLTrainingFile(string4, bl);
                        }
                        if (trainingData2 == null) {
                            if (bl) {
                                System.out.println(string4 + " was not a valid Mozilla token file or XML token file.");
                            }
                        } else {
                            trainingData2.setGoodMessageCount(trainingData2.getGoodMessageCount() + trainingData.getGoodMessageCount());
                            trainingData2.setBadMessageCount(trainingData2.getBadMessageCount() + trainingData.getBadMessageCount());
                            trainingData2.setTokenSet(Analyzer.mergeTokenLists(trainingData2.getTokenSet(), trainingData.getTokenSet()));
                            trainingData = trainingData2;
                            if (bl) {
                                System.out.println("Merge complete!");
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (!bl) break block90;
                        System.out.println(exception.getMessage());
                        System.out.println(string4 + " was not a valid Mozilla token file or XML token file.");
                    }
                }
            }
            trainingData.removeTokens(n2, n3);
            if (bl2) {
                if (bl) {
                    System.out.println("Launching GUI...");
                }
                serializable = new TableWindow(trainingData, string);
                ((Window)serializable).show();
                ((TableWindow)serializable).setOutputFilename(string2);
                ((TableWindow)serializable).waitForWindow();
            } else {
                serializable = new File(string2);
                if (bl) {
                    System.out.println("Writing tokens to " + string2);
                }
                Analyzer.writeOutput((File)serializable, trainingData, n);
                if (bl) {
                    System.out.println("Program complete. Output has been written to " + string2);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(-1);
        }
        System.exit(0);
    }
}

