/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.XMLParseException;

public class XMLEntityResolver
implements IXMLEntityResolver {
    private Hashtable entities = new Hashtable();

    public XMLEntityResolver() {
        this.entities.put("amp", "&#38;#38;");
        this.entities.put("quot", "&#38;#34;");
        this.entities.put("apos", "&#38;#39;");
        this.entities.put("lt", "&#38;#60;");
        this.entities.put("gt", "&#38;#62;");
    }

    protected void finalize() throws Throwable {
        this.entities.clear();
        this.entities = null;
        super.finalize();
    }

    public void addInternalEntity(String string, String string2) {
        if (!this.entities.containsKey(string)) {
            this.entities.put(string, string2);
        }
    }

    public void addExternalEntity(String string, String string2, String string3) {
        if (!this.entities.containsKey(string)) {
            this.entities.put(string, new String[]{string2, string3});
        }
    }

    public Reader getEntity(IXMLReader iXMLReader, String string) throws XMLParseException {
        Object v = this.entities.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return new StringReader((String)v);
        }
        String[] stringArray = (String[])v;
        return this.openExternalEntity(iXMLReader, stringArray[0], stringArray[1]);
    }

    protected Reader openExternalEntity(IXMLReader iXMLReader, String string, String string2) throws XMLParseException {
        try {
            return iXMLReader.openStream(string, string2);
        }
        catch (Exception exception) {
            throw new XMLParseException(iXMLReader.getSystemID(), iXMLReader.getLineNr(), "Could not open external entity at system ID: " + string2);
        }
    }
}

