/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.installer.VariableSubstitutor;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class ScriptParser {
    public static final String INSTALL_PATH = "INSTALL_PATH";
    public static final String JAVA_HOME = "JAVA_HOME";
    public static final String USER_HOME = "USER_HOME";
    public static final String USER_NAME = "USER_NAME";
    public static final String FILE_SEPARATOR = "FILE_SEPARATOR";
    public static final String APP_NAME = "APP_NAME";
    public static final String APP_URL = "APP_URL";
    public static final String APP_VER = "APP_VER";
    public static final String ISO3_LANG = "ISO3_LANG";
    private Collection files;
    private VariableSubstitutor vs;

    public ScriptParser(Collection collection, VariableSubstitutor variableSubstitutor) {
        this.files = collection;
        this.vs = variableSubstitutor;
    }

    public void parseFiles() throws Exception {
        Iterator iterator = this.files.iterator();
        while (iterator.hasNext()) {
            ParsableFile parsableFile = (ParsableFile)iterator.next();
            if (!OsConstraint.oneMatchesCurrentSystem(parsableFile.osConstraints)) continue;
            File file = new File(parsableFile.path);
            File file2 = File.createTempFile("izpp", null, file.getParentFile());
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 5120);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 5120);
            this.vs.substitute(bufferedInputStream, bufferedOutputStream, parsableFile.type, parsableFile.encoding);
            bufferedInputStream.close();
            bufferedOutputStream.close();
            file.delete();
            if (file2.renameTo(file)) continue;
            throw new IOException("Could not rename file " + file2 + " to " + file);
        }
    }
}

