%{
/*
 * Copyright (C) 1999, 2000, 2001, 2002  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
  Scanner for Python, version 0.3
  Written by Martin "Murphy" Gebert <Murphy.Gebert@gmx.de>
  Modified by Lorenzo Bettini <bettini@gnu.org>
*/

static int lineno = 1 ; /* number of scanned lines */
//char linebuf[1024] ; /* current code line in the source */
//int tokenpos = 0 ; /* current token position in the current line */

//#include "tags.h"
//#include "tokens.h"
//#include "colors.h"

#include "genfun.h"

%}
%option prefix="python_scanner_"
%option noyywrap


nl \n
cr \r
STRING \"[^\"\n]*\"
not_alpha [^a-zA-Z0-9]

%s COMMENT_STATE
%s SINGLELINE_COMMENT
%s STRING_STATE
%s CHAR_STATE

IDE [a-zA-Z_]([a-zA-Z0-9_])*
wspace [ \t\n\r]
templspec \<({wspace}|{IDE})*\>


keyword1 (and|assert|break|class|continue|def|del|elif|else|except|exec)
keyword2 (finally|for|from|global|if|import|in|is|lambda|not|or|pass)
keyword3 (print|raise|return|try|while)

keyword ({keyword1}|{keyword2}|{keyword3})
basetype (\0)
symbol [\~\!\%\^\*\(\)\-\+\=\[\]\|\\\:\;\,\.\/\?\&\<\>\{\}]
cbracket [\0]

funccall {IDE}/{wspace}*({templspec}){0,1}{wspace}*\(

%%

<INITIAL>^[ \t]*"\"\"\"" { BEGIN COMMENT_STATE ;
       startComment( yytext ) ;
     }
<INITIAL>"\"\"\"".*"\"\"\"" { generateComment( yytext ) ;  }

<COMMENT_STATE>\r*\n {
   endComment (""); 
   ++lineno;
   generateNewLine(yytext) ;
   startComment ("");
   /* if we encounter another // during a comment we simply
      treat it as a ordinary string */
 }
<COMMENT_STATE>"\"\"\"" { endComment(yytext) ;
                      BEGIN INITIAL ; /* end of the comment */ }

<INITIAL>^[ \t]*"\'\'\'" { BEGIN COMMENT_STATE ;
       startComment( yytext ) ;
     }
<INITIAL>"\'\'\'".*"\'\'\'" { generateComment( yytext ) ;  }

<COMMENT_STATE>\r*\n {
   endComment (""); 
   ++lineno;
   generateNewLine(yytext) ;
   startComment ("");
   /* if we encounter another // during a comment we simply
      treat it as a ordinary string */
 }
<COMMENT_STATE>"\'\'\'" { endComment(yytext) ;
                      BEGIN INITIAL ; /* end of the comment */ }

<INITIAL>"#" { BEGIN SINGLELINE_COMMENT ; startComment( yytext ) ; }
<SINGLELINE_COMMENT>\r*\n { 
   BEGIN INITIAL ; 
   yyless (0); // put the \n back
   endComment( yytext ) ; 
 }

<INITIAL>^[ \t]*\"[^"\n]*\"/\n { BEGIN SINGLELINE_COMMENT ; startComment( yytext ) ; }
<SINGLELINE_COMMENT>\r*\n { 
   BEGIN INITIAL ; 
   yyless (0); // put the \n back
   endComment( yytext ) ; 
 }

<INITIAL>^[ \t]*\'[^'\n]*\'/\n { BEGIN SINGLELINE_COMMENT ; startComment( yytext ) ; }
<SINGLELINE_COMMENT>\r*\n { 
   BEGIN INITIAL ; 
   yyless (0); // put the \n back
   endComment( yytext ) ; 
 }

<INITIAL>\" { BEGIN STRING_STATE ; startString( yytext );  }
<STRING_STATE>\\\\ {  generate_preproc( yytext ) ; }
<STRING_STATE>"\\\"" {  generate_preproc( yytext ) ; }
<STRING_STATE>\n { 
   endString (""); 
   ++lineno;
   generateNewLine() ;
   startString ("");
}
<STRING_STATE>\" { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>\' { BEGIN CHAR_STATE ; startString( yytext );  }
<CHAR_STATE>\\\\ {  generate_preproc( yytext ) ; }
<CHAR_STATE>"\\\'" {  generate_preproc( yytext ) ; }
<CHAR_STATE>\n { 
   endString (""); 
   ++lineno;
   generateNewLine() ;
   startString ("");
}
<CHAR_STATE>\' { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>[\0] { generatePreProc( yytext) ; }

<INITIAL>{keyword} { generateKeyWord( yytext ) ; }
<INITIAL>{basetype} { generateBaseType( yytext ) ; }
<INITIAL>{symbol} { generateSymbol( yytext ); }
<INITIAL>[\{\}] { generateCBracket ( yytext ); }

<INITIAL>{keyword}/{wspace}*\( { generateKeyWord( yytext ) ; }
<INITIAL>{basetype}/{wspace}*\( { generateBaseType( yytext ) ; }
<INITIAL>{funccall} { generateFunction ( yytext ); }

<INITIAL>0[xX][0-9a-fA-F]* { generateNumber( yytext ) ; }
<INITIAL>[0-9][0-9]*(\.[0-9]*[eE]?[-+]?[0-9]*)? { generateNumber( yytext ) ; }

<INITIAL>\<[^\"\n ]*\> { generateString (yytext); }

<INITIAL>[a-zA-Z_]([a-zA-Z0-9_])* { generate_normal( yytext ) ; }

\t {
        generateTab() ;
}

\r* {
        generate_preproc(&yytext[yyleng-1]);
        // skip the previous ones, only generate one
}

. { generate_preproc( yytext ) ; /* anything else */ }

\n { 
       ++lineno;
       generateNewLine() ;
}

%%
/*
void yyerror( char *s ) ;

void yyerror( char *s )
{  
  fprintf( stderr, "%d: %s: %s\n%s\n", lineno, s, yytext, linebuf ) ;
  fprintf( stderr, "%*s\n", tokenpos, "^" ) ;
}
*/
/* vim:set ft=flex expandtab cindent tabstop=4 softtabstop=4 shiftwidth=4 textwidth=0: */
