/*
 * Copyright (C) 1999, 2000, 2002, 2003  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

// decorators for esc codes

/**
   Decorate text with terminal control sequences (escape sequences).

   To set the attribute/fg_color/bg_color we need to print
   "\033[AA;FF;BBm"
   where AA is one of these:
   00=none 01=bold 04=underscore 05=blink 07=reverse 08=concealed,
   FF is one of these:
   30=black 31=red 32=green 33=yellow 34=blue 35=magenta 36=cyan 37=white
   BB is one of these:
   40=black 41=red 42=green 43=yellow 44=blue 45=magenta 46=cyan 47=white

   Any of AA,FF,BB may be omited.

   To reset do default color/attribute we need to print
   "\033[m"

   originally written by "Konstantine 'KCC' Serebriany" <kcc@mcst.ru>
*/   

#ifndef ESCDECORATOR_H
#define ESCDECORATOR_H

#include "decorators.h"
#include "globalostream.h"

#include <string>

using std::string;

class CharTranslator;

class EscDecorator: public TextDecorator
{
 private:
  string face;

 public:
  EscDecorator(TextGenerator *t, CharTranslator *ct,
                const string &face_arg);
  virtual ~EscDecorator();
  virtual void startDecorate();
  virtual void endDecorate();

  void enrich_face(const string &f) { face = f + ";" + face; }
  const string &get_face() const { return face; }

 private:
  // Set fg color and attribute. Do not touch bg color.
  void LeftEsc() const {
    (*sout) << "\033[" << face  << "m";
  }
  // restore default color and shape
  void RightEsc() const {
    (*sout) << "\033[m";
  }
};


#endif // ESCDECORATOR_H
