/* means.c		-*- mode: c; buffer-read-only: t -*-

   Generated by q2c from ../../src/means.q on Sat Aug 25 19:50:46 2007.
   Do not modify!
 */
#line 1 "../../src/means.q"
/* PSPP - computes sample statistics.
   Copyright (C) 1997-9, 2000 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 3 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA. */

#include <config.h>
#include <stdlib.h>
#include <stdio.h>
#include "dictionary.h"
#include "error.h"
#include "alloc.h"
#include "command.h"
#include "hash.h"
#include "lexer.h"
#include "error.h"
#include "magic.h"
#include "var.h"

#include "gettext.h"
#define _(msgid) gettext (msgid)

#line 43 "means.c"
#include <stdlib.h>
#include "alloc.h"
#include "error.h"
#include "lexer.h"
#include "settings.h"
#include "str.h"
#include "subclist.h"
#include "var.h"

#include "gettext.h"
#define _(msgid) gettext (msgid)

#line 37 "../../src/means.q"

#include "debug-print.h"

#line 60 "means.c"
#line 51 "../../src/means.q"
#line 62 "means.c"
/* Settings for subcommand specifiers. */
enum
  {
    MNS_LABELS = 1000,
    MNS_NOLABELS,
    MNS_NOCATLABS,
    MNS_NAMES,
    MNS_NONAMES,
    MNS_VALUES,
    MNS_NOVALUES,
    MNS_TABLE,
    MNS_TREE,
    MNS_INCLUDE,
    MNS_DEPENDENT
  };

#define MAXLISTS 10
/* Array indices for CELLS subcommand. */
enum
  {
    MNS_CL_DEFAULT = 0,
    MNS_CL_COUNT = 1,
    MNS_CL_SUM = 2,
    MNS_CL_MEAN = 3,
    MNS_CL_STDDEV = 4,
    MNS_CL_VARIANCE = 5,
    MNS_CL_ALL = 6,
    MNS_CL_count
  };

/* Array indices for STATISTICS subcommand. */
enum
  {
    MNS_ST_ANOVA = 0,
    MNS_ST_LINEARITY = 1,
    MNS_ST_ALL = 2,
    MNS_ST_NONE = 3,
    MNS_ST_count
  };

/* MEANS structure. */
struct cmd_means
  {
    /* TABLES subcommand. */
    int sbc_tables;
    
    /* FORMAT subcommand. */
    int sbc_format;
    long lab;
    long name;
    long val;
    long fmt;
    
    /* MISSING subcommand. */
    int sbc_missing;
    long miss;
    
    /* CELLS subcommand. */
    int sbc_cells;
    int a_cells[MNS_CL_count];
    
    /* STATISTICS subcommand. */
    int sbc_statistics;
    int a_statistics[MNS_ST_count];
  };

/* Prototype for custom subcommands of MEANS. */
static int mns_custom_tables (struct cmd_means *);

/* Command parsing functions. */
static int parse_means (struct cmd_means *);
static void free_means (struct cmd_means *);

#line 52 "../../src/means.q"
#line 137 "means.c"
static int
parse_means (struct cmd_means *p)
{
  p->sbc_tables = 0;
  p->sbc_format = 0;
  p->lab = MNS_LABELS;
  p->name = MNS_NAMES;
  p->val = MNS_VALUES;
  p->fmt = MNS_TABLE;
  p->sbc_missing = 0;
  p->miss = MNS_TABLE;
  p->sbc_cells = 0;
  memset (p->a_cells, 0, sizeof p->a_cells);
  p->sbc_statistics = 0;
  memset (p->a_statistics, 0, sizeof p->a_statistics);
  for (;;)
    {
      switch (mns_custom_tables (p))
        {
        case 0:
          goto lossage;
        case 1:
          p->sbc_tables++;
          continue;
        case 2:
          break;
        default:
          assert (0);
        }
      if (lex_match_id ("TABLES"))
        {
          lex_match ('=');
          p->sbc_tables++;
          switch (mns_custom_tables (p))
            {
            case 0:
              goto lossage;
            case 1:
              break;
            case 2:
              lex_error (NULL);
              goto lossage;
            default:
              assert (0);
            }
        }
      else if (lex_match_id ("FORMAT"))
        {
          lex_match ('=');
          p->sbc_format++;
          if (p->sbc_format > 1)
            {
              msg (SE, _("FORMAT subcommand may be given only once."));
              goto lossage;
            }
          while (token != '/' && token != '.')
            {
              if (lex_match_id ("LABELS"))
                p->lab = MNS_LABELS;
              else if (lex_match_id ("NOLABELS"))
                p->lab = MNS_NOLABELS;
              else if (lex_match_id ("NOCATLABS"))
                p->lab = MNS_NOCATLABS;
              else if (lex_match_id ("NAMES"))
                p->name = MNS_NAMES;
              else if (lex_match_id ("NONAMES"))
                p->name = MNS_NONAMES;
              else if (lex_match_id ("VALUES"))
                p->val = MNS_VALUES;
              else if (lex_match_id ("NOVALUES"))
                p->val = MNS_NOVALUES;
              else if (lex_match_id ("TABLE"))
                p->fmt = MNS_TABLE;
              else if (lex_match_id ("TREE"))
                p->fmt = MNS_TREE;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if (lex_match_id ("MISSING"))
        {
          lex_match ('=');
          p->sbc_missing++;
          if (p->sbc_missing > 1)
            {
              msg (SE, _("MISSING subcommand may be given only once."));
              goto lossage;
            }
          while (token != '/' && token != '.')
            {
              if (lex_match_id ("TABLE"))
                p->miss = MNS_TABLE;
              else if (lex_match_id ("INCLUDE"))
                p->miss = MNS_INCLUDE;
              else if (lex_match_id ("DEPENDENT"))
                p->miss = MNS_DEPENDENT;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if (lex_match_id ("CELLS"))
        {
          lex_match ('=');
          p->sbc_cells++;
          if (p->sbc_cells > 1)
            {
              msg (SE, _("CELLS subcommand may be given only once."));
              goto lossage;
            }
          while (token != '/' && token != '.')
            {
              if (lex_match_id ("DEFAULT"))
                p->a_cells[MNS_CL_DEFAULT] = 1;
              else if (lex_match_id ("COUNT"))
                p->a_cells[MNS_CL_COUNT] = 1;
              else if (lex_match_id ("SUM"))
                p->a_cells[MNS_CL_SUM] = 1;
              else if (lex_match_id ("MEAN"))
                p->a_cells[MNS_CL_MEAN] = 1;
              else if (lex_match_id ("STDDEV"))
                p->a_cells[MNS_CL_STDDEV] = 1;
              else if (lex_match_id ("VARIANCE"))
                p->a_cells[MNS_CL_VARIANCE] = 1;
              else if (lex_match (T_ALL))
                p->a_cells[MNS_CL_ALL] = 1;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if (lex_match_id ("STATISTICS"))
        {
          lex_match ('=');
          p->sbc_statistics++;
          if (p->sbc_statistics > 1)
            {
              msg (SE, _("STATISTICS subcommand may be given only once."));
              goto lossage;
            }
          while (token != '/' && token != '.')
            {
              if (lex_match_id ("ANOVA"))
                p->a_statistics[MNS_ST_ANOVA] = 1;
              else if (lex_match_id ("LINEARITY"))
                p->a_statistics[MNS_ST_LINEARITY] = 1;
              else if (lex_match (T_ALL))
                p->a_statistics[MNS_ST_ALL] = 1;
              else if (lex_match_id ("NONE"))
                p->a_statistics[MNS_ST_NONE] = 1;
              else
                {
                  lex_error (NULL);
                  goto lossage;
                }
              lex_match (',');
            }
        }
      else if ( get_syntax() != COMPATIBLE && lex_match_id("ALGORITHM"))
        {
          lex_match ('=');
          if (lex_match_id("COMPATIBLE"))
            set_cmd_algorithm(COMPATIBLE);
          else if (lex_match_id("ENHANCED"))
            set_cmd_algorithm(ENHANCED);
          }
        if (!lex_match ('/'))
          break;
      }
    
    if (token != '.')
      {
        lex_error (_("expecting end of command"));
        goto lossage;
      }
      
  return 1;
  
lossage:
  free_means (p);
  return 0;
}

static void
free_means (struct cmd_means *p UNUSED)
{
}
#line 53 "../../src/means.q"

/* TABLES: Variable lists for each dimension. */
int n_dim;		/* Number of dimensions. */
int *nv_dim;		/* Number of variables in each dimension. */
struct variable ***v_dim;	/* Variables in each dimension.  */

/* VARIABLES: List of variables. */
int n_var;
struct variable **v_var;

/* Parses and executes the T-TEST procedure. */
int
cmd_means (void)
{
  struct cmd_means cmd;
  int success = CMD_FAILURE;
  
  n_dim = 0;
  nv_dim = NULL;
  v_dim = NULL;
  v_var = NULL;

  if (!parse_means (&cmd))
    goto free;

  if (cmd.sbc_cells)
    {
      int i;
      for (i = 0; i < MNS_CL_count; i++)
	if (cmd.a_cells[i])
	  break;
      if (i >= MNS_CL_count)
	cmd.a_cells[MNS_CL_ALL] = 1;
    }
  else
    cmd.a_cells[MNS_CL_DEFAULT] = 1;
  if (cmd.a_cells[MNS_CL_DEFAULT] || cmd.a_cells[MNS_CL_ALL])
    cmd.a_cells[MNS_CL_MEAN] = cmd.a_cells[MNS_CL_STDDEV] = cmd.a_cells[MNS_CL_COUNT] = 1;
  if (cmd.a_cells[MNS_CL_ALL])
    cmd.a_cells[MNS_CL_SUM] = cmd.a_cells[MNS_CL_VARIANCE] = 1;

  if (cmd.sbc_statistics)
    {
      if (!cmd.a_statistics[MNS_ST_ANOVA] && !cmd.a_statistics[MNS_ST_LINEARITY])
	cmd.a_statistics[MNS_ST_ANOVA] = 1;
      if (cmd.a_statistics[MNS_ST_ALL])
	cmd.a_statistics[MNS_ST_ANOVA] = cmd.a_statistics[MNS_ST_LINEARITY] = 1;
    }

  if (!cmd.sbc_tables)
    {
      msg (SE, _("Missing required subcommand TABLES."));
      goto free;
    }

  success = CMD_SUCCESS;

free:
  {
    int i;
    
    for (i = 0; i < n_dim; i++)
      free (v_dim[i]);
    free (nv_dim);
    free (v_dim);
    free (v_var);
  }
  
  return success;
}

/* Parses the TABLES subcommand. */
static int
mns_custom_tables (struct cmd_means *cmd)
{
  struct var_set *var_set;
  
  if (!lex_match_id ("TABLES")
      && (token != T_ID || dict_lookup_var (default_dict, tokid) == NULL)
      && token != T_ALL)
    return 2;
  lex_match ('=');

  if (cmd->sbc_tables)
    {
      msg (SE, _("TABLES subcommand may not appear more "
		 "than once."));
      return 0;
    }

  var_set = var_set_create_from_dict (default_dict);
  assert (var_set != NULL);

  do
    {
      int nvl;
      struct variable **vl;

      if (!parse_var_set_vars (var_set, &vl, &nvl,
                               PV_NO_DUPLICATE | PV_NO_SCRATCH)) 
        goto lossage;
      
      n_dim++;
      nv_dim = xrealloc (nv_dim, n_dim * sizeof (int));
      v_dim = xrealloc (v_dim, n_dim * sizeof (struct variable **));

      nv_dim[n_dim - 1] = nvl;
      v_dim[n_dim - 1] = vl;
    }
  while (lex_match (T_BY));

  var_set_destroy (var_set);
  return 1;

 lossage:
  var_set_destroy (var_set);
  return 0;
}

/* 
   Local Variables:
   mode: c
   End:
*/
