#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by SmartEiffel The GNU Eiffel Compiler, Eiffel tools and libraries
Release 1.1 Release (Monday June 16th 2003) [Charlemagne]
Copyright (C), 1994-2003 - INRIA - LORIA - UHP - Nancy 2 - FRANCE
D.COLNET, S.COLLIN, O.ZENDRA, P.RIBET, C.ADRIAN - SmartEiffel@loria.fr
http://SmartEiffel.loria.fr
C Compiler options used: -pipe -O2
*/

/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/base.h) contains all basic Eiffel
  type definitions.
  This file is automatically included in the header for all modes of
  compilation: -boost, -no_check, -require_check, -ensure_check, ...
  This file is also included in the header of any cecil file (when the
  -cecil option is used).
  This file is also included in the header file of C++ wrappers (when
  using the external "C++" clause).
*/

#ifndef _BASE_H
#define _BASE_H

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
#  include <unistd.h>
#endif
#if !defined(WIN32) && \
       (defined(WINVER) || defined(_WIN32_WINNT) || defined(_WIN32) || \
	defined(__WIN32__) || defined(__TOS_WIN__) || defined(_MSC_VER))
#  define WIN32 1
#endif
#ifdef WIN32
#  include <windows.h>
#else
#  ifndef O_RDONLY
#    include <sys/file.h>
#  endif
#  ifndef O_RDONLY
#    define O_RDONLY 0000
#  endif
#endif

#if defined(_MSC_VER) && (_MSC_VER < 1400) /* MSVC older than v8 */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "d"
#  define PRId64 "I64d"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c
#  define INT64_C(c) c ## i64
#elif defined(__WATCOMC__) && (__WATCOMC__ <= 1100) /* WATCOM 11 or lower */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "d"
#  define PRId64 "Ld"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## i64
#elif defined(__BORLANDC__) && (__BORLANDC__ < 0x600) /* Borland before 6.0 */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "ld"
#  define PRId64 "I64Ld"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## i64
#elif defined(__FreeBSD__) && (__FreeBSD__ < 5) /* FreeBSD before 5.0 */ && !defined (_SYS_INTTYPES_H_)
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed long long int int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned long long int uint64_t;
#elif defined(__CYGWIN__) && defined(__BIT_TYPES_DEFINED__) /* Cygwin defines intxx_t in sys/types.h instead of inttypes.h */
typedef unsigned char uint8_t;
typedef __uint16_t uint16_t;
typedef __uint32_t uint32_t;
typedef __uint64_t uint64_t;
#else
#  include <inttypes.h>
#  if !defined(INT8_MAX) && defined(INT16_MAX)
/* int8_t is not mandatory */
typedef int_least8_t int8_t;
#  endif
#endif

#if !defined(PRId16)
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "ld"
#  define PRId64 "lld"
#elif !defined(PRId8)
#  define PRId8 "d"
#endif
#if !defined(INT16_C)
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## LL
#elif !defined(INT8_C)
#  define INT8_C(c) c
#endif
#if !defined(INT16_MIN)
#  define INT8_MIN (-INT8_C(127)-1)
#  define INT8_MAX (INT8_C(127))
#  define INT16_MIN (-INT16_C(32767)-1)
#  define INT16_MAX (INT16_C(32767))
#  define INT32_MIN (-INT32_C(2147483647)-1)
#  define INT32_MAX (INT32_C(2147483647))
#  define INT64_MIN (-INT64_C(9223372036854775807)-1)
#  define INT64_MAX (INT64_C(9223372036854775807))
#elif !defined(INT8_MIN)
#  define INT8_MIN (-INT8_C(127)-1)
#endif


/*
  Endian stuff
*/
#if defined(BSD) && (BSD >= 199103)
#  include <machine/endian.h>
#elif defined(__linux__)
#  include <endian.h>
#elif defined(__alpha__) || defined(__alpha) || defined(_M_ALPHA)
/* bi-endian processor, current mode should be find in machine/endian.h file */
#  include <machine/endian.h>
#endif



#if !defined(BYTE_ORDER) && defined(__BYTE_ORDER)
#  define BYTE_ORDER      __BYTE_ORDER
#endif

#if !defined(LITTLE_ENDIAN) && defined(__LITTLE_ENDIAN)
#  define LITTLE_ENDIAN      __LITTLE_ENDIAN
#endif

#if !defined(BIG_ENDIAN) && defined(__BIG_ENDIAN)
#  define BIG_ENDIAN      __BIG_ENDIAN
#endif

#if !defined(LITTLE_ENDIAN)
#  define LITTLE_ENDIAN   1234    /* LSB first (vax, pc) */
#endif
#if !defined(BIG_ENDIAN)
#  define BIG_ENDIAN      4321    /* MSB first (IBM, net) */
#endif
#if !defined(PDP_ENDIAN)
#  define PDP_ENDIAN      3412    /* LSB first in word, MSW first in long */
#endif

#if !defined(BYTE_ORDER) && defined(BIT_ZERO_ON_RIGHT)
#  define BYTE_ORDER      LITTLE_ENDIAN
#elif !defined(BYTE_ORDER) && defined(BIT_ZERO_ON_LEFT)
#  define BYTE_ORDER      BIG_ENDIAN
#elif !defined(BYTE_ORDER)

/* HP RISC */
#  if defined(__hppa__) || defined(__hppa) || defined(__hp9000) || \
      defined(__hp9000s300) || defined(hp9000s300) || \
      defined(__hp9000s700) || defined(hp9000s700) || \
      defined(__hp9000s800) || defined(hp9000s800) || defined(hp9000s820)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* IBM */
#  if defined(ibm032) || defined(ibm370) || defined(_IBMR2)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* Intel x86 */
#  if defined(i386) || defined(__i386__) || defined(__i386) || \
      defined(_M_IX86) || defined(_X86_) || defined(__THW_INTEL) || \
      defined(sun386)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Intel Itanium */
#  if defined(__ia64__) || defined(_IA64) || defined(__IA64__) || \
      defined(_M_IA64)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Nationnal Semiconductor 32000 serie */
#  if  defined(ns32000)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Motorola 68000 */
#  if defined(mc68000) || defined(is68k) || defined(macII) || defined(m68k)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* MIPS */
#  if defined(MIPSEL) || defined(_MIPSEL)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  elif defined(MIPSEB) || defined(_MIPSEB)
#    define BYTE_ORDER      BIG_ENDIAN
#  elif defined(__mips__) || defined(__mips) || defined(__MIPS__)
#    error "MIPS are bi-endian processors. Endianness is unknown for this system, please drop an e-mail to SmartEiffel@loria.fr"
#  endif

/* Power PC */
/* this processor is bi-endian, how to know if little-endian is set? */
#  if defined(__powerpc) || defined(__powerpc__) || defined(__POWERPC__) || \
      defined(__ppc__) || defined(__ppc) || defined(_M_PPC) || \
      defined(__PPC) || defined(__PPC__)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* Pyramid 9810 */
#  if defined(pyr)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* RS/6000 */
#  if defined(__THW_RS6000) || defined(_IBMR2) || defined(_POWER) || \
      defined(_ARCH_PWR) || defined(_ARCH_PWR2)
#    define BYTE_ORDER      _ENDIAN
#  endif

/* SPARC */
#  if defined(__sparc__) || defined(sparc) || defined(__sparc)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* CCI Tahoe */
#  if defined(tahoe)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* VAX */
#  if defined(vax) || defined(VAX) || defined(__vax__) || defined(_vax_) || \
      defined(__vax) || defined(__VAX)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* ELATE is a virtual OS with a little endian Virtual Processor */
#  if defined(__ELATE__)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Miscellaneous little endian */
#  if defined(wrltitan)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Miscellaneous big endian */
#  if defined(apollo) || defined(__convex__) || defined(_CRAY) || defined(sel)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif
#endif


#if !defined(BYTE_ORDER)
#  error "Unknown byte order. Add your system in above macros once you know your system type. Please drop an e-mail to SmartEiffel@loria.fr"
#endif
#if (BYTE_ORDER != BIG_ENDIAN && BYTE_ORDER != LITTLE_ENDIAN)
#  error "Only little-endian and big-endian are valid at this time. Please drop an e-mail to SmartEiffel@loria.fr"
#endif


/*
  Byte swapping stuff
*/
extern void copy_swap_16(const uint16_t *src, uint16_t *dest, int count);


/* Because ANSI C EXIT_* are not always defined: */
#ifndef EXIT_FAILURE
#  define EXIT_FAILURE 1
#endif
#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS 0
#endif

/*
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.

   NOTE: with gcc, -ansi is used for SmartEiffel generated files EXCEPT in
   -no_split mode. ANSI only recognizes the non-sig versions.
*/
#if (defined(_SIGSET_H_types) && !defined(__STRICT_ANSI__))
#  define JMP_BUF    sigjmp_buf
#  define SETJMP(x)  sigsetjmp( (x), 1)
#  define LONGJMP    siglongjmp
#else
#  define JMP_BUF    jmp_buf
#  define SETJMP(x)  setjmp( (x) )
#  define LONGJMP    longjmp
#endif

/*
   Type to store reference objects Id:
 */
typedef int Tid;
typedef struct S0 T0;
struct S0{Tid id;};

/*
   The default channel used to print runtime error messages:
*/
#define SE_ERR stderr

/*
   Eiffel type INTEGER_8 is #1:
*/
typedef int8_t T1;
#define EIF_INTEGER_8 T1
#define M1 (INT8_C(0))
#define EIF_INTEGER_8_BITS (CHAR_BIT)
#define EIF_MINIMUM_INTEGER_8 (INT8_MIN)
#define EIF_MAXIMUM_INTEGER_8 (INT8_MAX)

/*
  Eiffel type INTEGER_16 is #10:
*/
typedef int16_t T10;
#define EIF_INTEGER_16 T10
#define M10 (INT16_C(0))
#define EIF_INTEGER_16_BITS (CHAR_BIT*sizeof(T10t))
#define EIF_MINIMUM_INTEGER_16 (INT16_MIN) /*-32768*/
#define EIF_MAXIMUM_INTEGER_16 (INT16_MAX) /*+32767*/

/*
  Eiffel type INTEGER or INTEGER_32 is #2:
*/
typedef int32_t T2;
#define EIF_INTEGER T2
#define EIF_INTEGER_32 T2
#define M2 (INT32_C(0))
#define EIF_INTEGER_BITS ((T2)(CHAR_BIT*sizeof(T2)))
#define EIF_INTEGER_32_BITS EIF_INTEGER_BITS
#define EIF_MINIMUM_INTEGER (INT32_MIN)
#define EIF_MAXIMUM_INTEGER (INT32_MAX)

/*
  Eiffel type INTEGER_64 is #11:
*/
typedef int64_t T11;
#define EIF_INTEGER_64 T11
#define M11 (INT64_C(0))
#define EIF_INTEGER_64_BITS (CHAR_BIT*sizeof(T11))
#define EIF_MINIMUM_INTEGER_64 (INT64_MIN)
#define EIF_MAXIMUM_INTEGER_64 (INT64_MAX)

/*
  Eiffel type CHARACTER is #3:
*/
typedef unsigned char T3;
#define EIF_CHARACTER T3
#define M3 (0)
#define EIF_CHARACTER_BITS (CHAR_BIT)
#define EIF_MINIMUM_CHARACTER_CODE (0)
#define EIF_MAXIMUM_CHARACTER_CODE (255)
#define T3code(x) ((T10)(x))
#define T3to_integer(x) ((signed char)(x))
#define T3to_bit(x) (x)

/*
  Eiffel type REAL is #4:
*/
typedef float T4;
#define EIF_REAL T4
#define M4 (0.0)
#define EIF_REAL_BITS (CHAR_BIT*sizeof(float))
#define EIF_MINIMUM_REAL (-(FLT_MAX))
#define EIF_MAXIMUM_REAL (FLT_MAX)

/*
  Eiffel type DOUBLE is #5:
*/
typedef double T5;
#define EIF_DOUBLE T5
#define M5 (0.0)
#define EIF_DOUBLE_BITS (CHAR_BIT*sizeof(double))
#define EIF_MINIMUM_DOUBLE (-(DBL_MAX))
#define EIF_MAXIMUM_DOUBLE (DBL_MAX)

/*
  Eiffel type BOOLEAN is #6:
*/
typedef char T6;
#define EIF_BOOLEAN T6
#define M6 (0)
#define EIF_BOOLEAN_BITS (CHAR_BIT)

/*
   Eiffel type POINTER is #8:
*/
typedef void* T8;
#define EIF_POINTER T8
/* Sometimes, NULL is defined as 0 */
#define M8 ((void*)NULL)
#define EIF_POINTER_BITS (CHAR_BIT*sizeof(void*))

/*
  To use type STRING on the C side:
*/
#define EIF_STRING T7*

/*
  Some Other EIF_* defined in ETL:
*/
#define eif_access(x) ((char*)(x))
#define EIF_REFERENCE T0*
#define EIF_OBJ T0*
#define EIF_OBJECT EIF_OBJ

/*
   Wrappers for `malloc' and `calloc':
*/
void* se_malloc(size_t size);
void* se_calloc(size_t nmemb, size_t size);


#endif /* #ifndef _BASE_H */
#define SE_BOOST 1
#define SE_EXCEPTIONS 1

/*C Header Pass 1 :*/
typedef struct S325 T325;
typedef void*T635;
typedef struct S420 T420;
typedef struct S40 T40;
typedef int T49;
typedef struct S293 T293;
typedef void*T419;
typedef struct S740 T740;
typedef struct S654 T654;
typedef struct S405 T405;
typedef struct S300 T300;
typedef struct S408 T408;
typedef struct S291 T291;
typedef struct S689 T689;
typedef void*T634;
typedef struct S262 T262;
typedef struct S592 T592;
typedef struct S45 T45;
typedef struct S738 T738;
typedef struct S147 T147;
typedef struct S303 T303;
typedef void*T603;
typedef struct S418 T418;
typedef struct S105 T105;
typedef struct S636 T636;
typedef void*T568;
typedef struct S413 T413;
typedef struct S363 T363;
typedef struct S793 T793;
typedef struct S411 T411;
typedef struct S77 T77;
typedef struct S767 T767;
typedef struct S133 T133;
typedef struct S241 T241;
typedef struct S299 T299;
typedef struct S604 T604;
typedef void*T467;
typedef struct S20 T20;
typedef struct S269 T269;
typedef struct S775 T775;
typedef struct S531 T531;
typedef void*T593;
typedef struct S176 T176;
typedef struct S255 T255;
typedef void*T436;
typedef struct S466 T466;
typedef void*T380;
typedef void*T581;
typedef struct S233 T233;
typedef struct S196 T196;
typedef struct S450 T450;
typedef struct S630 T630;
typedef void*T74;
typedef struct S104 T104;
typedef void*T713;
typedef void*T223;
typedef struct S364 T364;
typedef struct S464 T464;
typedef struct S445 T445;
typedef void*T553;
typedef struct S367 T367;
typedef struct S481 T481;
typedef void*T121;
typedef struct S576 T576;
typedef struct S131 T131;
typedef void*T324;
typedef struct S256 T256;
typedef struct S362 T362;
typedef struct S523 T523;
typedef struct S266 T266;
typedef struct S749 T749;
typedef struct S252 T252;
typedef void*T565;
typedef struct S117 T117;
typedef struct S447 T447;
typedef struct S452 T452;
typedef void*T123;
typedef void*T489;
typedef struct S726 T726;
typedef void*T506;
typedef void*T407;
typedef struct S318 T318;
typedef struct S281 T281;
typedef struct S696 T696;
typedef struct S349 T349;
typedef struct S118 T118;
typedef void*T622;
typedef struct S143 T143;
typedef struct S780 T780;
typedef struct S243 T243;
typedef struct S292 T292;
typedef struct S707 T707;
typedef struct S586 T586;
typedef struct S493 T493;
typedef struct S285 T285;
typedef struct S43 T43;
typedef struct S23 T23;
typedef struct S588 T588;
typedef void*T73;
typedef struct S12 T12;
typedef struct S616 T616;
typedef void*T560;
typedef struct S113 T113;
typedef struct S446 T446;
typedef void*T575;
typedef struct S114 T114;
typedef void*T76;
typedef struct S365 T365;
typedef struct S144 T144;
typedef void*T637;
typedef struct S153 T153;
typedef struct S782 T782;
typedef struct S361 T361;
typedef struct S569 T569;
typedef struct S570 T570;
typedef struct S610 T610;
typedef struct S769 T769;
typedef void*T412;
typedef void*T333;
typedef struct S561 T561;
typedef struct S268 T268;
typedef struct S414 T414;
typedef struct S598 T598;
typedef struct S126 T126;
typedef struct S453 T453;
typedef void*T770;
typedef struct S527 T527;
typedef struct S577 T577;
typedef struct S330 T330;
typedef struct S734 T734;
typedef struct S164 T164;
typedef struct S482 T482;
typedef struct S533 T533;
typedef struct S716 T716;
typedef struct S660 T660;
typedef struct S254 T254;
typedef void*T587;
typedef struct S632 T632;
typedef struct S547 T547;
typedef struct S148 T148;
typedef struct S559 T559;
typedef struct S295 T295;
typedef struct S253 T253;
typedef struct S719 T719;
typedef struct S197 T197;
typedef struct S451 T451;
typedef struct S785 T785;
typedef struct S38 T38;
typedef struct S631 T631;
typedef int T16;
typedef struct S221 T221;
typedef struct S282 T282;
typedef struct S234 T234;
typedef struct S555 T555;
typedef struct S30 T30;
typedef struct S731 T731;
typedef void*T110;
typedef struct S534 T534;
typedef struct S7 T7;
typedef struct S750 T750;
typedef void*T251;
typedef struct S371 T371;
typedef struct S621 T621;
typedef void*T103;
typedef struct S276 T276;
typedef struct S671 T671;
typedef struct S120 T120;
typedef struct S687 T687;
typedef struct S212 T212;
typedef struct S115 T115;
typedef struct S29 T29;
typedef struct S112 T112;
typedef void*T756;
typedef struct S356 T356;
typedef struct S392 T392;
typedef struct S175 T175;
typedef struct S594 T594;
typedef struct S697 T697;
typedef struct S695 T695;
typedef struct S711 T711;
typedef struct S245 T245;
typedef struct S119 T119;
typedef struct S503 T503;
typedef struct S483 T483;
typedef struct S690 T690;
typedef struct S111 T111;
typedef struct S614 T614;
typedef struct S305 T305;
typedef struct S444 T444;
typedef void*T609;
typedef void*T494;
typedef struct S574 T574;
typedef struct S165 T165;
typedef struct S783 T783;
typedef struct S44 T44;
typedef struct S748 T748;
typedef struct S536 T536;
typedef struct S33 T33;
typedef struct S449 T449;
typedef void*T62;
typedef struct S746 T746;
typedef struct S410 T410;
typedef void*T162;
typedef struct S308 T308;
typedef struct S274 T274;
typedef void*T359;
typedef struct S566 T566;
typedef struct S65 T65;
typedef struct S99 T99;
typedef struct S294 T294;
typedef struct S557 T557;
typedef struct S509 T509;
typedef struct S778 T778;
typedef struct S287 T287;
typedef struct S717 T717;
typedef struct S628 T628;
typedef struct S433 T433;
typedef struct S556 T556;
typedef void*T151;
typedef struct S448 T448;
typedef struct S437 T437;
typedef struct S617 T617;
typedef struct S790 T790;
typedef struct S784 T784;
typedef void*T640;
typedef struct S552 T552;
typedef void*T219;
typedef struct S430 T430;
typedef struct S692 T692;
typedef struct S128 T128;
typedef struct S421 T421;
typedef struct S194 T194;
typedef struct S81 T81;
typedef struct S222 T222;
typedef void*T378;
typedef struct S582 T582;
typedef struct S374 T374;
typedef struct S404 T404;
typedef struct S743 T743;
typedef struct S535 T535;
typedef struct S490 T490;
typedef struct S100 T100;
typedef struct S620 T620;
typedef void*T417;
typedef struct S228 T228;
typedef struct S681 T681;
typedef struct S611 T611;
typedef void*T334;
typedef struct S242 T242;
typedef void*T409;
typedef struct S37 T37;
typedef struct S79 T79;
typedef struct S605 T605;
typedef struct S439 T439;
typedef struct S24 T24;
typedef void*T39;
typedef void*T317;
typedef struct S424 T424;
typedef struct S484 T484;
typedef struct S431 T431;
typedef struct S477 T477;
typedef struct S402 T402;

/*C Header Pass 2 :*/
typedef T8*T709;
#define M709 NULL
typedef T0**T302;
#define M302 NULL
typedef T0**T416;
#define M416 NULL
typedef T0**T608;
#define M608 NULL
typedef T0**T127;
#define M127 NULL
typedef T0**T373;
#define M373 NULL
typedef T0**T597;
#define M597 NULL
typedef T0**T580;
#define M580 NULL
typedef T6*T107;
#define M107 NULL
typedef T0**T369;
#define M369 NULL
typedef T0**T772;
#define M772 NULL
typedef T0**T146;
#define M146 NULL
typedef T0**T573;
#define M573 NULL
typedef T0**T787;
#define M787 NULL
typedef T0**T591;
#define M591 NULL
typedef T0**T564;
#define M564 NULL
typedef T10*T230;
#define M230 NULL
typedef T0**T130;
#define M130 NULL
typedef T0**T613;
#define M613 NULL
typedef T0**T332;
#define M332 NULL
typedef T0**T284;
#define M284 NULL
typedef T0**T226;
#define M226 NULL
typedef T3*T9;
#define M9 NULL
typedef T1*T236;
#define M236 NULL
typedef T0**T585;
#define M585 NULL
typedef T2*T96;
#define M96 NULL
typedef T0**T289;
#define M289 NULL
typedef T0**T423;
#define M423 NULL

/*C Header Pass 3 :*/
struct S33{T8 _directory_stream;T8 _current_entry;};
int se_cmpT33(T33 o1,T33 o2);

/*C Header Pass 4 :*/
struct S325{T0* _comparator;};
extern T325 M325;
extern T635 M635;
struct S420{T423 _storage;T2 _capacity;T2 _upper;};
extern T420 M420;
struct S40{Tid id;T0* _doc;T0* _params;T0* _ast;T0* _parts;T0* _authors;T0* _comments;T0* _summary;T0* _nbpages;T0* _date;T0* _type;T0* _file;T0* _title;T0* _language;T0* _url;T0* _documents;T0* _author_name;T0* _content;T0* _node_content;T0* _xml_filename;};
extern T40 M40;
extern T49 M49;
struct S293{Tid id;T2 _count;T0* _storage;T0* _symbols;};
extern T293 M293;
struct S740{T0* _item;T0* _right;};
extern T740 M740;
struct S654{T2 _position;T0* _container;};
extern T654 M654;
struct S405{Tid id;T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;};
extern T405 M405;
struct S408{T369 _storage;T2 _capacity;T2 _upper;};
extern T408 M408;
struct S291{T2 _count;T0* _storage;};
extern T291 M291;
struct S689{Tid id;T0* _item;T0* _right;};
extern T689 M689;
extern T634 M634;
struct S262{T6 _yyline_used;T0* _states;T0* _yy_accept;T0* _yy_ec;T6 _yyposition_used;T0* _input_filename;T0* _eiffel_header;T6 _bol_needed;T6 _pre_action_used;T6 _post_action_used;T6 _post_eof_action_used;T0* _yy_nxt;T6 _yybacking_up;T2 _start_states_count;T2 _maximum_symbol;T0* _yy_start_conditions;T2 _backing_up_count;T0* _partitions;T0* _yy_rules;T0* _yy_eof_rules;T2 _yynb_rules;T2 _yynull_equiv_class;T0* _eiffel_code;T6 _pre_eof_action_used;T2 _characters_count;T2 _array_size;T6 _actions_separated;T2 _yynb_rows;T2 _minimum_symbol;T2 _yyend_of_buffer;T6 _inspect_used;};
extern T262 M262;
struct S592{T0* _system_id;};
extern T592 M592;
struct S45{Tid id;T0* _name;T0* _string_name;T0* _last_string;T8 _input_stream;T6 _end_of_file;T0* _path;T6 _push_back_flag;T3 _last_character;T3 _old_last_character;T6 _end_reached;T0* _character_buffer;T6 _old_end_of_file;T9 _buffer;T2 _buffer_position;T2 _buffer_size;T2 _capacity;};
extern T45 M45;
struct S300{T2 _item;T0* _right;T0* _left;};
extern T300 M300;
struct S738{T0* _first;T0* _second;};
extern T738 M738;
struct S147{Tid id;};
extern T147 M147;
struct S303{Tid id;T0* _transition;T0* _epsilon_transition;T0* _accepted_rule;T2 _id;T6 _in_trail_context;};
extern T303 M303;
struct S418{T96 _storage;T2 _capacity;T2 _upper;};
extern T418 M418;
struct S105{T107 _storage;T2 _capacity;T2 _upper;};
extern T105 M105;
struct S636{Tid id;T2 _last_token;T0* _input_buffer;T2 _line;T2 _column;T2 _position;T2 _yy_start_state;T0* _yy_content;T0* _yy_content_area;T2 _yy_end;T2 _yy_start;T2 _yy_column;T2 _yy_line;T2 _yy_position;T6 _yy_more_flag;T2 _yy_more_len;T2 _yy_last_accepting_state;T2 _yy_last_accepting_cpos;T0* _yy_nxt;T0* _yy_chk;T0* _yy_base;T0* _yy_def;T0* _yy_ec;T0* _yy_meta;T0* _yy_accept;T0* _yy_acclist;T6 _yy_rejected;T0* _yy_state_stack;T2 _yy_state_count;T2 _yy_full_match;T2 _yy_lp;T2 _yy_looking_for_trail_begin;T2 _yy_full_lp;T2 _yy_full_state;T0* _input_stream;T0* _input_filter;T0* _last_error;T0* _filename;T0* _source;T0* _last_value;T0* _character_entity;T0* _start_conditions;T6 _decl_start_sent;T6 _decl_end_sent;};
extern T636 M636;
struct S413{T416 _storage;T2 _capacity;T2 _upper;};
extern T413 M413;
struct S363{T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;};
extern T363 M363;
struct S793{T0* _item;T0* _right;T0* _left;};
extern T793 M793;
struct S77{T0* _ast;T0* _str;T0* _path;T6 _allow_private;T0* _tcomment;T0* _tdocument;T0* _tglobal;T0* _httpd_path;T6 _is_writable;T2 _value;T0* _cerr;T0* _regexp;};
extern T77 M77;
struct S767{T2 _position;T0* _container;};
extern T767 M767;
struct S133{Tid id;T0* _next;T6 _has_error;T0* _last_error;};
extern T133 M133;
struct S241{T2 _count;T0* _first_cell;};
extern T241 M241;
struct S299{T302 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T299 M299;
struct S20{T0* _params;T2 _nb_docs;T2 _bibtex_index;T0* _tex_str;T6 _is_prog;T0* _res;};
extern T20 M20;
struct S269{T2 _error_count;T0* _yytranslate;T0* _yyr1;T0* _yydefact;T0* _yydefgoto;T0* _yypact;T0* _yypgoto;T0* _yytable;T0* _yycheck;T0* _yytypes1;T0* _yytypes2;T0* _yyss;T2 _yyssp;T6 _yy_lookahead_needed;T2 _yyerrstatus;T2 _yy_parsing_status;T2 _column;T2 _position;T2 _yy_start_state;T0* _yy_content;T0* _yy_content_area;T2 _yy_start;T2 _yy_column;T2 _yy_more_len;T2 _yy_last_accepting_state;T2 _yy_last_accepting_cpos;T0* _yy_nxt;T0* _yy_chk;T0* _yy_def;T0* _yy_ec;T0* _yy_accept;T0* _yy_acclist;T2 _yy_state_count;T2 _yy_looking_for_trail_begin;T0* _error_handler;T2 _line_nb;T0* _pending_rules;T0* _action_factory;T0* _rule;T6 _has_trail_context;T2 _singleton_line;T2 _singleton_column;T2 _singleton_count;T2 _series_line;T2 _series_count;T2 _head_column;T2 _trail_count;T0* _last_string_value;T0* _yy_base;T6 _yy_rejected;T2 _yy_full_state;T6 _successful;T0* _description;T0* _last_string;T2 _regexp_line;T0* _last_any_value;T2 _last_token;T0* _input_buffer;T2 _line;T2 _yy_end;T2 _yy_line;T2 _yy_position;T6 _yy_more_flag;T0* _yy_meta;T2 _yy_lp;T2 _yy_full_lp;T0* _character_classes;T0* _start_condition_stack;T6 _in_trail_context;T2 _series_column;T2 _regexp_column;T2 _regexp_count;T2 _head_line;T2 _head_count;T0* _last_lx_symbol_class_value;T0* _yy_state_stack;T2 _yy_full_match;T2 _rule_line_nb;T0* _name_definitions;T0* _yyvs1;T2 _yyvsc1;T2 _yyvsp1;T0* _yyspecial_routines1;T0* _yyvs2;T2 _yyvsc2;T2 _yyvsp2;T0* _yyspecial_routines2;T0* _yyvs3;T2 _yyvsc3;T2 _yyvsp3;T0* _yyspecial_routines3;T0* _yyvs4;T2 _yyvsc4;T2 _yyvsp4;T0* _yyspecial_routines4;T0* _yyvs5;T2 _yyvsc5;T2 _yyvsp5;T0* _yyspecial_routines5;T2 _last_integer_value;};
extern T269 M269;
struct S775{T0* _container;T6 _after;T6 _before;T0* _current_cell;T0* _next_cursor;};
extern T775 M775;
struct S531{Tid id;T0* _container;T2 _position;T0* _next_cursor;};
extern T531 M531;
struct S176{Tid id;T2 _last_token;T0* _input_buffer;T2 _line;T2 _column;T2 _position;T2 _yy_start_state;T0* _yy_content;T0* _yy_content_area;T2 _yy_end;T2 _yy_start;T2 _yy_column;T2 _yy_line;T2 _yy_position;T6 _yy_more_flag;T2 _yy_more_len;T2 _yy_last_accepting_state;T2 _yy_last_accepting_cpos;T0* _yy_nxt;T0* _yy_chk;T0* _yy_base;T0* _yy_def;T0* _yy_ec;T0* _yy_meta;T0* _yy_accept;T0* _yy_acclist;T6 _yy_rejected;T0* _yy_state_stack;T2 _yy_state_count;T2 _yy_full_match;T2 _yy_lp;T2 _yy_looking_for_trail_begin;T2 _yy_full_lp;T2 _yy_full_state;T0* _input_stream;T0* _input_filter;T0* _last_error;T0* _filename;T0* _source;T0* _last_value;T0* _character_entity;T0* _start_conditions;};
extern T176 M176;
struct S255{T0* _ast;T0* _regexp;T6 _res;T0* _document;T6 _allow_private;};
extern T255 M255;
extern T436 M436;
struct S466{Tid id;T0* _target;T0* _label;};
extern T466 M466;
struct S233{Tid id;T96 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T233 M233;
struct S196{Tid id;};
extern T196 M196;
struct S450{Tid id;T0* _parameters;};
extern T450 M450;
struct S630{Tid id;T6 _after;T6 _before;T0* _container;T0* _current_cell;T0* _next_cursor;};
extern T630 M630;
extern T74 M74;
extern T713 M713;
struct S464{Tid id;T0* _parameters;};
extern T464 M464;
struct S445{Tid id;T0* _parameters;};
extern T445 M445;
struct S367{T369 _storage;T2 _capacity;T2 _upper;};
extern T367 M367;
struct S481{Tid id;T0* _target;T2 _label;};
extern T481 M481;
struct S131{T0* _start;T0* _error;T0* _tree;T0* _last;};
extern T131 M131;
struct S256{T0* _subject;T2 _subject_start;T2 _subject_end;T2 _match_count;T2 _matched_start;T2 _matched_end;T0* _yy_nxt;T0* _yy_accept;T2 _yynb_rows;T6 _has_caret;T6 _has_dollar;};
extern T256 M256;
struct S523{Tid id;T2 _position;T0* _container;T0* _next_cursor;};
extern T523 M523;
struct S266{T0* _error_file;T0* _warning_file;T0* _info_file;};
extern T266 M266;
struct S252{T2 _count;T9 _area;T0* _area_string;};
extern T252 M252;
struct S117{T0* _item;T0* _next;};
extern T117 M117;
struct S447{Tid id;T0* _parameters;};
extern T447 M447;
struct S452{Tid id;T0* _parameters;};
extern T452 M452;
struct S726{T2 _count;T0* _last_cell;T0* _internal_cursor;T0* _first_cell;};
extern T726 M726;
struct S318{T0* _comparator;};
extern T318 M318;
struct S281{T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;};
extern T281 M281;
struct S696{T0* _first;T0* _second;};
extern T696 M696;
struct S349{T0* _container;T2 _position;T0* _next_cursor;};
extern T349 M349;
struct S118{T0* _item;T0* _next;};
extern T118 M118;
extern T622 M622;
struct S143{Tid id;T0* _next;T0* _document;T0* _last_position_table;T0* _current_element;T0* _namespace_cache;T0* _source_parser;};
extern T143 M143;
struct S780{T0* _item;T0* _right;T0* _left;};
extern T780 M780;
struct S243{Tid id;T0* _filename;};
extern T243 M243;
struct S292{T289 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T292 M292;
struct S707{T6 _after;T6 _before;T0* _container;T0* _current_cell;T0* _next_cursor;};
extern T707 M707;
struct S586{T0* _name;T0* _items;T3 _type;T3 _repetition;T6 _is_character_data_allowed;};
extern T586 M586;
struct S493{Tid id;T0* _parameters;};
extern T493 M493;
struct S285{T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;};
extern T285 M285;
struct S43{T0* _documents;};
extern T43 M43;
struct S23{T0* _file;T0* _buff;T0* _model;T0* _path;};
extern T23 M23;
struct S588{T591 _storage;T2 _capacity;T2 _upper;};
extern T588 M588;
extern T73 M73;
struct S12{T0* _params;T6 _is_writeable;};
extern T12 M12;
struct S411{T0* _equality_tester;T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;T6 _negated;T6 _sort_needed;};
extern T411 M411;
struct S104{T0* _set;};
extern T104 M104;
struct S616{Tid id;T6 _end_of_input;T3 _last_character;T0* _last_string;T0* _string;T2 _location;};
extern T616 M616;
struct S113{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T113 M113;
struct S446{Tid id;T0* _parameters;};
extern T446 M446;
struct S114{T0* _author_name;T0* _content;};
extern T114 M114;
extern T76 M76;
struct S365{Tid id;T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;};
extern T365 M365;
struct S144{T146 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T144 M144;
struct S153{Tid id;T0* _dtd_resolver;T0* _entity_resolver;T0* _callbacks;T0* _source;T6 _is_correct;T2 _last_error;T2 _last_internal_error;T8 _item;};
extern T153 M153;
struct S782{Tid id;T0* _parent;T0* _data;};
extern T782 M782;
struct S362{Tid id;T0* _states;T6 _in_trail_context;};
extern T362 M362;
struct S361{T0* _text;};
extern T361 M361;
struct S570{T573 _storage;T2 _capacity;T2 _upper;};
extern T570 M570;
struct S610{T613 _storage;T2 _capacity;T2 _upper;};
extern T610 M610;
struct S769{T772 _storage;T2 _capacity;T2 _upper;};
extern T769 M769;
struct S561{T564 _storage;T2 _capacity;T2 _upper;};
extern T561 M561;
struct S268{T2 _array_size;T6 _case_insensitive;T2 _characters_count;T6 _equiv_classes_used;T6 _meta_equiv_classes_used;T6 _full_table;T6 _actions_separated;T6 _inspect_used;T6 _reject_used;T6 _line_used;T6 _position_used;T6 _pre_action_used;T6 _post_action_used;T6 _pre_eof_action_used;T6 _post_eof_action_used;T0* _input_filename;T0* _start_conditions;T0* _rules;T0* _eof_rules;T0* _equiv_classes;T6 _bol_needed;T6 _variable_trail_context;T0* _eiffel_code;T0* _eiffel_header;};
extern T268 M268;
struct S414{T416 _storage;T2 _capacity;T2 _upper;};
extern T414 M414;
struct S598{T6 _use_namespaces;T0* _first;T2 _count;T0* _second;T0* _tail;};
extern T598 M598;
struct S126{T127 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T126 M126;
struct S453{T2 _position;T0* _container;T0* _next_cursor;};
extern T453 M453;
struct S527{Tid id;T0* _container;};
extern T527 M527;
struct S577{T580 _storage;T2 _capacity;T2 _upper;};
extern T577 M577;
struct S330{T332 _storage;T2 _capacity;T2 _upper;};
extern T330 M330;
struct S734{Tid id;T0* _parent;T0* _content;};
extern T734 M734;
struct S164{Tid id;};
extern T164 M164;
struct S482{Tid id;T0* _parameters;};
extern T482 M482;
struct S533{T0* _name;};
extern T533 M533;
struct S716{T0* _item;};
extern T716 M716;
struct S660{T2 _count;T0* _last_cell;T0* _internal_cursor;T0* _first_cell;};
extern T660 M660;
struct S254{T0* _ast;T0* _path;T0* _str;T0* _tdocument;T0* _tcomment;T6 _grep;};
extern T254 M254;
struct S632{T3 _item;T0* _right;};
extern T632 M632;
struct S547{T0* _last_value;T0* _eif_buffer;T0* _yydefact;T0* _yydefgoto;T0* _yypgoto;T0* _yytable;T0* _yycheck;T0* _yytypes1;T0* _yytypes2;T0* _yyss;T2 _yyssp;T2 _yyerrstatus;T2 _yy_parsing_status;T2 _line;T2 _column;T2 _position;T2 _yy_start_state;T0* _yy_content_area;T2 _yy_start;T2 _yy_line;T2 _yy_column;T2 _yy_position;T2 _yy_more_len;T2 _yy_last_accepting_cpos;T0* _yyvs;T2 _yyvsc;T0* _yyval;T0* _fixed_array_;T0* _yy_nxt;T0* _yy_chk;T0* _yy_base;T0* _yy_def;T0* _yy_ec;T0* _yy_accept;T0* _yy_acclist;T6 _yy_rejected;T0* _yy_state_stack;T2 _yy_state_count;T2 _yy_lp;T2 _yy_looking_for_trail_begin;T2 _yy_full_lp;T2 _yy_full_state;T2 _eif_lineno;T2 _error_count;T0* _yytranslate;T0* _yyr1;T0* _yypact;T6 _yy_lookahead_needed;T0* _input_buffer;T6 _yy_more_flag;T2 _yy_last_accepting_state;T2 _yyvsp;T2 _last_token;T0* _yy_content;T2 _yy_end;T0* _yy_meta;T2 _yy_full_match;T0* _data;};
extern T547 M547;
struct S148{Tid id;T0* _next;T0* _context;T0* _element_prefix;T0* _element_local_part;T0* _attributes_prefix;T0* _attributes_local_part;T0* _attributes_value;};
extern T148 M148;
struct S295{T107 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T295 M295;
struct S253{T2 _code;};
extern T253 M253;
struct S719{T0* _context;};
extern T719 M719;
struct S197{Tid id;};
extern T197 M197;
struct S451{Tid id;T0* _parameters;};
extern T451 M451;
struct S785{T787 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T785 M785;
struct S38{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T38 M38;
struct S631{Tid id;T2 _count;T0* _first_cell;T0* _last_cell;T0* _internal_cursor;};
extern T631 M631;
extern T16 M16;
struct S221{T130 _storage;T2 _capacity;T2 _upper;};
extern T221 M221;
struct S282{T284 _storage;T2 _capacity;T2 _upper;};
extern T282 M282;
struct S364{T2 _id;T0* _name;T0* _patterns;T0* _bol_patterns;T6 _is_exclusive;};
extern T364 M364;
struct S234{Tid id;T236 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T234 M234;
struct S555{Tid id;T2 _item;};
extern T555 M555;
struct S30{T0* _path;T6 _end_of_input;T6 _push_back_flag;T8 _input_stream;T9 _buffer;T6 _end_reached;T2 _buffer_position;T2 _buffer_size;T2 _capacity;};
extern T30 M30;
struct S731{T6 _after;T6 _before;T0* _container;T0* _current_cell;T0* _next_cursor;};
extern T731 M731;
struct S534{T0* _ast;T6 _enable_private;T2 _pos;T0* _path;T0* _str;T0* _tdocument;};
extern T534 M534;
struct S750{T0* _equality_tester;T2 _count;T2 _capacity;T2 _last_position;T2 _modulus;T2 _free_slot;T2 _position;T2 _slots_position;T2 _clashes_previous_position;T2 _found_position;T0* _internal_cursor;T0* _items;T0* _clashes;T0* _slots;T0* _fixed_item_array_;};
extern T750 M750;
struct S371{T373 _storage;T2 _capacity;T2 _upper;};
extern T371 M371;
struct S621{T2 _item;T0* _right;};
extern T621 M621;
struct S276{T2 _id;T0* _action;T0* _pattern;T2 _line_nb;T2 _trail_count;T2 _head_count;T2 _line_count;T2 _column_count;T6 _is_useful;T6 _has_trail_context;};
extern T276 M276;
struct S671{T6 _before;T0* _container;};
extern T671 M671;
struct S120{T2 _item;T0* _next;};
extern T120 M120;
struct S687{T6 _after;T6 _before;T0* _container;T0* _current_cell;T0* _next_cursor;};
extern T687 M687;
struct S212{T2 _position;T0* _container;T0* _next_cursor;};
extern T212 M212;
struct S115{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T115 M115;
struct S29{T6 _verbose;T6 _html_mode;T6 _display_mode;T6 _bibtex_mode;T6 _latex_mode;T0* _xml_file;T0* _input_path;T6 _recursive;T0* _output_file;T0* _output_path;T0* _httpd_path;T6 _enable_private;T0* _regexp;T6 _insensitive;T0* _conffile;T0* _template_path;};
extern T29 M29;
struct S112{T0* _parts;T0* _authors;T0* _comments;T0* _summary;T0* _nbpages;T0* _date;T0* _type;T0* _file;T0* _url;T0* _title;T0* _language;T6 _mark;};
extern T112 M112;
struct S356{T0* _container;T2 _position;T0* _next_cursor;};
extern T356 M356;
struct S392{Tid id;T2 _position;T0* _container;};
extern T392 M392;
struct S7{Tid id;T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S594{T597 _storage;T2 _capacity;T2 _upper;};
extern T594 M594;
struct S576{T2 _count;T0* _last_cell;T0* _internal_cursor;T0* _first_cell;};
extern T576 M576;
struct S697{T2 _count;T0* _last_cell;T0* _internal_cursor;T0* _first_cell;};
extern T697 M697;
struct S695{T0* _first;T0* _second;};
extern T695 M695;
struct S711{T0* _item;T0* _right;T0* _left;};
extern T711 M711;
struct S245{Tid id;T0* _content;T2 _count;T2 _capacity;T2 _position;T2 _column;T2 _line;T2 _index;T6 _beginning_of_line;T6 _filled;};
extern T245 M245;
struct S119{T0* _item;T0* _next;};
extern T119 M119;
struct S503{T0* _container;T2 _position;T0* _next_cursor;};
extern T503 M503;
struct S483{Tid id;T0* _parameters;};
extern T483 M483;
struct S690{Tid id;T0* _item;T0* _right;T0* _left;};
extern T690 M690;
struct S111{T0* _lower_table;T0* _flip_table;};
extern T111 M111;
struct S614{T0* _item;T0* _right;};
extern T614 M614;
struct S305{Tid id;T0* _equality_tester;T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;};
extern T305 M305;
struct S444{Tid id;T0* _parameters;};
extern T444 M444;
extern T494 M494;
struct S574{T0* _name;T3 _type;T3 _value;T0* _default_value;T6 _is_list_type;T0* _enumeration_list;};
extern T574 M574;
struct S165{Tid id;T0* _yydefact;T0* _yydefgoto;T0* _yytable;T0* _yycheck;T0* _yytypes1;T0* _yytypes2;T0* _yyss;T2 _yyssp;T6 _yy_lookahead_needed;T2 _yyerrstatus;T0* _callbacks;T2 _string_mode;T0* _dtd_resolver;T0* _entity_resolver;T2 _error_count;T0* _yytranslate;T0* _yyr1;T0* _yypact;T0* _yypgoto;T2 _yy_parsing_status;T0* _dtd_callbacks;T0* _last_any_value;T0* _last_string_value;T6 _use_namespaces;T0* _last_error_description;T0* _entities;T0* _pe_entities;T6 _in_external_dtd;T0* _scanner;T0* _scanners;T2 _last_token;T0* _yyvs1;T2 _yyvsc1;T2 _yyvsp1;T0* _yyspecial_routines1;T0* _yyvs2;T2 _yyvsc2;T2 _yyvsp2;T0* _yyspecial_routines2;T0* _yyvs3;T2 _yyvsc3;T2 _yyvsp3;T0* _yyspecial_routines3;T0* _yyvs4;T2 _yyvsc4;T2 _yyvsp4;T0* _yyspecial_routines4;T0* _yyvs5;T2 _yyvsc5;T2 _yyvsp5;T0* _yyspecial_routines5;T0* _yyvs6;T2 _yyvsc6;T2 _yyvsp6;T0* _yyspecial_routines6;T0* _yyvs7;T2 _yyvsc7;T2 _yyvsp7;T0* _yyspecial_routines7;T0* _yyvs8;T2 _yyvsc8;T2 _yyvsp8;T0* _yyspecial_routines8;T0* _yyvs9;T2 _yyvsc9;T2 _yyvsp9;T0* _yyspecial_routines9;T0* _yyvs10;T2 _yyvsc10;T2 _yyvsp10;T0* _yyspecial_routines10;T0* _yyvs11;T2 _yyvsc11;T2 _yyvsp11;T0* _yyspecial_routines11;};
extern T165 M165;
struct S783{Tid id;T0* _element;T0* _character_data;T0* _processing_instruction;T0* _document;T0* _comment;T0* _xml_attribute;T0* _composite;};
extern T783 M783;
struct S44{T0* _path;T0* _event_parser;T0* _tree_pipe;};
extern T44 M44;
struct S748{T2 _count;T0* _first_cell;T0* _last_cell;};
extern T748 M748;
struct S536{Tid id;T0* _parent;T2 _count;T0* _first_cell;T0* _last_cell;T0* _internal_cursor;T0* _root_element;};
extern T536 M536;
extern T33 M33;
struct S449{Tid id;T0* _parameters;};
extern T449 M449;
extern T62 M62;
struct S746{T0* _item;T0* _right;};
extern T746 M746;
struct S410{T130 _storage;T2 _capacity;T2 _upper;};
extern T410 M410;
extern T162 M162;
struct S308{Tid id;T0* _target;};
extern T308 M308;
struct S274{Tid id;T2 _id;T0* _states;T0* _accepted_rules;T0* _accepted_head_rules;T0* _transitions;T2 _code;};
extern T274 M274;
struct S566{T107 _storage;T2 _capacity;T2 _upper;};
extern T566 M566;
struct S65{Tid id;T9 _storage;T2 _count;T2 _capacity;T2 _byte_count;T2 _last_byte_index_input;T2 _last_byte_index_result;};
extern T65 M65;
struct S99{Tid id;T96 _storage;T2 _capacity;T2 _upper;};
extern T99 M99;
struct S294{Tid id;T2 _count;T0* _storage;};
extern T294 M294;
struct S557{Tid id;T6 _item;};
extern T557 M557;
struct S509{Tid id;T0* _equality_tester;T2 _count;T2 _capacity;T2 _last_position;T2 _modulus;T2 _free_slot;T2 _position;T2 _slots_position;T2 _clashes_previous_position;T2 _found_position;T0* _internal_cursor;T0* _key_equality_tester;T0* _items;T0* _keys;T0* _clashes;T0* _slots;T0* _fixed_item_array_;T0* _fixed_key_array_;};
extern T509 M509;
struct S778{Tid id;T0* _parent;T0* _target;T0* _data;};
extern T778 M778;
struct S559{T0* _version;T0* _encoding;T6 _stand_alone;};
extern T559 M559;
struct S287{T289 _storage;T2 _capacity;T2 _upper;};
extern T287 M287;
struct S717{Tid id;T0* _uri;};
extern T717 M717;
struct S628{Tid id;T0* _container;T6 _after;T6 _before;T0* _current_cell;T0* _next_cursor;};
extern T628 M628;
struct S433{Tid id;T0* _content;T2 _count;T2 _capacity;T2 _position;T2 _column;T2 _line;T2 _index;T6 _beginning_of_line;T6 _filled;T6 _interactive;T0* _file;T6 _end_of_file;};
extern T433 M433;
struct S556{T2 _buffer_position;T9 _buffer;T2 _capacity;T0* _name;};
extern T556 M556;
extern T151 M151;
struct S175{Tid id;T2 _last_token;T0* _input_buffer;T2 _line;T2 _column;T2 _position;T2 _yy_start_state;T0* _yy_content;T0* _yy_content_area;T2 _yy_end;T2 _yy_start;T2 _yy_column;T2 _yy_line;T2 _yy_position;T6 _yy_more_flag;T2 _yy_more_len;T2 _yy_last_accepting_state;T2 _yy_last_accepting_cpos;T0* _yy_nxt;T0* _yy_chk;T0* _yy_base;T0* _yy_def;T0* _yy_ec;T0* _yy_meta;T0* _yy_accept;T0* _yy_acclist;T6 _yy_rejected;T0* _yy_state_stack;T2 _yy_state_count;T2 _yy_full_match;T2 _yy_lp;T2 _yy_looking_for_trail_begin;T2 _yy_full_lp;T2 _yy_full_state;T0* _input_stream;T0* _input_filter;T0* _last_error;T0* _filename;T0* _source;T0* _last_value;T0* _character_entity;T0* _start_conditions;T0* _resolver;T6 _is_external;T0* _value;T6 _in_use;};
extern T175 M175;
struct S448{Tid id;T0* _parameters;};
extern T448 M448;
struct S437{T0* _name;};
extern T437 M437;
struct S617{Tid id;T0* _last_string;T2 _encoding;T0* _utf_queue;T0* _impl;};
extern T617 M617;
struct S790{T0* _source;T2 _byte_index;T2 _column;T2 _row;};
extern T790 M790;
struct S784{Tid id;T0* _parent;T0* _name;T0* _namespace;T0* _value;};
extern T784 M784;
struct S552{T0* _html_file;T0* _bibtex_file;T0* _latex_file;T0* _xml_file;T0* _input_path;T0* _output_path;T0* _mode;T6 _recursive;T6 _enable_private;T0* _template_path;T0* _httpd_path;};
extern T552 M552;
struct S430{Tid id;T9 _storage;T2 _count;T2 _capacity;T2 _byte_count;T2 _last_byte_index_input;T2 _last_byte_index_result;};
extern T430 M430;
struct S692{Tid id;T2 _last_token;T0* _input_buffer;T2 _line;T2 _column;T2 _position;T2 _yy_start_state;T0* _yy_content;T0* _yy_content_area;T2 _yy_end;T2 _yy_start;T2 _yy_column;T2 _yy_line;T2 _yy_position;T6 _yy_more_flag;T2 _yy_more_len;T2 _yy_last_accepting_state;T2 _yy_last_accepting_cpos;T0* _yy_nxt;T0* _yy_chk;T0* _yy_base;T0* _yy_def;T0* _yy_ec;T0* _yy_meta;T0* _yy_accept;T0* _yy_acclist;T6 _yy_rejected;T0* _yy_state_stack;T2 _yy_state_count;T2 _yy_full_match;T2 _yy_lp;T2 _yy_looking_for_trail_begin;T2 _yy_full_lp;T2 _yy_full_state;T0* _input_stream;T0* _input_filter;T0* _last_error;T0* _filename;T0* _source;T0* _last_value;T0* _character_entity;T0* _start_conditions;T0* _resolver;T6 _is_external;T0* _value;T6 _in_use;T6 _pre_sent;T6 _post_sent;};
extern T692 M692;
struct S128{T130 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T128 M128;
struct S421{T423 _storage;T2 _capacity;T2 _upper;};
extern T421 M421;
struct S194{T0* _equality_tester;T2 _count;T2 _capacity;T2 _last_position;T2 _modulus;T2 _free_slot;T2 _position;T2 _slots_position;T2 _clashes_previous_position;T2 _found_position;T0* _internal_cursor;T0* _key_equality_tester;T0* _items;T0* _keys;T0* _clashes;T0* _slots;T0* _fixed_item_array_;T0* _fixed_key_array_;};
extern T194 M194;
struct S81{T6 _is_caseless;T6 _is_extended;T6 _is_greedy;T6 _is_multiline;T6 _is_dotall;T6 _is_empty_allowed;T6 _is_dollar_endonly;T6 _is_bol;T6 _is_eol;T6 _is_anchored;T6 _is_strict;T0* _byte_code;T0* _character_case_mapping;T0* _word_set;T0* _error_message;T2 _error_code;T2 _error_position;T6 _is_startline;T6 _is_ichanged;T2 _optchanged;T2 _code_index;T0* _pattern;T2 _pattern_position;T2 _pattern_count;T2 _subexpression_count;T2 _maxbackrefs;T0* _start_bits;T2 _first_character;T2 _required_character;T2 _regexp_countlits;T0* _subject;T2 _subject_start;T2 _subject_end;T2 _match_count;T6 _is_matching_caseless;T6 _is_matching_multiline;T6 _is_matching_dotall;T2 _subject_next_start;T2 _first_matched_index;T2 _eptr;T0* _offset_vector;T2 _offset_vector_count;T2 _offset_top;T96 _brastart_vector;T2 _brastart_lower;T2 _brastart_count;T2 _brastart_capacity;T96 _eptr_vector;T2 _eptr_lower;T2 _eptr_upper;T2 _eptr_capacity;};
extern T81 M81;
struct S222{T226 _storage;T2 _capacity;T2 _upper;};
extern T222 M222;
struct S582{T585 _storage;T2 _capacity;T2 _upper;};
extern T582 M582;
struct S374{Tid id;T0* _equality_tester;T2 _count;T2 _capacity;T2 _last_position;T2 _modulus;T2 _free_slot;T2 _position;T2 _slots_position;T2 _clashes_previous_position;T2 _found_position;T0* _internal_cursor;T0* _key_equality_tester;T0* _items;T0* _keys;T0* _clashes;T0* _slots;T0* _fixed_item_array_;T0* _fixed_key_array_;};
extern T374 M374;
struct S404{T284 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T404 M404;
struct S743{Tid id;T0* _parent;T0* _name;T0* _namespace;T2 _count;T0* _first_cell;T0* _last_cell;T0* _internal_cursor;};
extern T743 M743;
struct S535{T0* _ast;T6 _enable_private;T0* _path;T0* _str;T0* _tdocument;T0* _tcomment;};
extern T535 M535;
struct S490{T0* _comparator;};
extern T490 M490;
struct S100{T2 _count;T2 _capacity;T96 _byte_code;T107 _character_sets;T2 _character_sets_count;T2 _character_sets_capacity;};
extern T100 M100;
struct S620{T2 _count;T0* _first_cell;T0* _last_cell;};
extern T620 M620;
struct S228{Tid id;T230 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T228 M228;
struct S681{T0* _item;T0* _right;T0* _left;};
extern T681 M681;
struct S611{T613 _storage;T2 _capacity;T2 _upper;};
extern T611 M611;
struct S242{T2 _count;T0* _first_cell;};
extern T242 M242;
struct S604{T0* _equality_tester;T2 _count;T2 _capacity;T2 _last_position;T2 _modulus;T2 _free_slot;T2 _position;T2 _slots_position;T2 _clashes_previous_position;T2 _found_position;T0* _internal_cursor;T0* _items;T0* _clashes;T0* _slots;T0* _fixed_item_array_;};
extern T604 M604;
struct S37{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T37 M37;
struct S79{T0* _path;T9 _buffer;T2 _buffer_position;T2 _capacity;T8 _output_stream;};
extern T79 M79;
struct S749{T0* _ns_prefix;T0* _uri;};
extern T749 M749;
struct S605{T608 _storage;T2 _capacity;T2 _upper;};
extern T605 M605;
struct S439{T0* _equality_tester;T2 _count;T2 _capacity;T2 _last_position;T2 _modulus;T2 _free_slot;T2 _position;T2 _slots_position;T2 _clashes_previous_position;T2 _found_position;T0* _internal_cursor;T0* _key_equality_tester;T0* _items;T0* _keys;T0* _clashes;T0* _slots;T0* _fixed_item_array_;T0* _fixed_key_array_;};
extern T439 M439;
struct S569{Tid id;T0* _equality_tester;T2 _count;T0* _last_cell;T0* _internal_cursor;T0* _first_cell;};
extern T569 M569;
struct S24{T2 _buffer_position;T9 _buffer;T2 _capacity;};
extern T24 M24;
extern T39 M39;
struct S424{Tid id;T0* _parameters;};
extern T424 M424;
struct S484{Tid id;T0* _parameters;};
extern T484 M484;
struct S431{T0* _program_name;};
extern T431 M431;
struct S477{T0* _container;};
extern T477 M477;
struct S402{T0* _container;};
extern T402 M402;
extern char*s23_0;
extern char*s23_10;
extern char*s12_32;
extern char*s12_43;
extern char*s77_46;
extern char*s20_47;
extern char*s176_62;
extern char*s33_63;
extern char*s12_93;
extern char*s535_95;
extern char*s89_1607748595;
extern char*s254_252;
extern char*s33_276;
extern char*s77_277;
extern char*s29_324;
extern char*s40_7207;
extern char*s12_1956468118;
extern char*s12_1256;
extern char*s171_1338477769;
extern char*s89_269618764;
extern char*s29_576769141;
extern char*s40_1090070780;
extern char*s270_1173251759;
extern char*s617_90456;
extern char*s178_195717202;
extern char*s12_94835277;
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/

/*
  This file (SmartEiffel/sys/runtime/boost.h) is automatically included when
  `run_control.boost' is true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void se_signal_handler(int sig);
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/exception.h) is automatically included
  when exception handling is used somewhere in the live code.
*/

#define SE_EXCEPTIONS 1

/*
  Constants from Eiffel class EXCEPTIONS :
*/
#define Check_instruction 	  1
#define Class_invariant 	  2
#define Developer_exception 	  3
#define Incorrect_inspect_value   4
#define Loop_invariant 		  5
#define Loop_variant 		  6
#define No_more_memory  	  7
#define Postcondition 		  8
#define Precondition  		  9
#define Routine_failure  	  10
#define	Os_signal		  11
#define Void_attached_to_expanded 12
#define Void_call_target 	  13
#define System_level_type_error	  14

/*
   This will be the structure of rescue contexts.  A rescue context
   will be declared for every routine that has a rescue clause.

   The `next' pointer is the address of the next rescue context if there
   is one higher up the call chain, or NULL if there is no other
   context.
*/
struct rescue_context {
  JMP_BUF jb;
#ifndef SE_BOOST
    /* To keep track of dump stack to unwind it safely
       before the LONGJMP :
    */
    struct _se_dump_stack * top_of_ds ;
#endif
  struct rescue_context *next;
};

extern struct rescue_context *rescue_context_top;
extern int internal_exception_number;
extern int original_internal_exception_number;
extern int signal_exception_number;
extern char *additional_error_message;

void setup_signal_handler(void);
void signal_exception_handler(int);
void internal_exception_handler(int);
void print_exception(void);

#ifndef SE_BOOST
void free_exception_frames(void);
#endif
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/basic_directory.h) is automatically
  included when some external "SmartEiffel" feature of class BASIC_DIRECTORY
  is live.
*/

#ifndef WIN32
#  include <dirent.h>
#endif
#ifndef WIN32
#  include <unistd.h>
#endif

EIF_POINTER basic_directory_open(EIF_POINTER path);
EIF_POINTER basic_directory_read_entry(EIF_POINTER dirstream);
EIF_POINTER basic_directory_get_entry_name(EIF_POINTER entry);
EIF_BOOLEAN basic_directory_close(EIF_POINTER dirstream);
#define basic_directory_current_working_directory (basic_directory_cwd())
EIF_POINTER basic_directory_cwd(void);
EIF_BOOLEAN basic_directory_chdir(EIF_POINTER destination);
EIF_BOOLEAN basic_directory_mkdir(EIF_POINTER directory_path);
EIF_BOOLEAN basic_directory_rmdir(EIF_POINTER directory_path);
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/basic_io.h) is automatically
  included when some external "SmartEiffel" basic_io_* feature is used.
*/

#define basic_io_stdin (stdin)
#define basic_io_stdout (stdout)
#define basic_io_stderr (stderr)
#define basic_io_eof (EOF)
#define basic_io_text_file_read_open(p) (fopen(((char*)(p)),"r"))
#define basic_io_text_file_write_open(p) (fopen(((char*)(p)),"w"))
#define basic_io_text_file_write_append(p) (fopen(((char*)(p)),"a"))
#define basic_io_text_file_read_write_open(p) (fopen(((char*)(p)),"r+"))
#define basic_io_text_file_read_write_append(p) (fopen(((char*)(p)),"a+"))
#define basic_io_binary_file_read_open(p) (fopen(((char*)(p)),"rb"))
#define basic_io_binary_file_write_open(p) (fopen(((char*)(p)),"wb"))
#define basic_io_binary_file_write_append(p) (fopen(((char*)(p)),"ab"))
#define basic_io_fclose(p) (fclose((FILE*)(p)))
#define basic_io_flush(p) (fflush((FILE*)(p)))
#define basic_io_getc(f) (getc(((FILE*)(f))))
#define basic_io_putc(b, f) (putc((b),((FILE*)(f))))
#define basic_io_fread(b, n, f) (fread((void *)(b),(size_t)(1), (size_t)(n),(FILE*)(f)))
#define basic_io_fwrite(b, n, f) (fwrite((void *)(b),(size_t)(1), (size_t)(n),(FILE*)(f)))
#define basic_io_feof(f) (feof(((FILE*)(f))))
#define basic_io_rename(o, n) (rename(((char*)(o)),((char*)(n))))
#define basic_io_remove(f) (remove(((char*)(f))))

#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
#  define basic_io_read_stdin(b, s) (read(STDIN_FILENO, b, s))
#else
  extern int basic_io_read_stdin(char *buffer, int size);
#endif

/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/basic_sprintf.h) is automatically
  included when the external "SmartEiffel" basic_sprintf feature is used.
*/

#define basic_sprintf_pointer(buffer, pointer) sprintf((char*)(buffer),"%p",pointer)

void basic_sprintf_double(EIF_CHARACTER* b, int f, double d);
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/basic_getenv.h) is automatically
  included when the GENERAL.basic_getenv feature is used (ie. in live code).
*/

#define basic_getenv(v) (getenv((char*)v))
/*POINTER*/
T6 r8is_null(T8 C);
extern T0*oBC8string_buffer;
/*POINTER*/
void r8append_in(T8 C,T0* a1);
/*BOOLEAN*/
T6 r6_ix_and(T6 C,T6 a1);
/*BOOLEAN*/
T6 r6_px_not(T6 C);
/*BOOLEAN*/
T6 r6_ix_or(T6 C,T6 a1);
/*CHARACTER*/
T6 r3is_digit(T3 C);
/*CHARACTER*/
T6 r3is_separator(T3 C);
/*CHARACTER*/
T6 r3_ix_6061(T3 C,T3 a1);
/*CHARACTER*/
T1 r3value(T3 C);
/*CHARACTER*/
T6 r3same_as(T3 C,T3 a1);
/*CHARACTER*/
T1 r3decimal_value(T3 C);
/*CHARACTER*/
T6 r3_ix_6261(T3 C,T3 a1);
/*CHARACTER*/
T3 r3to_lower(T3 C);
/*CHARACTER*/
T6 r3_ix_60(T3 C,T3 a1);
/*CHARACTER*/
T6 r3_ix_62(T3 C,T3 a1);
/*INTEGER*/
T0* r2out(T2 C);
/*INTEGER*/
T6 r2is_equal(T2 C,T2 a1);
extern T0*oBC21string_buffer;
/*INTEGER*/
T2 r2max(T2 C,T2 a1);
/*INTEGER*/
T0* r2to_string(T2 C);
/*INTEGER*/
T2 r2min(T2 C,T2 a1);
/*INTEGER*/
T3 r2digit(T2 C);
/*INTEGER*/
T2 r2hash_code(T2 C);
/*INTEGER*/
void r2append_in(T2 C,T0* a1);
/*INTEGER*/
T11 r2to_integer_64(T2 C);
extern T0*oBC15tagged_out_memory;
/*INTEGER_16*/
T0* r10out(T10 C);
/*INTEGER_16*/
T3 r10digit(T10 C);
/*INTEGER_16*/
void r10append_in(T10 C,T0* a1);
/*NATIVE_ARRAY[DS_BILINKABLE[INTEGER]]*/
void r302set_all_with(T302 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[LX_SYMBOL_CLASS]*/
void r416clear_all(T416 C,T2 a1);
/*NATIVE_ARRAY[LX_SYMBOL_CLASS]*/
T416 r416realloc(T416 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_SYMBOL_CLASS]*/
void r416set_all_with(T416 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[LX_SYMBOL_CLASS]*/
void r416clear(T416 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_SYMBOL_CLASS]*/
void r416copy_from(T416 C,T416 a1,T2 a2);
/*NATIVE_ARRAY[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
void r608clear_all(T608 C,T2 a1);
/*NATIVE_ARRAY[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
T608 r608realloc(T608 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
void r608set_all_with(T608 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
void r608clear(T608 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
void r608copy_from(T608 C,T608 a1,T2 a2);
/*NATIVE_ARRAY[LX_START_CONDITION]*/
void r373clear_all(T373 C,T2 a1);
/*NATIVE_ARRAY[XM_DTD_EXTERNAL_ID]*/
void r597clear_all(T597 C,T2 a1);
/*NATIVE_ARRAY[XM_DTD_EXTERNAL_ID]*/
T597 r597realloc(T597 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_EXTERNAL_ID]*/
void r597set_all_with(T597 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_EXTERNAL_ID]*/
void r597clear(T597 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_EXTERNAL_ID]*/
void r597copy_from(T597 C,T597 a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
void r580clear_all(T580 C,T2 a1);
/*NATIVE_ARRAY[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
T580 r580realloc(T580 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
void r580set_all_with(T580 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
void r580clear(T580 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
void r580copy_from(T580 C,T580 a1,T2 a2);
/*NATIVE_ARRAY[BOOLEAN]*/
void r107clear_all(T107 C,T2 a1);
/*NATIVE_ARRAY[BOOLEAN]*/
T107 r107realloc(T107 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[BOOLEAN]*/
void r107set_all_with(T107 C,T6 a1,T2 a2);
/*NATIVE_ARRAY[BOOLEAN]*/
void r107clear(T107 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[BOOLEAN]*/
void r107copy_from(T107 C,T107 a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA]*/
void r369clear_all(T369 C,T2 a1);
/*NATIVE_ARRAY[LX_NFA]*/
T369 r369realloc(T369 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA]*/
void r369set_all_with(T369 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA]*/
void r369clear(T369 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA]*/
void r369copy_from(T369 C,T369 a1,T2 a2);
/*NATIVE_ARRAY[XM_NAMESPACE]*/
void r772clear_all(T772 C,T2 a1);
/*NATIVE_ARRAY[XM_NAMESPACE]*/
T772 r772realloc(T772 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_NAMESPACE]*/
void r772clear(T772 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_NAMESPACE]*/
void r772copy_from(T772 C,T772 a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[STRING]]*/
void r573clear_all(T573 C,T2 a1);
/*NATIVE_ARRAY[DS_BILINKED_LIST[STRING]]*/
T573 r573realloc(T573 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[STRING]]*/
void r573set_all_with(T573 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[STRING]]*/
void r573clear(T573 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[STRING]]*/
void r573copy_from(T573 C,T573 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ELEMENT_CONTENT]*/
void r591clear_all(T591 C,T2 a1);
/*NATIVE_ARRAY[XM_DTD_ELEMENT_CONTENT]*/
T591 r591realloc(T591 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ELEMENT_CONTENT]*/
void r591set_all_with(T591 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ELEMENT_CONTENT]*/
void r591clear(T591 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ELEMENT_CONTENT]*/
void r591copy_from(T591 C,T591 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_DECLARATION]*/
void r564clear_all(T564 C,T2 a1);
/*NATIVE_ARRAY[XM_EIFFEL_DECLARATION]*/
T564 r564realloc(T564 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_DECLARATION]*/
void r564set_all_with(T564 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_DECLARATION]*/
void r564clear(T564 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_DECLARATION]*/
void r564copy_from(T564 C,T564 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_16]*/
void r230set_all_with(T230 C,T10 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/
void r130clear_all(T130 C,T2 a1);
/*NATIVE_ARRAY[STRING]*/
T130 r130realloc(T130 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/
void r130set_all_with(T130 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/
void r130clear(T130 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/
void r130copy_from(T130 C,T130 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_PARSER_NAME]*/
void r613clear_all(T613 C,T2 a1);
/*NATIVE_ARRAY[XM_EIFFEL_PARSER_NAME]*/
T613 r613realloc(T613 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_PARSER_NAME]*/
void r613set_all_with(T613 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_PARSER_NAME]*/
void r613clear(T613 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_PARSER_NAME]*/
void r613copy_from(T613 C,T613 a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA_STATE]*/
void r332clear_all(T332 C,T2 a1);
/*NATIVE_ARRAY[LX_NFA_STATE]*/
T332 r332realloc(T332 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA_STATE]*/
void r332clear(T332 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA_STATE]*/
void r332copy_from(T332 C,T332 a1,T2 a2);
/*NATIVE_ARRAY[LX_RULE]*/
void r284clear_all(T284 C,T2 a1);
/*NATIVE_ARRAY[LX_RULE]*/
T284 r284realloc(T284 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_RULE]*/
void r284set_all_with(T284 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[LX_RULE]*/
void r284clear(T284 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_RULE]*/
void r284copy_from(T284 C,T284 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_ENTITY_DEF]*/
void r226clear_all(T226 C,T2 a1);
/*NATIVE_ARRAY[XM_EIFFEL_ENTITY_DEF]*/
T226 r226realloc(T226 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_ENTITY_DEF]*/
void r226clear(T226 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_ENTITY_DEF]*/
void r226copy_from(T226 C,T226 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
void r9copy_slice(T9 C,T2 a1,T9 a2,T2 a3,T2 a4);
/*NATIVE_ARRAY[CHARACTER]*/
T9 r9realloc(T9 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
void r9move(T9 C,T2 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/
void r9set_all_with(T9 C,T3 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
T6 r9fast_has(T9 C,T3 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/
void r9clear(T9 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
void r9copy_from(T9 C,T9 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_8]*/
void r236set_all_with(T236 C,T1 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ATTRIBUTE_CONTENT]*/
void r585clear_all(T585 C,T2 a1);
/*NATIVE_ARRAY[XM_DTD_ATTRIBUTE_CONTENT]*/
T585 r585realloc(T585 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ATTRIBUTE_CONTENT]*/
void r585set_all_with(T585 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ATTRIBUTE_CONTENT]*/
void r585clear(T585 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ATTRIBUTE_CONTENT]*/
void r585copy_from(T585 C,T585 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER]*/
void r96clear_all(T96 C,T2 a1);
/*NATIVE_ARRAY[INTEGER]*/
T96 r96realloc(T96 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER]*/
void r96set_all_with(T96 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER]*/
void r96clear(T96 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER]*/
void r96copy_from(T96 C,T96 a1,T2 a2);
/*NATIVE_ARRAY[LX_DFA_STATE]*/
void r289clear_all(T289 C,T2 a1);
/*NATIVE_ARRAY[LX_DFA_STATE]*/
T289 r289realloc(T289 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_DFA_STATE]*/
void r289set_all_with(T289 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[LX_DFA_STATE]*/
void r289clear(T289 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_DFA_STATE]*/
void r289copy_from(T289 C,T289 a1,T2 a2);
/*NATIVE_ARRAY[ANY]*/
void r423clear_all(T423 C,T2 a1);
/*NATIVE_ARRAY[ANY]*/
T423 r423realloc(T423 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ANY]*/
void r423set_all_with(T423 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[ANY]*/
void r423clear(T423 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ANY]*/
void r423copy_from(T423 C,T423 a1,T2 a2);
/*STRING*/
T0* r7out(T7* C);
/*STRING*/
void r7copy(T7* C,T0* a1);
/*STRING*/
T0* r7substring(T7* C,T2 a1,T2 a2);
/*STRING*/
T3 r7last(T7* C);
/*STRING*/
T2 r7first_substring_index(T7* C,T0* a1);
/*STRING*/
T2 r7item_code(T7* C,T2 a1);
/*STRING*/
void r7remove_between(T7* C,T2 a1,T2 a2);
/*STRING*/
T6 r7is_equal(T7* C,T0* a1);
/*STRING*/
T3 r7item(T7* C,T2 a1);
/*STRING*/
void r7append(T7* C,T0* a1);
/*STRING*/
T6 r7se_assigned_from(T0* a1);
/*STRING*/
void r7print_on(T7* C,T0* a1);
/*STRING*/
void r7make_from_string(T7* C,T0* a1);
/*STRING*/
T2 r7index_of(T7* C,T3 a1,T2 a2);
/*STRING*/
void r7out_in_tagged_out_memory(T7* C);
/*STRING*/
T6 r7same_type(T7* C,T0* a1);
/*STRING*/
void r7remove_tail(T7* C,T2 a1);
/*STRING*/
void r7make(T7* C,T2 a1);
/*STRING*/
void r7fill_tagged_out_memory(T7* C);
/*STRING*/
void r7append_string(T7* C,T0* a1);
/*STRING*/
void r7make_filled(T7* C,T3 a1,T2 a2);
/*STRING*/
void r7remove(T7* C,T2 a1);
/*STRING*/
T0* r7string(T7* C);
/*STRING*/
void r7extend(T7* C,T3 a1);
/*STRING*/
T2 r7hash_code(T7* C);
/*STRING*/
void r7remove_last(T7* C,T2 a1);
/*STRING*/
T6 r7conforms_to(T7* C,T0* a1);
/*STRING*/
T6 r7has(T7* C,T3 a1);
/*STRING*/
T2 r7to_integer(T7* C);
/*STRING*/
void r7append_character(T7* C,T3 a1);
/*STRING*/
void r7extend_unless(T7* C,T3 a1);
/*STRING*/
T6 r7same_as(T7* C,T0* a1);
/*STRING*/
void r7add_last(T7* C,T3 a1);
/*STRING*/
T3 r7first(T7* C);
/*STRING*/
void r7resize(T7* C,T2 a1);
/*STRING*/
T2 r7substring_index(T7* C,T0* a1,T2 a2);
/*STRING*/
void r7from_external_copy(T7* C,T8 a1);
/*STRING*/
void r7replace_substring(T7* C,T0* a1,T2 a2,T2 a3);
/*STRING*/
T8 r7to_external(T7* C);
/*STRING*/
void r7to_lower(T7* C);
/*STRING*/
T0* r7twin(T7* C);
/*STRING*/
T0* r7_ix_43(T7* C,T0* a1);
/*STRING*/
void r7swap(T7* C,T2 a1,T2 a2);
/*FIXED_ARRAY[BOOLEAN]*/
void r105make(T105* C,T2 a1);
/*ARRAY[DS_BILINKABLE[INTEGER]]*/
T2 r299count(T299* C);
/*ARRAY[DS_BILINKABLE[INTEGER]]*/
T0* r299item(T299* C,T2 a1);
/*ARRAY[DS_BILINKABLE[INTEGER]]*/
void r299make(T299* C,T2 a1,T2 a2);
/*ARRAY[INTEGER]*/
void r233clear_all(T233* C);
/*ARRAY[INTEGER]*/
T2 r233count(T233* C);
/*ARRAY[INTEGER]*/
T2 r233item(T233* C,T2 a1);
/*ARRAY[INTEGER]*/
void r233make(T233* C,T2 a1,T2 a2);
/*FIXED_ARRAY[LX_NFA]*/
void r367make(T367* C,T2 a1);
/*FIXED_ARRAY[LX_NFA]*/
void r367resize(T367* C,T2 a1);
/*ARRAY[LX_DFA_STATE]*/
T0* r292item(T292* C,T2 a1);
/*ARRAY[LX_DFA_STATE]*/
void r292make(T292* C,T2 a1,T2 a2);
/*ARRAY[XM_CALLBACKS_FILTER]*/
T0* r144item(T144* C,T2 a1);
/*FIXED_ARRAY[XM_NAMESPACE]*/
void r769make(T769* C,T2 a1);
/*FIXED_ARRAY[XM_NAMESPACE]*/
void r769resize(T769* C,T2 a1);
/*FIXED_ARRAY[LX_SYMBOL_CLASS]*/
void r414make(T414* C,T2 a1);
/*FIXED_ARRAY[LX_SYMBOL_CLASS]*/
void r414resize(T414* C,T2 a1);
/*ARRAY[RX_CHARACTER_SET]*/
T0* r126item(T126* C,T2 a1);
/*FIXED_ARRAY[LX_NFA_STATE]*/
void r330make(T330* C,T2 a1);
/*FIXED_ARRAY[LX_NFA_STATE]*/
void r330resize(T330* C,T2 a1);
/*ARRAY[BOOLEAN]*/
T6 r295item(T295* C,T2 a1);
/*ARRAY[BOOLEAN]*/
void r295make(T295* C,T2 a1,T2 a2);
/*ARRAY[ARRAY[INTEGER]]*/
T0* r785item(T785* C,T2 a1);
/*FIXED_ARRAY[STRING]*/
void r221make(T221* C,T2 a1);
/*FIXED_ARRAY[STRING]*/
void r221resize(T221* C,T2 a1);
/*FIXED_ARRAY[LX_RULE]*/
void r282make(T282* C,T2 a1);
/*FIXED_ARRAY[LX_RULE]*/
void r282resize(T282* C,T2 a1);
/*ARRAY[INTEGER_8]*/
T2 r234count(T234* C);
/*ARRAY[INTEGER_8]*/
T1 r234item(T234* C,T2 a1);
/*ARRAY[INTEGER_8]*/
void r234make(T234* C,T2 a1,T2 a2);
/*FIXED_ARRAY[LX_START_CONDITION]*/
void r371make(T371* C,T2 a1);
/*FIXED_ARRAY[INTEGER]*/
void r99copy(T99* C,T0* a1);
/*FIXED_ARRAY[INTEGER]*/
void r99make(T99* C,T2 a1);
/*FIXED_ARRAY[INTEGER]*/
void r99resize(T99* C,T2 a1);
/*FIXED_ARRAY[INTEGER]*/
T0* r99twin(T99* C);
/*FIXED_ARRAY[INTEGER]*/
void r99with_capacity(T99* C,T2 a1);
/*FIXED_ARRAY[INTEGER]*/
void r99from_collection(T99* C,T0* a1);
/*FIXED_ARRAY[LX_DFA_STATE]*/
void r287make(T287* C,T2 a1);
/*FIXED_ARRAY[LX_DFA_STATE]*/
void r287resize(T287* C,T2 a1);
/*ARRAY[STRING]*/
T2 r128count(T128* C);
/*ARRAY[STRING]*/
T0* r128item(T128* C,T2 a1);
/*ARRAY[STRING]*/
T6 r128valid_index(T128* C,T2 a1);
/*ARRAY[STRING]*/
void r128make(T128* C,T2 a1,T2 a2);
/*FIXED_ARRAY[ANY]*/
void r421make(T421* C,T2 a1);
/*FIXED_ARRAY[ANY]*/
void r421resize(T421* C,T2 a1);
/*FIXED_ARRAY[XM_EIFFEL_ENTITY_DEF]*/
void r222make(T222* C,T2 a1);
/*FIXED_ARRAY[XM_EIFFEL_ENTITY_DEF]*/
void r222resize(T222* C,T2 a1);
/*ARRAY[LX_RULE]*/
void r404make(T404* C,T2 a1,T2 a2);
/*ARRAY[INTEGER_16]*/
T2 r228count(T228* C);
/*ARRAY[INTEGER_16]*/
T10 r228item(T228* C,T2 a1);
/*ARRAY[INTEGER_16]*/
void r228make(T228* C,T2 a1,T2 a2);
/*FIXED_ARRAY[XM_EIFFEL_PARSER_NAME]*/
void r611make(T611* C,T2 a1);
/*FIXED_ARRAY[XM_EIFFEL_PARSER_NAME]*/
void r611resize(T611* C,T2 a1);
/*DS_BUBBLE_SORTER[LX_NFA_STATE]*/
void r325subsort_with_comparator(T0* a1,T0* a2,T2 a3,T2 a4);
/*DS_BUBBLE_SORTER[LX_NFA_STATE]*/
void r325sort_with_comparator(T0* a1,T0* a2);
/*SPECIAL[ANY]*/
void r420make(T420* C,T2 a1);
/*SPECIAL[ANY]*/
T0* r420resize(T420* C,T2 a1);
/*SPECIAL[ANY]*/
void r420array_resize(T420* C,T2 a1);
/*KL_SPECIAL_ROUTINES[ANY]*/
T0* r419make(T2 a1);
/*KL_SPECIAL_ROUTINES[ANY]*/
T0* r419resize(T0* a1,T2 a2);
/*DS_HASH_SET_CURSOR[XM_EIFFEL_PARSER_NAME]*/
void r654make(T654* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
T2 r405new_capacity(T2 a1);
/*DS_ARRAYED_LIST[STRING]*/
T6 r405extendible(T405* C,T2 a1);
/*DS_ARRAYED_LIST[STRING]*/
T0* r405last(T405* C);
/*DS_ARRAYED_LIST[STRING]*/
T0* r405cursor_item(T405* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
void r405remove_traversing_cursor(T405* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
void r405add_traversing_cursor(T405* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
T6 r405cursor_before(T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
void r405make(T405* C,T2 a1);
/*DS_ARRAYED_LIST[STRING]*/
T6 r405cursor_after(T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
void r405cursor_forth(T405* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
void r405resize(T405* C,T2 a1);
/*DS_ARRAYED_LIST[STRING]*/
void r405cursor_start(T405* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
void r405force_last(T405* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
T0* r405new_cursor(T405* C);
/*DS_ARRAYED_LIST[STRING]*/
T6 r405cursor_off(T0* a1);
/*SPECIAL[LX_NFA]*/
void r408make(T408* C,T2 a1);
/*SPECIAL[LX_NFA]*/
T0* r408resize(T408* C,T2 a1);
/*SPECIAL[LX_NFA]*/
void r408array_resize(T408* C,T2 a1);
/*LX_TRANSITION_TABLE[LX_DFA_STATE]*/
void r291set_target(T291* C,T0* a1,T2 a2);
/*LX_TRANSITION_TABLE[LX_DFA_STATE]*/
void r291make(T291* C,T2 a1,T2 a2);
/*DS_BILINKABLE[INTEGER]*/
void r300put_left(T300* C,T0* a1);
/*DS_BILINKABLE[INTEGER]*/
void r300put_right(T300* C,T0* a1);
/*DS_PAIR[XM_POSITION,XM_NODE]*/
void r738make(T738* C,T0* a1,T0* a2);
/*KL_SPECIAL_ROUTINES[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
T0* r603make(T2 a1);
/*KL_SPECIAL_ROUTINES[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
T0* r603resize(T0* a1,T2 a2);
/*SPECIAL[INTEGER]*/
void r418make(T418* C,T2 a1);
/*SPECIAL[INTEGER]*/
T0* r418resize(T418* C,T2 a1);
/*SPECIAL[INTEGER]*/
void r418array_resize(T418* C,T2 a1);
/*KL_SPECIAL_ROUTINES[DS_BILINKED_LIST[STRING]]*/
T0* r568make(T2 a1);
/*KL_SPECIAL_ROUTINES[DS_BILINKED_LIST[STRING]]*/
T0* r568resize(T0* a1,T2 a2);
/*SPECIAL[LX_SYMBOL_CLASS]*/
void r413make(T413* C,T2 a1);
/*SPECIAL[LX_SYMBOL_CLASS]*/
T0* r413resize(T413* C,T2 a1);
/*SPECIAL[LX_SYMBOL_CLASS]*/
void r413array_resize(T413* C,T2 a1);
/*DS_BILINKABLE[XM_DTD_ELEMENT_CONTENT]*/
void r793put_right(T793* C,T0* a1);
/*DS_HASH_SET_CURSOR[XM_NAMESPACE]*/
void r767make(T767* C,T0* a1);
/*DS_LINKED_STACK[XM_EIFFEL_SCANNER]*/
void r241force(T241* C,T0* a1);
/*DS_LINKED_STACK[XM_EIFFEL_SCANNER]*/
void r241remove(T241* C);
/*KL_FIXED_ARRAY_ROUTINES[LX_SYMBOL_CLASS]*/
T0* r467make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_SYMBOL_CLASS]*/
T0* r467resize(T0* a1,T2 a2);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r775set(T775* C,T0* a1,T6 a2,T6 a3);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
T6 r775is_first(T775* C);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
T6 r775is_last(T775* C);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r775make(T775* C,T0* a1);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r775remove(T775* C);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r775forth(T775* C);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r775start(T775* C);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r775go_after(T775* C);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r775set_after(T775* C);
/*DS_ARRAYED_LIST_CURSOR[STRING]*/
T0* r531item(T531* C);
/*DS_ARRAYED_LIST_CURSOR[STRING]*/
T6 r531after(T531* C);
/*DS_ARRAYED_LIST_CURSOR[STRING]*/
T6 r531off(T531* C);
/*KL_SPECIAL_ROUTINES[XM_DTD_EXTERNAL_ID]*/
T0* r593make(T2 a1);
/*KL_SPECIAL_ROUTINES[XM_DTD_EXTERNAL_ID]*/
T0* r593resize(T0* a1,T2 a2);
/*LX_SYMBOL_CLASS_TRANSITION[LX_NFA_STATE]*/
T6 r466labeled(T466* C,T2 a1);
/*LX_SYMBOL_CLASS_TRANSITION[LX_NFA_STATE]*/
void r466make(T466* C,T0* a1,T0* a2);
/*LX_SYMBOL_CLASS_TRANSITION[LX_NFA_STATE]*/
T0* r466twin(T466* C);
/*LX_SYMBOL_CLASS_TRANSITION[LX_NFA_STATE]*/
void r466record(T466* C,T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_NFA]*/
T0* r380make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_NFA]*/
T0* r380resize(T0* a1,T2 a2);
/*KL_SPECIAL_ROUTINES[XM_DTD_ATTRIBUTE_CONTENT]*/
T0* r581make(T2 a1);
/*KL_SPECIAL_ROUTINES[XM_DTD_ATTRIBUTE_CONTENT]*/
T0* r581resize(T0* a1,T2 a2);
/*KL_EQUALITY_TESTER[STRING]*/
T6 r196test(T0* a1,T0* a2);
/*DS_BILINKED_LIST_CURSOR[STRING]*/
void r630set(T630* C,T0* a1,T6 a2,T6 a3);
/*DS_BILINKED_LIST_CURSOR[STRING]*/
void r630make(T630* C,T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[XM_EIFFEL_ENTITY_DEF]*/
T0* r223make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[XM_EIFFEL_ENTITY_DEF]*/
T0* r223resize(T0* a1,T2 a2);
/*KL_FIXED_ARRAY_ROUTINES[ANY]*/
T0* r553make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[ANY]*/
T0* r553resize(T0* a1,T2 a2);
/*LX_SYMBOL_TRANSITION[LX_NFA_STATE]*/
void r481make(T481* C,T2 a1,T0* a2);
/*LX_SYMBOL_TRANSITION[LX_NFA_STATE]*/
T0* r481twin(T481* C);
/*LX_SYMBOL_TRANSITION[LX_NFA_STATE]*/
void r481record(T481* C,T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[INTEGER]*/
T0* r121to_fixed_array(T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[INTEGER]*/
T0* r121make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[INTEGER]*/
T0* r121make_from_array(T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[INTEGER]*/
T0* r121resize(T0* a1,T2 a2);
/*KL_COMPARABLE_COMPARATOR[LX_NFA_STATE]*/
T6 r324less_than(T0* a1,T0* a2);
/*DS_HASH_TABLE_CURSOR[STRING,STRING]*/
T0* r523item(T523* C);
/*DS_HASH_TABLE_CURSOR[STRING,STRING]*/
T6 r523after(T523* C);
/*DS_HASH_TABLE_CURSOR[STRING,STRING]*/
void r523make(T523* C,T0* a1);
/*KL_SPECIAL_ROUTINES[BOOLEAN]*/
T0* r565make(T2 a1);
/*KL_SPECIAL_ROUTINES[BOOLEAN]*/
T0* r565resize(T0* a1,T2 a2);
/*LINK[COMMENT]*/
void r117make(T117* C,T0* a1,T0* a2);
/*KL_NATIVE_ARRAY_ROUTINES[BOOLEAN]*/
T107 r123make(T2 a1);
/*KL_NATIVE_ARRAY_ROUTINES[BOOLEAN]*/
T107 r123resize(T107 a1,T2 a2,T2 a3);
/*KL_COMPARABLE_COMPARATOR[INTEGER]*/
T6 r489less_than(T2 a1,T2 a2);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r726set_last_cell(T726* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r726wipe_out(T726* C);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r726cursor_back(T726* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
T0* r726cursor_item(T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r726remove_traversing_cursor(T726* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r726move_all_cursors_after(T726* C);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r726add_traversing_cursor(T726* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
T6 r726cursor_before(T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r726make(T726* C);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r726remove_last(T726* C);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r726cursor_finish(T726* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r726move_last_cursors_after(T726* C);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r726cursor_go_before(T726* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r726force_last(T726* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
T0* r726new_cursor(T726* C);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
T6 r726cursor_off(T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_START_CONDITION]*/
T0* r506make(T2 a1);
/*KL_SPECIAL_ROUTINES[LX_NFA]*/
T0* r407make(T2 a1);
/*KL_SPECIAL_ROUTINES[LX_NFA]*/
T0* r407resize(T0* a1,T2 a2);
/*DS_BUBBLE_SORTER[LX_RULE]*/
void r318subsort_with_comparator(T0* a1,T0* a2,T2 a3,T2 a4);
/*DS_BUBBLE_SORTER[LX_RULE]*/
void r318sort_with_comparator(T0* a1,T0* a2);
/*DS_ARRAYED_LIST[LX_RULE]*/
T2 r281new_capacity(T2 a1);
/*DS_ARRAYED_LIST[LX_RULE]*/
T6 r281extendible(T281* C,T2 a1);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r281move_cursors_right(T281* C,T2 a1,T2 a2);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r281put(T281* C,T0* a1,T2 a2);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r281force_first(T281* C,T0* a1);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r281make(T281* C,T2 a1);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r281move_right(T281* C,T2 a1,T2 a2);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r281resize(T281* C,T2 a1);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r281force_last(T281* C,T0* a1);
/*DS_ARRAYED_LIST[LX_RULE]*/
T0* r281new_cursor(T281* C);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r281put_last(T281* C,T0* a1);
/*DS_PAIR[STRING,STRING]*/
void r696make(T696* C,T0* a1,T0* a2);
/*LINK[STRING]*/
void r118make(T118* C,T0* a1,T0* a2);
/*DS_BILINKABLE[DS_HASH_TABLE[STRING,STRING]]*/
void r780put_right(T780* C,T0* a1);
/*DS_BILINKED_LIST_CURSOR[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r707set(T707* C,T0* a1,T6 a2,T6 a3);
/*DS_BILINKED_LIST_CURSOR[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r707make(T707* C,T0* a1);
/*DS_ARRAYED_LIST[LX_DFA_STATE]*/
void r285make(T285* C,T2 a1);
/*DS_ARRAYED_LIST[LX_DFA_STATE]*/
void r285resize(T285* C,T2 a1);
/*DS_ARRAYED_LIST[LX_DFA_STATE]*/
T0* r285new_cursor(T285* C);
/*DS_ARRAYED_LIST[LX_DFA_STATE]*/
void r285put_last(T285* C,T0* a1);
/*SPECIAL[XM_DTD_ELEMENT_CONTENT]*/
void r588make(T588* C,T2 a1);
/*SPECIAL[XM_DTD_ELEMENT_CONTENT]*/
T0* r588resize(T588* C,T2 a1);
/*SPECIAL[XM_DTD_ELEMENT_CONTENT]*/
void r588array_resize(T588* C,T2 a1);
/*KL_SPECIAL_ROUTINES[XM_EIFFEL_DECLARATION]*/
T0* r560make(T2 a1);
/*KL_SPECIAL_ROUTINES[XM_EIFFEL_DECLARATION]*/
T0* r560resize(T0* a1,T2 a2);
/*LINKED_LIST[DOCUMENT]*/
T0* r113item(T113* C,T2 a1);
/*LINKED_LIST[DOCUMENT]*/
void r113make(T113* C);
/*LINKED_LIST[DOCUMENT]*/
void r113add_last(T113* C,T0* a1);
/*LINKED_LIST[DOCUMENT]*/
void r113go_item(T113* C,T2 a1);
/*KL_SPECIAL_ROUTINES[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
T0* r575make(T2 a1);
/*KL_SPECIAL_ROUTINES[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
T0* r575resize(T0* a1,T2 a2);
/*DS_ARRAYED_LIST[LX_NFA]*/
T2 r365new_capacity(T2 a1);
/*DS_ARRAYED_LIST[LX_NFA]*/
T6 r365extendible(T365* C,T2 a1);
/*DS_ARRAYED_LIST[LX_NFA]*/
void r365make(T365* C,T2 a1);
/*DS_ARRAYED_LIST[LX_NFA]*/
void r365resize(T365* C,T2 a1);
/*DS_ARRAYED_LIST[LX_NFA]*/
void r365force_last(T365* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA]*/
T0* r365new_cursor(T365* C);
/*KL_FIXED_ARRAY_ROUTINES[XM_EIFFEL_PARSER_NAME]*/
T0* r637make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[XM_EIFFEL_PARSER_NAME]*/
T0* r637resize(T0* a1,T2 a2);
/*SPECIAL[DS_BILINKED_LIST[STRING]]*/
void r570make(T570* C,T2 a1);
/*SPECIAL[DS_BILINKED_LIST[STRING]]*/
T0* r570resize(T570* C,T2 a1);
/*SPECIAL[DS_BILINKED_LIST[STRING]]*/
void r570array_resize(T570* C,T2 a1);
/*SPECIAL[XM_EIFFEL_PARSER_NAME]*/
void r610make(T610* C,T2 a1);
/*SPECIAL[XM_EIFFEL_PARSER_NAME]*/
T0* r610resize(T610* C,T2 a1);
/*SPECIAL[XM_EIFFEL_PARSER_NAME]*/
void r610array_resize(T610* C,T2 a1);
/*KL_SPECIAL_ROUTINES[LX_SYMBOL_CLASS]*/
T0* r412make(T2 a1);
/*KL_SPECIAL_ROUTINES[LX_SYMBOL_CLASS]*/
T0* r412resize(T0* a1,T2 a2);
/*KL_FIXED_ARRAY_ROUTINES[LX_NFA_STATE]*/
T0* r333make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_NFA_STATE]*/
T0* r333resize(T0* a1,T2 a2);
/*SPECIAL[XM_EIFFEL_DECLARATION]*/
void r561make(T561* C,T2 a1);
/*SPECIAL[XM_EIFFEL_DECLARATION]*/
T0* r561resize(T561* C,T2 a1);
/*SPECIAL[XM_EIFFEL_DECLARATION]*/
void r561array_resize(T561* C,T2 a1);
/*DS_HASH_TABLE_CURSOR[LX_SYMBOL_CLASS,STRING]*/
T0* r453item(T453* C);
/*DS_HASH_TABLE_CURSOR[LX_SYMBOL_CLASS,STRING]*/
T6 r453after(T453* C);
/*DS_HASH_TABLE_CURSOR[LX_SYMBOL_CLASS,STRING]*/
void r453make(T453* C,T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[XM_NAMESPACE]*/
T0* r770make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[XM_NAMESPACE]*/
T0* r770resize(T0* a1,T2 a2);
/*SPECIAL[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
void r577make(T577* C,T2 a1);
/*SPECIAL[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
T0* r577resize(T577* C,T2 a1);
/*SPECIAL[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
void r577array_resize(T577* C,T2 a1);
/*DS_BILINKED_LIST[XM_DTD_ELEMENT_CONTENT]*/
void r660force_first(T660* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ELEMENT_CONTENT]*/
void r660make(T660* C);
/*DS_BILINKED_LIST[XM_DTD_ELEMENT_CONTENT]*/
void r660force_last(T660* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ELEMENT_CONTENT]*/
T0* r660new_cursor(T660* C);
/*KL_SPECIAL_ROUTINES[XM_DTD_ELEMENT_CONTENT]*/
T0* r587make(T2 a1);
/*KL_SPECIAL_ROUTINES[XM_DTD_ELEMENT_CONTENT]*/
T0* r587resize(T0* a1,T2 a2);
/*LINKED_LIST[STRING]*/
T0* r38item(T38* C,T2 a1);
/*LINKED_LIST[STRING]*/
void r38make(T38* C);
/*LINKED_LIST[STRING]*/
void r38add_last(T38* C,T0* a1);
/*LINKED_LIST[STRING]*/
void r38go_item(T38* C,T2 a1);
/*DS_LINKED_LIST[STRING]*/
T0* r631last(T631* C);
/*DS_LINKED_LIST[STRING]*/
T0* r631cursor_item(T0* a1);
/*DS_LINKED_LIST[STRING]*/
void r631remove_traversing_cursor(T631* C,T0* a1);
/*DS_LINKED_LIST[STRING]*/
T0* r631item(T631* C,T2 a1);
/*DS_LINKED_LIST[STRING]*/
void r631add_traversing_cursor(T631* C,T0* a1);
/*DS_LINKED_LIST[STRING]*/
void r631make(T631* C);
/*DS_LINKED_LIST[STRING]*/
T6 r631cursor_after(T0* a1);
/*DS_LINKED_LIST[STRING]*/
void r631cursor_forth(T631* C,T0* a1);
/*DS_LINKED_LIST[STRING]*/
void r631cursor_start(T631* C,T0* a1);
/*DS_LINKED_LIST[STRING]*/
void r631force_last(T631* C,T0* a1);
/*DS_LINKED_LIST[STRING]*/
T0* r631new_cursor(T631* C);
/*DS_LINKED_LIST[STRING]*/
T6 r631cursor_off(T0* a1);
/*DS_BILINKED_LIST_CURSOR[DS_HASH_TABLE[STRING,STRING]]*/
void r731set(T731* C,T0* a1,T6 a2,T6 a3);
/*DS_BILINKED_LIST_CURSOR[DS_HASH_TABLE[STRING,STRING]]*/
void r731set_before(T731* C);
/*DS_BILINKED_LIST_CURSOR[DS_HASH_TABLE[STRING,STRING]]*/
void r731make(T731* C,T0* a1);
/*DS_BILINKED_LIST_CURSOR[DS_HASH_TABLE[STRING,STRING]]*/
void r731set_after(T731* C);
/*KL_FIXED_ARRAY_ROUTINES[BOOLEAN]*/
T0* r110make(T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T2 r750new_capacity(T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r750make_equal(T750* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T0* r750keys_item(T750* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r750make_clashes(T750* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r750search_position(T750* C,T0* a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T0* r750item(T750* C,T0* a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r750make_items(T750* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r750make(T750* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T6 r750has(T750* C,T0* a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T2 r750hash_position(T750* C,T0* a1);
extern T0*oBC83fixed_integer_array_;
/*DS_HASH_SET[XM_NAMESPACE]*/
void r750items_resize(T750* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r750resize(T750* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r750clashes_resize(T750* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r750slots_resize(T750* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r750force_last(T750* C,T0* a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T0* r750new_cursor(T750* C);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r750make_slots(T750* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T2 r750new_modulus(T2 a1);
/*KL_ARRAY_ROUTINES[INTEGER]*/
void r251subcopy(T0* a1,T0* a2,T2 a3,T2 a4,T2 a5);
/*KL_NATIVE_ARRAY_ROUTINES[INTEGER]*/
T96 r103make(T2 a1);
/*KL_NATIVE_ARRAY_ROUTINES[INTEGER]*/
T96 r103resize(T96 a1,T2 a2,T2 a3);
/*DS_BILINKED_LIST_CURSOR[XM_DTD_ELEMENT_CONTENT]*/
void r671make(T671* C,T0* a1);
/*LINK[INTEGER]*/
void r120make(T120* C,T2 a1,T0* a2);
/*DS_BILINKED_LIST_CURSOR[XM_DTD_ATTRIBUTE_CONTENT]*/
void r687set(T687* C,T0* a1,T6 a2,T6 a3);
/*DS_BILINKED_LIST_CURSOR[XM_DTD_ATTRIBUTE_CONTENT]*/
void r687make(T687* C,T0* a1);
/*DS_HASH_TABLE_CURSOR[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r212make(T212* C,T0* a1);
/*LINKED_LIST[COMMENT]*/
T0* r115item(T115* C,T2 a1);
/*LINKED_LIST[COMMENT]*/
void r115make(T115* C);
/*LINKED_LIST[COMMENT]*/
void r115add_last(T115* C,T0* a1);
/*LINKED_LIST[COMMENT]*/
void r115go_item(T115* C,T2 a1);
/*KL_EQUALITY_TESTER[XM_NAMESPACE]*/
T6 r756test(T0* a1,T0* a2);
/*DS_ARRAYED_LIST_CURSOR[LX_NFA_STATE]*/
T0* r356item(T356* C);
/*DS_ARRAYED_LIST_CURSOR[LX_NFA_STATE]*/
T6 r356after(T356* C);
/*DS_ARRAYED_LIST_CURSOR[LX_NFA_STATE]*/
T6 r356off(T356* C);
/*DS_HASH_TABLE_CURSOR[LX_NFA,INTEGER]*/
void r392make(T392* C,T0* a1);
/*SPECIAL[XM_DTD_EXTERNAL_ID]*/
void r594make(T594* C,T2 a1);
/*SPECIAL[XM_DTD_EXTERNAL_ID]*/
T0* r594resize(T594* C,T2 a1);
/*SPECIAL[XM_DTD_EXTERNAL_ID]*/
void r594array_resize(T594* C,T2 a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
T0* r576cursor_item(T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
void r576remove_traversing_cursor(T576* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
void r576add_traversing_cursor(T576* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
void r576make(T576* C);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
T6 r576cursor_after(T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
void r576cursor_forth(T576* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
void r576cursor_start(T576* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
void r576force_last(T576* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
T0* r576new_cursor(T576* C);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
T6 r576cursor_off(T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
T0* r697cursor_item(T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r697remove_traversing_cursor(T697* C,T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r697add_traversing_cursor(T697* C,T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r697make(T697* C);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
T6 r697cursor_after(T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r697cursor_forth(T697* C,T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r697cursor_start(T697* C,T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r697force_last(T697* C,T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
T0* r697new_cursor(T697* C);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
T6 r697cursor_off(T0* a1);
/*DS_PAIR[DS_PAIR[STRING,STRING],STRING]*/
void r695make(T695* C,T0* a1,T0* a2);
/*DS_BILINKABLE[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r711put_right(T711* C,T0* a1);
/*LINK[DOCUMENT]*/
void r119make(T119* C,T0* a1,T0* a2);
/*DS_BILINKABLE[STRING]*/
void r690put_right(T690* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T2 r305new_capacity(T2 a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r305extendible(T305* C,T2 a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305append_last(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305move_cursors_right(T305* C,T2 a1,T2 a2);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T0* r305last(T305* C);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305put(T305* C,T0* a1,T2 a2);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T0* r305cursor_item(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r305is_equal(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305remove_traversing_cursor(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305add_traversing_cursor(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r305se_assigned_from(T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305print_on(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305out_in_tagged_out_memory(T305* C);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r305cursor_before(T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r305same_type(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305make(T305* C,T2 a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r305cursor_after(T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r305conforms_to(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r305has(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305move_right(T305* C,T2 a1,T2 a2);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305cursor_forth(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305resize(T305* C,T2 a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305cursor_start(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305force_last(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T0* r305new_cursor(T305* C);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305extend_last(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r305put_last(T305* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r305cursor_off(T0* a1);
/*KL_SPECIAL_ROUTINES[XM_EIFFEL_PARSER_NAME]*/
T0* r609make(T2 a1);
/*KL_SPECIAL_ROUTINES[XM_EIFFEL_PARSER_NAME]*/
T0* r609resize(T0* a1,T2 a2);
/*DS_LINKED_QUEUE[STRING]*/
void r748force(T748* C,T0* a1);
/*DS_LINKED_QUEUE[STRING]*/
void r748wipe_out(T748* C);
/*DS_LINKED_QUEUE[STRING]*/
T0* r748item(T748* C);
/*DS_LINKED_QUEUE[STRING]*/
void r748remove(T748* C);
/*SPECIAL[STRING]*/
void r410make(T410* C,T2 a1);
/*SPECIAL[STRING]*/
T0* r410resize(T410* C,T2 a1);
/*SPECIAL[STRING]*/
void r410array_resize(T410* C,T2 a1);
/*LX_EPSILON_TRANSITION[LX_NFA_STATE]*/
T6 r308labeled(T2 a1);
/*LX_EPSILON_TRANSITION[LX_NFA_STATE]*/
T0* r308twin(T308* C);
/*KL_FIXED_ARRAY_ROUTINES[LX_DFA_STATE]*/
T0* r359make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_DFA_STATE]*/
T0* r359resize(T0* a1,T2 a2);
/*SPECIAL[BOOLEAN]*/
void r566make(T566* C,T2 a1);
/*SPECIAL[BOOLEAN]*/
T0* r566resize(T566* C,T2 a1);
/*SPECIAL[BOOLEAN]*/
void r566array_resize(T566* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T2 r509new_capacity(T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509make_clashes(T509* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T0* r509cursor_item(T509* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509search_position(T509* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509remove_traversing_cursor(T509* C,T0* a1);
extern T2 oBC187default_capacity;
/*DS_HASH_TABLE[STRING,STRING]*/
void r509keys_resize(T509* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T0* r509item(T509* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509make_items(T509* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509add_traversing_cursor(T509* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509make(T509* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T6 r509cursor_after(T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T6 r509has(T509* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509make_keys(T509* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509force_new(T509* C,T0* a1,T0* a2);
/*DS_HASH_TABLE[STRING,STRING]*/
T2 r509hash_position(T509* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509cursor_forth(T509* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509items_resize(T509* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509resize(T509* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509make_with_equality_testers(T509* C,T2 a1,T0* a2,T0* a3);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509make_sparse_container(T509* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509cursor_start(T509* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509clashes_resize(T509* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509slots_resize(T509* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T0* r509new_cursor(T509* C);
/*DS_HASH_TABLE[STRING,STRING]*/
void r509make_slots(T509* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T2 r509new_modulus(T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T6 r509cursor_off(T0* a1);
/*DS_LINKED_LIST_CURSOR[STRING]*/
void r628set(T628* C,T0* a1,T6 a2,T6 a3);
/*DS_LINKED_LIST_CURSOR[STRING]*/
T0* r628item(T628* C);
/*DS_LINKED_LIST_CURSOR[STRING]*/
void r628make(T628* C,T0* a1);
/*DS_LINKED_LIST_CURSOR[STRING]*/
void r628forth(T628* C);
/*DS_LINKED_LIST_CURSOR[STRING]*/
void r628start(T628* C);
/*KL_EQUALITY_TESTER[XM_EIFFEL_PARSER_NAME]*/
T6 r640test(T0* a1,T0* a2);
/*KL_FIXED_ARRAY_ROUTINES[STRING]*/
T0* r219make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[STRING]*/
T0* r219resize(T0* a1,T2 a2);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
T2 r194new_capacity(T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194force(T194* C,T0* a1,T0* a2);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194wipe_out(T194* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194make_clashes(T194* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194search_position(T194* C,T0* a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194keys_resize(T194* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
T0* r194item(T194* C,T0* a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194move_all_cursors_after(T194* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194make_items(T194* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194slots_wipe_out(T194* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194make(T194* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194clashes_wipe_out(T194* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
T6 r194has(T194* C,T0* a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194make_keys(T194* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
T2 r194hash_position(T194* C,T0* a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194items_wipe_out(T194* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194items_resize(T194* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194resize(T194* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194make_with_equality_testers(T194* C,T2 a1,T0* a2,T0* a3);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194make_sparse_container(T194* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194clashes_resize(T194* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194slots_resize(T194* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194keys_wipe_out(T194* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
T0* r194new_cursor(T194* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r194make_slots(T194* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
T2 r194new_modulus(T2 a1);
/*KL_EQUALITY_TESTER[INTEGER]*/
T6 r378test(T2 a1,T2 a2);
/*SPECIAL[XM_DTD_ATTRIBUTE_CONTENT]*/
void r582make(T582* C,T2 a1);
/*SPECIAL[XM_DTD_ATTRIBUTE_CONTENT]*/
T0* r582resize(T582* C,T2 a1);
/*SPECIAL[XM_DTD_ATTRIBUTE_CONTENT]*/
void r582array_resize(T582* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
T2 r374new_capacity(T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374force(T374* C,T0* a1,T2 a2);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374make_clashes(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374search_position(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374keys_resize(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
T0* r374item(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374make_items(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374make(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
T6 r374has(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374make_keys(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
T2 r374hash_position(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374items_resize(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374make_with_equality_testers(T374* C,T2 a1,T0* a2,T0* a3);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374resize(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374make_sparse_container(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374clashes_resize(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374slots_resize(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
T0* r374new_cursor(T374* C);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r374make_slots(T374* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
T2 r374new_modulus(T2 a1);
/*DS_SHELL_SORTER[INTEGER]*/
void r490subsort_with_comparator(T0* a1,T0* a2,T2 a3,T2 a4);
/*DS_SHELL_SORTER[INTEGER]*/
void r490sort_with_comparator(T0* a1,T0* a2);
/*DS_LINKED_QUEUE[CHARACTER]*/
void r620force(T620* C,T3 a1);
/*DS_LINKED_QUEUE[CHARACTER]*/
void r620wipe_out(T620* C);
/*DS_LINKED_QUEUE[CHARACTER]*/
void r620remove(T620* C);
/*KL_SPECIAL_ROUTINES[INTEGER]*/
T0* r417make(T2 a1);
/*KL_SPECIAL_ROUTINES[INTEGER]*/
T0* r417resize(T0* a1,T2 a2);
/*DS_BILINKABLE[XM_DTD_ATTRIBUTE_CONTENT]*/
void r681put_right(T681* C,T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_RULE]*/
T0* r334make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_RULE]*/
T0* r334resize(T0* a1,T2 a2);
/*DS_LINKED_STACK[INTEGER]*/
void r242force(T242* C,T2 a1);
/*DS_LINKED_STACK[INTEGER]*/
void r242remove(T242* C);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
T2 r604new_capacity(T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r604make_equal(T604* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
T0* r604keys_item(T604* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r604make_clashes(T604* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r604search_position(T604* C,T0* a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r604make_items(T604* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r604make(T604* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
T6 r604has(T604* C,T0* a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r604force_new(T604* C,T0* a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
T2 r604hash_position(T604* C,T0* a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r604items_resize(T604* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r604resize(T604* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r604clashes_resize(T604* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r604slots_resize(T604* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
T0* r604new_cursor(T604* C);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r604make_slots(T604* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
T2 r604new_modulus(T2 a1);
/*KL_SPECIAL_ROUTINES[STRING]*/
T0* r409make(T2 a1);
/*KL_SPECIAL_ROUTINES[STRING]*/
T0* r409resize(T0* a1,T2 a2);
/*LINKED_LIST[INTEGER]*/
T2 r37item(T37* C,T2 a1);
/*LINKED_LIST[INTEGER]*/
void r37make(T37* C);
/*LINKED_LIST[INTEGER]*/
void r37add_last(T37* C,T2 a1);
/*LINKED_LIST[INTEGER]*/
void r37go_item(T37* C,T2 a1);
/*SPECIAL[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
void r605make(T605* C,T2 a1);
/*SPECIAL[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
T0* r605resize(T605* C,T2 a1);
/*SPECIAL[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
void r605array_resize(T605* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T2 r439new_capacity(T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439force(T439* C,T0* a1,T0* a2);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439make_clashes(T439* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T0* r439cursor_item(T439* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439search_position(T439* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439remove_traversing_cursor(T439* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439keys_resize(T439* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T0* r439item(T439* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439make_items(T439* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439add_traversing_cursor(T439* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439make(T439* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T6 r439cursor_after(T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T6 r439has(T439* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439make_keys(T439* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T2 r439hash_position(T439* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439cursor_forth(T439* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439items_resize(T439* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439make_with_equality_testers(T439* C,T2 a1,T0* a2,T0* a3);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439resize(T439* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439make_sparse_container(T439* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439cursor_start(T439* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439clashes_resize(T439* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439slots_resize(T439* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T0* r439new_cursor(T439* C);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r439make_slots(T439* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T2 r439new_modulus(T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T6 r439cursor_off(T0* a1);
/*DS_BILINKED_LIST[STRING]*/
T0* r569cursor_item(T0* a1);
/*DS_BILINKED_LIST[STRING]*/
void r569remove_traversing_cursor(T569* C,T0* a1);
/*DS_BILINKED_LIST[STRING]*/
T0* r569item(T569* C,T2 a1);
/*DS_BILINKED_LIST[STRING]*/
void r569add_traversing_cursor(T569* C,T0* a1);
/*DS_BILINKED_LIST[STRING]*/
void r569make(T569* C);
/*DS_BILINKED_LIST[STRING]*/
T6 r569cursor_after(T0* a1);
/*DS_BILINKED_LIST[STRING]*/
void r569cursor_forth(T569* C,T0* a1);
/*DS_BILINKED_LIST[STRING]*/
void r569cursor_start(T569* C,T0* a1);
/*DS_BILINKED_LIST[STRING]*/
void r569force_last(T569* C,T0* a1);
/*DS_BILINKED_LIST[STRING]*/
T0* r569new_cursor(T569* C);
/*DS_BILINKED_LIST[STRING]*/
T6 r569cursor_off(T0* a1);
/*KL_COMPARABLE_COMPARATOR[LX_RULE]*/
T6 r317less_than(T0* a1,T0* a2);
extern T0*oBC42string_;
/*TREE_TO_AST*/
void r40process_end_element(T40* C,T0* a1);
/*TREE_TO_AST*/
void r40process_start_element(T40* C,T0* a1);
/*TREE_TO_AST*/
void r40process_composite(T40* C,T0* a1);
/*TREE_TO_AST*/
void r40make(T40* C,T0* a1,T0* a2,T0* a3);
/*TREE_TO_AST*/
T0* r40convert(T40* C);
/*TREE_TO_AST*/
void r40process_element(T40* C,T0* a1);
/*TREE_TO_AST*/
void r40process_character_data(T40* C,T0* a1);
/*LX_SYMBOL_PARTITIONS*/
void r293build(T293* C);
/*LX_SYMBOL_PARTITIONS*/
T2 r293previous_symbol(T293* C,T2 a1);
/*LX_SYMBOL_PARTITIONS*/
void r293put(T293* C,T2 a1);
/*LX_SYMBOL_PARTITIONS*/
T0* r293to_array(T293* C,T2 a1,T2 a2);
/*LX_SYMBOL_PARTITIONS*/
void r293make(T293* C,T2 a1,T2 a2);
/*LX_SYMBOL_PARTITIONS*/
void r293equiv_add(T293* C,T0* a1);
/*LX_SYMBOL_PARTITIONS*/
void r293equiv_initialize(T293* C);
/*LX_SYMBOL_PARTITIONS*/
T2 r293equivalence_class(T293* C,T2 a1);
/*LX_SYMBOL_PARTITIONS*/
void r293add(T293* C,T0* a1);
/*LX_SYMBOL_PARTITIONS*/
T6 r293is_representative(T293* C,T2 a1);
/*LX_SYMBOL_PARTITIONS*/
void r293initialize(T293* C);
/*LX_SYMBOL_PARTITIONS*/
void r293equiv_put(T293* C,T2 a1);
/*LX_FULL_DFA*/
void r262build(T262* C);
/*LX_FULL_DFA*/
void r262build_accept_table(T262* C);
/*LX_FULL_DFA*/
void r262initialize_dfa(T262* C,T0* a1,T2 a2,T2 a3);
/*LX_FULL_DFA*/
void r262put_start_condition(T262* C,T0* a1);
/*LX_FULL_DFA*/
void r262set_nfa_state_ids(T0* a1);
/*LX_FULL_DFA*/
void r262make(T262* C,T0* a1);
/*LX_FULL_DFA*/
void r262build_eof_rules(T262* C,T0* a1,T2 a2,T2 a3);
/*LX_FULL_DFA*/
void r262build_transitions(T262* C,T0* a1);
/*LX_FULL_DFA*/
void r262initialize(T262* C,T0* a1);
/*LX_FULL_DFA*/
void r262put_eob_state(T262* C);
/*LX_FULL_DFA*/
void r262build_rules(T262* C,T0* a1);
/*LX_FULL_DFA*/
void r262build_nxt_table(T262* C);
/*LX_FULL_DFA*/
T0* r262new_state(T262* C,T0* a1);
/*KL_TEXT_INPUT_FILE*/
T6 r45is_closed(T45* C);
/*KL_TEXT_INPUT_FILE*/
void r45old_close(T45* C);
/*KL_TEXT_INPUT_FILE*/
T2 r45read_to_string(T45* C,T0* a1,T2 a2,T2 a3);
/*KL_TEXT_INPUT_FILE*/
void r45open_read(T45* C);
/*KL_TEXT_INPUT_FILE*/
void r45old_read_character(T45* C);
/*KL_TEXT_INPUT_FILE*/
void r45read_character(T45* C);
/*KL_TEXT_INPUT_FILE*/
void r45fill_buffer(T45* C);
/*KL_TEXT_INPUT_FILE*/
void r45close(T45* C);
/*KL_TEXT_INPUT_FILE*/
void r45make(T45* C,T0* a1);
/*KL_TEXT_INPUT_FILE*/
T2 r45read_to_buffer(T45* C,T0* a1,T2 a2,T2 a3);
/*KL_TEXT_INPUT_FILE*/
void r45connect_to(T45* C,T0* a1);
/*KL_TEXT_INPUT_FILE*/
void r45read_string(T45* C,T2 a1);
/*KL_TEXT_INPUT_FILE*/
T2 r45_57Pread_to_buffer(T45* C,T0* a1,T2 a2,T2 a3);
/*KL_TEXT_INPUT_FILE*/
void r45old_open_read(T45* C);
/*LX_NFA_STATE*/
T6 r303is_equal(T303* C,T0* a1);
/*LX_NFA_STATE*/
T6 r303has_transition(T303* C);
/*LX_NFA_STATE*/
T6 r303is_accepting_head(T303* C);
/*LX_NFA_STATE*/
T0* r303twin(T303* C);
/*LX_NFA_STATE*/
void r303set_beginning_as_normal(T303* C);
/*LX_NFA_STATE*/
T6 r303_ix_60(T303* C,T0* a1);
/*XM_EIFFEL_SCANNER_DTD*/
void r636_177Pmake_scanner(T636* C);
extern T0*oBC177normalized_newline;
extern T0*oBC180integer_array_;
/*XM_EIFFEL_SCANNER_DTD*/
T2 r636start_condition(T636* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r636set_input_buffer(T636* C,T0* a1);
/*XM_EIFFEL_SCANNER_DTD*/
T0* r636text_substring(T636* C,T2 a1,T2 a2);
extern T0*oBC176yy_ec_template;
extern int fBC176yy_ec_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r636yy_ec_template(void);
/*XM_EIFFEL_SCANNER_DTD*/
void r636yy_execute_action(T636* C,T2 a1);
extern T0*oBC176yy_def_template;
extern int fBC176yy_def_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r636yy_def_template(void);
/*XM_EIFFEL_SCANNER_DTD*/
T3 r636text_item(T636* C,T2 a1);
/*XM_EIFFEL_SCANNER_DTD*/
void r636_179Pset_input_buffer(T636* C,T0* a1);
/*XM_EIFFEL_SCANNER_DTD*/
T0* r636system_literal_text(T636* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r636yy_load_input_buffer(T636* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r636make_with_buffer(T636* C,T0* a1);
/*XM_EIFFEL_SCANNER_DTD*/
T2 r636yy_null_trans_state(T636* C,T2 a1);
/*XM_EIFFEL_SCANNER_DTD*/
void r636pop_start_condition(T636* C);
extern T0*oBC176yy_accept_template;
extern int fBC176yy_accept_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r636yy_accept_template(void);
/*XM_EIFFEL_SCANNER_DTD*/
void r636read_token(T636* C);
/*XM_EIFFEL_SCANNER_DTD*/
T2 r636yy_previous_state(T636* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r636yy_refill_input_buffer(T636* C);
/*XM_EIFFEL_SCANNER_DTD*/
T0* r636yy_fixed_array(T0* a1);
extern T0*oBC176yy_meta_template;
extern int fBC176yy_meta_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r636yy_meta_template(void);
/*XM_EIFFEL_SCANNER_DTD*/
void r636_178Preset(T636* C);
extern T0*oBC176yy_base_template;
extern int fBC176yy_base_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r636yy_base_template(void);
/*XM_EIFFEL_SCANNER_DTD*/
void r636set_input_stream(T636* C,T0* a1);
/*XM_EIFFEL_SCANNER_DTD*/
T2 r636text_count(T636* C);
/*XM_EIFFEL_SCANNER_DTD*/
T0* r636new_file_buffer(T0* a1);
/*XM_EIFFEL_SCANNER_DTD*/
void r636make_scanner(T636* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r636yy_initialize(T636* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r636reset(T636* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r636push_start_condition(T636* C,T2 a1);
/*XM_EIFFEL_SCANNER_DTD*/
T0* r636text(T636* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r636close_input(T636* C);
extern T0*oBC176yy_nxt_template;
extern int fBC176yy_nxt_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r636yy_nxt_template(void);
/*XM_EIFFEL_SCANNER_DTD*/
void r636yy_set_line_column(T636* C);
extern T0*oBC181empty_buffer;
extern int fBC181empty_buffer;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r636empty_buffer(void);
extern T0*oBC176yy_chk_template;
extern int fBC176yy_chk_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r636yy_chk_template(void);
/*XM_EIFFEL_SCANNER_DTD*/
void r636yy_set_content(T636* C,T0* a1);
/*XM_EIFFEL_SCANNER_DTD*/
void r636set_start_condition(T636* C,T2 a1);
/*XM_EIFFEL_SCANNER_DTD*/
void r636_176Pread_token(T636* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r636yy_build_tables(T636* C);
/*LX_START_CONDITIONS*/
void r363move_cursors_right(T363* C,T2 a1,T2 a2);
/*LX_START_CONDITIONS*/
void r363put(T363* C,T0* a1,T2 a2);
/*LX_START_CONDITIONS*/
void r363make_with_initial(T363* C,T2 a1);
/*LX_START_CONDITIONS*/
void r363add_bol_nfa_to_all(T363* C,T0* a1);
/*LX_START_CONDITIONS*/
T0* r363names(T363* C);
/*LX_START_CONDITIONS*/
void r363add_nfa_to_non_exclusive(T363* C,T0* a1);
/*LX_START_CONDITIONS*/
void r363add_bol_nfa_to_non_exclusive(T363* C,T0* a1);
/*LX_START_CONDITIONS*/
void r363make(T363* C,T2 a1);
/*LX_START_CONDITIONS*/
void r363move_right(T363* C,T2 a1,T2 a2);
/*LX_START_CONDITIONS*/
void r363add_nfa_to_all(T363* C,T0* a1);
/*LX_START_CONDITIONS*/
T0* r363new_cursor(T363* C);
/*LX_START_CONDITIONS*/
void r363put_last(T363* C,T0* a1);
/*HTML_VISITOR*/
void r77sub_visit(T77* C,T0* a1);
/*HTML_VISITOR*/
T0* r77visit_cmts(T77* C,T0* a1);
/*HTML_VISITOR*/
void r77visit(T77* C);
/*HTML_VISITOR*/
void r77make(T77* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8,T0* a9);
/*HTML_VISITOR*/
T0* r77visit_strs(T0* a1);
/*HTML_VISITOR*/
T0* r77concat(T0* a1,T0* a2,T0* a3);
/*HTML_VISITOR*/
T0* r77get_result(T77* C);
/*HTML_VISITOR*/
T0* r77read_file(T0* a1);
/*HTML_VISITOR*/
T0* r77visit_cmt(T77* C,T0* a1);
/*HTML_VISITOR*/
T0* r77visit_str(T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r133_135Pon_error(T133* C,T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r133_135Pon_attribute(T133* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*XM_STOP_ON_ERROR_FILTER*/
void r133on_start_tag_finish(T133* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r133_135Pon_processing_instruction(T133* C,T0* a1,T0* a2);
/*XM_STOP_ON_ERROR_FILTER*/
void r133_135Pon_finish(T133* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r133on_finish(T133* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r133_135Pon_end_tag(T133* C,T0* a1,T0* a2,T0* a3);
/*XM_STOP_ON_ERROR_FILTER*/
void r133_135Pon_comment(T133* C,T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r133on_content(T133* C,T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r133make_null(T133* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r133on_start(T133* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r133on_processing_instruction(T133* C,T0* a1,T0* a2);
/*XM_STOP_ON_ERROR_FILTER*/
void r133on_start_tag(T133* C,T0* a1,T0* a2,T0* a3);
/*XM_STOP_ON_ERROR_FILTER*/
void r133_135Pon_start_tag_finish(T133* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r133_135Pon_content(T133* C,T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r133on_comment(T133* C,T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r133on_end_tag(T133* C,T0* a1,T0* a2,T0* a3);
/*XM_STOP_ON_ERROR_FILTER*/
void r133_135Pon_start(T133* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r133on_attribute(T133* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*XM_STOP_ON_ERROR_FILTER*/
void r133on_error(T133* C,T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r133_135Pon_start_tag(T133* C,T0* a1,T0* a2,T0* a3);
/*XM_STOP_ON_ERROR_FILTER*/
void r133on_xml_declaration(T133* C,T0* a1,T0* a2,T6 a3);
/*ORGADOC*/
void r20convert_html_file(T20* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*ORGADOC*/
void r20convert_latex_file(T20* C,T0* a1,T0* a2);
/*ORGADOC*/
T0* r20correct(T0* a1);
/*ORGADOC*/
void r20make_cgi(T20* C,T0* a1);
/*ORGADOC*/
void r20convert_bibtex_file(T20* C,T0* a1,T0* a2);
/*ORGADOC*/
void r20print(T0* a1);
/*ORGADOC*/
void r20convert_display_file(T20* C,T0* a1,T0* a2);
extern T0*oBC15std_output;
/*ORGADOC*/
void r20convert_regexp_file(T20* C,T0* a1,T0* a2);
/*ORGADOC*/
void r20convert_file_nosubpaths(T20* C,T0* a1,T0* a2);
/*ORGADOC*/
T6 r20recursive_convert(T20* C,T0* a1);
/*ORGADOC*/
void r20create_dirs(T0* a1);
/*ORGADOC*/
void r20convert_file(T20* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*LX_REGEXP_PARSER*/
void r269report_iteration_not_positive_error(T269* C);
/*LX_REGEXP_PARSER*/
void r269yy_do_action(T269* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r269process_escaped_character(T269* C);
/*LX_REGEXP_PARSER*/
void r269report_bad_character_error(T269* C,T0* a1);
extern T0*oBC269yytable_template;
extern int fBC269yytable_template;
/*LX_REGEXP_PARSER*/
T0* r269yytable_template(void);
/*LX_REGEXP_PARSER*/
void r269make_parser_skeleton(T269* C);
/*LX_REGEXP_PARSER*/
T0* r269append_character_set_to_character_class(T269* C,T2 a1,T2 a2,T0* a3);
/*LX_REGEXP_PARSER*/
void r269process_regexp_or_series(T269* C);
/*LX_REGEXP_PARSER*/
T0* r269append_trail_context_to_regexp(T269* C,T0* a1,T0* a2);
/*LX_REGEXP_PARSER*/
void r269report_bad_character_in_brackets_error(T269* C);
/*LX_REGEXP_PARSER*/
void r269process_singleton_dot(T269* C);
/*LX_REGEXP_PARSER*/
T0* r269new_iteration_nfa(T269* C,T0* a1,T2 a2);
/*LX_REGEXP_PARSER*/
void r269report_unrecognized_rule_error(T269* C);
/*LX_REGEXP_PARSER*/
void r269report_bad_iteration_values_error(T269* C);
/*LX_REGEXP_PARSER*/
void r269fatal_error(T0* a1);
extern T0*oBC86std;
/*LX_REGEXP_PARSER*/
void r269process_singleton_empty_string(T269* C);
/*LX_REGEXP_PARSER*/
T2 r269start_condition(T269* C);
/*LX_REGEXP_PARSER*/
void r269yy_do_error_action(T269* C,T2 a1);
/*LX_REGEXP_PARSER*/
T0* r269new_nfa_from_character(T269* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r269parse(T269* C);
/*LX_REGEXP_PARSER*/
void r269check_options(T269* C);
/*LX_REGEXP_PARSER*/
void r269report_missing_quote_error(T269* C);
/*LX_REGEXP_PARSER*/
void r269set_input_buffer(T269* C,T0* a1);
extern T0*oBC270yy_ec_template;
extern int fBC270yy_ec_template;
/*LX_REGEXP_PARSER*/
T0* r269yy_ec_template(void);
/*LX_REGEXP_PARSER*/
void r269yy_execute_action(T269* C,T2 a1);
extern T0*oBC269yytranslate_template;
extern int fBC269yytranslate_template;
/*LX_REGEXP_PARSER*/
T0* r269yytranslate_template(void);
extern T0*oBC270yy_def_template;
extern int fBC270yy_def_template;
/*LX_REGEXP_PARSER*/
T0* r269yy_def_template(void);
/*LX_REGEXP_PARSER*/
void r269report_full_and_meta_equiv_classes_error(T269* C);
/*LX_REGEXP_PARSER*/
T3 r269text_item(T269* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r269yy_push_last_value(T269* C,T2 a1);
/*LX_REGEXP_PARSER*/
T0* r269new_string_buffer(T0* a1);
/*LX_REGEXP_PARSER*/
void r269yy_load_input_buffer(T269* C);
/*LX_REGEXP_PARSER*/
void r269yy_push_error_value(T269* C);
extern T0*oBC269yyr1_template;
extern int fBC269yyr1_template;
/*LX_REGEXP_PARSER*/
T0* r269yyr1_template(void);
/*LX_REGEXP_PARSER*/
void r269make_with_buffer(T269* C,T0* a1);
/*LX_REGEXP_PARSER*/
void r269process_singleton_unbounded_iteration(T269* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r269process_rule(T269* C,T0* a1);
extern T0*oBC269yytypes1_template;
extern int fBC269yytypes1_template;
/*LX_REGEXP_PARSER*/
T0* r269yytypes1_template(void);
/*LX_REGEXP_PARSER*/
void r269process_character(T269* C,T2 a1);
/*LX_REGEXP_PARSER*/
T2 r269yy_null_trans_state(T269* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r269process_singleton_bounded_iteration(T269* C,T2 a1,T2 a2);
/*LX_REGEXP_PARSER*/
T0* r269dot_character_class(T269* C);
/*LX_REGEXP_PARSER*/
void r269report_negative_range_in_character_class_error(T269* C);
/*LX_REGEXP_PARSER*/
void r269report_full_and_variable_trailing_context_error(T269* C);
extern T0*oBC270yy_accept_template;
extern int fBC270yy_accept_template;
/*LX_REGEXP_PARSER*/
T0* r269yy_accept_template(void);
/*LX_REGEXP_PARSER*/
void r269read_token(T269* C);
/*LX_REGEXP_PARSER*/
void r269yy_init_value_stacks(T269* C);
/*LX_REGEXP_PARSER*/
T2 r269yy_previous_state(T269* C);
extern T0*oBC269yypgoto_template;
extern int fBC269yypgoto_template;
/*LX_REGEXP_PARSER*/
T0* r269yypgoto_template(void);
/*LX_REGEXP_PARSER*/
void r269yy_refill_input_buffer(T269* C);
extern T0*oBC269yytypes2_template;
extern int fBC269yytypes2_template;
/*LX_REGEXP_PARSER*/
T0* r269yytypes2_template(void);
/*LX_REGEXP_PARSER*/
T0* r269yy_fixed_array(T0* a1);
extern T0*oBC270yy_meta_template;
extern int fBC270yy_meta_template;
/*LX_REGEXP_PARSER*/
T0* r269yy_meta_template(void);
/*LX_REGEXP_PARSER*/
void r269report_character_out_of_range_error(T269* C,T0* a1);
/*LX_REGEXP_PARSER*/
void r269process_bol_rule(T269* C,T0* a1);
/*LX_REGEXP_PARSER*/
T0* r269new_epsilon_nfa(T269* C);
extern T0*oBC270yy_base_template;
extern int fBC270yy_base_template;
/*LX_REGEXP_PARSER*/
T0* r269yy_base_template(void);
/*LX_REGEXP_PARSER*/
T0* r269append_eol_to_regexp(T269* C,T0* a1);
/*LX_REGEXP_PARSER*/
void r269report_full_and_reject_error(T269* C);
/*LX_REGEXP_PARSER*/
T0* r269append_character_to_character_class(T269* C,T2 a1,T0* a2);
/*LX_REGEXP_PARSER*/
T2 r269text_count(T269* C);
/*LX_REGEXP_PARSER*/
void r269process_singleton_plus(T269* C);
/*LX_REGEXP_PARSER*/
void r269parse_string(T269* C,T0* a1);
/*LX_REGEXP_PARSER*/
void r269yy_initialize(T269* C);
/*LX_REGEXP_PARSER*/
T0* r269text(T269* C);
/*LX_REGEXP_PARSER*/
void r269report_missing_bracket_error(T269* C);
/*LX_REGEXP_PARSER*/
T0* r269new_symbol_nfa(T269* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r269process_singleton_symbol_class(T269* C,T0* a1);
/*LX_REGEXP_PARSER*/
void r269yy_clear_value_stacks(T269* C);
extern T0*oBC270yy_nxt_template;
extern int fBC270yy_nxt_template;
/*LX_REGEXP_PARSER*/
T0* r269yy_nxt_template(void);
/*LX_REGEXP_PARSER*/
void r269yy_set_line_column(T269* C);
/*LX_REGEXP_PARSER*/
void r269yy_build_parser_tables(T269* C);
/*LX_REGEXP_PARSER*/
void r269process_singleton_string(T269* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r269build_equiv_classes(T269* C);
/*LX_REGEXP_PARSER*/
T0* r269new_symbol_class_nfa(T269* C,T0* a1);
/*LX_REGEXP_PARSER*/
void r269process_series_singleton(T269* C);
/*LX_REGEXP_PARSER*/
T0* r269new_unbounded_iteration_nfa(T269* C,T0* a1,T2 a2);
/*LX_REGEXP_PARSER*/
T0* r269new_bounded_iteration_nfa(T269* C,T0* a1,T2 a2,T2 a3);
/*LX_REGEXP_PARSER*/
void r269process_singleton_optional(T269* C);
/*LX_REGEXP_PARSER*/
void r269report_trailing_context_used_twice_error(T269* C);
/*LX_REGEXP_PARSER*/
T0* r269empty_buffer(void);
/*LX_REGEXP_PARSER*/
void r269report_error(T269* C,T0* a1);
/*LX_REGEXP_PARSER*/
T0* r269append_character_to_string(T269* C,T2 a1,T0* a2);
/*LX_REGEXP_PARSER*/
void r269process_singleton_star(T269* C);
/*LX_REGEXP_PARSER*/
void r269process_singleton_fixed_iteration(T269* C,T2 a1);
extern T0*oBC269yydefact_template;
extern int fBC269yydefact_template;
/*LX_REGEXP_PARSER*/
T0* r269yydefact_template(void);
extern T0*oBC270yy_chk_template;
extern int fBC270yy_chk_template;
/*LX_REGEXP_PARSER*/
T0* r269yy_chk_template(void);
/*LX_REGEXP_PARSER*/
T0* r269new_nfa_from_character_class(T269* C,T0* a1);
extern T0*oBC269yycheck_template;
extern int fBC269yycheck_template;
/*LX_REGEXP_PARSER*/
T0* r269yycheck_template(void);
/*LX_REGEXP_PARSER*/
T0* r269new_character_class(T269* C);
/*LX_REGEXP_PARSER*/
T0* r269filename(T269* C);
/*LX_REGEXP_PARSER*/
T0* r269yyfixed_array(T0* a1);
/*LX_REGEXP_PARSER*/
void r269process_singleton_char(T269* C,T2 a1);
extern T0*oBC269yydefgoto_template;
extern int fBC269yydefgoto_template;
/*LX_REGEXP_PARSER*/
T0* r269yydefgoto_template(void);
/*LX_REGEXP_PARSER*/
void r269yy_pop_last_value(T269* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r269yy_set_content(T269* C,T0* a1);
extern T0*oBC269yypact_template;
extern int fBC269yypact_template;
/*LX_REGEXP_PARSER*/
T0* r269yypact_template(void);
/*LX_REGEXP_PARSER*/
void r269set_start_condition(T269* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r269yy_build_tables(T269* C);
/*LX_REGEXP_PARSER*/
void r269make_lex_scanner_from_description(T269* C,T0* a1,T0* a2);
/*LX_REGEXP_PARSER*/
void r269less(T269* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r269report_bad_character_class_error(T269* C);
/*LX_REGEXP_PARSER*/
void r269make_from_description(T269* C,T0* a1,T0* a2);
/*XM_EIFFEL_SCANNER*/
T2 r176start_condition(T176* C);
/*XM_EIFFEL_SCANNER*/
void r176yy_chk_template_1(T0* a1);
/*XM_EIFFEL_SCANNER*/
void r176yy_chk_template_2(T0* a1);
/*XM_EIFFEL_SCANNER*/
void r176set_input_buffer(T176* C,T0* a1);
/*XM_EIFFEL_SCANNER*/
T0* r176text_substring(T176* C,T2 a1,T2 a2);
/*XM_EIFFEL_SCANNER*/
T0* r176yy_ec_template(void);
/*XM_EIFFEL_SCANNER*/
void r176yy_execute_action(T176* C,T2 a1);
/*XM_EIFFEL_SCANNER*/
T0* r176yy_def_template(void);
/*XM_EIFFEL_SCANNER*/
T3 r176text_item(T176* C,T2 a1);
/*XM_EIFFEL_SCANNER*/
void r176_179Pset_input_buffer(T176* C,T0* a1);
/*XM_EIFFEL_SCANNER*/
T0* r176system_literal_text(T176* C);
/*XM_EIFFEL_SCANNER*/
void r176yy_load_input_buffer(T176* C);
/*XM_EIFFEL_SCANNER*/
void r176make_with_buffer(T176* C,T0* a1);
/*XM_EIFFEL_SCANNER*/
T2 r176yy_null_trans_state(T176* C,T2 a1);
/*XM_EIFFEL_SCANNER*/
void r176pop_start_condition(T176* C);
/*XM_EIFFEL_SCANNER*/
T6 r176is_valid_encoding(T176* C,T0* a1);
/*XM_EIFFEL_SCANNER*/
T0* r176yy_accept_template(void);
/*XM_EIFFEL_SCANNER*/
void r176read_token(T176* C);
/*XM_EIFFEL_SCANNER*/
T2 r176yy_previous_state(T176* C);
/*XM_EIFFEL_SCANNER*/
void r176yy_refill_input_buffer(T176* C);
/*XM_EIFFEL_SCANNER*/
void r176push_start_condition_dtd_ignore(T176* C);
/*XM_EIFFEL_SCANNER*/
T0* r176yy_fixed_array(T0* a1);
/*XM_EIFFEL_SCANNER*/
T0* r176yy_meta_template(void);
/*XM_EIFFEL_SCANNER*/
void r176_178Preset(T176* C);
/*XM_EIFFEL_SCANNER*/
T0* r176yy_base_template(void);
/*XM_EIFFEL_SCANNER*/
void r176set_input_stream(T176* C,T0* a1);
/*XM_EIFFEL_SCANNER*/
T2 r176text_count(T176* C);
/*XM_EIFFEL_SCANNER*/
T0* r176new_file_buffer(T0* a1);
/*XM_EIFFEL_SCANNER*/
void r176make_scanner(T176* C);
/*XM_EIFFEL_SCANNER*/
void r176yy_initialize(T176* C);
/*XM_EIFFEL_SCANNER*/
void r176reset(T176* C);
/*XM_EIFFEL_SCANNER*/
void r176push_start_condition(T176* C,T2 a1);
/*XM_EIFFEL_SCANNER*/
T0* r176text(T176* C);
/*XM_EIFFEL_SCANNER*/
void r176close_input(T176* C);
/*XM_EIFFEL_SCANNER*/
T0* r176yy_nxt_template(void);
/*XM_EIFFEL_SCANNER*/
void r176yy_set_line_column(T176* C);
/*XM_EIFFEL_SCANNER*/
T0* r176empty_buffer(void);
/*XM_EIFFEL_SCANNER*/
void r176yy_nxt_template_1(T0* a1);
/*XM_EIFFEL_SCANNER*/
void r176yy_nxt_template_2(T0* a1);
/*XM_EIFFEL_SCANNER*/
T0* r176yy_chk_template(void);
/*XM_EIFFEL_SCANNER*/
void r176yy_set_content(T176* C,T0* a1);
/*XM_EIFFEL_SCANNER*/
void r176set_start_condition(T176* C,T2 a1);
/*XM_EIFFEL_SCANNER*/
void r176yy_execute_eof_action(T176* C,T2 a1);
/*XM_EIFFEL_SCANNER*/
void r176yy_build_tables(T176* C);
/*GREP_VISITOR*/
void r255sub_visit(T255* C,T0* a1);
/*GREP_VISITOR*/
void r255visit(T255* C);
/*GREP_VISITOR*/
void r255visit_string(T255* C,T0* a1);
/*GREP_VISITOR*/
void r255make(T255* C,T0* a1,T6 a2,T0* a3,T6 a4);
/*GREP_VISITOR*/
void r255visit_comments(T255* C,T0* a1);
/*GREP_VISITOR*/
void r255visit_strings(T255* C,T0* a1);
/*GREP_VISITOR*/
void r255visit_comment(T255* C,T0* a1);
extern T0*oBC426arguments;
extern int fBC426arguments;
/*LX_FULL_AND_REJECT_ERROR*/
T0* r450arguments(void);
/*LX_FULL_AND_REJECT_ERROR*/
void r450make(T450* C);
/*LX_FULL_AND_REJECT_ERROR*/
T0* r450message(T450* C,T0* a1);
/*LX_UNRECOGNIZED_RULE_ERROR*/
T0* r464arguments(void);
/*LX_UNRECOGNIZED_RULE_ERROR*/
void r464make(T464* C,T0* a1,T2 a2);
/*LX_UNRECOGNIZED_RULE_ERROR*/
T0* r464message(T464* C,T0* a1);
/*LX_BAD_CHARACTER_IN_BRACKETS_ERROR*/
T0* r445arguments(void);
/*LX_BAD_CHARACTER_IN_BRACKETS_ERROR*/
void r445make(T445* C,T0* a1,T2 a2);
/*LX_BAD_CHARACTER_IN_BRACKETS_ERROR*/
T0* r445message(T445* C,T0* a1);
/*XM_TREE_CALLBACKS_PIPE*/
T0* r131callbacks_pipe(T0* a1);
/*XM_TREE_CALLBACKS_PIPE*/
T0* r131new_tree_builder(void);
/*XM_TREE_CALLBACKS_PIPE*/
void r131make(T131* C);
/*XM_TREE_CALLBACKS_PIPE*/
T0* r131new_namespace_resolver(void);
/*XM_TREE_CALLBACKS_PIPE*/
T0* r131new_stop_on_error(void);
/*LX_DFA_REGULAR_EXPRESSION*/
void r256wipe_out(T256* C);
/*LX_DFA_REGULAR_EXPRESSION*/
T6 r256matches(T256* C,T0* a1);
/*LX_DFA_REGULAR_EXPRESSION*/
void r256compile(T256* C,T0* a1,T6 a2);
/*LX_DFA_REGULAR_EXPRESSION*/
T2 r256smallest_end_position(T256* C,T0* a1,T2 a2);
/*LX_DFA_REGULAR_EXPRESSION*/
T2 r256longest_end_position(T256* C,T0* a1,T2 a2);
/*UT_ERROR_HANDLER*/
void r266make_null(T266* C);
extern T0*oBC267null_output_stream;
extern int fBC267null_output_stream;
/*UT_ERROR_HANDLER*/
T0* r266null_output_stream(void);
/*UT_ERROR_HANDLER*/
T0* r266message(T0* a1);
/*YY_FILE_BUFFER*/
void r433fill(T433* C);
/*YY_FILE_BUFFER*/
void r433compact_left(T433* C);
/*YY_FILE_BUFFER*/
void r433set_position(T433* C,T2 a1,T2 a2,T2 a3);
/*YY_FILE_BUFFER*/
T0* r433name(T433* C);
extern T2 oBC245default_capacity;
/*YY_FILE_BUFFER*/
void r433make_from_string(T433* C,T0* a1);
/*YY_FILE_BUFFER*/
void r433make_from_buffer(T433* C,T0* a1);
/*YY_FILE_BUFFER*/
void r433resize(T433* C);
/*YY_FILE_BUFFER*/
T0* r433new_default_buffer(T2 a1);
/*YY_FILE_BUFFER*/
void r433make_with_size(T433* C,T0* a1,T2 a2);
/*YY_FILE_BUFFER*/
void r433set_file(T433* C,T0* a1);
/*YY_FILE_BUFFER*/
void r433flush(T433* C);
/*LX_MISSING_QUOTE_ERROR*/
T0* r447arguments(void);
/*LX_MISSING_QUOTE_ERROR*/
void r447make(T447* C,T0* a1,T2 a2);
/*LX_MISSING_QUOTE_ERROR*/
T0* r447message(T447* C,T0* a1);
/*LX_FULL_AND_META_ERROR*/
T0* r452arguments(void);
/*LX_FULL_AND_META_ERROR*/
void r452make(T452* C);
/*LX_FULL_AND_META_ERROR*/
T0* r452message(T452* C,T0* a1);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r143on_start_tag_finish(T143* C);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r143on_finish(T143* C);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r143on_content(T143* C,T0* a1);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r143make_null(T143* C);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r143on_start(T143* C);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r143on_processing_instruction(T143* C,T0* a1,T0* a2);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r143on_start_tag(T143* C,T0* a1,T0* a2,T0* a3);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r143handle_position(T143* C,T0* a1);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r143on_comment(T143* C,T0* a1);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r143on_end_tag(T143* C,T0* a1,T0* a2,T0* a3);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r143on_attribute(T143* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*XM_CALLBACKS_TO_TREE_FILTER*/
T0* r143new_namespace(T143* C,T0* a1,T0* a2);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r143on_error(T143* C,T0* a1);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r143on_xml_declaration(T143* C,T0* a1,T0* a2,T6 a3);
/*XM_DTD_ELEMENT_CONTENT*/
void r586make_choice(T586* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r586make_mixed(T586* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r586set_content_mixed(T586* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r586make_empty(T586* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r586set_default(T586* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r586make_any(T586* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r586make_sequence(T586* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r586make_list(T586* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r586make_name(T586* C,T0* a1);
/*XM_DTD_ELEMENT_CONTENT*/
void r586set_content_any(T586* C);
/*LX_NEGATIVE_RANGE_IN_CHARACTER_CLASS_ERROR*/
T0* r493arguments(void);
/*LX_NEGATIVE_RANGE_IN_CHARACTER_CLASS_ERROR*/
void r493make(T493* C,T0* a1,T2 a2);
/*LX_NEGATIVE_RANGE_IN_CHARACTER_CLASS_ERROR*/
T0* r493message(T493* C,T0* a1);
/*TEMPLATE*/
void r23make(T23* C,T0* a1);
/*TEMPLATE*/
void r23print(T0* a1);
/*TEMPLATE*/
T6 r23start(T23* C);
/*TEMPLATE*/
void r23replace(T23* C,T0* a1,T0* a2);
/*LX_SYMBOL_CLASS*/
T2 r411new_capacity(T2 a1);
/*LX_SYMBOL_CLASS*/
T6 r411extendible(T411* C,T2 a1);
/*LX_SYMBOL_CLASS*/
T2 r411last(T411* C);
/*LX_SYMBOL_CLASS*/
void r411put(T411* C,T2 a1);
/*LX_SYMBOL_CLASS*/
void r411sort(T411* C);
/*LX_SYMBOL_CLASS*/
T6 r411arrayed_has(T411* C,T2 a1);
/*LX_SYMBOL_CLASS*/
void r411make(T411* C,T2 a1);
/*LX_SYMBOL_CLASS*/
void r411convert_to_equivalence(T411* C,T0* a1);
extern T0*oBC411sorter;
extern int fBC411sorter;
/*LX_SYMBOL_CLASS*/
T0* r411sorter(void);
/*LX_SYMBOL_CLASS*/
T6 r411has(T411* C,T2 a1);
/*LX_SYMBOL_CLASS*/
void r411resize(T411* C,T2 a1);
/*LX_SYMBOL_CLASS*/
void r411force_last(T411* C,T2 a1);
/*LX_SYMBOL_CLASS*/
T0* r411new_cursor(T411* C);
/*RX_CHARACTER_SET*/
void r104wipe_out(T104* C);
extern T0*oBC83fixed_boolean_array_;
/*RX_CHARACTER_SET*/
void r104make(T104* C,T0* a1);
/*RX_CHARACTER_SET*/
T6 r104has(T104* C,T2 a1);
/*RX_CHARACTER_SET*/
void r104add_set(T104* C,T0* a1);
/*RX_CHARACTER_SET*/
void r104add_string(T104* C,T0* a1);
/*RX_CHARACTER_SET*/
void r104add_negated_set(T104* C,T0* a1);
/*RX_CHARACTER_SET*/
void r104add_character(T104* C,T2 a1);
extern T0*oBC616name;
/*KL_STRING_INPUT_STREAM*/
T2 r616read_to_string(T616* C,T0* a1,T2 a2,T2 a3);
/*KL_STRING_INPUT_STREAM*/
void r616read_character(T616* C);
/*KL_STRING_INPUT_STREAM*/
void r616make(T616* C,T0* a1);
/*KL_STRING_INPUT_STREAM*/
T2 r616read_to_buffer(T616* C,T0* a1,T2 a2,T2 a3);
/*KL_STRING_INPUT_STREAM*/
void r616read_string(T616* C,T2 a1);
/*LX_MISSING_BRACKET_ERROR*/
T0* r446arguments(void);
/*LX_MISSING_BRACKET_ERROR*/
void r446make(T446* C,T0* a1,T2 a2);
/*LX_MISSING_BRACKET_ERROR*/
T0* r446message(T446* C,T0* a1);
/*XM_EXPAT_PARSER*/
void r153on_end_tag_procedure(T153* C,T8 a1);
/*l735c4/xm_expat_api.e*/#ifdef __cplusplus
}
#endif
#include <expat.h>
#ifdef __cplusplus
extern "C" {
#endif
/*l735c4/xm_expat_api.e*//*XM_EXPAT_PARSER*/
void r153on_start_tag_finish(T153* C);
/*XM_EXPAT_PARSER*/
void r153create_default_parser(T153* C);
/*XM_EXPAT_PARSER*/
void r153register_default_callbacks(T153* C);
/*XM_EXPAT_PARSER*/
void r153on_finish(T153* C);
/*XM_EXPAT_PARSER*/
T0* r153new_uc_string_from_c_utf8_runlength_string(T8 a1,T2 a2);
/*XM_EXPAT_PARSER*/
T0* r153new_string_from_c_zero_terminated_string(T8 a1);
/*XM_EXPAT_PARSER*/
void r153on_content(T153* C,T0* a1);
/*XM_EXPAT_PARSER*/
T0* r153new_uc_string_from_c_utf8_zero_terminated_string_safe(T8 a1);
/*XM_EXPAT_PARSER*/
T0* r153clone(T0* a1);
/*XM_EXPAT_PARSER*/
void r153on_start(T153* C);
/*XM_EXPAT_PARSER*/
T0* r153new_unicode_string_from_utf8(T0* a1);
/*XM_EXPAT_PARSER*/
void r153on_processing_instruction(T153* C,T0* a1,T0* a2);
/*XM_EXPAT_PARSER*/
void r153finish_incremental(T153* C);
/*XM_EXPAT_PARSER*/
void r153parse_incremental_from_stream(T153* C,T0* a1);
/*XM_EXPAT_PARSER*/
void r153on_start_tag_procedure(T153* C,T8 a1,T8 a2);
/*XM_EXPAT_PARSER*/
void r153on_processing_instruction_procedure(T153* C,T8 a1,T8 a2);
/*XM_EXPAT_PARSER*/
T0* r153position(T153* C);
/*XM_EXPAT_PARSER*/
T2 r153last_line_number(T153* C);
/*XM_EXPAT_PARSER*/
void r153on_start_tag(T153* C,T0* a1,T0* a2,T0* a3);
/*XM_EXPAT_PARSER*/
T0* r153new_string_from_c_runlength_string(T8 a1,T2 a2);
/*XM_EXPAT_PARSER*/
void r153make(T153* C);
/*XM_EXPAT_PARSER*/
void r153on_comment(T153* C,T0* a1);
/*XM_EXPAT_PARSER*/
T8 r153default_pointer(void);
/*XM_EXPAT_PARSER*/
void r153parse_from_stream(T153* C,T0* a1);
/*XM_EXPAT_PARSER*/
void r153parse_string_and_set_error(T153* C,T0* a1,T6 a2);
/*XM_EXPAT_PARSER*/
void r153on_end_tag(T153* C,T0* a1,T0* a2,T0* a3);
/*XM_EXPAT_PARSER*/
T2 r153last_column_number(T153* C);
extern T0*oBC154exceptions;
/*XM_EXPAT_PARSER*/
void r153set_error_from_parse_result(T153* C,T2 a1);
/*XM_EXPAT_PARSER*/
void r153on_attribute(T153* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*XM_EXPAT_PARSER*/
T6 r153is_parser_created(T153* C);
/*XM_EXPAT_PARSER*/
T2 r153exml_xml_parse_string(T8 a1,T0* a2,T6 a3);
/*XM_EXPAT_PARSER*/
T2 r153last_byte_index(T153* C);
/*XM_EXPAT_PARSER*/
T0* r153new_unicode_string_empty(void);
/*XM_EXPAT_PARSER*/
void r153free_parser(T153* C);
/*XM_EXPAT_PARSER*/
T0* r153new_attribute_list_from_c(T8 a1);
/*XM_EXPAT_PARSER*/
void r153set_callback_object(T8 a1,T0* a2);
/*XM_EXPAT_PARSER*/
T0* r153new_uc_string_from_c_utf8_zero_terminated_string(T8 a1);
/*XM_EXPAT_PARSER*/
void r153create_new_parser(T153* C);
/*XM_EXPAT_PARSER*/
void r153on_xml_declaration(T153* C,T0* a1,T0* a2,T6 a3);
extern int fBC157init_api;
/*XM_EXPAT_PARSER*/
void r153init_api(void);
/*XM_COMMENT*/
void r782make_last_in_document(T782* C,T0* a1,T0* a2);
/*XM_COMMENT*/
void r782process(T782* C,T0* a1);
/*XM_COMMENT*/
void r782make_last(T782* C,T0* a1,T0* a2);
/*LX_NFA*/
void r362copy(T362* C,T0* a1);
/*LX_NFA*/
void r362build_closure(T362* C);
/*LX_NFA*/
void r362build_unbounded_iteration(T362* C,T2 a1);
/*LX_NFA*/
T0* r362clone(T0* a1);
/*LX_NFA*/
void r362build_bounded_iteration(T362* C,T2 a1,T2 a2);
/*LX_NFA*/
void r362make_symbol(T362* C,T2 a1,T6 a2);
/*LX_NFA*/
void r362build_optional(T362* C);
/*LX_NFA*/
void r362build_positive_closure(T362* C);
/*LX_NFA*/
T0* r362twin(T362* C);
/*LX_NFA*/
void r362build_concatenation(T362* C,T0* a1);
/*LX_NFA*/
void r362make_epsilon(T362* C,T6 a1);
/*LX_NFA*/
void r362build_iteration(T362* C,T2 a1);
/*LX_NFA*/
void r362make_symbol_class(T362* C,T0* a1,T6 a2);
/*LX_NFA*/
void r362build_union(T362* C,T0* a1);
/*LX_DESCRIPTION*/
void r268make(T268* C);
/*LX_DESCRIPTION*/
void r268create_equiv_classes(T268* C);
/*XM_EIFFEL_PARSER_NAME*/
void r598make_no_namespaces(T598* C);
/*XM_EIFFEL_PARSER_NAME*/
void r598make_namespaces(T598* C);
/*XM_EIFFEL_PARSER_NAME*/
T0* r598last(T598* C);
/*XM_EIFFEL_PARSER_NAME*/
T6 r598is_equal(T598* C,T0* a1);
/*XM_EIFFEL_PARSER_NAME*/
T0* r598item(T598* C,T2 a1);
extern T0*oBC149string_equality_tester;
/*XM_EIFFEL_PARSER_NAME*/
T0* r598clone(T0* a1);
/*XM_EIFFEL_PARSER_NAME*/
T2 r598hash_code(T598* C);
/*XM_EIFFEL_PARSER_NAME*/
T6 r598can_force_last(T598* C,T0* a1);
/*XM_EIFFEL_PARSER_NAME*/
T6 r598same_string(T0* a1,T0* a2);
/*XM_EIFFEL_PARSER_NAME*/
void r598force_last(T598* C,T0* a1);
/*XM_EIFFEL_PARSER_NAME*/
T0* r598ns_prefix(T598* C);
/*XM_EIFFEL_PARSER_NAME*/
T0* r598local_part(T598* C);
/*XM_EIFFEL_PARSER_NAME*/
T6 r598is_namespace_name(T598* C);
/*XM_EIFFEL_PARSER_NAME*/
T0* r598new_string_bilinked_list(void);
/*XM_CHARACTER_DATA*/
void r734process(T734* C,T0* a1);
/*XM_CHARACTER_DATA*/
void r734make_last(T734* C,T0* a1,T0* a2);
/*LX_TRAILING_CONTEXT_USED_TWICE_ERROR*/
T0* r482arguments(void);
/*LX_TRAILING_CONTEXT_USED_TWICE_ERROR*/
void r482make(T482* C,T0* a1,T2 a2);
/*LX_TRAILING_CONTEXT_USED_TWICE_ERROR*/
T0* r482message(T482* C,T0* a1);
/*PRINT_VISITOR*/
void r254sub_visit(T254* C,T0* a1);
/*PRINT_VISITOR*/
T0* r254visit_cmts(T254* C,T0* a1);
/*PRINT_VISITOR*/
void r254visit(T254* C);
/*PRINT_VISITOR*/
void r254make_all(T254* C,T0* a1,T0* a2,T0* a3);
/*PRINT_VISITOR*/
void r254make(T254* C,T0* a1,T0* a2,T0* a3);
/*PRINT_VISITOR*/
T0* r254visit_strs(T0* a1);
/*PRINT_VISITOR*/
T0* r254get_result(T254* C);
/*PRINT_VISITOR*/
T0* r254visit_cmt(T254* C,T0* a1);
/*PRINT_VISITOR*/
T0* r254visit_str(T0* a1);
/*PARSER*/
void r547yy_refill_input_buffer(T547* C);
/*PARSER*/
void r547yy_push_last_value(T547* C,T2 a1);
/*PARSER*/
void r547yy_build_tables(T547* C);
extern T0*oBC548yy_meta_template;
extern int fBC548yy_meta_template;
/*PARSER*/
T0* r547yy_meta_template(void);
/*PARSER*/
void r547yy_create_value_stacks(T547* C);
extern T0*oBC547yycheck_template;
extern int fBC547yycheck_template;
/*PARSER*/
T0* r547yycheck_template(void);
/*PARSER*/
void r547yy_pop_last_value(T547* C,T2 a1);
extern T0*oBC547yytypes1_template;
extern int fBC547yytypes1_template;
/*PARSER*/
T0* r547yytypes1_template(void);
extern T0*oBC548yy_accept_template;
extern int fBC548yy_accept_template;
/*PARSER*/
T0* r547yy_accept_template(void);
/*PARSER*/
void r547read_token(T547* C);
/*PARSER*/
void r547yy_execute_eof_action(T547* C,T2 a1);
extern T0*oBC548yy_base_template;
extern int fBC548yy_base_template;
/*PARSER*/
T0* r547yy_base_template(void);
/*PARSER*/
void r547yy_build_parser_tables(T547* C);
extern T0*oBC547yytable_template;
extern int fBC547yytable_template;
/*PARSER*/
T0* r547yytable_template(void);
/*PARSER*/
void r547set_input_buffer(T547* C,T0* a1);
/*PARSER*/
T0* r547empty_buffer(void);
extern T0*oBC547yytypes2_template;
extern int fBC547yytypes2_template;
/*PARSER*/
T0* r547yytypes2_template(void);
/*PARSER*/
T0* r547yyfixed_array(T0* a1);
/*PARSER*/
T2 r547yy_null_trans_state(T547* C,T2 a1);
extern T0*oBC547yypgoto_template;
extern int fBC547yypgoto_template;
/*PARSER*/
T0* r547yypgoto_template(void);
/*PARSER*/
void r547yy_set_content(T547* C,T0* a1);
extern T0*oBC548yy_nxt_template;
extern int fBC548yy_nxt_template;
/*PARSER*/
T0* r547yy_nxt_template(void);
/*PARSER*/
void r547make(T547* C);
extern T0*oBC548yy_chk_template;
extern int fBC548yy_chk_template;
/*PARSER*/
T0* r547yy_chk_template(void);
/*PARSER*/
void r547yy_push_error_value(T547* C);
/*PARSER*/
void r547fatal_error(T0* a1);
extern T0*oBC547yypact_template;
extern int fBC547yypact_template;
/*PARSER*/
T0* r547yypact_template(void);
/*PARSER*/
void r547make_parser_skeleton(T547* C);
extern T0*oBC547yydefact_template;
extern int fBC547yydefact_template;
/*PARSER*/
T0* r547yydefact_template(void);
extern T0*oBC548yy_def_template;
extern int fBC548yy_def_template;
/*PARSER*/
T0* r547yy_def_template(void);
/*PARSER*/
void r547yy_clear_all(T547* C);
/*PARSER*/
T0* r547yytype2(T0* a1);
extern T0*oBC548yy_ec_template;
extern int fBC548yy_ec_template;
/*PARSER*/
T0* r547yy_ec_template(void);
/*PARSER*/
T6 r547yytype4(T0* a1);
/*PARSER*/
void r547make_with_buffer(T547* C,T0* a1);
/*PARSER*/
void r547yy_execute_action(T547* C,T2 a1);
/*PARSER*/
void r547execute(T547* C,T0* a1);
/*PARSER*/
void r547reset(T547* C);
/*PARSER*/
void r547yy_do_error_action(T547* C,T2 a1);
/*PARSER*/
void r547yy_initialize(T547* C);
extern T0*oBC547yyr1_template;
extern int fBC547yyr1_template;
/*PARSER*/
T0* r547yyr1_template(void);
/*PARSER*/
void r547parse(T547* C);
/*PARSER*/
void r547yy_do_action(T547* C,T2 a1);
/*PARSER*/
void r547yy_load_input_buffer(T547* C);
extern T0*oBC547yytranslate_template;
extern int fBC547yytranslate_template;
/*PARSER*/
T0* r547yytranslate_template(void);
/*PARSER*/
T0* r547yy_fixed_array(T0* a1);
/*PARSER*/
T0* r547text(T547* C);
/*PARSER*/
T2 r547text_count(T547* C);
/*PARSER*/
T2 r547yy_previous_state(T547* C);
/*PARSER*/
void r547report_error(T547* C,T0* a1);
/*PARSER*/
void r547make_scanner(T547* C);
extern T0*oBC547yydefgoto_template;
extern int fBC547yydefgoto_template;
/*PARSER*/
T0* r547yydefgoto_template(void);
/*PARSER*/
T0* r547new_file_buffer(T0* a1);
/*PARSER*/
void r547reset_compressed_scanner_skeleton(T547* C);
/*XM_NAMESPACE_RESOLVER*/
void r148on_start_tag_finish(T148* C);
/*XM_NAMESPACE_RESOLVER*/
void r148on_delayed_attributes(T148* C);
/*XM_NAMESPACE_RESOLVER*/
void r148on_finish(T148* C);
/*XM_NAMESPACE_RESOLVER*/
void r148_135Pon_end_tag(T148* C,T0* a1,T0* a2,T0* a3);
/*XM_NAMESPACE_RESOLVER*/
void r148on_content(T148* C,T0* a1);
/*XM_NAMESPACE_RESOLVER*/
void r148make_null(T148* C);
/*XM_NAMESPACE_RESOLVER*/
void r148on_start(T148* C);
/*XM_NAMESPACE_RESOLVER*/
T6 r148is_xmlns(T0* a1);
/*XM_NAMESPACE_RESOLVER*/
void r148on_processing_instruction(T148* C,T0* a1,T0* a2);
/*XM_NAMESPACE_RESOLVER*/
T0* r148new_string_queue(void);
/*XM_NAMESPACE_RESOLVER*/
void r148on_start_tag(T148* C,T0* a1,T0* a2,T0* a3);
/*XM_NAMESPACE_RESOLVER*/
void r148_135Pon_start_tag_finish(T148* C);
/*XM_NAMESPACE_RESOLVER*/
T6 r148has_prefix(T0* a1);
/*XM_NAMESPACE_RESOLVER*/
void r148on_comment(T148* C,T0* a1);
/*XM_NAMESPACE_RESOLVER*/
void r148on_end_tag(T148* C,T0* a1,T0* a2,T0* a3);
extern T0*oBC150xmlns;
/*XM_NAMESPACE_RESOLVER*/
void r148attributes_make(T148* C);
/*XM_NAMESPACE_RESOLVER*/
void r148on_attribute(T148* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*XM_NAMESPACE_RESOLVER*/
void r148on_error(T148* C,T0* a1);
/*XM_NAMESPACE_RESOLVER*/
T6 r148same_string(T0* a1,T0* a2);
/*XM_NAMESPACE_RESOLVER*/
void r148attributes_remove(T148* C);
/*XM_NAMESPACE_RESOLVER*/
void r148attributes_force(T148* C,T0* a1,T0* a2,T0* a3);
/*XM_NAMESPACE_RESOLVER*/
void r148on_xml_declaration(T148* C,T0* a1,T0* a2,T6 a3);
/*XM_EIFFEL_CHARACTER_ENTITY*/
void r253from_hexadecimal(T253* C,T0* a1);
extern T0*oBC68utf8;
/*XM_EIFFEL_CHARACTER_ENTITY*/
T0* r253to_utf8(T253* C);
/*XM_EIFFEL_CHARACTER_ENTITY*/
T6 r253is_valid(T253* C);
/*XM_EIFFEL_CHARACTER_ENTITY*/
void r253from_decimal(T253* C,T0* a1);
extern T0*oBC63unicode;
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T0* r719new_string_string_table(void);
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T6 r719shallow_has(T719* C,T0* a1);
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
void r719make(T719* C);
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T0* r719resolve(T719* C,T0* a1);
extern T0*oBC719default_pseudo_prefix;
extern int fBC719default_pseudo_prefix;
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T0* r719default_pseudo_prefix(void);
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T6 r719has(T719* C,T0* a1);
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T0* r719resolve_default(T719* C);
extern T0*oBC719default_namespace;
extern int fBC719default_namespace;
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T0* r719default_namespace(void);
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
void r719pop(T719* C);
/*LX_FULL_AND_VARIABLE_TRAILING_CONTEXT_ERROR*/
T0* r451arguments(void);
/*LX_FULL_AND_VARIABLE_TRAILING_CONTEXT_ERROR*/
void r451make(T451* C);
/*LX_FULL_AND_VARIABLE_TRAILING_CONTEXT_ERROR*/
T0* r451message(T451* C,T0* a1);
/*LX_START_CONDITION*/
void r364make(T364* C,T0* a1,T2 a2,T6 a3);
/*TEXT_FILE_READ*/
void r30disconnect(T30* C);
/*TEXT_FILE_READ*/
void r30fill_buffer(T30* C);
/*TEXT_FILE_READ*/
void r30read_line_in(T30* C,T0* a1);
/*TEXT_FILE_READ*/
void r30connect_to(T30* C,T0* a1);
/*TEXT_FILE_READ*/
void r30read_line(T30* C);
extern T0*oBC32last_string;
/*BIBTEX_VISITOR*/
void r534sub_visit(T534* C,T0* a1);
/*BIBTEX_VISITOR*/
void r534visit(T534* C);
/*BIBTEX_VISITOR*/
void r534make(T534* C,T0* a1,T6 a2,T0* a3,T2 a4,T0* a5);
/*BIBTEX_VISITOR*/
T0* r534visit_strs(T0* a1);
/*BIBTEX_VISITOR*/
T0* r534visit_str(T0* a1);
/*LX_RULE*/
void r276make_default(T276* C,T2 a1);
extern T0*oBC276dummy_pattern;
extern int fBC276dummy_pattern;
/*LX_RULE*/
T0* r276dummy_pattern(void);
extern T0*oBC276dummy_action;
extern int fBC276dummy_action;
/*LX_RULE*/
T0* r276dummy_action(void);
/*LX_RULE*/
T6 r276_ix_60(T276* C,T0* a1);
/*PARAMS*/
void r29process_arguments(T29* C);
/*PARAMS*/
void r29display_help(T29* C);
extern T0*oBC15command_arguments;
extern int fBC15command_arguments;
/*PARAMS*/
T0* r29command_arguments(void);
/*PARAMS*/
void r29set_search(T29* C,T0* a1,T6 a2);
/*PARAMS*/
void r29display_version(T29* C);
/*PARAMS*/
void r29use_conffile(T29* C,T0* a1);
/*PARAMS*/
void r29pre_process_arguments(T29* C);
/*PARAMS*/
void r29make(T29* C);
/*PARAMS*/
void r29reinit(T29* C);
/*DOCUMENT*/
void r112make(T112* C);
/*YY_BUFFER*/
void r245set_position(T245* C,T2 a1,T2 a2,T2 a3);
/*YY_BUFFER*/
void r245make(T245* C,T0* a1);
/*YY_BUFFER*/
void r245make_from_buffer(T245* C,T0* a1);
/*YY_BUFFER*/
T0* r245new_default_buffer(T2 a1);
/*LX_BAD_ITERATION_VALUES_ERROR*/
T0* r483arguments(void);
/*LX_BAD_ITERATION_VALUES_ERROR*/
void r483make(T483* C,T0* a1,T2 a2);
/*LX_BAD_ITERATION_VALUES_ERROR*/
T0* r483message(T483* C,T0* a1);
/*RX_CASE_MAPPING*/
void r111make_default(T111* C);
/*RX_CASE_MAPPING*/
void r111make(T111* C,T0* a1,T0* a2);
/*RX_CASE_MAPPING*/
void r111add(T111* C,T0* a1,T0* a2);
/*RX_CASE_MAPPING*/
void r111clear(T111* C);
/*RX_CASE_MAPPING*/
T2 r111to_lower(T111* C,T2 a1);
/*RX_CASE_MAPPING*/
T2 r111flip_case(T111* C,T2 a1);
/*LX_CHARACTER_OUT_OF_RANGE_ERROR*/
T0* r444arguments(void);
/*LX_CHARACTER_OUT_OF_RANGE_ERROR*/
void r444make(T444* C,T0* a1,T2 a2,T0* a3);
/*LX_CHARACTER_OUT_OF_RANGE_ERROR*/
T0* r444message(T444* C,T0* a1);
/*XM_DTD_ATTRIBUTE_CONTENT*/
void r574set_enumeration_list(T574* C,T0* a1);
/*XM_DTD_ATTRIBUTE_CONTENT*/
T6 r574is_value_required(T574* C);
/*XM_DTD_ATTRIBUTE_CONTENT*/
void r574set_enumeration(T574* C);
/*XM_DTD_ATTRIBUTE_CONTENT*/
void r574set_default_value(T574* C,T0* a1);
extern T0*oBC574default_enumeration_list;
extern int fBC574default_enumeration_list;
/*XM_DTD_ATTRIBUTE_CONTENT*/
T0* r574default_enumeration_list(void);
/*XM_DTD_ATTRIBUTE_CONTENT*/
void r574make(T574* C);
/*XM_DTD_ATTRIBUTE_CONTENT*/
void r574copy_default(T574* C,T0* a1);
/*XM_DTD_ATTRIBUTE_CONTENT*/
void r574set_value_fixed(T574* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r165yy_do_action(T165* C,T2 a1);
extern T0*oBC165yytable_template;
extern int fBC165yytable_template;
/*XM_EIFFEL_PARSER*/
T0* r165yytable_template(void);
/*XM_EIFFEL_PARSER*/
void r165on_end_tag(T165* C,T0* a1,T0* a2,T0* a3);
/*XM_EIFFEL_PARSER*/
void r165check_void(T165* C);
/*XM_EIFFEL_PARSER*/
T0* r165defined_entity_referenced(T165* C,T0* a1);
/*XM_EIFFEL_PARSER*/
T2 r165line(T165* C);
/*XM_EIFFEL_PARSER*/
T0* r165new_entities_table(void);
/*XM_EIFFEL_PARSER*/
void r165on_attribute(T165* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*XM_EIFFEL_PARSER*/
void r165on_start_tag_finish(T165* C);
/*XM_EIFFEL_PARSER*/
void r165when_external_dtd(T165* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r165yy_do_error_action(T165* C,T2 a1);
/*XM_EIFFEL_PARSER*/
void r165parse(T165* C);
/*XM_EIFFEL_PARSER*/
T0* r165new_dtd_external_id(void);
/*XM_EIFFEL_PARSER*/
T2 r165byte_position(T165* C);
/*XM_EIFFEL_PARSER*/
void r165when_entity_declared(T165* C,T0* a1,T0* a2);
/*XM_EIFFEL_PARSER*/
void r165on_error(T165* C,T0* a1);
/*XM_EIFFEL_PARSER*/
T0* r165new_literal_entity(T0* a1);
extern T0*oBC165yytranslate_template;
extern int fBC165yytranslate_template;
/*XM_EIFFEL_PARSER*/
T0* r165yytranslate_template(void);
/*XM_EIFFEL_PARSER*/
void r165process_pe_entity(T165* C,T0* a1);
/*XM_EIFFEL_PARSER*/
T0* r165new_unicode_string_from_utf8(T0* a1);
/*XM_EIFFEL_PARSER*/
void r165yy_push_last_value(T165* C,T2 a1);
/*XM_EIFFEL_PARSER*/
T0* r165new_name_set(void);
/*XM_EIFFEL_PARSER*/
void r165yy_push_error_value(T165* C);
/*XM_EIFFEL_PARSER*/
void r165on_start(T165* C);
extern T0*oBC165yyr1_template;
extern int fBC165yyr1_template;
/*XM_EIFFEL_PARSER*/
T0* r165yyr1_template(void);
/*XM_EIFFEL_PARSER*/
T0* r165new_external_entity(T165* C,T0* a1);
extern T0*oBC165yytypes1_template;
extern int fBC165yytypes1_template;
/*XM_EIFFEL_PARSER*/
T0* r165yytypes1_template(void);
/*XM_EIFFEL_PARSER*/
T0* r165onstring_ascii(T165* C,T0* a1);
/*XM_EIFFEL_PARSER*/
T0* r165position(T165* C);
/*XM_EIFFEL_PARSER*/
void r165on_finish(T165* C);
/*XM_EIFFEL_PARSER*/
T0* r165new_dtd_attribute_content(void);
/*XM_EIFFEL_PARSER*/
void r165read_token(T165* C);
/*XM_EIFFEL_PARSER*/
void r165on_attribute_declarations(T165* C,T0* a1,T0* a2);
/*XM_EIFFEL_PARSER*/
void r165yy_init_value_stacks(T165* C);
extern T0*oBC165yypgoto_template;
extern int fBC165yypgoto_template;
/*XM_EIFFEL_PARSER*/
T0* r165yypgoto_template(void);
/*XM_EIFFEL_PARSER*/
void r165process_entity_scanner(T165* C,T0* a1);
extern T0*oBC165yytypes2_template;
extern int fBC165yytypes2_template;
/*XM_EIFFEL_PARSER*/
T0* r165yytypes2_template(void);
/*XM_EIFFEL_PARSER*/
void r165namespace_force_last(T165* C,T0* a1,T0* a2);
/*XM_EIFFEL_PARSER*/
void r165when_pe_entity_declared(T165* C,T0* a1,T0* a2);
extern T0*oBC66integer_;
/*XM_EIFFEL_PARSER*/
T0* r165shared_empty_string(T165* C);
/*XM_EIFFEL_PARSER*/
T2 r165column(T165* C);
/*XM_EIFFEL_PARSER*/
void r165set_element_repetition(T0* a1,T0* a2);
/*XM_EIFFEL_PARSER*/
void r165make_scanner(T165* C);
/*XM_EIFFEL_PARSER*/
T0* r165new_namespace_name(T165* C);
/*XM_EIFFEL_PARSER*/
void r165reset(T165* C);
/*XM_EIFFEL_PARSER*/
T0* r165new_string_bilinked_list(void);
/*XM_EIFFEL_PARSER*/
T0* r165source(T165* C);
extern T0*oBC166null_resolver;
/*XM_EIFFEL_PARSER*/
void r165_135Pon_error(T165* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r165yy_clear_value_stacks(T165* C);
/*XM_EIFFEL_PARSER*/
void r165parse_from_stream(T165* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r165yy_build_parser_tables(T165* C);
/*XM_EIFFEL_PARSER*/
void r165force_error(T165* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r165on_start_tag(T165* C,T0* a1,T0* a2,T0* a3);
/*XM_EIFFEL_PARSER*/
T0* r165element_name(T0* a1);
/*XM_EIFFEL_PARSER*/
void r165on_processing_instruction(T165* C,T0* a1,T0* a2);
/*XM_EIFFEL_PARSER*/
void r165apply_encoding(T165* C,T0* a1);
/*XM_EIFFEL_PARSER*/
T0* r165external_entity_to_string(T165* C,T0* a1);
/*XM_EIFFEL_PARSER*/
T0* r165entity_referenced_in_entity_value(T165* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r165on_content(T165* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r165make_parser(T165* C);
extern T0*oBC165yydefact_template;
extern int fBC165yydefact_template;
/*XM_EIFFEL_PARSER*/
T0* r165yydefact_template(void);
extern T0*oBC166shared_empty_string_uc;
extern int fBC166shared_empty_string_uc;
/*XM_EIFFEL_PARSER*/
T0* r165shared_empty_string_uc(void);
extern T0*oBC165yycheck_template;
extern int fBC165yycheck_template;
/*XM_EIFFEL_PARSER*/
T0* r165yycheck_template(void);
/*XM_EIFFEL_PARSER*/
T0* r165new_dtd_attribute_content_list(void);
/*XM_EIFFEL_PARSER*/
void r165make(T165* C);
/*XM_EIFFEL_PARSER*/
void r165on_xml_declaration(T165* C,T0* a1,T0* a2,T6 a3);
/*XM_EIFFEL_PARSER*/
T0* r165yyfixed_array(T0* a1);
extern T0*oBC165yydefgoto_template;
extern int fBC165yydefgoto_template;
/*XM_EIFFEL_PARSER*/
T0* r165yydefgoto_template(void);
/*XM_EIFFEL_PARSER*/
void r165yy_pop_last_value(T165* C,T2 a1);
/*XM_EIFFEL_PARSER*/
void r165process_entity(T165* C,T0* a1);
extern T0*oBC165yypact_template;
extern int fBC165yypact_template;
/*XM_EIFFEL_PARSER*/
T0* r165yypact_template(void);
/*XM_EIFFEL_PARSER*/
void r165on_comment(T165* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r165process_attribute_entity(T165* C,T0* a1);
extern T0*oBC166shared_empty_string_string;
extern int fBC166shared_empty_string_string;
/*XM_EIFFEL_PARSER*/
T0* r165shared_empty_string_string(void);
/*XM_EIFFEL_PARSER*/
T0* r165onstring_utf8(T165* C,T0* a1);
/*READ_XML*/
T6 r44file_exist(T44* C);
/*READ_XML*/
void r44print(T0* a1);
/*READ_XML*/
T6 r44parse(T44* C);
extern T0*oBC44fact;
/*XM_DOCUMENT*/
void r536set_last_cell(T536* C,T0* a1);
/*XM_DOCUMENT*/
void r536wipe_out(T536* C);
/*XM_DOCUMENT*/
void r536remove_first(T536* C);
extern T0*oBC540default_ns;
extern int fBC540default_ns;
/*XM_DOCUMENT*/
T0* r536default_ns(void);
/*XM_DOCUMENT*/
T0* r536cursor_item(T0* a1);
/*XM_DOCUMENT*/
T6 r536cursor_is_last(T536* C,T0* a1);
/*XM_DOCUMENT*/
void r536remove_traversing_cursor(T536* C,T0* a1);
/*XM_DOCUMENT*/
void r536cursor_go_after(T536* C,T0* a1);
/*XM_DOCUMENT*/
void r536move_all_cursors_after(T536* C);
/*XM_DOCUMENT*/
void r536add_traversing_cursor(T536* C,T0* a1);
/*XM_DOCUMENT*/
void r536remove_previous_root_element(T536* C);
/*XM_DOCUMENT*/
void r536_538Pforce_last(T536* C,T0* a1);
/*XM_DOCUMENT*/
void r536process(T536* C,T0* a1);
/*XM_DOCUMENT*/
void r536before_addition(T536* C,T0* a1);
/*XM_DOCUMENT*/
void r536remove_last(T536* C);
/*XM_DOCUMENT*/
T6 r536cursor_after(T0* a1);
/*XM_DOCUMENT*/
void r536make_with_root_named(T536* C,T0* a1,T0* a2);
/*XM_DOCUMENT*/
void r536make_list(T536* C);
/*XM_DOCUMENT*/
void r536equality_delete(T536* C,T0* a1);
/*XM_DOCUMENT*/
void r536cursor_forth(T536* C,T0* a1);
/*XM_DOCUMENT*/
void r536move_last_cursors_after(T536* C);
/*XM_DOCUMENT*/
void r536cursor_start(T536* C,T0* a1);
/*XM_DOCUMENT*/
void r536force_last(T536* C,T0* a1);
/*XM_DOCUMENT*/
T0* r536new_cursor(T536* C);
/*XM_DOCUMENT*/
T6 r536cursor_is_first(T536* C,T0* a1);
/*XM_DOCUMENT*/
void r536remove_at_cursor(T536* C,T0* a1);
/*XM_DOCUMENT*/
void r536move_all_cursors(T536* C,T0* a1,T0* a2);
/*XM_DOCUMENT*/
T6 r536cursor_off(T0* a1);
/*XM_DOCUMENT*/
void r536set_root_element(T536* C,T0* a1);
/*LX_BAD_CHARACTER_ERROR*/
T0* r449arguments(void);
/*LX_BAD_CHARACTER_ERROR*/
void r449make(T449* C,T0* a1,T2 a2,T0* a3);
/*LX_BAD_CHARACTER_ERROR*/
T0* r449message(T449* C,T0* a1);
/*LX_DFA_STATE*/
T6 r274is_equal(T274* C,T0* a1);
extern T0*oBC274rule_sorter;
extern int fBC274rule_sorter;
/*LX_DFA_STATE*/
T0* r274rule_sorter(void);
/*LX_DFA_STATE*/
T6 r274se_assigned_from(T0* a1);
/*LX_DFA_STATE*/
void r274print_on(T274* C,T0* a1);
extern T0*oBC274bubble_sorter;
extern int fBC274bubble_sorter;
/*LX_DFA_STATE*/
T0* r274bubble_sorter(void);
/*LX_DFA_STATE*/
void r274out_in_tagged_out_memory(T274* C);
/*LX_DFA_STATE*/
T6 r274same_type(T274* C,T0* a1);
/*LX_DFA_STATE*/
void r274make(T274* C,T0* a1,T2 a2,T2 a3);
/*LX_DFA_STATE*/
void r274partition(T274* C,T0* a1);
/*LX_DFA_STATE*/
T6 r274conforms_to(T274* C,T0* a1);
/*LX_DFA_STATE*/
T6 r274is_accepting(T274* C);
/*LX_DFA_STATE*/
T0* r274new_state(T274* C,T2 a1);
/*UC_STRING*/
T0* r65out(T65* C);
/*UC_STRING*/
void r65copy(T65* C,T0* a1);
/*UC_STRING*/
T0* r65substring(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
void r65reset_byte_index_cache(T65* C);
/*UC_STRING*/
T2 r65shifted_byte_index(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
void r65wipe_out(T65* C);
/*UC_STRING*/
T3 r65last(T65* C);
/*UC_STRING*/
T2 r65first_substring_index(T65* C,T0* a1);
/*UC_STRING*/
T6 r65same_unicode_string(T65* C,T0* a1);
/*UC_STRING*/
T2 r65item_code(T65* C,T2 a1);
/*UC_STRING*/
T3 r65character_item_at_byte_index(T65* C,T2 a1);
/*UC_STRING*/
void r65put(T65* C,T3 a1,T2 a2);
/*UC_STRING*/
void r65remove_between(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
T6 r65is_equal(T65* C,T0* a1);
/*UC_STRING*/
T2 r65index_of_code(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
T3 r65item(T65* C,T2 a1);
/*UC_STRING*/
void r65resize_byte_storage(T65* C,T2 a1);
/*UC_STRING*/
void r65append(T65* C,T0* a1);
/*UC_STRING*/
T6 r65se_assigned_from(T0* a1);
/*UC_STRING*/
T2 r65byte_index(T65* C,T2 a1);
/*UC_STRING*/
void r65print_on(T65* C,T0* a1);
/*UC_STRING*/
T0* r65clone(T0* a1);
/*UC_STRING*/
T2 r65index_of(T65* C,T3 a1,T2 a2);
/*UC_STRING*/
void r65out_in_tagged_out_memory(T65* C);
/*UC_STRING*/
void r65remove_substring(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
void r65move_bytes_right(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
void r65set_count(T65* C,T2 a1);
/*UC_STRING*/
T2 r65next_byte_index(T65* C,T2 a1);
/*UC_STRING*/
T6 r65same_type(T65* C,T0* a1);
/*UC_STRING*/
void r65remove_tail(T65* C,T2 a1);
extern T0*oBC65dummy_uc_string;
extern int fBC65dummy_uc_string;
/*UC_STRING*/
T0* r65dummy_uc_string(void);
/*UC_STRING*/
void r65make(T65* C,T2 a1);
/*UC_STRING*/
void r65old_make_filled(T65* C,T3 a1,T2 a2);
/*UC_STRING*/
void r65fill_tagged_out_memory(T65* C);
/*UC_STRING*/
void r65append_string(T65* C,T0* a1);
/*UC_STRING*/
void r65remove(T65* C,T2 a1);
/*UC_STRING*/
void r65append_substring(T65* C,T0* a1,T2 a2,T2 a3);
/*UC_STRING*/
T2 r65item_code_at_byte_index(T65* C,T2 a1);
extern T0*oBC55platform;
/*UC_STRING*/
T0* r65string(T65* C);
/*UC_STRING*/
void r65extend(T65* C,T3 a1);
/*UC_STRING*/
T2 r65hash_code(T65* C);
/*UC_STRING*/
void r65remove_last(T65* C,T2 a1);
/*UC_STRING*/
T0* r65prefixed_string(T65* C,T0* a1);
/*UC_STRING*/
T6 r65conforms_to(T65* C,T0* a1);
/*UC_STRING*/
T6 r65has(T65* C,T3 a1);
/*UC_STRING*/
void r65keep_head(T65* C,T2 a1);
/*UC_STRING*/
T2 r65to_integer(T65* C);
/*UC_STRING*/
T0* r65new_empty_string(T2 a1);
/*UC_STRING*/
void r65append_character(T65* C,T3 a1);
/*UC_STRING*/
void r65make_from_substring(T65* C,T0* a1,T2 a2,T2 a3);
/*UC_STRING*/
void r65put_code_at_byte_index(T65* C,T2 a1,T2 a2,T2 a3);
/*UC_STRING*/
void r65fill_with(T65* C,T3 a1);
/*UC_STRING*/
T6 r65same_as(T65* C,T0* a1);
/*UC_STRING*/
void r65extend_unless(T65* C,T3 a1);
/*UC_STRING*/
void r65put_character_at_byte_index(T65* C,T3 a1,T2 a2,T2 a3);
/*UC_STRING*/
void r65_7Pappend_string(T65* C,T0* a1);
/*UC_STRING*/
void r65add_last(T65* C,T3 a1);
/*UC_STRING*/
T3 r65first(T65* C);
/*UC_STRING*/
void r65resize(T65* C,T2 a1);
/*UC_STRING*/
void r65put_substring_at_byte_index(T65* C,T0* a1,T2 a2,T2 a3,T2 a4,T2 a5);
/*UC_STRING*/
T2 r65substring_index(T65* C,T0* a1,T2 a2);
/*UC_STRING*/
void r65replace_substring(T65* C,T0* a1,T2 a2,T2 a3);
/*UC_STRING*/
void r65from_external_copy(T65* C,T8 a1);
/*UC_STRING*/
T3 r65byte_item(T65* C,T2 a1);
/*UC_STRING*/
void r65move_bytes_left(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
void r65old_make(T65* C,T2 a1);
/*UC_STRING*/
T8 r65to_external(T65* C);
/*UC_STRING*/
void r65old_make_from_string(T65* C,T0* a1);
/*UC_STRING*/
void r65to_lower(T65* C);
/*UC_STRING*/
T0* r65twin(T65* C);
/*UC_STRING*/
T0* r65to_utf8(T65* C);
/*UC_STRING*/
T0* r65_ix_43(T65* C,T0* a1);
/*UC_STRING*/
T2 r65_7Phash_code(T65* C);
/*UC_STRING*/
T2 r65unicode_substring_index(T65* C,T0* a1,T2 a2);
/*UC_STRING*/
void r65swap(T65* C,T2 a1,T2 a2);
/*LX_EQUIVALENCE_CLASSES*/
void r294build(T294* C);
/*LX_EQUIVALENCE_CLASSES*/
void r294put(T294* C,T2 a1);
/*LX_EQUIVALENCE_CLASSES*/
T2 r294upper(T294* C);
/*LX_EQUIVALENCE_CLASSES*/
T2 r294lower(T294* C);
/*LX_EQUIVALENCE_CLASSES*/
T0* r294to_array(T294* C,T2 a1,T2 a2);
/*LX_EQUIVALENCE_CLASSES*/
void r294make(T294* C,T2 a1,T2 a2);
/*LX_EQUIVALENCE_CLASSES*/
T2 r294equivalence_class(T294* C,T2 a1);
/*LX_EQUIVALENCE_CLASSES*/
void r294add(T294* C,T0* a1);
/*LX_EQUIVALENCE_CLASSES*/
T6 r294is_representative(T294* C,T2 a1);
/*LX_EQUIVALENCE_CLASSES*/
void r294initialize(T294* C);
/*XM_PROCESSING_INSTRUCTION*/
void r778make_last_in_document(T778* C,T0* a1,T0* a2,T0* a3);
/*XM_PROCESSING_INSTRUCTION*/
void r778process(T778* C,T0* a1);
/*XM_PROCESSING_INSTRUCTION*/
void r778make_last(T778* C,T0* a1,T0* a2,T0* a3);
/*XM_EIFFEL_DECLARATION*/
void r559process(T559* C,T0* a1);
/*XM_EIFFEL_DECLARATION*/
void r559make(T559* C);
/*KL_STDOUT_FILE*/
void r556make(T556* C);
/*KL_STDOUT_FILE*/
void r556old_put_string(T556* C,T0* a1);
/*KL_STDOUT_FILE*/
void r556old_put_character(T556* C,T3 a1);
/*KL_STDOUT_FILE*/
void r556old_make(T556* C);
/*KL_STDOUT_FILE*/
void r556write_buffer(T556* C);
/*KL_STDOUT_FILE*/
void r556put_string(T556* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175normalized_newline(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
T6 r175is_literal(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
T2 r175start_condition(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175yy_chk_template_1(T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r175yy_chk_template_2(T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r175set_input_buffer(T175* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175text_substring(T175* C,T2 a1,T2 a2);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175yy_ec_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
void r175yy_execute_action(T175* C,T2 a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175yy_def_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
T3 r175text_item(T175* C,T2 a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r175_179Pset_input_buffer(T175* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175system_literal_text(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175yy_load_input_buffer(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175apply_input_buffer(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175make_with_buffer(T175* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r175_177Preset(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
T2 r175yy_null_trans_state(T175* C,T2 a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r175pop_start_condition(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
T6 r175is_valid_encoding(T175* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175yy_accept_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
void r175read_token(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
T2 r175yy_previous_state(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175yy_refill_input_buffer(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175push_start_condition_dtd_ignore(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175yy_fixed_array(T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175yy_meta_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175yy_base_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
void r175set_input_stream(T175* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T2 r175text_count(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175new_file_buffer(T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r175make_scanner(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175yy_initialize(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175reset(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175push_start_condition(T175* C,T2 a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175text(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175close_input(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175yy_nxt_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
void r175yy_set_line_column(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175_178P_177Preset(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175make_literal(T175* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175empty_buffer(void);
/*XM_EIFFEL_ENTITY_DEF*/
void r175yy_nxt_template_1(T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r175yy_nxt_template_2(T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r175yy_chk_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
void r175yy_set_content(T175* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r175set_start_condition(T175* C,T2 a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r175yy_execute_eof_action(T175* C,T2 a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r175_176Pread_token(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175yy_build_tables(T175* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r175make_external(T175* C,T0* a1,T0* a2);
/*LX_BAD_CHARACTER_CLASS_ERROR*/
T0* r448arguments(void);
/*LX_BAD_CHARACTER_CLASS_ERROR*/
void r448make(T448* C,T0* a1,T2 a2);
/*LX_BAD_CHARACTER_CLASS_ERROR*/
T0* r448message(T448* C,T0* a1);
/*KL_STDERR_FILE*/
void r437old_put_string(T0* a1);
/*KL_STDERR_FILE*/
void r437put_integer(T2 a1);
/*KL_STDERR_FILE*/
void r437put_string(T0* a1);
/*XM_EIFFEL_INPUT_STREAM*/
void r617make_from_stream(T617* C,T0* a1);
/*XM_EIFFEL_INPUT_STREAM*/
T0* r617name(T617* C);
/*XM_EIFFEL_INPUT_STREAM*/
T2 r617read_to_string(T617* C,T0* a1,T2 a2,T2 a3);
/*XM_EIFFEL_INPUT_STREAM*/
T2 r617most_significant(T617* C,T3 a1,T3 a2);
/*XM_EIFFEL_INPUT_STREAM*/
T6 r617is_valid_encoding(T0* a1);
/*XM_EIFFEL_INPUT_STREAM*/
void r617noqueue_read_character(T617* C);
/*XM_EIFFEL_INPUT_STREAM*/
T0* r617clone(T0* a1);
/*XM_EIFFEL_INPUT_STREAM*/
void r617read_character(T617* C);
/*XM_EIFFEL_INPUT_STREAM*/
void r617utf16_detect_read_character(T617* C);
/*XM_EIFFEL_INPUT_STREAM*/
T2 r617least_significant(T617* C,T3 a1,T3 a2);
/*XM_EIFFEL_INPUT_STREAM*/
T2 r617read_to_buffer(T617* C,T0* a1,T2 a2,T2 a3);
/*XM_EIFFEL_INPUT_STREAM*/
T2 r617_56Pread_to_string(T617* C,T0* a1,T2 a2,T2 a3);
/*XM_EIFFEL_INPUT_STREAM*/
T6 r617end_of_input(T617* C);
/*XM_EIFFEL_INPUT_STREAM*/
void r617append_character(T617* C,T2 a1);
/*XM_EIFFEL_INPUT_STREAM*/
void r617latin1_read_character(T617* C);
/*XM_EIFFEL_INPUT_STREAM*/
void r617utf16_read_character(T617* C);
/*XM_EIFFEL_INPUT_STREAM*/
T3 r617last_character(T617* C);
/*XM_EIFFEL_INPUT_STREAM*/
void r617read_string(T617* C,T2 a1);
extern T0*oBC67utf16;
extern T0*oBC617utf8_buffer;
extern int fBC617utf8_buffer;
/*XM_EIFFEL_INPUT_STREAM*/
T0* r617utf8_buffer(void);
/*XM_EIFFEL_INPUT_STREAM*/
void r617set_encoding(T617* C,T0* a1);
/*XM_DEFAULT_POSITION*/
void r790make(T790* C,T0* a1,T2 a2,T2 a3,T2 a4);
/*XM_ATTRIBUTE*/
void r784process(T784* C,T0* a1);
/*XM_ATTRIBUTE*/
void r784make_last(T784* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*UC_UTF8_STRING*/
T0* r430out(T430* C);
/*UC_UTF8_STRING*/
void r430copy(T430* C,T0* a1);
/*UC_UTF8_STRING*/
T0* r430substring(T430* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
void r430reset_byte_index_cache(T430* C);
/*UC_UTF8_STRING*/
T2 r430shifted_byte_index(T430* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
void r430wipe_out(T430* C);
/*UC_UTF8_STRING*/
T3 r430last(T430* C);
/*UC_UTF8_STRING*/
T2 r430first_substring_index(T430* C,T0* a1);
/*UC_UTF8_STRING*/
T6 r430same_unicode_string(T430* C,T0* a1);
/*UC_UTF8_STRING*/
T2 r430item_code(T430* C,T2 a1);
/*UC_UTF8_STRING*/
T3 r430character_item_at_byte_index(T430* C,T2 a1);
/*UC_UTF8_STRING*/
void r430put(T430* C,T3 a1,T2 a2);
/*UC_UTF8_STRING*/
void r430remove_between(T430* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
T6 r430is_equal(T430* C,T0* a1);
/*UC_UTF8_STRING*/
T2 r430index_of_code(T430* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
T3 r430item(T430* C,T2 a1);
/*UC_UTF8_STRING*/
void r430resize_byte_storage(T430* C,T2 a1);
/*UC_UTF8_STRING*/
void r430append(T430* C,T0* a1);
/*UC_UTF8_STRING*/
T6 r430se_assigned_from(T0* a1);
/*UC_UTF8_STRING*/
T2 r430byte_index(T430* C,T2 a1);
/*UC_UTF8_STRING*/
void r430print_on(T430* C,T0* a1);
/*UC_UTF8_STRING*/
T0* r430clone(T0* a1);
/*UC_UTF8_STRING*/
T2 r430index_of(T430* C,T3 a1,T2 a2);
/*UC_UTF8_STRING*/
void r430out_in_tagged_out_memory(T430* C);
/*UC_UTF8_STRING*/
void r430remove_substring(T430* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
void r430move_bytes_right(T430* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
void r430set_count(T430* C,T2 a1);
/*UC_UTF8_STRING*/
T2 r430next_byte_index(T430* C,T2 a1);
/*UC_UTF8_STRING*/
T6 r430same_type(T430* C,T0* a1);
/*UC_UTF8_STRING*/
T0* r430dummy_uc_string(void);
/*UC_UTF8_STRING*/
void r430remove_tail(T430* C,T2 a1);
/*UC_UTF8_STRING*/
void r430make(T430* C,T2 a1);
/*UC_UTF8_STRING*/
void r430old_make_filled(T430* C,T3 a1,T2 a2);
/*UC_UTF8_STRING*/
void r430fill_tagged_out_memory(T430* C);
/*UC_UTF8_STRING*/
void r430append_string(T430* C,T0* a1);
/*UC_UTF8_STRING*/
void r430remove(T430* C,T2 a1);
/*UC_UTF8_STRING*/
void r430append_substring(T430* C,T0* a1,T2 a2,T2 a3);
/*UC_UTF8_STRING*/
T2 r430item_code_at_byte_index(T430* C,T2 a1);
/*UC_UTF8_STRING*/
T0* r430string(T430* C);
/*UC_UTF8_STRING*/
void r430extend(T430* C,T3 a1);
/*UC_UTF8_STRING*/
T2 r430hash_code(T430* C);
/*UC_UTF8_STRING*/
T0* r430prefixed_string(T430* C,T0* a1);
/*UC_UTF8_STRING*/
void r430remove_last(T430* C,T2 a1);
/*UC_UTF8_STRING*/
T6 r430conforms_to(T430* C,T0* a1);
/*UC_UTF8_STRING*/
T6 r430has(T430* C,T3 a1);
/*UC_UTF8_STRING*/
void r430keep_head(T430* C,T2 a1);
/*UC_UTF8_STRING*/
T2 r430to_integer(T430* C);
/*UC_UTF8_STRING*/
T0* r430new_empty_string(T2 a1);
/*UC_UTF8_STRING*/
void r430append_character(T430* C,T3 a1);
/*UC_UTF8_STRING*/
void r430put_code_at_byte_index(T430* C,T2 a1,T2 a2,T2 a3);
/*UC_UTF8_STRING*/
void r430make_from_substring(T430* C,T0* a1,T2 a2,T2 a3);
/*UC_UTF8_STRING*/
void r430fill_with(T430* C,T3 a1);
/*UC_UTF8_STRING*/
T6 r430same_as(T430* C,T0* a1);
/*UC_UTF8_STRING*/
void r430extend_unless(T430* C,T3 a1);
/*UC_UTF8_STRING*/
void r430put_character_at_byte_index(T430* C,T3 a1,T2 a2,T2 a3);
/*UC_UTF8_STRING*/
void r430_7Pappend_string(T430* C,T0* a1);
/*UC_UTF8_STRING*/
void r430add_last(T430* C,T3 a1);
/*UC_UTF8_STRING*/
void r430resize(T430* C,T2 a1);
/*UC_UTF8_STRING*/
void r430put_substring_at_byte_index(T430* C,T0* a1,T2 a2,T2 a3,T2 a4,T2 a5);
/*UC_UTF8_STRING*/
T2 r430substring_index(T430* C,T0* a1,T2 a2);
/*UC_UTF8_STRING*/
void r430append_utf8(T430* C,T0* a1);
/*UC_UTF8_STRING*/
void r430replace_substring(T430* C,T0* a1,T2 a2,T2 a3);
/*UC_UTF8_STRING*/
void r430from_external_copy(T430* C,T8 a1);
/*UC_UTF8_STRING*/
void r430move_bytes_left(T430* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
void r430old_make(T430* C,T2 a1);
/*UC_UTF8_STRING*/
T8 r430to_external(T430* C);
/*UC_UTF8_STRING*/
void r430old_make_from_string(T430* C,T0* a1);
/*UC_UTF8_STRING*/
void r430to_lower(T430* C);
/*UC_UTF8_STRING*/
T0* r430twin(T430* C);
/*UC_UTF8_STRING*/
T0* r430to_utf8(T430* C);
/*UC_UTF8_STRING*/
T0* r430_ix_43(T430* C,T0* a1);
/*UC_UTF8_STRING*/
T2 r430unicode_substring_index(T430* C,T0* a1,T2 a2);
/*UC_UTF8_STRING*/
T2 r430_7Phash_code(T430* C);
/*UC_UTF8_STRING*/
void r430make_from_utf8(T430* C,T0* a1);
/*UC_UTF8_STRING*/
void r430swap(T430* C,T2 a1,T2 a2);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692_175Preset(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692normalized_newline(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692_175Pread_token(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T2 r692start_condition(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692_177P_175Preset(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692set_input_buffer(T692* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692_176P_175Pread_token(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692text_substring(T692* C,T2 a1,T2 a2);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692yy_ec_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692yy_execute_action(T692* C,T2 a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692_178P_177P_175Preset(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692yy_def_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T3 r692text_item(T692* C,T2 a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692_179Pset_input_buffer(T692* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692system_literal_text(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692yy_load_input_buffer(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692apply_input_buffer(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692make_with_buffer(T692* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T2 r692yy_null_trans_state(T692* C,T2 a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692pop_start_condition(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692yy_accept_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692read_token(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T2 r692yy_previous_state(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692yy_refill_input_buffer(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692yy_fixed_array(T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692yy_meta_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692yy_base_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692set_input_stream(T692* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T2 r692text_count(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692new_file_buffer(T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692make_scanner(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692yy_initialize(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692reset(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692push_start_condition(T692* C,T2 a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692text(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692make_def(T692* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692reset_sent(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692close_input(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692yy_nxt_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692yy_set_line_column(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692make_literal(T692* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692empty_buffer(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r692yy_chk_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692yy_set_content(T692* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692set_start_condition(T692* C,T2 a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692yy_build_tables(T692* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r692make_external(T692* C,T0* a1,T0* a2);
extern T0*oBC89default_word_set;
extern int fBC89default_word_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81default_word_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81compile_repeats(T81* C,T2 a1,T2 a2,T2 a3,T2 a4,T2 a5);
extern T0*oBC89digit_set;
extern int fBC89digit_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81digit_set(void);
extern T0*oBC89graph_set;
extern int fBC89graph_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81graph_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81match_additional_bracket(T81* C,T2 a1,T2 a2);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81unset_option_dotall(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r81has_startline(T81* C);
extern T0*oBC89upper_set;
extern int fBC89upper_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81upper_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81first_significant_code(T81* C,T2 a1,T2 a2,T6 a3);
extern T2 oBC85infinity;
extern int fBC85infinity;
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81infinity(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81match_recursive(T81* C,T2 a1,T6 a2,T6 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81escape_character(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81compile_regexp(T81* C,T2 a1,T6 a2,T6 a3,T2 a4);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r81is_option_dotall(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81match_internal(T81* C,T2 a1,T6 a2,T6 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81match_repeated_classes(T81* C,T2 a1);
extern T0*oBC89meta_set;
extern int fBC89meta_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81meta_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81find_firstchar(T81* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r81is_option_caseless(T2 a1);
extern T0*oBC89punct_set;
extern int fBC89punct_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81punct_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81to_option_ims(T2 a1);
extern T0*oBC89print_set;
extern int fBC89print_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81print_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81match_substring(T81* C,T0* a1,T2 a2,T2 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r81match_start(T81* C,T2 a1);
extern T0*oBC89space_set;
extern int fBC89space_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81space_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81match_repeated_characters(T81* C,T2 a1,T2 a2,T2 a3,T6 a4);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81set_error(T81* C,T0* a1,T2 a2,T2 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81ims_options(T81* C);
extern T0*oBC85actual_set;
extern int fBC85actual_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81actual_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81unset_option_multiline(T2 a1);
extern T0*oBC84native_integer_array_;
extern T0*oBC89alnum_set;
extern int fBC89alnum_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81alnum_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81check_posix_syntax(T81* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81match_not_repeated_characters(T81* C,T2 a1,T2 a2,T2 a3,T6 a4);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81match_it(T81* C,T0* a1,T2 a2,T2 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81scan_octal_number(T81* C,T2 a1);
extern T0*oBC89default_character_case_mapping;
extern int fBC89default_character_case_mapping;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81default_character_case_mapping(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81match_repeated_refs(T81* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81unset_option_caseless(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81wipe_out(T81* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81match_repeated_type(T81* C,T2 a1,T2 a2,T2 a3,T6 a4);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81compile_single_repeat(T81* C,T2 a1,T2 a2,T2 a3,T2 a4,T2 a5,T2 a6);
extern T0*oBC89xdigit_set;
extern int fBC89xdigit_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81xdigit_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r81is_captured_substring_defined(T81* C,T2 a1);
extern T0*oBC89ascii_set;
extern int fBC89ascii_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81ascii_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81captured_start_position(T81* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81clone(T0* a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81match_ref(T81* C,T2 a1,T2 a2,T2 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81captured_end_position(T81* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81reset(T81* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81scan_escape(T81* C,T2 a1,T6 a2);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81find_fixed_code_length(T81* C,T2 a1);
extern T2 oBC85maxlit;
extern int fBC85maxlit;
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81maxlit(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81set_option_multiline(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81set_ims_options(T81* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81next_matching_alternate(T81* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81set_default_options(T81* C);
extern T0*oBC89cntrl_set;
extern int fBC89cntrl_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81cntrl_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r81compile_counted_repeats(T81* C,T2 a1,T2 a2,T2 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81scan_comment(T81* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81compile_character_class(T81* C);
extern T0*oBC85empty_pattern;
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81set_default_internal_options(T81* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r81is_option_multiline(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81compile(T81* C,T0* a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81_85Preset(T81* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r81is_option_undef(T2 a1);
extern T0*oBC89lower_set;
extern int fBC89lower_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81lower_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81_94Pwipe_out(T81* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81scan_hex_number(T81* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81compile_branch(T81* C,T6 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81make(T81* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81scan_decimal_number(T81* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81set_option_caseless(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r81matches(T81* C,T0* a1);
extern T0*oBC89class_sets;
extern int fBC89class_sets;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81class_sets(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81_85Pmake(T81* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81set_option_dotall(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r81can_anchored(T81* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r81_85Pcompile(T81* C,T0* a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r81check_posix_name(T81* C,T2 a1,T2 a2);
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81captured_substring(T81* C,T2 a1);
extern T0*oBC89class_names;
extern T0*oBC89alpha_set;
extern int fBC89alpha_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r81alpha_set(void);
/*XM_ELEMENT*/
void r743set_last_cell(T743* C,T0* a1);
/*XM_ELEMENT*/
void r743wipe_out(T743* C);
/*XM_ELEMENT*/
void r743remove_first(T743* C);
/*XM_ELEMENT*/
T0* r743cursor_item(T0* a1);
/*XM_ELEMENT*/
T6 r743cursor_is_last(T743* C,T0* a1);
/*XM_ELEMENT*/
void r743remove_traversing_cursor(T743* C,T0* a1);
/*XM_ELEMENT*/
void r743make_root(T743* C,T0* a1,T0* a2,T0* a3);
/*XM_ELEMENT*/
void r743cursor_go_after(T743* C,T0* a1);
/*XM_ELEMENT*/
void r743move_all_cursors_after(T743* C);
/*XM_ELEMENT*/
void r743add_traversing_cursor(T743* C,T0* a1);
/*XM_ELEMENT*/
void r743process(T743* C,T0* a1);
/*XM_ELEMENT*/
void r743make(T743* C,T0* a1,T0* a2,T0* a3);
/*XM_ELEMENT*/
T0* r743parent_element(T743* C);
/*XM_ELEMENT*/
void r743before_addition(T743* C,T0* a1);
/*XM_ELEMENT*/
void r743remove_last(T743* C);
/*XM_ELEMENT*/
T6 r743cursor_after(T0* a1);
/*XM_ELEMENT*/
void r743make_last(T743* C,T0* a1,T0* a2,T0* a3);
/*XM_ELEMENT*/
void r743make_list(T743* C);
/*XM_ELEMENT*/
void r743_538P_537Pforce_last(T743* C,T0* a1);
/*XM_ELEMENT*/
void r743equality_delete(T743* C,T0* a1);
/*XM_ELEMENT*/
void r743cursor_forth(T743* C,T0* a1);
/*XM_ELEMENT*/
void r743move_last_cursors_after(T743* C);
/*XM_ELEMENT*/
void r743cursor_start(T743* C,T0* a1);
/*XM_ELEMENT*/
void r743force_last(T743* C,T0* a1);
/*XM_ELEMENT*/
T0* r743new_cursor(T743* C);
/*XM_ELEMENT*/
void r743_537Pforce_last(T743* C,T0* a1);
/*XM_ELEMENT*/
T6 r743cursor_is_first(T743* C,T0* a1);
/*XM_ELEMENT*/
void r743remove_at_cursor(T743* C,T0* a1);
/*XM_ELEMENT*/
void r743move_all_cursors(T743* C,T0* a1,T0* a2);
/*XM_ELEMENT*/
T6 r743cursor_off(T0* a1);
/*LATEX_VISITOR*/
void r535sub_visit(T535* C,T0* a1);
/*LATEX_VISITOR*/
T0* r535visit_cmts(T535* C,T0* a1);
/*LATEX_VISITOR*/
void r535visit(T535* C);
/*LATEX_VISITOR*/
T0* r535correct(T0* a1);
/*LATEX_VISITOR*/
void r535make(T535* C,T0* a1,T6 a2,T0* a3,T0* a4);
/*LATEX_VISITOR*/
T0* r535visit_strs(T0* a1);
/*LATEX_VISITOR*/
T0* r535visit_cmt(T535* C,T0* a1);
/*LATEX_VISITOR*/
T0* r535visit_str(T0* a1);
/*RX_BYTE_CODE*/
void r100wipe_out(T100* C);
/*RX_BYTE_CODE*/
void r100append_integer(T100* C,T2 a1);
/*RX_BYTE_CODE*/
void r100resize_character_sets(T100* C,T2 a1);
extern T0*oBC84native_boolean_array_;
/*RX_BYTE_CODE*/
void r100make(T100* C,T2 a1);
/*RX_BYTE_CODE*/
void r100append_opcode(T100* C,T2 a1);
/*RX_BYTE_CODE*/
void r100move_right(T100* C,T2 a1,T2 a2);
/*RX_BYTE_CODE*/
void r100append_character(T100* C,T2 a1);
/*RX_BYTE_CODE*/
void r100resize_byte_code(T100* C,T2 a1);
/*RX_BYTE_CODE*/
void r100append_subcopy(T100* C,T2 a1,T2 a2);
/*RX_BYTE_CODE*/
T6 r100character_set_has(T100* C,T2 a1,T2 a2);
/*RX_BYTE_CODE*/
void r100append_character_set(T100* C,T0* a1,T6 a2);
/*RX_BYTE_CODE*/
void r100put_character(T100* C,T2 a1,T2 a2);
/*TEXT_FILE_WRITE*/
void r79disconnect(T79* C);
/*TEXT_FILE_WRITE*/
void r79connect_to(T79* C,T0* a1);
/*TEXT_FILE_WRITE*/
void r79write_buffer(T79* C);
/*TEXT_FILE_WRITE*/
void r79put_character(T79* C,T3 a1);
/*TEXT_FILE_WRITE*/
void r79put_string(T79* C,T0* a1);
/*XM_NAMESPACE*/
T6 r749is_equal(T749* C,T0* a1);
/*XM_NAMESPACE*/
void r749make(T749* C,T0* a1,T0* a2);
/*XM_NAMESPACE*/
T2 r749hash_code(T749* C);
/*XM_NAMESPACE*/
T6 r749same_prefix(T749* C,T0* a1);
/*STD_OUTPUT*/
void r24make(T24* C);
/*STD_OUTPUT*/
void r24flush(T24* C);
/*STD_OUTPUT*/
void r24write_buffer(T24* C);
/*STD_OUTPUT*/
void r24put_character(T24* C,T3 a1);
/*STD_OUTPUT*/
void r24put_string(T24* C,T0* a1);
/*STD_ERROR*/
void r39put_string(T0* a1);
/*UT_SYNTAX_ERROR*/
T0* r424arguments(void);
/*UT_SYNTAX_ERROR*/
void r424make(T424* C,T0* a1,T2 a2);
/*UT_SYNTAX_ERROR*/
T0* r424message(T424* C,T0* a1);
/*LX_ITERATION_NOT_POSITIVE_ERROR*/
T0* r484arguments(void);
/*LX_ITERATION_NOT_POSITIVE_ERROR*/
void r484make(T484* C,T0* a1,T2 a2);
/*LX_ITERATION_NOT_POSITIVE_ERROR*/
T0* r484message(T484* C,T0* a1);
/*KL_ARGUMENTS*/
T0* r431command_arguments(void);
/*KL_ARGUMENTS*/
T0* r431argument(T2 a1);
/*KL_CHARACTER_BUFFER*/
T0* r252substring(T252* C,T2 a1,T2 a2);
/*KL_CHARACTER_BUFFER*/
void r252fill_from_string(T252* C,T0* a1,T2 a2);
/*KL_CHARACTER_BUFFER*/
T2 r252fill_from_stream(T252* C,T0* a1,T2 a2,T2 a3);
/*KL_CHARACTER_BUFFER*/
void r252move_left(T252* C,T2 a1,T2 a2,T2 a3);
/*KL_CHARACTER_BUFFER*/
void r252make(T252* C,T2 a1);
/*KL_CHARACTER_BUFFER*/
void r252resize(T252* C,T2 a1);
/*UC_UTF16_ROUTINES*/
T6 r634is_endian_detection_character_least_first(T2 a1,T2 a2);
/*UC_UTF16_ROUTINES*/
T6 r634is_high_surrogate(T2 a1);
/*UC_UTF16_ROUTINES*/
T6 r634is_low_surrogate(T2 a1);
/*UC_UTF16_ROUTINES*/
T6 r634is_endian_detection_character_most_first(T2 a1,T2 a2);
/*UC_UTF16_ROUTINES*/
T6 r634is_surrogate(T2 a1);
/*UC_UTF16_ROUTINES*/
T2 r634least_10_bits(T2 a1,T2 a2);
/*UC_UTF16_ROUTINES*/
T2 r634surrogate(T2 a1,T2 a2);
extern T0*oBC436error;
extern int fBC436error;
/*KL_STANDARD_FILES*/
T0* r436error(void);
extern T0*oBC436output;
extern int fBC436output;
/*KL_STANDARD_FILES*/
T0* r436output(void);
extern T2 oBC74maximum_character_code;
extern int fBC74maximum_character_code;
/*KL_PLATFORM*/
T2 r74maximum_character_code(T74* C);
extern T2 oBC74maximum_integer;
/*KL_EXCEPTIONS*/
void r713raise(T713* C,T0* a1);
extern T0*oBC714developer_exception_name_memory;
extern T0*oBC623lowercase_24;
extern int fBC623lowercase_24;
/*UC_UNICODE_ROUTINES*/
T0* r622lowercase_24(void);
extern T0*oBC623lowercase_21;
extern int fBC623lowercase_21;
/*UC_UNICODE_ROUTINES*/
T0* r622lowercase_21(void);
extern T0*oBC623lowercase_06;
extern int fBC623lowercase_06;
/*UC_UNICODE_ROUTINES*/
T0* r622lowercase_06(void);
extern T0*oBC623lowercase_05;
extern int fBC623lowercase_05;
/*UC_UNICODE_ROUTINES*/
T0* r622lowercase_05(void);
extern T0*oBC623lowercase_04;
extern int fBC623lowercase_04;
/*UC_UNICODE_ROUTINES*/
T0* r622lowercase_04(void);
extern T0*oBC623lowercase_03;
extern int fBC623lowercase_03;
/*UC_UNICODE_ROUTINES*/
T0* r622lowercase_03(void);
extern T0*oBC623lowercase_02;
extern int fBC623lowercase_02;
/*UC_UNICODE_ROUTINES*/
T0* r622lowercase_02(void);
extern T0*oBC623lowercase_01;
extern int fBC623lowercase_01;
/*UC_UNICODE_ROUTINES*/
T0* r622lowercase_01(void);
extern T0*oBC623lowercase_00;
extern int fBC623lowercase_00;
/*UC_UNICODE_ROUTINES*/
T0* r622lowercase_00(void);
extern T0*oBC623lowercase_ff;
extern int fBC623lowercase_ff;
/*UC_UNICODE_ROUTINES*/
T0* r622lowercase_ff(void);
/*UC_UNICODE_ROUTINES*/
T2 r622lower_code(T2 a1);
/*UC_UNICODE_ROUTINES*/
T6 r622valid_code(T2 a1);
extern T0*oBC623lowercase_1f;
extern int fBC623lowercase_1f;
/*UC_UNICODE_ROUTINES*/
T0* r622lowercase_1f(void);
extern T0*oBC623lowercase_1e;
extern int fBC623lowercase_1e;
/*UC_UNICODE_ROUTINES*/
T0* r622lowercase_1e(void);
extern T0*oBC623lowercase;
extern int fBC623lowercase;
/*UC_UNICODE_ROUTINES*/
T0* r622lowercase(void);
/*UC_UTF8_ROUTINES*/
T2 r73encoded_next_value(T3 a1);
/*UC_UTF8_ROUTINES*/
T2 r73character_byte_count(T3 a1);
/*UC_UTF8_ROUTINES*/
T2 r73encoded_first_value(T3 a1);
/*UC_UTF8_ROUTINES*/
T2 r73code_byte_count(T2 a1);
/*UC_UTF8_ROUTINES*/
T2 r73encoded_byte_count(T3 a1);
/*UC_UTF8_ROUTINES*/
void r73append_code_to_utf8(T0* a1,T2 a2);
/*UC_UTF8_ROUTINES*/
T0* r73to_utf8(T0* a1);
/*UC_UTF8_ROUTINES*/
T2 r73substring_byte_count(T0* a1,T2 a2,T2 a3);
/*CGI*/
void r12error(T12* C,T0* a1);
/*CGI*/
void r12process(T12* C,T0* a1);
/*CGI*/
void r12make(T12* C);
/*CGI*/
void r12print(T0* a1);
/*CGI*/
T0* r12replace(T0* a1,T0* a2,T0* a3);
/*KL_INTEGER_ROUTINES*/
T3 r76to_character(T2 a1);
/*UC_EQUALITY_TESTER*/
T6 r197test(T0* a1,T0* a2);
/*SYSTEM*/
T0* r16get_environment_variable(T0* a1);
/*reference INTEGER*/
T0* r555twin(T555* C);
/*XM_NODE_TYPER*/
void r783process_comment(T783* C,T0* a1);
/*XM_NODE_TYPER*/
void r783process_processing_instruction(T783* C,T0* a1);
/*XM_NODE_TYPER*/
void r783process_document(T783* C,T0* a1);
/*XM_NODE_TYPER*/
void r783process_element(T783* C,T0* a1);
/*XM_NODE_TYPER*/
void r783process_attribute(T783* C,T0* a1);
/*XM_NODE_TYPER*/
void r783process_character_data(T783* C,T0* a1);
/*XM_NODE_TYPER*/
void r783reset(T783* C);
/*BASIC_DIRECTORY*/
void r33set_notation_using(T0* a1);
/*BASIC_DIRECTORY*/
T6 r33amiga_notation(void);
/*BASIC_DIRECTORY*/
void r33disconnect(T33* C);
/*BASIC_DIRECTORY*/
void r33compute_subdirectory_with(T0* a1,T0* a2);
/*BASIC_DIRECTORY*/
T6 r33system_notation_detected(void);
/*BASIC_DIRECTORY*/
T6 r33windows_notation(void);
/*BASIC_DIRECTORY*/
T6 r33unix_notation(void);
extern T0*oBC33last_entry;
/*BASIC_DIRECTORY*/
T6 r33macintosh_notation(void);
/*BASIC_DIRECTORY*/
void r33read_entry(T33* C);
/*BASIC_DIRECTORY*/
void r33connect_to(T33* C,T0* a1);
/*BASIC_DIRECTORY*/
T6 r33create_new_directory(T0* a1);
/*BASIC_DIRECTORY*/
T6 r33openvms_notation(void);
/*BASIC_DIRECTORY*/
T6 r33cygwin_notation(void);
/*KL_STRING_ROUTINES*/
T0* r62substring(T0* a1,T2 a2,T2 a3);
/*KL_STRING_ROUTINES*/
void r62wipe_out(T0* a1);
/*KL_STRING_ROUTINES*/
T0* r62as_string(T0* a1);
/*KL_STRING_ROUTINES*/
T0* r62clone(T0* a1);
/*KL_STRING_ROUTINES*/
T0* r62appended_string(T0* a1,T0* a2);
/*KL_STRING_ROUTINES*/
T6 r62is_integer(T0* a1);
/*KL_STRING_ROUTINES*/
T0* r62make(T2 a1);
/*KL_STRING_ROUTINES*/
T0* r62string(T0* a1);
/*KL_STRING_ROUTINES*/
T2 r62hexadecimal_to_integer(T0* a1);
/*KL_STRING_ROUTINES*/
T0* r62as_lower(T0* a1);
/*KL_STRING_ROUTINES*/
T0* r62appended_substring(T0* a1,T0* a2,T2 a3,T2 a4);
/*KL_STRING_ROUTINES*/
T0* r62new_empty_string(T0* a1,T2 a2);
/*KL_STRING_ROUTINES*/
T0* r62concat(T0* a1,T0* a2);
/*KL_STRING_ROUTINES*/
T2 r62substring_index(T0* a1,T0* a2,T2 a3);
/*KL_STRING_ROUTINES*/
T6 r62same_string(T0* a1,T0* a2);
/*KL_STRING_ROUTINES*/
T6 r62elks_same_string(T0* a1,T0* a2);
/*KL_STRING_ROUTINES*/
void r62append_substring_to_string(T0* a1,T0* a2,T2 a3,T2 a4);
/*XM_NULL_EXTERNAL_RESOLVER*/
T0* r162last_error(void);
/*reference BOOLEAN*/
T0* r557twin(T557* C);
/*XM_EXPAT_PARSER_FACTORY*/
T0* r151new_expat_parser(void);
extern T12*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 795
extern T7*g[];
extern T7*t[];
void se_atexit(void);
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T0*ms92_619510042;
extern T0*ms47_250860571;
extern T0*ms78_469863407;
extern T0*ms78_438699;
extern T0*ms168_1040340337;
extern T0*ms92_727439395;
extern T0*ms78_93494782;
extern T0*ms7_241908472;
extern T0*ms168_1383485945;
extern T0*ms168_498324258;
extern T0*ms40_10378916;
extern T0*ms168_993001251;
extern T0*ms446_111876583;
extern T0*ms168_930325994;
extern T0*ms29_1356433198;
extern T0*ms168_1787513656;
extern T0*ms29_1356433650;
extern T0*ms23_0aaaa;
extern T0*ms12_94835277;
extern T0*ms78_94830657;
extern T0*ms493_823229232;
extern T0*ms92_139329733;
extern T0*ms33_276a;
extern T0*ms450_1686894687;
extern T0*ms168_429369815;
extern T0*ms168_766510371;
extern T0*ms40_3603;
extern T0*ms464_280487577;
extern T0*ms168_2065551545;
extern T0*ms168_1864547461;
extern T0*ms20_8970;
extern T0*ms20_8991;
extern T0*ms617_90456;
extern T0*ms77_277;
extern T0*ms77_46a;
extern T0*ms29_750997226;
extern T0*ms7_280756769;
extern T0*ms534_840780094;
extern T0*ms92_529870453;
extern T0*ms444_645257649;
extern T0*ms23_0aa;
extern T0*ms617_11156230;
extern T0*ms92_106524939;
extern T0*ms23_0;
extern T0*ms92_1317500565;
extern T0*ms92_1200988023;
extern T0*ms168_1806352573;
extern T0*ms447_1203377682;
extern T0*ms168_2083254325;
extern T0*ms168_758578972;
extern T0*ms168_1806545392;
extern T0*ms77_2032339083;
extern T0*ms168_224621212;
extern T0*ms254_763354227;
extern T0*ms92_1675130891;
extern T0*ms92_1141105903;
extern T0*ms245_6934577;
extern T0*ms168_313350252;
extern T0*ms77_46;
extern T0*ms168_1680506019;
extern T0*ms7_1983847;
extern T0*ms15_14150;
extern T0*ms168_1389019675;
extern T0*ms92_53019651;
extern T0*ms482_596994766;
extern T0*ms166_42;
extern T0*ms40_1978691;
extern T0*ms484_465236511;
extern T0*ms168_414094759;
extern T0*ms29_167969882;
extern T0*ms78_94145427;
extern T0*ms40_9946191;
extern T0*ms78_29952;
extern T0*ms254_511118884;
extern T0*ms168_620986269;
extern T0*ms78_93444877;
extern T0*ms448_1086870388;
extern T0*ms168_1639807481;
extern T0*ms78_151842;
extern T0*ms449_215272365;
extern T0*ms40_1980191;
extern T0*ms92_42590039;
extern T0*ms168_1105337616;
extern T0*ms92_247606932;
extern T0*ms168_225532234;
extern T0*ms559_1503;
extern T0*ms92_261495747;
extern T0*ms78_746857;
extern T0*ms92_535188632;
extern T0*ms12_689620590;
extern T0*ms78_752737;
extern T0*ms12_94835277a;
extern T0*ms12_1956468118;
extern T0*ms168_880035048;
extern T0*ms29_257857803;
extern T0*ms92_1584292294;
extern T0*ms77_1538838099;
extern T0*ms78_3789657;
extern T0*ms535_670536417;
extern T0*ms168_729820516;
extern T0*ms617_259593324;
extern T0*ms23_0aaaaa;
extern T0*ms78_467436677;
extern T0*ms29_1487;
extern T0*ms451_1520688928;
extern T0*ms40_89166;
extern T0*ms77_462330772;
extern T0*ms168_1785408556;
extern T0*ms92_1432094708;
extern T0*ms29_883075729;
extern T0*ms12_442391;
extern T0*ms12_32;
extern T0*ms12_43;
extern T0*ms92_1005188058;
extern T0*ms92_1012776380;
extern T0*ms78_759757;
extern T0*ms92_1884818624;
extern T0*ms12_614543876;
extern T0*ms168_1232318322;
extern T0*ms40_1231385571;
extern T0*ms40_2110320;
extern T0*ms29_271663153;
extern T0*ms92_577467693;
extern T0*ms40_434646;
extern T0*ms92_1194160835;
extern T0*ms445_19730319;
extern T0*ms92_1835565352;
extern T0*ms77_1101570667;
extern T0*ms77_1318123306;
extern T0*ms23_0aaa;
extern T0*ms40_2247366;
extern T0*ms78_18948517;
extern T0*ms92_532624755;
extern T0*ms33_276;
extern T0*ms148_2055053662;
extern T0*ms33_63a;
extern T0*ms483_1753741984;
extern T0*ms23_10;
extern T0*ms23_0a;
extern T0*ms424_1449702436;
extern T0*ms40_394019;
extern T0*ms168_1718816811;
extern T0*ms452_1531431095;
extern T0*ms40_16016;
extern T0*ms40_15606;
extern T0*ms617_90456a;
extern T0*ms535_986516197;
extern T0*ms168_513387338;
extern T0*ms78_3772177;
extern T0*ms40_17111;
extern T0*ms168_438332871;
extern T0*ms92_2048967656;
extern T0*ms78_18688922;
extern T0*ms92_1189338692;
extern T0*ms40_18186;
extern T0*ms148_473224273;
extern T0*ms78_10968511;
extern T0*ms263_1338085634;
extern T0*ms12_1956468118a;
extern T0*ms92_763469248;
extern T0*ms536_17696;
extern T0*ms78_18886672;
extern T0*ms33_63;
extern T0*ms78_3763952;
extern T0*ms177_192;
extern T0*ms617_452299;
T0*se_ms(int c,char*e);
T0*se_string(char*e);
void se_msi1(void);
void se_msi2(void);
void se_msi3(void);
void se_msi4(void);
void W153on_xml_declaration_procedure(void* C,T8 a1,T8 a2,T2 a3);
void W153on_content_procedure(void* C,T8 a1,T2 a2);
void W153on_comment_procedure(void* C,T8 a1);
void*se_ma785(int argc,...);
void*se_ma228(int argc,...);
void*se_ma233(int argc,...);
void*se_ma234(int argc,...);
void*se_ma126(int argc,...);
void*se_ma128(int argc,...);
void*se_ma144(int argc,...);
void X294put(T0*C,T2 a1);
T0* X294to_array(T0*C,T2 a1,T2 a2);
void X294add(T0*C,T0* a1);
void X233put(T0*C,T2 a1,T2 a2);
T2 X233item(T0*C,T2 a1);
T6 X196test(T0*C,T0* a1,T0* a2);
T6 X65same_unicode_string(T0*C,T0* a1);
T0* X65as_string(T0*C);
T2 X65byte_index(T0*C,T2 a1);
T2 X65next_byte_index(T0*C,T2 a1);
T6 X65same_type(T0*C,T0* a1);
void X65append_string(T0*C,T0* a1);
void X65append_substring(T0*C,T0* a1,T2 a2,T2 a3);
T2 X65item_code_at_byte_index(T0*C,T2 a1);
T0* X65string(T0*C);
T0* X65prefixed_string(T0*C,T0* a1);
T0* X65new_empty_string(T0*C,T2 a1);
T2 X65substring_index(T0*C,T0* a1,T2 a2);
T3 X65byte_item(T0*C,T2 a1);
T0* X65to_utf8(T0*C);
T0* X65_ix_43(T0*C,T0* a1);
T0* X518item(T0*C);
T6 X518after(T0*C);
void X518forth(T0*C);
void X518start(T0*C);
T0* X514cursor_item(T0*C,T0* a1);
T6 X514cursor_after(T0*C,T0* a1);
void X514cursor_forth(T0*C,T0* a1);
void X514cursor_start(T0*C,T0* a1);
T0* X7out(T0*C);
void X7copy(T0*C,T0* a1);
T0* X7substring(T0*C,T2 a1,T2 a2);
void X7wipe_out(T0*C);
T3 X7last(T0*C);
T2 X7first_substring_index(T0*C,T0* a1);
T2 X7item_code(T0*C,T2 a1);
void X7put(T0*C,T3 a1,T2 a2);
T6 X7is_equal(T0*C,T0* a1);
T3 X7item(T0*C,T2 a1);
void X7append(T0*C,T0* a1);
T2 X7index_of(T0*C,T3 a1,T2 a2);
void X7set_count(T0*C,T2 a1);
T6 X7same_type(T0*C,T0* a1);
void X7remove_tail(T0*C,T2 a1);
void X7append_string(T0*C,T0* a1);
void X7remove(T0*C,T2 a1);
T0* X7string(T0*C);
void X7extend(T0*C,T3 a1);
T2 X7hash_code(T0*C);
T6 X7has(T0*C,T3 a1);
T2 X7to_integer(T0*C);
void X7append_character(T0*C,T3 a1);
void X7extend_unless(T0*C,T3 a1);
T6 X7same_as(T0*C,T0* a1);
void X7add_last(T0*C,T3 a1);
T3 X7first(T0*C);
void X7resize(T0*C,T2 a1);
T2 X7substring_index(T0*C,T0* a1,T2 a2);
void X7from_external_copy(T0*C,T8 a1);
void X7replace_substring(T0*C,T0* a1,T2 a2,T2 a3);
T8 X7to_external(T0*C);
void X7to_lower(T0*C);
T0* X7twin(T0*C);
T0* X7_ix_43(T0*C,T0* a1);
void X7swap(T0*C,T2 a1,T2 a2);
T0* X546cursor_item(T0*C,T0* a1);
T6 X546cursor_after(T0*C,T0* a1);
void X546cursor_forth(T0*C,T0* a1);
void X546cursor_start(T0*C,T0* a1);
void X689put_right(T0*C,T0* a1);
void X138set_callbacks(T0*C,T0* a1);
T0* X138position(T0*C);
void X138parse_from_stream(T0*C,T0* a1);
T0* X529last(T0*C);
T0* X529cursor_item(T0*C,T0* a1);
T0* X529item(T0*C,T2 a1);
T6 X529cursor_after(T0*C,T0* a1);
void X529cursor_forth(T0*C,T0* a1);
void X529cursor_start(T0*C,T0* a1);
void X529force_last(T0*C,T0* a1);
T0* X529new_cursor(T0*C);
T0* X13twin(T0*C);
void X540process(T0*C,T0* a1);
void X175apply_input_buffer(T0*C);
T6 X15se_assigned_from(T0*C,T0* a1);
void X15print_on(T0*C,T0* a1);
T6 X15conforms_to(T0*C,T0* a1);
T6 X56is_closable(T0*C);
T0* X56name(T0*C);
T2 X56read_to_string(T0*C,T0* a1,T2 a2,T2 a3);
void X56read_character(T0*C);
void X56close(T0*C);
T2 X56read_to_buffer(T0*C,T0* a1,T2 a2,T2 a3);
T6 X56end_of_input(T0*C);
T3 X56last_character(T0*C);
void X56read_string(T0*C,T2 a1);
T0* X56last_string(T0*C);
void X539process(T0*C,T0* a1);
void X539equality_delete(T0*C,T0* a1);
T0* X539new_cursor(T0*C);
void X245fill(T0*C);
T0* X245name(T0*C);
void X41process_comment(T0*C,T0* a1);
void X41process_processing_instruction(T0*C,T0* a1);
void X41process_document(T0*C,T0* a1);
void X41process_element(T0*C,T0* a1);
void X41process_attribute(T0*C,T0* a1);
void X41process_character_data(T0*C,T0* a1);
void X628set(T0*C,T0* a1,T6 a2,T6 a3);
void X628set_next_cursor(T0*C,T0* a1);
T6 X628after(T0*C);
T6 X628before(T0*C);
void X136on_start_tag_finish(T0*C);
void X136on_finish(T0*C);
void X136on_content(T0*C,T0* a1);
void X136on_start(T0*C);
void X136on_processing_instruction(T0*C,T0* a1,T0* a2);
void X136on_start_tag(T0*C,T0* a1,T0* a2,T0* a3);
void X136on_comment(T0*C,T0* a1);
void X136on_end_tag(T0*C,T0* a1,T0* a2,T0* a3);
void X136on_attribute(T0*C,T0* a1,T0* a2,T0* a3,T0* a4);
void X136on_error(T0*C,T0* a1);
void X136on_xml_declaration(T0*C,T0* a1,T0* a2,T6 a3);
T2 X231count(T0*C);
T2 X231item(T0*C,T2 a1);
T6 X306labeled(T0*C,T2 a1);
void X306record(T0*C,T0* a1);
T0* X530item(T0*C);
T6 X530after(T0*C);
void X530forth(T0*C);
void X530start(T0*C);
T6 X777cursor_is_last(T0*C,T0* a1);
void X777cursor_go_after(T0*C,T0* a1);
void X777cursor_forth(T0*C,T0* a1);
void X777cursor_start(T0*C,T0* a1);
T6 X777cursor_is_first(T0*C,T0* a1);
void X777remove_at_cursor(T0*C,T0* a1);
void X631cursor_forth(T0*C,T0* a1);
void X631cursor_start(T0*C,T0* a1);
T0* X425default_message(T0*C);
void X176read_token(T0*C);
void X176close_input(T0*C);
void X176reset(T0*C);
void X176set_input_stream(T0*C,T0* a1);
T0* T2toT555(T2 source);
T0* T6toT557(T6 source);

#ifdef __cplusplus
}
#endif
