/*
#ident	"@(#)smail/src:RELEASE-3_2_0_108:smtplib.h,v 1.10 1999/09/16 20:02:24 woods Exp"
 */

/*
 *    Copyright (C) 1987, 1988 by Ronald S. Karr and Landon Curt Noll
 *    Copyright (C) 1992  Ronald S. Karr
 *
 * See the file COPYING, distributed with smail, for restriction
 * and warranty information.
 */

/*
 * smtplib.h:
 *	interface file for routines in smtplib.c.
 */

/* values returned by functions in smtplib.c */
#define SMTP_SUCCEED	0
#define SMTP_FAIL	(-1)
#define SMTP_AGAIN	(-2)
#define SMTP_EHLO_FAIL	(-3)

/*
 * NOTE: #define sucks for bit-flags, enum is only slightly better and still
 * requires that we be able to count in binary and understand binary logic
 * idioms.  Bit-fields are the best way to represent flags (except for when you
 * want to mass-assign them all to one value! :-).
 */
typedef struct esmtpflags {
    unsigned int ESMTP_basic		: 1; /* got EHLO 250 reply */
    unsigned int ESMTP_8bitmime		: 1; /* rfc1652 */
    unsigned int ESMTP_atrn		: 1; /* rfc2645 */
    unsigned int ESMTP_auth		: 1; /* rfc2645 */
    unsigned int ESMTP_chunking		: 1; /* rfc1830 */
    unsigned int ESMTP_dsn		: 1; /* rfc1891 */
    unsigned int ESMTP_enhancedstatuscodes : 1;	/* rfc2034 */
    unsigned int ESMTP_etrn		: 1; /* rfc1985 */
    unsigned int ESMTP_expn		: 1; /* rfc821+rfc1869 */
    unsigned int ESMTP_help		: 1; /* rfc821+rfc1869 */
    unsigned int ESMTP_onex		: 1; /* One message transaction only [Eric Allman] */
    unsigned int ESMTP_pipelining	: 1; /* rfc2197 */
    unsigned int ESMTP_saml		: 1; /* rfc821+rfc1869 */
    unsigned int ESMTP_send		: 1; /* rfc821+rfc1869 */
    unsigned int ESMTP_size		: 1; /* rfc1870 */
    unsigned int ESMTP_soml		: 1; /* rfc821+rfc1869 */
    unsigned int ESMTP_starttls		: 1; /* rfc2487 */
    unsigned int ESMTP_turn		: 1; /* rfc821+rfc1869 */
    unsigned int ESMTP_verb		: 1; /* Verbose [Eric Allman] */
    unsigned int ESMTP_x		: 1; /* unspported, non-standard, unregistered */
} esmtpf_t;

/*
 * the following structure is passed around between SMTP functions and
 * should be initialized as necessary to describe the SMTP connection
 * characteristics.
 *
 * NOTE:  If "in" is set to NULL, then we will be producing batch SMTP.
 */
struct smtp {
    FILE *in;				/* input channel from remote server */
    FILE *out;				/* output channel to remote server */
    unsigned short_timeout;		/* timeout period for short commands */
    unsigned long_timeout;		/* normal SMTP read timeout period */
    char *nl;				/* line terminator string */
    struct transport *tp;		/* associated transport */
    esmtpf_t esmtp_flags;		/* ESMTP extensions supported by remote */
    unsigned long max_size;		/* message size limit of remote */
};

/* functions defined in smtplib.c */
extern int smtp_startup();
extern int smtp_send();
extern void smtp_shutdown();
