/* scorer functions
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/*
 * scorer.h
 * Guy Albertelli II 1997
 */
#ifndef _SCORER_H_
#define _SCORER_H_ 1

/* Tcl command functions */
int buildStudentList(ClientData, Tcl_Interp*, int, char**);
int freeStudentList(ClientData, Tcl_Interp*, int, char**);
int getAnswersFromSet(ClientData, Tcl_Interp *, int, char**);
int compareCapaID(ClientData, Tcl_Interp *, int, char**);
int scorer_get_entry(ClientData, Tcl_Interp *, int, char**);
int scorer_set_entry(ClientData, Tcl_Interp *, int, char**);

#define SCO_FATALERROR 1
#define SCO_NEW 2
#define SCO_EXIST 3

#define CAPA_METHOD 1
#define LENIENT_METHOD 2
#define STRICT 3

#define YES 1
#define NO 0

#ifndef NeXT
#define TRUE 1
#define FALSE 0
#endif

#define MAX_QUEST 50
#define MAX_ANSWER_LENGTH 23
#define CONFIG_LINE_LENGTH 250
#define MAX_LINE_LENGTH 2048
#define MAX_PID_MATCHES 100
#define MAX_NUM_FLAG 30
#define SCAN_INPUT_LENGTH 577

#define SCANTRON_ERROR 34
#define SCANTRON_OK 13

#define ONE_OUT_OF_8 'a'
#define GLE 'b'
#define TF 'c'
#define ASSIGNED 'd'
#define N_OUT_OF_M 'e'
#define SINGLE_DIGIT 'f'
#define STRING_MATCH 'g'

#define QUESTION_MENU 'y'
#define QUESTION_STOP 'z'

#define CHECK_PIN 1
#define ANON_MODE 3
#define CHECK_SPACES 4
#define SURVEY_MODE 5
#define SURVEY_HEADER 6
#define PAUSE_TIME 8
#define ID_FORMAT 9
#define MULTIPLE_MARKS 10
#define QUERY_ABOUT_PID 11
#define LOGGING 12

#define ANUMBER_FORMAT 1
#define SOC_SEC_FORMAT 2

#define E_OPENOUTPUT 1
#define E_OPENOUTPUTRETURN 2
#define E_MODIFYFLAG 3
#define E_GETYESNO 4
#define E_PRINTQUESTIONS 5
#define E_OPENSERIAL 6
#define E_INITSCANTRON 7
#define E_BADFORM 8
#define E_UNKNOWSCANTRON 9
#define E_BUILDPIDPIN 10
#define E_GETFORM 11
#define E_CHECKFORM 12
#define E_HANDLESAVEFORM 13
#define E_INTREPRETFORM 14
#define E_CAPA_GET_STUDENT 15
#define E_PARSER 16
#define E_UNKNOWN_QTYPE 17
#define E_PARSER_DIFFERENT 18
#define E_INVALIDIDFORMAT 19
#define E_SINGLEDIGIT 20
#define E_GARBAGEPIDDATA 21
#define E_LOGERROR 22
#define E_GRADINGMETHOD 23

#define GF_SPACES 1
#define GF_MULTIPLEMARKS 2
#define GF_EOF 4
#define GF_PINWRONG 8

#define CF_STID 2
#define CF_CLASSL 3
#define CF_PIN 4
#define CF_NOERROR 5

#define LOG_NOPINFOUND 1
#define LOG_PINWRONG 2
#define LOG_STUDENTNOTEXIST 3
#define LOG_PINNOTMATCH 4
#define LOG_BADPID 5
#define LOG_BADPIN 6
#define LOG_SPACES 7
#define LOG_MULTIPLEMARKS 8

extern char NUMBER[10];
extern char LETTER[10];

typedef struct
{
  char answerPID[10];
  char questionPID[10];
  char PIN[7];
  int classlPIN;
  char Answers[MAX_QUEST][MAX_ANSWER_LENGTH];
  char Name[17];
  char serialNumber[7];
  char origString[577];
  int error;
} Student;

typedef struct
{
  char type;
  int points;
  int leafs;
} Question;

typedef struct
{
  char Class[10];
  int SetId;
  int NumQuestions;
  int NumOfStudents;
  int CheckPIN;
  int AnonMode;
  int CheckSpaces;
  int CheckMultipleMarks;
  int SurveyMode;
  int SurveyHeader;
  int Pause;
  float PauseTime;
  int IdFormat;
  int QueryAboutPID;
  int log;
  FILE* logFile;
  int linesRead;
  int loggedErrors;
} Flags;

typedef struct
{
  int writefd;
  int readfd;
} SerialLines;

typedef struct
{
  char PID[MAX_STUDENT_NUMBER];
  int PIN;
  char *capaid_plus;
} PIDPIN;

typedef struct PIDPINlist 
{
  char *PID;/*FIXME*/
  int PIN;  /*FIXME*/
  char* classname;
  long num;
  PIDPIN* classList;
  int numStudents;
  struct PIDPINlist *next;
} PIDPINlist;
#endif /*_SCORER_H_*/
