/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "SessionService.h"
#include <sstream>
#include <fstream>
#include <time.h>
#include <stdio.h>
#include <vector>
#include <iostream>
#include <cstdlib>
#include "JSONParser.h"
#include "ConfigCentral.h"
void mkdirer(std::string path);
std::vector<std::string> tokenize(std::string line);

void saveSession(std::string login,std::string session,std::string time){
    mkdirer(ConfigCentral::getGamePath());
    std::ifstream ifs ((ConfigCentral::getGamePath()+"/session.csv").c_str(), std::ifstream::in);
    
    //search for existing login
    for( std::string line; std::getline( ifs, line ); )
    {
      std::vector<std::string> list=tokenize( line);
      if (list[0]==login)
      {
	ifs.close();
	throw new std::string("Login existing in the session :"+login);
      }
       if (list[1]==session)
      {
	ifs.close();
	throw new std::string("Session existing in the session :"+session);
      }
    }
    ifs.close();
    
    std::ofstream ofs ((ConfigCentral::getGamePath()+"/session.csv").c_str(),std::ofstream::in | std::ofstream::out | std::ofstream::app);
    ofs <<login<<";"<<session<<";"<<time<<std::endl;
    ofs.close();
}

std::string SessionService::create(std::string username){
  
  time_t seed1 = time(NULL);
  std::srand(seed1);
  int random_variable = std::rand();
  std::stringstream seeStr;
  std::stringstream session;
  seeStr<<seed1;
  session <<seed1<<"L"<<random_variable;
  saveSession(username,session.str(),seeStr.str());
  return session.str();
}

std::string SessionService::createFromJson(std::string json){
   std::istringstream  ssJson(json);
  json_parser::Parser parser(&ssJson);
  try{
    json_parser::Value *val = parser.jValue();
    
    json_parser::Object* my_object = dynamic_cast<json_parser::Object*>(val);
    if (my_object==NULL)
      return "no session created due to error";
    json_parser::Value *login=getValue(my_object,"login");
    return create(login->cleanStr());
    
  } catch (json_parser::ParseError e) {
    std::cerr << "Oops, the json you gave me does not contain JSON data:" << std::endl;
    std::cerr << e.what() << std::endl;
    return "no session created due to error";
  }
}

std::string SessionService::retrieveUser(std::string login){
  mkdirer(ConfigCentral::getGamePath());
  std::ifstream ifs ((ConfigCentral::getGamePath()+"/session.csv").c_str(), std::ifstream::in);
    
    //search for existing login
    for( std::string line; std::getline( ifs, line ); )
    {
      std::vector<std::string> list=tokenize( line);
      if (list[0]==login)
      {
	ifs.close();
	return list[1];
      }
    }
    ifs.close();
    return "";
}

std::string SessionService::retrieveUserFromSession(std::string session){
  mkdirer(ConfigCentral::getGamePath());
  std::ifstream ifs ((ConfigCentral::getGamePath()+"/session.csv").c_str(), std::ifstream::in);
    
    //search for existing login
    for( std::string line; std::getline( ifs, line ); )
    {
      std::vector<std::string> list=tokenize( line);
      if (list[1]==session)
      {
	ifs.close();
	return list[0];
      }
    }
    ifs.close();
    return "";
}
void SessionService::refresh(std::string session ){
    mkdirer(ConfigCentral::getGamePath());
    std::ofstream ofs ((ConfigCentral::getGamePath()+"/session2.csv").c_str(),std::ofstream::in | std::ofstream::out | std::ofstream::app);
    
    std::ifstream ifs ((ConfigCentral::getGamePath()+"/session.csv").c_str(), std::ifstream::in);
    time_t seed1 = time(NULL);
    //search for existing login
    for( std::string line; std::getline( ifs, line ); )
    {
      std::vector<std::string> list=tokenize( line);
      if (list[1]==session)
      {
	ofs <<list[0]<<";"<<list[1]<<";"<<seed1<<std::endl;
	
	
      }
    }
    ofs.close();
    ifs.close();
      
    std::remove( (ConfigCentral::getGamePath()+"/session.csv").c_str() );
    std::rename( (ConfigCentral::getGamePath()+"/session2.csv").c_str(), (ConfigCentral::getGamePath()+"/session.csv").c_str() ); 

}

bool SessionService::validate(std::string session){
  mkdirer(ConfigCentral::getGamePath());
  std::ifstream ifs ((ConfigCentral::getGamePath()+"/session.csv").c_str(), std::ifstream::in);
    time_t seed1 = time(NULL);
    //search for existing login
    for( std::string line; std::getline( ifs, line ); )
    {
      std::vector<std::string> list=tokenize( line);
      if (list[1]==session)
      {
	//TODO unvalidate on hold session
	return true;
	
      }
    }
    
    ifs.close();
    return false;
}

std::string SessionService::unvalidateFromJson(std::string msg){
  std::istringstream  ssJson(msg);
  json_parser::Parser parser(&ssJson);
  try{
    json_parser::Value *val = parser.jValue();
    
    json_parser::Object* my_object = dynamic_cast<json_parser::Object*>(val);
    if (my_object==NULL)
      return "no session retrieved";
    json_parser::Value *login=getValue(my_object,"login");
    unvalidate(retrieveUser(login->cleanStr()));
    
  } catch (json_parser::ParseError e) {
    std::cerr << "Oops, the json you gave me does not contain JSON data:" << std::endl;
    std::cerr << e.what() << std::endl;
    return "no session retrieved";
  }
  return "user session removed";
}
void SessionService::unvalidate(std::string session){
    std::ofstream ofs ((ConfigCentral::getGamePath()+"/session2.csv").c_str(),std::ofstream::in | std::ofstream::out | std::ofstream::app);
    
    std::ifstream ifs ((ConfigCentral::getGamePath()+"/session.csv").c_str(), std::ifstream::in);
    
    //search for existing login
    for( std::string line; std::getline( ifs, line ); )
    {
      std::vector<std::string> list=tokenize( line);
      if (list[1]!=session)
	ofs <<line<<std::endl;
    }
    ofs.close();
    ifs.close();
    std::remove( (ConfigCentral::getGamePath()+"/session.csv").c_str() );
    std::rename( (ConfigCentral::getGamePath()+"/session2.csv").c_str(), (ConfigCentral::getGamePath()+"/session.csv").c_str() ); 
}
