/* simi.h

   originally written by Frederic Bois

   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.simi.h
    Revision:  1.5
        Date:  13 Jan 1996
     Modtime:  15:55:39
      Author:  @a
   -- SCCS  ---------

   Header file for simi.c
*/

#ifndef _SIMI_H_
#define _SIMI_H_

/* ----------------------------------------------------------------------------
   Inclusions
*/

#include "sim.h"
#include "strutil.h"


/* ----------------------------------------------------------------------------
   Prototypes
*/

BOOL CheckDistribParam(PLIST list, HVAR hvar1, HVAR hvar2);
void DListToArray (PLIST plist, PINT pcDouble, PDOUBLE *ppDouble);
BOOL EndExperiment (PINPUTBUF pibIn, PANALYSIS panal);
BOOL GetData (PINPUTBUF pibIn, PSTR szLex, POUTSPEC pos);
BOOL GetGibbsSpec (PINPUTBUF pibIn, PEXPERIMENT pexp);
BOOL GetIntegrate (PINPUTBUF pibIn, PINTSPEC pis);
PSTR GetKeyword (int iKWCode);
int  GetKeywordCode (PSTR szKeyword, PINT pfContext);
BOOL GetListOfData (PINPUTBUF pibIn, PDATAREC pda, PSTR szLex);
BOOL GetListOfTimes (PINPUTBUF pibIn, PPRINTREC ppr, PSTR szLex);
int GetMCVaryParam(PINPUTBUF pibIn, PSTR szLex, PLIST list, int n,
                   PMCVAR pmcvar);
int  GetMCVarySpec (PINPUTBUF pibIn, PANALYSIS panal, PSTR szLex);
int  GetMonteCarloSpec (PINPUTBUF pibIn, PANALYSIS panal, PSTR szLex);
BOOL GetOutputFile (PINPUTBUF pibIn, PSTR szLex, POUTSPEC pos);
BOOL GetParmMod (PINPUTBUF pibIn, PSTRLEX szLex, PSTREQN szeqn);
BOOL GetPrint (PINPUTBUF pibIn, PSTR szLex, POUTSPEC pos);
BOOL GetPrintStep (PINPUTBUF pibIn, PSTR szLex, POUTSPEC pos);
int  GetSetPointsSpec (PINPUTBUF pibIn, PANALYSIS  panal, PSTR szLex);
BOOL GetSimType (PINPUTBUF pibIn);
BOOL GetSimulate (PINPUTBUF pibIn, PEXPERIMENT pexp);
BOOL GetStringArg (PINPUTBUF pibIn, PSTR *pszArg, PSTR szLex, BOOL bDelim);
int  GetTerminator (PINPUTBUF pibIn, PSTR szLex);
long ImFromLex (PSTR szLex);
int  McvFromLex (PSTR szLex);
void NewExperiment (PANALYSIS panal);
int  OneDToArray (PVOID pData, PVOID pInfo);
void ProcessWord (PINPUTBUF pibIn, PSTR szLex, PSTR szEqn);
BOOL ReadAnalysis (PINPUTBUF);
BOOL YesNoFromLex (PSTR szLex);

#endif /* _SIMI_H_ */

/* End */

