/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.ByteVector;
import gnu.lists.Convert;
import gnu.lists.Sequence;
import java.io.UnsupportedEncodingException;

public class U8Vector
extends ByteVector {
    public U8Vector() {
        this.data = ByteVector.empty;
    }

    public U8Vector(int size, byte value) {
        byte[] array = new byte[size];
        this.data = array;
        this.size = size;
        while (--size >= 0) {
            array[size] = value;
        }
    }

    public U8Vector(int size) {
        this.data = new byte[size];
        this.size = size;
    }

    public U8Vector(byte[] data) {
        this.data = data;
        this.size = data.length;
    }

    public U8Vector(Sequence seq) {
        this.data = new byte[seq.size()];
        this.addAll(seq);
    }

    public U8Vector(U8Vector seq) {
        this.size = seq.size;
        this.data = new byte[this.size];
        System.arraycopy(seq.data, 0, this.data, 0, this.size);
    }

    public U8Vector(U8Vector seq, int offset, int length) {
        this.size = length;
        this.data = new byte[length];
        if (offset + length > seq.size) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(seq.data, offset, this.data, 0, length);
    }

    public U8Vector(byte[] buffer, int offset, int length) {
        this.size = length;
        this.data = new byte[length];
        System.arraycopy(buffer, offset, this.data, 0, length);
    }

    public final int intAtBuffer(int index) {
        return this.data[index] & 0xFF;
    }

    public final Object get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObjectUnsigned(this.data[index]);
    }

    public final Object getBuffer(int index) {
        return Convert.toObjectUnsigned(this.data[index]);
    }

    public Object setBuffer(int index, Object value) {
        byte old = this.data[index];
        this.data[index] = Convert.toByteUnsigned(value);
        return Convert.toObjectUnsigned(old);
    }

    public int getElementKind() {
        return 17;
    }

    public String getTag() {
        return "u8";
    }

    public int compareTo(Object obj) {
        return U8Vector.compareToInt(this, (U8Vector)obj);
    }

    public String toUtf8(int start, int length) {
        if (start + length > this.size) {
            throw new IndexOutOfBoundsException();
        }
        try {
            return new String(this.data, start, length, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

