
(defun eval-phi (r)
  (* r r))

(defun d-by-dr (function r dr)
  (/ (- (funcall function (+ r dr))
        (funcall function (+ r)))
     dr))

(defun eval-grad-phi (r)
  (d-by-dr 'eval-phi r dr))

(defun r-to-hashes (r)
  (make-string (max 0 (+ 40 (floor (* r 10)))) ?#))

(progn
  (setq dr 0.1)
  (setq dt 0.1)
  (setq r 5)
  (setq m 1)
  (setq rdot 0)
  (setq i 0)
  (while (< i 1000)
    (setq rdotdot (/ (- (eval-grad-phi r)) m))
    (setq rdot    (+ rdot (* dt rdotdot)))
    (setq r       (+ r (* dt rdot)))
    (message (r-to-hashes r))
    (sit-for 0.1)
    (incf i)))

(message "done")
