// GUICons.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#define GUICONS_FILE
#include "GUICons.h"

#include "MainFrm.h"
#include "GUIConsDoc.h"
#include "GUIConsView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// CGUIConsApp

BEGIN_MESSAGE_MAP(CGUIConsApp, CWinApp)
	//{{AFX_MSG_MAP(CGUIConsApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGUIConsApp construction

BOOL threadExited = FALSE;
int	 exitCode = 0;
extern "C" int main(int argc,char *argv[]);
extern "C" char **M_Cmd_Line_To_Argv(char *cmd,int *argc);
extern "C" void W32GC_Set_Title(char *s);


/*-------------------------------------------------------------------------*/
/* THREAD                                                                  */
/*                                                                         */
/*-------------------------------------------------------------------------*/
UINT ThreadProc( LPVOID pParam )
{
    int    argc;
	char **argv;
#ifdef GUICONSPRJ
    argc=0;
    argv=NULL;
#else
	argv=M_Cmd_Line_To_Argv(GetCommandLine(),&argc);
#endif
	WaitForSingleObject(thread_event,INFINITE);
	exitCode =main(argc,argv);
	threadExited = TRUE;
	theApp.m_pMainWnd->PostMessage(WM_CLOSE);
	
	return 0;   // thread completed successfully
}


CGUIConsApp::CGUIConsApp()
{
	kbd_event = CreateEvent(NULL,TRUE,FALSE,NULL);
	thread_event = CreateEvent(NULL,TRUE,FALSE,NULL);
	theThread = AfxBeginThread(ThreadProc, NULL);

}

CGUIConsApp::~CGUIConsApp()
{
	if (!threadExited)
	//	TerminateThread(theThread->m_hThread,0);
    	 delete theThread;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CGUIConsApp object


/////////////////////////////////////////////////////////////////////////////
// CGUIConsApp initialization

extern "C" void W32GC_Fatal_Error(char *s);

BOOL CGUIConsApp::InitInstance()
{
	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
//	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CGUIConsDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CGUIConsView));
	pDocTemplate->SetContainerInfo(IDR_CNTR_INPLACE);
	AddDocTemplate(pDocTemplate);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it.
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();

	::W32GC_Set_Title("GNU-Prolog for Windows");

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CGUIConsApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CGUIConsApp message handlers

int CGUIConsApp::ExitInstance()
{
	return exitCode;
}
