/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.IzPanelConstraints;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.panels.PathSelectionPanel;
import com.izforge.izpack.util.Log;
import com.izforge.izpack.util.MultiLineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class IzPanelLayout
implements LayoutManager,
LayoutManager2,
LayoutConstants {
    private ArrayList<ArrayList<IzPanelConstraints>> components = new ArrayList();
    private int currentYPos = 0;
    private int currentXPos = -1;
    private Dimension prefLayoutDim;
    private Dimension oldParentSize;
    private Insets oldParentInsets;
    private int columnFillOutRule;
    private double[] overallYStretch = new double[]{-1.0, 0.0};
    protected static int[] DEFAULT_Y_GAPS = new int[]{-1, 0, 5, 5, 10, 5, 5, 5, 5, 5, 5, 5, 5, 5, 15, 12, 9, 6, 3, 0};
    protected static int[] DEFAULT_X_GAPS = new int[]{-1, 0, 0, 0, 0, 0, 10, 10, 10, 10, 10, 10, 10, 15, 12, 9, 6, 3, 0};
    protected static int[] DEFAULT_X_ALIGNMENT = new int[]{2, 2, 2, 2};
    protected static int[] DEFAULT_Y_ALIGNMENT = new int[]{0, 0, 0, 0};
    private static IzPanelConstraints[] DEFAULT_CONSTRAINTS = new IzPanelConstraints[]{new IzPanelConstraints(-1, -1, -1, -2, 1, 1, -19, -19, 0.0, 0.0), new IzPanelConstraints(-2, -2, -1, -2, 1, 1, -19, -19, 0.0, 0.0), new IzPanelConstraints(-3, -3, -1, -2, 1, 1, -19, -19, 0.0, 0.0), new IzPanelConstraints(-1, -1, 0, -1, 127, 127, -19, -19, -1.0, 0.0), new IzPanelConstraints(-1, -1, 0, -1, 127, 127, -19, -19, -1.0, -2.0), new IzPanelConstraints(-1, -1, -1, -2, 1, 1, 0, 0, 0.0, 0.0), new IzPanelConstraints(-1, -1, 0, -1, 1, 1, 0, 0, 0.0, 0.0), new IzPanelConstraints(-3, -3, 0, -1, 127, 127, -19, -19, -1.0, 0.0)};
    private static int ANCHOR = 0;
    private static int X_STRETCH_TYPE = 1;
    private static int Y_STRETCH_TYPE = 1;
    private static double FULL_LINE_STRETCH_DEFAULT = 1.0;
    private static double FULL_COLUMN_STRETCH_DEFAULT = 1.0;
    private static int DEFAULT_TEXTFIELD_LENGTH = 12;
    private static final int[][] GAP_INTERMEDIAER_LOOKUP = new int[][]{{-1, -5, -6, -1, -6, -1, -1}, {-7, -2, -10, -7, -10, -2, -2}, {-8, -9, -3, -8, -3, -3, -3}, {-1, -5, -6, -1, -6, -1, -1}, {-8, -9, -3, -8, -3, -3, -3}, {-13, -13, -13, -13, -13, -13, -13, -13}, {-13, -13, -13, -13, -13, -13, -13, -13}, {-13, -13, -13, -13, -13, -13, -13, -13}};

    public IzPanelLayout() {
        this(0);
    }

    public IzPanelLayout(int n) {
        this.columnFillOutRule = n;
    }

    private static int getYGap(IzPanelConstraints izPanelConstraints, IzPanelConstraints izPanelConstraints2) {
        Class<FillerComponent> clazz = izPanelConstraints2 != null ? izPanelConstraints2.component.getClass() : FillerComponent.class;
        int n = GAP_INTERMEDIAER_LOOKUP[IzPanelLayout.getIntermediarId(izPanelConstraints.component.getClass(), null)][IzPanelLayout.getIntermediarId(clazz, null)];
        if (n < 0) {
            n = -n;
        }
        return DEFAULT_Y_GAPS[n];
    }

    private static int getXGap(IzPanelConstraints izPanelConstraints, IzPanelConstraints izPanelConstraints2) {
        Class<FillerComponent> clazz = izPanelConstraints2 != null ? izPanelConstraints2.component.getClass() : FillerComponent.class;
        int n = GAP_INTERMEDIAER_LOOKUP[IzPanelLayout.getIntermediarId(izPanelConstraints.component.getClass(), null)][IzPanelLayout.getIntermediarId(clazz, null)];
        if (n < 0) {
            n = -n;
        }
        return DEFAULT_X_GAPS[n];
    }

    private static int getIntermediarId(Class clazz, Component component) {
        if (component != null) {
            if (MultiLineLabel.class.isAssignableFrom(clazz) || LabelFactory.FullLineLabel.class.isAssignableFrom(clazz)) {
                return 3;
            }
            if (PathSelectionPanel.class.isAssignableFrom(clazz) || JCheckBox.class.isAssignableFrom(clazz) || JRadioButton.class.isAssignableFrom(clazz)) {
                return 7;
            }
            if (FillerComponent.class.isAssignableFrom(clazz) || Box.Filler.class.isAssignableFrom(clazz)) {
                Dimension dimension = component.getPreferredSize();
                if (dimension.height >= Short.MAX_VALUE || dimension.height <= 0) {
                    dimension.height = 0;
                    component.setSize(dimension);
                    return 5;
                }
                if (dimension.width >= Short.MAX_VALUE || dimension.width <= 0) {
                    dimension.width = 0;
                    component.setSize(dimension);
                    return 6;
                }
            }
        }
        if (JScrollPane.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (JLabel.class.isAssignableFrom(clazz)) {
            return 0;
        }
        if (JTextComponent.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (FillerComponent.class.isAssignableFrom(clazz)) {
            return 5;
        }
        if (Box.Filler.class.isAssignableFrom(clazz)) {
            return 5;
        }
        return 2;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.determineSize();
    }

    private Dimension determineSize() {
        if (this.prefLayoutDim == null) {
            int n = this.minimumAllColumnsWidth();
            int n2 = this.minimumOverallHeight();
            this.prefLayoutDim = new Dimension(n, n2);
        }
        return (Dimension)this.prefLayoutDim.clone();
    }

    private int rows() {
        int n = 0;
        for (ArrayList<IzPanelConstraints> arrayList : this.components) {
            int n2 = arrayList.size();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private int columns() {
        return this.components.size();
    }

    private int minimumOverallHeight() {
        int n = 0;
        for (int i = 0; i < this.rows(); ++i) {
            n += this.rowHeight(i);
        }
        return n;
    }

    private int rowHeight(int n) {
        int n2 = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            int n3 = this.getCellSize((int)i, (int)n, null).height;
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private int rowHeight(int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        double[] dArray = this.getOverallYStretch();
        if (dArray[0] <= 0.0) {
            return this.rowHeight(n);
        }
        double d = 0.0;
        double[] dArray2 = new double[this.components.size()];
        for (n4 = 0; n4 < this.components.size(); ++n4) {
            int n6;
            double d2;
            IzPanelConstraints izPanelConstraints = this.getConstraints(n4, n);
            dArray2[n4] = d2 = izPanelConstraints.getYStretch();
            if (d2 > d) {
                d = d2;
            }
            if ((n6 = this.getCellSize((int)n4, (int)n, (IzPanelConstraints)izPanelConstraints).height) <= n5) continue;
            n5 = n6;
        }
        if (n3 <= n2) {
            return n5;
        }
        n4 = (int)((double)n3 - dArray[1] - (double)n2);
        int n7 = (int)((double)n4 * d);
        if (n7 > 0) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (dArray2[i] < 1.0E-8) continue;
                IzPanelConstraints izPanelConstraints = this.getConstraints(i, n);
                Dimension dimension = izPanelConstraints.component.getPreferredSize();
                dimension.height = (double)dimension.height + (double)n7 * dArray2[i] < (double)n5 ? (int)((double)n5 + (double)n7 * dArray2[i]) : n5 + n7;
                if (izPanelConstraints.component instanceof JScrollPane && ((JScrollPane)izPanelConstraints.component).getViewport().getView() instanceof JTextArea && ((JTextArea)((JScrollPane)izPanelConstraints.component).getViewport().getView()).getLineWrap()) {
                    dimension.width = 1000;
                }
                izPanelConstraints.component.setPreferredSize(dimension);
            }
            n5 += n7;
        }
        return n5;
    }

    private double[] getOverallYStretch() {
        if (this.overallYStretch[0] >= 0.0) {
            return this.overallYStretch;
        }
        this.overallYStretch[0] = 0.0;
        for (int i = 0; i < this.rows(); ++i) {
            double d = 0.0;
            double d2 = 0.0;
            for (int j = 0; j < this.components.size(); ++j) {
                double d3;
                double d4;
                IzPanelConstraints izPanelConstraints = this.getConstraints(j, i);
                this.resolveDefaultSettings(j, i);
                if (izPanelConstraints.getYStretch() == -2.0) {
                    izPanelConstraints.setYStretch(IzPanelLayout.getFullColumnStretch());
                }
                if ((d4 = izPanelConstraints.getYStretch()) > d) {
                    d = d4;
                }
                if (!((d3 = (double)izPanelConstraints.getYGap()) > d2)) continue;
                d2 = d3;
            }
            this.overallYStretch[0] = this.overallYStretch[0] + d;
            this.overallYStretch[1] = this.overallYStretch[1] + d2;
        }
        if (this.overallYStretch[0] > 0.0) {
            switch (IzPanelLayout.getYStretchType()) {
                case 1: {
                    break;
                }
                case 2: {
                    this.overallYStretch[0] = 1.0;
                    break;
                }
                default: {
                    this.overallYStretch[0] = 0.0;
                }
            }
        }
        return this.overallYStretch;
    }

    private Dimension getCellSize(int n, int n2, IzPanelConstraints izPanelConstraints) {
        Dimension dimension = new Dimension();
        try {
            if (izPanelConstraints == null) {
                izPanelConstraints = this.getConstraints(n, n2);
            }
            if (izPanelConstraints != null) {
                Component component = izPanelConstraints.component;
                Dimension dimension2 = component.getPreferredSize();
                Dimension dimension3 = component.getMinimumSize();
                dimension.height = dimension2.height > dimension3.height ? dimension2.height : dimension3.height;
                int n3 = dimension.width = dimension2.width > dimension3.width ? dimension2.width : dimension3.width;
                if (component instanceof JScrollPane) {
                    dimension.height = dimension3.height;
                    dimension.width = dimension3.width;
                }
                if (this.needsReEvaluation(component)) {
                    dimension.width = 0;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return dimension;
    }

    private int minimumColumnWidth(int n) {
        int n2;
        int n3 = 0;
        Dimension[] dimensionArray = new Dimension[this.rows()];
        for (n2 = 0; n2 < this.rows(); ++n2) {
            IzPanelConstraints izPanelConstraints = this.getConstraints(n, n2);
            dimensionArray[n2] = this.getCellSize(n, n2, izPanelConstraints);
            if (izPanelConstraints.getXWeight() > 1 || n3 >= dimensionArray[n2].width) continue;
            n3 = dimensionArray[n2].width;
        }
        if (n3 == 0) {
            for (n2 = 0; n2 < this.rows(); ++n2) {
                if (n3 >= dimensionArray[n2].width) continue;
                n3 = dimensionArray[n2].width;
            }
        }
        return n3;
    }

    private int minimumAllColumnsWidth() {
        int n = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            n += this.minimumColumnWidth(i);
        }
        return n;
    }

    private IzPanelConstraints getConstraints(int n, int n2) {
        if (n >= this.columns() || n2 >= this.rows()) {
            return null;
        }
        Cloneable cloneable = this.components.get(n);
        if (cloneable != null && cloneable instanceof ArrayList) {
            try {
                cloneable = this.components.get(n).get(n2);
            }
            catch (Throwable throwable) {
                cloneable = null;
            }
            if (cloneable != null) {
                return (IzPanelConstraints)cloneable;
            }
            ArrayList<IzPanelConstraints> arrayList = this.components.get(n);
            for (int i = arrayList.size(); n2 >= i; ++i) {
                IzPanelConstraints izPanelConstraints = IzPanelLayout.getDefaultConstraint(5);
                izPanelConstraints.setXPos(n);
                izPanelConstraints.setYPos(i);
                izPanelConstraints.component = new FillerComponent();
                try {
                    this.components.get(n).add(n2, izPanelConstraints);
                    continue;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
            return this.getConstraints(n, n2);
        }
        return null;
    }

    private int getAdaptedXPos(int n, int n2, Dimension dimension, IzPanelConstraints izPanelConstraints) {
        int n3 = n;
        if ((this.columnFillOutRule & 1) > 0) {
            return n3;
        }
        switch (izPanelConstraints.getXCellAlignment()) {
            case 2: {
                break;
            }
            case 4: {
                n3 += n2 - dimension.width;
                break;
            }
            default: {
                n3 += (n2 - dimension.width) / 2;
            }
        }
        return n3;
    }

    private int getAdaptedYPos(int n, int n2, Dimension dimension, IzPanelConstraints izPanelConstraints) {
        int n3 = n;
        if ((this.columnFillOutRule & 2) > 0) {
            return n3;
        }
        int n4 = dimension.height;
        switch (izPanelConstraints.getYCellAlignment()) {
            case 1: {
                break;
            }
            case 3: {
                n3 += n2 - n4;
                break;
            }
            default: {
                n3 += (n2 - n4) / 2;
            }
        }
        if (n3 < n) {
            return n;
        }
        return n3;
    }

    private void resolveDefaultSettings(int n, int n2) {
        IzPanelConstraints izPanelConstraints = this.getConstraints(n, n2);
        IzPanelConstraints izPanelConstraints2 = this.getConstraints(n, n2 + 1);
        IzPanelConstraints izPanelConstraints3 = this.getConstraints(n + 1, n2);
        if (izPanelConstraints == null) {
            return;
        }
        int n3 = izPanelConstraints.getYGap();
        if (n3 == -19) {
            izPanelConstraints.setYGap(IzPanelLayout.getYGap(izPanelConstraints, izPanelConstraints2));
        } else if (n3 < 0) {
            izPanelConstraints.setYGap(DEFAULT_Y_GAPS[-n3]);
        }
        n3 = izPanelConstraints.getXGap();
        if (n3 == -19) {
            izPanelConstraints.setXGap(IzPanelLayout.getXGap(izPanelConstraints, izPanelConstraints3));
        } else if (n3 < 0) {
            izPanelConstraints.setXGap(DEFAULT_X_GAPS[-n3]);
        }
        if (izPanelConstraints.getXCellAlignment() < 0) {
            izPanelConstraints.setXCellAlignment(DEFAULT_X_ALIGNMENT[-izPanelConstraints.getXCellAlignment()]);
        }
        if (izPanelConstraints.getYCellAlignment() < 0) {
            izPanelConstraints.setYCellAlignment(DEFAULT_Y_ALIGNMENT[-izPanelConstraints.getYCellAlignment()]);
        }
    }

    public void layoutContainer(Container container) {
        if (!this.needNewLayout(container)) {
            this.fastLayoutContainer(container);
            return;
        }
        this.prefLayoutDim = null;
        this.preferredLayoutSize(container);
        Dimension dimension = container.getSize();
        Log.getInstance().addDebugMessage("IzPanelLayout.layoutContainer parent size: {0}", new String[]{container.getSize().toString()}, "LayoutTrace", null);
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{0, 0};
        int n3 = 0;
        int n4 = 0;
        Rectangle rectangle = new Rectangle();
        int n5 = this.minimumOverallHeight();
        int n6 = dimension.height - insets.top - insets.bottom;
        for (int i = 0; i < 2; i += this.resolveGenerellOffsets(nArray, dimension, insets, n3, n4)) {
            int n7 = insets.top;
            int n8 = 0;
            int n9 = 65535;
            int n10 = 65535;
            n3 = 0;
            n4 = 0;
            while (n8 < this.rows()) {
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = 0;
                int n17 = insets.left;
                int n18 = 0;
                IzPanelConstraints[] izPanelConstraintsArray = new IzPanelConstraints[this.columns()];
                int n19 = 0;
                while (n18 < this.columns()) {
                    int n20;
                    IzPanelConstraints izPanelConstraints;
                    if (n18 == 0) {
                        n = this.rowHeight(n8, n5, n6);
                    }
                    izPanelConstraintsArray[n18] = izPanelConstraints = this.getConstraints(n18, n8);
                    Component component = izPanelConstraints.component;
                    Dimension dimension2 = component.getPreferredSize();
                    n15 = this.minimumColumnWidth(n18);
                    ++n18;
                    if (izPanelConstraints.getXWeight() > 1) {
                        for (n14 = izPanelConstraints.getXWeight(); n14 > 1 && n18 < this.columns(); ++n18, --n14) {
                            izPanelConstraintsArray[n18] = this.getConstraints(n18, n8);
                            if (!(izPanelConstraintsArray[n18].component instanceof FillerComponent)) break;
                            n15 += this.minimumColumnWidth(n18);
                        }
                    }
                    n14 = this.getAdaptedXPos(n17, n15, dimension2, izPanelConstraints);
                    n13 = this.getAdaptedYPos(n7, n, dimension2, izPanelConstraints);
                    n12 = dimension2.width;
                    n11 = dimension2.height;
                    if ((this.columnFillOutRule & 1) > 0) {
                        n12 = n15;
                    }
                    if ((this.columnFillOutRule & 2) > 0) {
                        n11 = n;
                    }
                    if (n15 < n12) {
                        n12 = n15;
                    }
                    component.setBounds(n14 + nArray[0], n13 + nArray[1], n12, n11);
                    component.getBounds(rectangle);
                    if (rectangle.height > 100) {
                        rectangle.height = n11;
                    }
                    if (!(component instanceof FillerComponent)) {
                        if (rectangle.x < n9) {
                            n9 = rectangle.x;
                        }
                        if (rectangle.y < n10) {
                            n10 = rectangle.y;
                        }
                    }
                    if ((n20 = (int)rectangle.getMaxX()) - n9 > n3) {
                        n3 = n20 - n9;
                    }
                    n20 = (int)rectangle.getMaxY();
                    izPanelConstraints.setBounds(rectangle);
                    if (n20 - n10 > n4) {
                        n4 = n20 - n10;
                    }
                    n17 += n15 + izPanelConstraints.getXGap();
                    n19 += n15;
                    if (n16 >= n + izPanelConstraints.getYGap()) continue;
                    n16 = n + izPanelConstraints.getYGap();
                }
                double d = 0.0;
                for (n15 = 0; n15 < izPanelConstraintsArray.length; ++n15) {
                    if (izPanelConstraintsArray[n15].getXStretch() == -1.0) {
                        izPanelConstraintsArray[n15].setXStretch(IzPanelLayout.getFullLineStretch());
                    }
                    d += izPanelConstraintsArray[n15].getXStretch();
                }
                if (d > 0.0) {
                    switch (IzPanelLayout.getXStretchType()) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            d = 1.0;
                            break;
                        }
                        default: {
                            d = 0.0;
                        }
                    }
                }
                if (dimension.width - insets.right != n17 && d > 0.0) {
                    n14 = dimension.width - insets.right - n17;
                    n13 = 0;
                    n12 = n2;
                    for (n15 = 0; n15 < izPanelConstraintsArray.length; ++n15) {
                        int n21;
                        n11 = (int)(izPanelConstraintsArray[n15].getXStretch() / d * (double)n14);
                        Rectangle rectangle2 = izPanelConstraintsArray[n15].component.getBounds();
                        int n22 = this.minimumColumnWidth(n15);
                        if (rectangle2.width < n22) {
                            rectangle2.width = n22;
                        }
                        int n23 = n11 + rectangle2.width;
                        Log.getInstance().addDebugMessage("IzPanelLayout.layoutContainer resize bounds for {2}|{3} old width {0} new width {1}", new String[]{Integer.toString(rectangle2.width), Integer.toString(n23), Integer.toString(n8), Integer.toString(n15)}, "LayoutTrace", null);
                        izPanelConstraintsArray[n15].component.setBounds(rectangle2.x + n13, rectangle2.y, n23, rectangle2.height);
                        izPanelConstraintsArray[n15].component.getBounds(rectangle);
                        if (rectangle.x > 0 && rectangle.x < n9) {
                            n9 = rectangle.x;
                        }
                        if (rectangle.y > 0 && rectangle.y < n10) {
                            n10 = rectangle.y;
                        }
                        if ((n21 = (int)rectangle.getMaxX()) - n9 > n3) {
                            n3 = n21 - n9;
                        }
                        n21 = (int)rectangle.getMaxY();
                        izPanelConstraintsArray[n15].setBounds(rectangle);
                        if (n21 - n10 > n4) {
                            n4 = n21 - n10;
                        }
                        Log.getInstance().addDebugMessage("IzPanelLayout.layoutContainer resize bounds for {2}|{3} ({0}): {1}", new String[]{izPanelConstraintsArray[n15].component.getClass().getName(), rectangle.toString(), Integer.toString(n8), Integer.toString(n15)}, "LayoutTrace", null);
                        Log.getInstance().addDebugMessage("IzPanelLayout.layoutContainer resize bounds for {2}|{3}: maxWidth = {0} maxHeight = {1}", new String[]{Integer.toString(n3), Integer.toString(n4), Integer.toString(n8), Integer.toString(n15)}, "LayoutTrace", null);
                        n13 += n11;
                        if (!this.needsReEvaluation(izPanelConstraintsArray[n15].component) || n12 != n2) continue;
                        ++n2;
                    }
                }
                if (n2 == 1) continue;
                n2 = 0;
                n7 += n16;
                ++n8;
            }
        }
    }

    private void fastLayoutContainer(Container container) {
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                IzPanelConstraints izPanelConstraints = this.getConstraints(j, i);
                if (izPanelConstraints == null) continue;
                Log.getInstance().addDebugMessage("IzPanelLayout.fastLayoutContainer bounds: {0}", new String[]{izPanelConstraints.getBounds().toString()}, "LayoutTrace", null);
                izPanelConstraints.component.setBounds(izPanelConstraints.getBounds());
            }
        }
    }

    private boolean needNewLayout(Container container) {
        Dimension dimension = this.oldParentSize;
        Insets insets = this.oldParentInsets;
        this.oldParentSize = container.getSize();
        this.oldParentInsets = container.getInsets();
        if (insets == null) {
            return true;
        }
        return !dimension.equals(container.getSize()) || !insets.equals(container.getInsets());
    }

    private int resolveGenerellOffsets(int[] nArray, Dimension dimension, Insets insets, int n, int n2) {
        int n3 = 1;
        switch (IzPanelLayout.getAnchor()) {
            case 0: {
                nArray[0] = (dimension.width - insets.left - insets.right - n) / 2;
                nArray[1] = (dimension.height - insets.top - insets.bottom - n2) / 2;
                break;
            }
            case 7: {
                nArray[0] = 0;
                nArray[1] = (dimension.height - insets.top - insets.bottom - n2) / 2;
                break;
            }
            case 3: {
                nArray[0] = dimension.width - insets.left - insets.right - n;
                nArray[1] = (dimension.height - insets.top - insets.bottom - n2) / 2;
                break;
            }
            case 1: {
                nArray[0] = (dimension.width - insets.left - insets.right - n) / 2;
                nArray[1] = 0;
                break;
            }
            case 5: {
                nArray[0] = (dimension.width - insets.left - insets.right - n) / 2;
                nArray[1] = dimension.height - insets.top - insets.bottom - n2;
                break;
            }
            case 8: {
                nArray[0] = 0;
                nArray[1] = 0;
                n3 = 2;
                break;
            }
            case 2: {
                nArray[0] = dimension.width - insets.left - insets.right - n;
                nArray[1] = 0;
                break;
            }
            case 6: {
                nArray[0] = 0;
                nArray[1] = dimension.height - insets.top - insets.bottom - n2;
                break;
            }
            case 4: {
                nArray[0] = dimension.width - insets.left - insets.right - n;
                nArray[1] = dimension.height - insets.top - insets.bottom - n2;
            }
        }
        if (nArray[0] < 0) {
            nArray[0] = 0;
        }
        if (nArray[1] < 0) {
            nArray[1] = 0;
        }
        return n3;
    }

    private boolean needsReEvaluation(Component component) {
        return component instanceof MultiLineLabel || component instanceof PathSelectionPanel;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public void addLayoutComponent(Component component, Object object) {
        int n;
        int n2;
        int n3;
        IzPanelConstraints izPanelConstraints;
        if (component == null) {
            throw new NullPointerException("component has to be not null");
        }
        if (!(object instanceof IzPanelConstraints)) {
            izPanelConstraints = component instanceof FillerComponent && ((FillerComponent)component).getConstraints() != null ? (IzPanelConstraints)((FillerComponent)component).getConstraints().clone() : (IzPanelConstraints)DEFAULT_CONSTRAINTS[IzPanelLayout.getIntermediarId(component.getClass(), component)].clone();
            if ("nextLine".equals(object)) {
                izPanelConstraints.setXPos(0);
                izPanelConstraints.setYPos(-1);
            }
        } else {
            izPanelConstraints = (IzPanelConstraints)((IzPanelConstraints)object).clone();
        }
        izPanelConstraints.component = component;
        int n4 = izPanelConstraints.getYPos();
        if (n4 == -1) {
            n4 = this.currentYPos + 1;
        }
        if (n4 == -2) {
            n4 = this.currentYPos;
        }
        izPanelConstraints.setYPos(n4);
        int n5 = izPanelConstraints.getXPos();
        if (n5 == -1) {
            n5 = this.currentXPos + 1;
        }
        if (n5 == -2) {
            n5 = this.currentXPos;
        }
        izPanelConstraints.setXPos(n5);
        int n6 = n3 = izPanelConstraints.getXWeight() < 127 ? izPanelConstraints.getXWeight() : 1;
        if (this.components.size() < izPanelConstraints.getXPos() + n3) {
            for (n2 = this.components.size() - 1; n2 < izPanelConstraints.getXPos() + n3 - 1; ++n2) {
                this.components.add(new ArrayList());
            }
        }
        IzPanelConstraints izPanelConstraints2 = izPanelConstraints;
        for (n = 0; n < n3; ++n) {
            ArrayList<IzPanelConstraints> arrayList = this.components.get(n5);
            if (arrayList.size() < n4) {
                for (n2 = arrayList.size() - 1; n2 < n4 - 1; ++n2) {
                    IzPanelConstraints izPanelConstraints3 = IzPanelLayout.getDefaultConstraint(5);
                    izPanelConstraints3.component = new FillerComponent();
                    arrayList.add(izPanelConstraints3);
                }
            }
            arrayList.add(n4, izPanelConstraints2);
            if (n >= n3 - 1) continue;
            izPanelConstraints2 = IzPanelLayout.getDefaultConstraint(5);
            izPanelConstraints2.component = new FillerComponent();
            ++n5;
        }
        n = this.components.get(n5).size() - 1;
        if (this.currentYPos < n) {
            this.currentYPos = n;
        }
        this.currentXPos = n5;
    }

    public static Component createHorizontalStrut(int n) {
        return new FillerComponent(new Dimension(n, 0));
    }

    public static Component createVerticalStrut(int n) {
        return new FillerComponent(new Dimension(0, n));
    }

    public static Component createParagraphGap() {
        return IzPanelLayout.createGap(-4, 1);
    }

    public static Component createVerticalFiller(int n) {
        return IzPanelLayout.createGap(-13 - n, 1);
    }

    public static Component createHorizontalFiller(int n) {
        return IzPanelLayout.createGap(-13 - n, 0);
    }

    public static Component createGap(int n, int n2) {
        if (n2 == 0) {
            return new FillerComponent(new Dimension(0, 0), new IzPanelConstraints(-3, -3, -1, -2, 1, 1, n, 0, 0.0, 0.0));
        }
        return new FillerComponent(new Dimension(0, 0), new IzPanelConstraints(-3, -3, 0, -1, 10, 10, 0, n, 1.0, 0.0));
    }

    public static IzPanelConstraints getDefaultConstraint(int n) {
        return (IzPanelConstraints)DEFAULT_CONSTRAINTS[n].clone();
    }

    public static int getAnchor() {
        return ANCHOR;
    }

    public static void setAnchor(int n) {
        ANCHOR = n;
    }

    public static int getXStretchType() {
        return X_STRETCH_TYPE;
    }

    public static void setXStretchType(int n) {
        X_STRETCH_TYPE = n;
    }

    public static int getYStretchType() {
        return Y_STRETCH_TYPE;
    }

    public static void setYStretchType(int n) {
        Y_STRETCH_TYPE = n;
    }

    public static double getFullLineStretch() {
        return FULL_LINE_STRETCH_DEFAULT;
    }

    public static void setFullLineStretch(double d) {
        FULL_LINE_STRETCH_DEFAULT = d;
    }

    public static double getFullColumnStretch() {
        return FULL_COLUMN_STRETCH_DEFAULT;
    }

    public static void setFullColumnStretch(double d) {
        FULL_COLUMN_STRETCH_DEFAULT = d;
    }

    public static int verifyGapId(int n) {
        if (n < 0) {
            n = -n;
        }
        if (n >= DEFAULT_X_GAPS.length) {
            throw new IndexOutOfBoundsException("gapId is not in the default gap container.");
        }
        return n;
    }

    public static int getDefaultXGap(int n) {
        n = IzPanelLayout.verifyGapId(n);
        return DEFAULT_X_GAPS[n];
    }

    public static void setDefaultXGap(int n, int n2) {
        n2 = IzPanelLayout.verifyGapId(n2);
        IzPanelLayout.DEFAULT_X_GAPS[n2] = n;
    }

    public static int getDefaultYGap(int n) {
        n = IzPanelLayout.verifyGapId(n);
        return DEFAULT_Y_GAPS[n];
    }

    public static void setDefaultYGap(int n, int n2) {
        n2 = IzPanelLayout.verifyGapId(n2);
        IzPanelLayout.DEFAULT_Y_GAPS[n2] = n;
    }

    public static int getDefaultTextfieldLength() {
        return DEFAULT_TEXTFIELD_LENGTH;
    }

    public static void setDefaultTextfieldLength(int n) {
        DEFAULT_TEXTFIELD_LENGTH = n;
    }

    public static class FillerComponent
    extends Component {
        private static final long serialVersionUID = 7270064864038287900L;
        private Dimension size;
        private IzPanelConstraints constraints;

        public FillerComponent() {
            this(new Dimension(0, 0));
        }

        public FillerComponent(Dimension dimension) {
            this(dimension, null);
        }

        public FillerComponent(Dimension dimension, IzPanelConstraints izPanelConstraints) {
            this.size = dimension;
            this.constraints = izPanelConstraints;
        }

        public Dimension getMinimumSize() {
            return (Dimension)this.size.clone();
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            return this.getMinimumSize();
        }

        public Rectangle getBounds() {
            return this.getBounds(new Rectangle());
        }

        public Rectangle getBounds(Rectangle rectangle) {
            Rectangle rectangle2 = rectangle != null ? rectangle : new Rectangle();
            rectangle2.setBounds(0, 0, this.size.width, this.size.height);
            return rectangle2;
        }

        public IzPanelConstraints getConstraints() {
            return this.constraints;
        }

        public void setConstraints(IzPanelConstraints izPanelConstraints) {
            this.constraints = izPanelConstraints;
        }
    }
}

