/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.tool.routing.experimentalAStar1.AStarRoutingFrame;
import com.sun.electric.tool.routing.experimentalAStar1.Node;
import com.sun.electric.tool.routing.experimentalAStar1.ObjectPool;
import com.sun.electric.tool.routing.experimentalAStar1.Poolable;
import com.sun.electric.tool.routing.experimentalAStar1.PriorityQueue;

public class Storage
implements Poolable<Storage> {
    private boolean DEBUG = false;
    private PriorityQueue queue = new PriorityQueue();
    private Storage tail;
    private Node[] nodeMap = null;
    private int width = -1;
    private int height = -1;
    private int layers = -1;
    private Node nodeListHead = null;
    private Node nodeListLast = null;
    private int[] minX;
    private int[] maxX;
    private int[] minY;
    private int[] maxY;
    private int nodeCount = 0;

    public Storage() {
        this.DEBUG &= AStarRoutingFrame.getInstance().isOutputEnabled();
    }

    public void initialize(int width, int height, int layers) {
        if (this.nodeMap == null || width != this.width || height != this.height || layers != this.layers) {
            this.width = width;
            this.height = height;
            this.layers = layers;
            this.nodeMap = new Node[width * height * layers];
            this.minX = new int[layers];
            this.maxX = new int[layers];
            this.minY = new int[layers];
            this.maxY = new int[layers];
        } else {
            long startTime = 0L;
            if (this.DEBUG) {
                startTime = System.nanoTime();
            }
            for (int z = 0; z < layers; ++z) {
                int temp = z * height;
                for (int y = this.minY[z]; y <= this.maxY[z]; ++y) {
                    int temp2 = (temp + y) * width;
                    for (int x = this.minX[z]; x <= this.maxX[z]; ++x) {
                        this.nodeMap[temp2 + x] = null;
                    }
                }
            }
            if (this.DEBUG) {
                float percentage = 0.0f;
                int sweepedCount = 0;
                for (int z = 0; z < layers; ++z) {
                    if (this.maxX[z] < this.minX[z] || this.maxY[z] < this.minY[z]) continue;
                    sweepedCount += (this.maxY[z] - this.minY[z] + 1) * (this.maxX[z] - this.minX[z] + 1);
                }
                if (sweepedCount != 0) {
                    percentage = (float)this.nodeCount * 100.0f / (float)sweepedCount;
                }
                System.out.printf("Storage: Sweeping nodeMap in %d ms, %d/%d necessary sweeps (%.1f %%)\n", (System.nanoTime() - startTime) / 1000000L, this.nodeCount, sweepedCount, Float.valueOf(percentage));
            }
            this.nodeCount = 0;
        }
        for (int z = 0; z < layers; ++z) {
            this.minX[z] = Integer.MAX_VALUE;
            this.maxX[z] = Integer.MIN_VALUE;
            this.minY[z] = Integer.MAX_VALUE;
            this.maxY[z] = Integer.MIN_VALUE;
        }
        this.queue.clear();
        this.nodeListHead = null;
        this.nodeListLast = null;
    }

    public void addToOpen(Node node) {
        node.childCount = (byte)-1;
        this.queue.add(node);
        int nodeMapIndex = (node.z * this.height + node.y) * this.width + node.x;
        byte z = node.z;
        this.minX[z] = Math.min(this.minX[z], node.x);
        this.maxX[z] = Math.max(this.maxX[z], node.x);
        this.minY[z] = Math.min(this.minY[z], node.y);
        this.maxY[z] = Math.max(this.maxY[z], node.y);
        this.nodeMap[nodeMapIndex] = node;
        ++this.nodeCount;
        node.setTail(this.nodeListHead);
        if (this.nodeListHead == null) {
            this.nodeListLast = node;
        }
        this.nodeListHead = node;
    }

    public Node shiftCheapestNode() {
        Node node = this.queue.remove();
        node.childCount = 0;
        return node;
    }

    public boolean isOpenEmpty() {
        return this.queue.isEmpty();
    }

    public boolean contains(int x, int y, int z) {
        return this.nodeMap[(z * this.height + y) * this.width + x] != null;
    }

    public Node get(int x, int y, int z) {
        return this.nodeMap[(z * this.height + y) * this.width + x];
    }

    public boolean isNodeInOpen(Node node) {
        return node.childCount == -1;
    }

    public void decreaseCost(Node node, int newCost) {
        this.queue.decreaseKey(node, newCost);
    }

    public void freeNodes(ObjectPool<Node> pool) {
        if (this.nodeListHead != null) {
            pool.freeAllLinked(this.nodeListHead, this.nodeListLast);
            this.nodeListHead = null;
            this.nodeListLast = null;
        }
    }

    @Override
    public Storage getTail() {
        return this.tail;
    }

    @Override
    public void setTail(Storage tail) {
        this.tail = tail;
    }
}

