/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.Variable;
import java.util.ArrayList;
import java.util.List;

public class FlagAnnotations {
    public static final Variable.Key FLAG_ANNOTATION_KEY = Variable.newKey("ATTR_FLAG");
    public static final String ATOMIC = "atomic";
    public static final String AUTO_GEN = "autoGen";
    private String cellThatOwnsMe;
    private List<String> annotText = new ArrayList<String>();
    private boolean cellHasAnnotations;
    private boolean atomic;
    private String autoGenClassName;

    private void prErr(String s2) {
        String currAnnot = this.annotText.get(this.annotText.size() - 1);
        System.out.println("  " + s2 + "  cell= " + this.cellThatOwnsMe + " annotation= " + currAnnot);
    }

    private void doAnnotation(String note) {
        this.annotText.add(note);
        String[] toks = note.split("\\s+");
        String ann = toks[0];
        if (ann.equals(ATOMIC)) {
            this.atomic = true;
        } else if (ann.equals(AUTO_GEN)) {
            if (toks.length != 2) {
                this.prErr("Wrong number of arguments to FLAG autoGen annotation.");
                return;
            }
            this.autoGenClassName = toks[1];
        } else {
            this.prErr("Unrecognized FLAG annotation");
        }
    }

    public FlagAnnotations(Cell cell) {
        Variable flagVar = cell.getVar(FLAG_ANNOTATION_KEY);
        if (flagVar == null) {
            return;
        }
        Object annotation = flagVar.getObject();
        this.cellThatOwnsMe = cell.libDescribe();
        if (annotation instanceof String) {
            this.doAnnotation((String)annotation);
        } else if (annotation instanceof String[]) {
            String[] ss = (String[])annotation;
            for (int i = 0; i < ss.length; ++i) {
                this.doAnnotation(ss[i]);
            }
        } else {
            this.prErr(" ignoring bad Flag annotation: ");
        }
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public boolean isAutoGen() {
        return this.autoGenClassName != null;
    }

    public String getAutoGenClassName() {
        return this.autoGenClassName;
    }

    public boolean cellHasAnnotations() {
        return this.cellHasAnnotations;
    }
}

