/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.math;

import com.sun.electric.util.math.FixpCoord;
import java.awt.geom.Point2D;

public abstract class AbstractFixpPoint
extends Point2D {
    public abstract long getFixpX();

    public abstract long getFixpY();

    public abstract void setFixpLocation(long var1, long var3);

    protected abstract AbstractFixpPoint create(long var1, long var3);

    @Override
    public double getX() {
        return FixpCoord.fixpToLambda(this.getFixpX());
    }

    @Override
    public double getY() {
        return FixpCoord.fixpToLambda(this.getFixpY());
    }

    @Override
    public void setLocation(double x2, double y) {
        this.setFixpLocation(FixpCoord.lambdaToFixp(x2), FixpCoord.lambdaToFixp(y));
    }

    @Override
    public void setLocation(Point2D p) {
        if (p instanceof AbstractFixpPoint) {
            AbstractFixpPoint fp = (AbstractFixpPoint)p;
            this.setFixpLocation(fp.getFixpX(), fp.getFixpY());
        } else {
            super.setLocation(p);
        }
    }

    @Override
    public double distanceSq(Point2D pt) {
        if (pt instanceof AbstractFixpPoint) {
            AbstractFixpPoint fp = (AbstractFixpPoint)pt;
            long fx = this.getFixpX() - fp.getFixpX();
            long fy = this.getFixpY() - fp.getFixpY();
            if (fx == 0L) {
                double dy = FixpCoord.fixpToLambda(fy);
                return dy * dy;
            }
            if (fy == 0L) {
                double dx = FixpCoord.fixpToLambda(fx);
                return dx * dx;
            }
            double dx = FixpCoord.fixpToLambda(fx);
            double dy = FixpCoord.fixpToLambda(fy);
            return dx * dx + dy * dy;
        }
        return super.distanceSq(pt);
    }

    @Override
    public double distance(Point2D pt) {
        if (pt instanceof AbstractFixpPoint) {
            AbstractFixpPoint fp = (AbstractFixpPoint)pt;
            long fx = this.getFixpX() - fp.getFixpX();
            long fy = this.getFixpY() - fp.getFixpY();
            if (fx == 0L) {
                return FixpCoord.fixpToLambda(Math.abs(fy));
            }
            if (fy == 0L) {
                return FixpCoord.fixpToLambda(Math.abs(fx));
            }
            double dx = FixpCoord.fixpToLambda(fx);
            double dy = FixpCoord.fixpToLambda(fy);
            return Math.sqrt(dx * dx + dy * dy);
        }
        return super.distance(pt);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AbstractFixpPoint) {
            AbstractFixpPoint that = (AbstractFixpPoint)o;
            return this.getFixpX() == that.getFixpX() && this.getFixpY() == that.getFixpY();
        }
        return super.equals(o);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getX() + ", " + this.getY() + "]";
    }
}

