/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.PlacementMinCut;
import com.sun.electric.tool.placement.PlacementRandom;
import com.sun.electric.tool.placement.PlacementSimple;
import com.sun.electric.tool.placement.forceDirected1.PlacementForceDirectedTeam5;
import com.sun.electric.tool.placement.forceDirected2.PlacementForceDirectedStaged;
import com.sun.electric.tool.placement.general.BottomUpPartition;
import com.sun.electric.tool.placement.general.BottomUpPlace;
import com.sun.electric.tool.placement.general.Control;
import com.sun.electric.tool.placement.general.FDRowCol;
import com.sun.electric.tool.placement.general.SARowCol;
import com.sun.electric.tool.placement.genetic1.g1.GeneticPlacement;
import com.sun.electric.tool.placement.genetic2.PlacementGenetic;
import com.sun.electric.tool.placement.metrics.boundingbox.BBMetric;
import com.sun.electric.tool.placement.metrics.mst.MSTMetric;
import com.sun.electric.tool.placement.simulatedAnnealing1.SimulatedAnnealing;
import com.sun.electric.tool.placement.simulatedAnnealing2.PlacementSimulatedAnnealing;
import com.sun.electric.tool.util.concurrent.utils.ElapseTimer;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlacementAdapter {
    private static final Logger logger = LoggerFactory.getLogger(PlacementAdapter.class);
    public static Control GEN = new Control();
    public static BottomUpPartition BUpa = new BottomUpPartition();
    public static BottomUpPlace BUpl = new BottomUpPlace();
    public static SimulatedAnnealing SA1 = new SimulatedAnnealing();
    public static PlacementSimulatedAnnealing SA2 = new PlacementSimulatedAnnealing();
    public static SARowCol SA3 = new SARowCol();
    public static GeneticPlacement G1 = new GeneticPlacement();
    public static PlacementGenetic G2 = new PlacementGenetic();
    public static PlacementForceDirectedTeam5 FD1 = new PlacementForceDirectedTeam5();
    public static PlacementForceDirectedStaged FD2 = new PlacementForceDirectedStaged();
    public static FDRowCol FD3 = new FDRowCol();
    public static PlacementMinCut MC = new PlacementMinCut();
    public static PlacementSimple SIMP = new PlacementSimple();
    public static PlacementRandom RAND = new PlacementRandom();
    private static Map<String, NodeInst> namedPlacedNodes;
    private static String lastHPWL;
    static PlacementFrame[] placementAlgorithms;

    public static PlacementFrame[] getPlacementAlgorithms() {
        return placementAlgorithms;
    }

    public static Cell doPlacement(PlacementFrame pla, Library lib, String cellName, List<PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementExport> exportsToPlace, NodeProto iconToPlace, Placement.PlacementPreferences prefs, boolean quiet, Job job) {
        ElapseTimer timer = ElapseTimer.createInstance().start();
        System.out.println("Running placement on cell '" + (lib == Library.getCurrent() ? "" : lib.getName() + ":") + cellName + "' using the '" + pla.getAlgorithmName() + "' algorithm");
        for (PlacementFrame.PlacementParameter par2 : pla.getParameters()) {
            par2.setValue(prefs.getParameter(par2));
        }
        ArrayList<PlacementFrame.PlacementNode> nodesToPlaceCopy = new ArrayList<PlacementFrame.PlacementNode>(nodesToPlace);
        pla.runPlacement(nodesToPlaceCopy, allNetworks, cellName, job);
        if (pla.isFailure()) {
            return null;
        }
        HashMap<PlacementFrame.PlacementNetwork, List<PlacementConnection>> optimalConnections = new HashMap<PlacementFrame.PlacementNetwork, List<PlacementConnection>>();
        Cell cell = PlacementAdapter.doGeneratePlacedCell(lib, cellName, nodesToPlace, iconToPlace, allNetworks, exportsToPlace, timer, quiet, optimalConnections);
        BBMetric bmetric = new BBMetric(nodesToPlaceCopy, allNetworks, optimalConnections);
        lastHPWL = bmetric.toString();
        if (Job.getDebug() && !quiet && logger.isDebugEnabled()) {
            Date now = new Date();
            try {
                InetAddress addr = InetAddress.getLocalHost();
                String hostname = addr.getHostName();
                logger.debug("====================================================");
                logger.debug("machine: " + hostname);
                logger.debug("date: " + TextUtils.formatDate(now));
                logger.debug("Electric's version: " + Version.getVersion());
                logger.debug("algorithm: " + pla.getAlgorithmName());
                logger.debug("#threads : " + pla.numOfThreads);
                logger.debug("#runtime : " + pla.runtime);
                logger.debug("cell     : " + cellName);
                logger.debug("### BBMetric: " + lastHPWL);
                MSTMetric mstMetric = new MSTMetric(nodesToPlaceCopy, allNetworks, optimalConnections);
                logger.debug("### MSTMetric: " + mstMetric.toString());
                logger.debug("====================================================");
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return cell;
    }

    public static String getLastHPWL() {
        return lastHPWL;
    }

    private static Cell doGeneratePlacedCell(Library lib, String cellName, List<PlacementNode> nodesToPlace, NodeProto iconToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementExport> exportsToPlace, ElapseTimer timer, boolean quiet, Map<PlacementFrame.PlacementNetwork, List<PlacementConnection>> optimalConnections) {
        Cell newCell = Cell.makeInstance(lib, cellName);
        HashMap<PlacementNode, NodeInst> placedNodes = new HashMap<PlacementNode, NodeInst>();
        namedPlacedNodes = new HashMap<String, NodeInst>();
        for (PlacementNode plNode : nodesToPlace) {
            NodeInst ni;
            String name;
            double xPos = plNode.getPlacementX();
            double yPos = plNode.getPlacementY();
            Orientation orient = plNode.getPlacementOrientation();
            NodeProto np = plNode.getType();
            if (np instanceof Cell) {
                Cell placementCell = (Cell)np;
                ERectangle bounds = placementCell.getBounds();
                Point2D.Double centerOffset = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                orient.pureRotate().transform(centerOffset, centerOffset);
                xPos -= ((Point2D)centerOffset).getX();
                yPos -= ((Point2D)centerOffset).getY();
            }
            if ((name = plNode.nodeName) == null && plNode.originalNode != null && !plNode.originalNode.getNameKey().isTempname()) {
                name = plNode.originalNode.getName();
            }
            if ((ni = NodeInst.makeInstance(np, (Point2D)new Point2D.Double(xPos, yPos), np.getDefWidth(), np.getDefHeight(), newCell, orient, name, plNode.getTechBits())) == null) {
                System.out.println("Placement failed to create node");
            } else {
                if (plNode.isTerminal()) {
                    ni.setLocked();
                }
                if (plNode.originalNode != null && !plNode.originalNode.getNameKey().isTempname()) {
                    ni.setTextDescriptor(NodeInst.NODE_NAME, plNode.originalNode.getTextDescriptor(NodeInst.NODE_NAME));
                }
                placedNodes.put(plNode, ni);
                namedPlacedNodes.put(ni.getName(), ni);
            }
            if (plNode.addedVariables == null) continue;
            for (String varName : plNode.addedVariables.keySet()) {
                Object value2 = plNode.addedVariables.get(varName);
                Variable.Key key = Variable.newKey(varName);
                Variable var = ni.newDisplayVar(key, value2);
                if (key == Schematics.SCHEM_RESISTANCE) {
                    ni.setTextDescriptor(key, var.getTextDescriptor().withOff(0.0, 0.5).withDispPart(AbstractTextDescriptor.DispPos.VALUE));
                    continue;
                }
                if (key == Schematics.ATTR_WIDTH) {
                    ni.setTextDescriptor(key, var.getTextDescriptor().withOff(0.5, -1.0).withRelSize(1.0).withDispPart(AbstractTextDescriptor.DispPos.VALUE));
                    continue;
                }
                if (key == Schematics.ATTR_LENGTH) {
                    ni.setTextDescriptor(key, var.getTextDescriptor().withOff(-0.5, -1.0).withRelSize(0.5).withDispPart(AbstractTextDescriptor.DispPos.VALUE));
                    continue;
                }
                ni.setTextDescriptor(key, var.getTextDescriptor().withDispPart(AbstractTextDescriptor.DispPos.VALUE));
            }
        }
        if (iconToPlace != null) {
            ERectangle bounds = newCell.getBounds();
            EPoint center = new EPoint(bounds.getMaxX() + iconToPlace.getDefWidth(), bounds.getMaxY() + iconToPlace.getDefHeight());
            NodeInst.makeInstance(iconToPlace, center, iconToPlace.getDefWidth(), iconToPlace.getDefHeight(), newCell);
        }
        for (PlacementExport plExport : exportsToPlace) {
            PlacementPort plPort = plExport.getPort();
            String exportName = plExport.getName();
            PlacementNode plNode = (PlacementNode)plPort.getPlacementNode();
            NodeInst newNI = (NodeInst)placedNodes.get(plNode);
            if (newNI == null) continue;
            PortInst portToExport = newNI.findPortInstFromProto(plPort.getPortProto());
            Export.newInstance(newCell, portToExport, exportName, plExport.getCharacteristic());
        }
        ImmutableArcInst a = Generic.tech().unrouted_arc.getDefaultInst(newCell.getEditingPreferences());
        long gridExtend = a.getGridExtendOverMin();
        for (PlacementFrame.PlacementNetwork plNet : allNetworks) {
            List<PlacementConnection> connections = PlacementAdapter.getOptimalConnections(plNet);
            optimalConnections.put(plNet, connections);
            for (PlacementConnection pc : connections) {
                PlacementNode plNode1 = (PlacementNode)pc.getP1().getPlacementNode();
                PlacementPort thisPp1 = (PlacementPort)pc.getP1();
                NodeInst newNi1 = (NodeInst)placedNodes.get(plNode1);
                PortInst thisPi1 = newNi1.findPortInstFromProto(thisPp1.getPortProto());
                EPoint pt1 = thisPi1.getCenter();
                PlacementNode plNode2 = (PlacementNode)pc.getP2().getPlacementNode();
                PlacementPort thisPp2 = (PlacementPort)pc.getP2();
                NodeInst newNi2 = (NodeInst)placedNodes.get(plNode2);
                PortInst thisPi2 = newNi2.findPortInstFromProto(thisPp2.getPortProto());
                EPoint pt2 = thisPi2.getCenter();
                ArcInst.newInstanceNoCheck(newCell, Generic.tech().unrouted_arc, null, null, thisPi1, thisPi2, pt1, pt2, gridExtend, -1, a.flags);
            }
        }
        if (timer != null) {
            timer.end();
            if (!quiet) {
                System.out.println("\t(took " + timer + ")");
            }
        }
        return newCell;
    }

    public static Map<String, NodeInst> getPlacementMap() {
        return namedPlacedNodes;
    }

    public static List<PlacementConnection> getOptimalConnections(PlacementFrame.PlacementNetwork plNet) {
        ArrayList<PlacementFrame.PlacementPort> ports = new ArrayList<PlacementFrame.PlacementPort>();
        for (PlacementFrame.PlacementPort plPort : plNet.getPortsOnNet()) {
            ports.add(plPort);
        }
        double shortest = Double.MAX_VALUE;
        int i1 = -1;
        int i2 = -1;
        for (int i = 1; i < ports.size(); ++i) {
            PlacementFrame.PlacementPort pI = (PlacementFrame.PlacementPort)ports.get(i);
            PlacementFrame.PlacementNode nI = pI.getPlacementNode();
            Set<PlacementPort> equiv = ((PlacementNode)nI).getEquivalents((PlacementPort)pI);
            for (int j = 0; j < i; ++j) {
                double hpwl;
                PlacementFrame.PlacementPort pJ = (PlacementFrame.PlacementPort)ports.get(j);
                PlacementFrame.PlacementNode nJ = pJ.getPlacementNode();
                if (equiv != null && equiv.contains(pJ) || !((hpwl = Math.abs(pI.getRotatedOffX() + nI.getPlacementX() - (pJ.getRotatedOffX() + nJ.getPlacementX())) + Math.abs(pI.getRotatedOffY() + nI.getPlacementY() - (pJ.getRotatedOffY() + nJ.getPlacementY()))) < shortest)) continue;
                shortest = hpwl;
                i1 = i;
                i2 = j;
            }
        }
        ArrayList<PlacementConnection> connections = new ArrayList<PlacementConnection>();
        if (i1 < 0 || i2 < 0) {
            return connections;
        }
        PlacementFrame.PlacementPort e1 = (PlacementFrame.PlacementPort)ports.get(i1);
        PlacementFrame.PlacementNode e1n = e1.getPlacementNode();
        PlacementFrame.PlacementPort e2 = (PlacementFrame.PlacementPort)ports.get(i2);
        PlacementFrame.PlacementNode e2n = e2.getPlacementNode();
        boolean isRail = plNet.isOnRail();
        PlacementConnection pc = new PlacementConnection(e1, e2, isRail);
        connections.add(pc);
        ports.remove(Math.max(i1, i2));
        ports.remove(Math.min(i1, i2));
        Set<PlacementPort> equiv = ((PlacementNode)e1n).getEquivalents((PlacementPort)e1);
        if (equiv != null) {
            for (PlacementPort pp : equiv) {
                ports.remove(pp);
            }
        }
        if ((equiv = ((PlacementNode)e2n).getEquivalents((PlacementPort)e2)) != null) {
            for (PlacementPort pp : equiv) {
                ports.remove(pp);
            }
        }
        while (ports.size() > 0) {
            PlacementConnection pCon;
            double e1Dist = Double.MAX_VALUE;
            double e2Dist = Double.MAX_VALUE;
            int ei1 = -1;
            int ei2 = -1;
            for (int i = 0; i < ports.size(); ++i) {
                PlacementFrame.PlacementPort pI = (PlacementFrame.PlacementPort)ports.get(i);
                PlacementFrame.PlacementNode nI = pI.getPlacementNode();
                double hpwl = Math.abs(pI.getRotatedOffX() + nI.getPlacementX() - (e1.getRotatedOffX() + e1n.getPlacementX())) + Math.abs(pI.getRotatedOffY() + nI.getPlacementY() - (e1.getRotatedOffY() + e1n.getPlacementY()));
                if (hpwl < e1Dist) {
                    e1Dist = hpwl;
                    ei1 = i;
                }
                if (!((hpwl = Math.abs(pI.getRotatedOffX() + nI.getPlacementX() - (e2.getRotatedOffX() + e2n.getPlacementX())) + Math.abs(pI.getRotatedOffY() + nI.getPlacementY() - (e2.getRotatedOffY() + e2n.getPlacementY()))) < e2Dist)) continue;
                e2Dist = hpwl;
                ei2 = i;
            }
            if (e1Dist > e2Dist) {
                pCon = new PlacementConnection(e2, (PlacementFrame.PlacementPort)ports.get(ei2), isRail);
                connections.add(pCon);
                ports.remove(ei2);
                e2 = pCon.getP2();
                equiv = ((PlacementNode)e2.getPlacementNode()).getEquivalents((PlacementPort)e2);
                if (equiv == null) continue;
                for (PlacementPort pp : equiv) {
                    ports.remove(pp);
                }
                continue;
            }
            pCon = new PlacementConnection((PlacementFrame.PlacementPort)ports.get(ei1), e1, isRail);
            connections.add(pCon);
            ports.remove(ei1);
            e1 = pCon.getP1();
            equiv = ((PlacementNode)e1.getPlacementNode()).getEquivalents((PlacementPort)e1);
            if (equiv == null) continue;
            for (PlacementPort pp : equiv) {
                ports.remove(pp);
            }
        }
        return connections;
    }

    static {
        placementAlgorithms = new PlacementFrame[]{GEN, BUpa, BUpl, SA1, SA2, SA3, G1, G2, FD1, FD2, FD3, MC, SIMP, RAND};
    }

    public static class PlacementConnection {
        private PlacementFrame.PlacementPort p1;
        private PlacementFrame.PlacementPort p2;
        private boolean isRail;

        public PlacementConnection(PlacementFrame.PlacementPort p1, PlacementFrame.PlacementPort p2, boolean isRail) {
            this.p1 = p1;
            this.p2 = p2;
            this.isRail = isRail;
        }

        public PlacementFrame.PlacementPort getP1() {
            return this.p1;
        }

        public PlacementFrame.PlacementPort getP2() {
            return this.p2;
        }

        public boolean isOnPowerGround() {
            return this.isRail;
        }
    }

    public static class PlacementExport {
        private PlacementPort portToExport;
        private String exportName;
        private PortCharacteristic characteristic;

        public PlacementExport(PlacementPort port, String name, PortCharacteristic chr) {
            this.portToExport = port;
            this.exportName = name;
            this.characteristic = chr;
        }

        PlacementPort getPort() {
            return this.portToExport;
        }

        String getName() {
            return this.exportName;
        }

        PortCharacteristic getCharacteristic() {
            return this.characteristic;
        }
    }

    public static class PlacementPort
    extends PlacementFrame.PlacementPort {
        private PortProto proto;

        public PlacementPort(double x2, double y, PortProto pp) {
            super(x2, y);
            this.proto = pp;
        }

        public PortProto getPortProto() {
            return this.proto;
        }

        public String toString() {
            return this.proto.getName();
        }
    }

    public static class PlacementNode
    extends PlacementFrame.PlacementNode {
        private final NodeInst originalNode;
        private final NodeProto original;
        private final String nodeName;
        private final int techBits;
        private final double width;
        private final double height;
        private final List<PlacementFrame.PlacementPort> ports;
        private Map<String, Object> addedVariables;
        private final boolean terminal;
        private Map<PlacementPort, Set<PlacementPort>> equivPorts;

        public PlacementNode(NodeInst ni, NodeProto type, String name, int tBits, double wid, double hei, List<PlacementPort> pps, boolean terminal) {
            this.originalNode = ni;
            this.original = type;
            this.nodeName = name;
            this.techBits = tBits;
            this.width = wid;
            this.height = hei;
            this.ports = new ArrayList<PlacementPort>(pps);
            this.equivPorts = new HashMap<PlacementPort, Set<PlacementPort>>();
            this.terminal = terminal;
        }

        public void addEquivalentPorts(PlacementPort p1, PlacementPort p2) {
            Set<PlacementPort> list1 = this.equivPorts.get(p1);
            if (list1 == null) {
                list1 = new HashSet<PlacementPort>();
                this.equivPorts.put(p1, list1);
            }
            list1.add(p2);
            Set<PlacementPort> list2 = this.equivPorts.get(p2);
            if (list2 == null) {
                list2 = new HashSet<PlacementPort>();
                this.equivPorts.put(p2, list2);
            }
            list2.add(p1);
        }

        public Set<PlacementPort> getEquivalents(PlacementPort p) {
            return this.equivPorts.get(p);
        }

        public void addVariable(String name, Object value2) {
            if (this.addedVariables == null) {
                this.addedVariables = new HashMap<String, Object>();
            }
            this.addedVariables.put(name, value2);
        }

        public NodeProto getType() {
            if (this.original != null) {
                return this.original;
            }
            if (this.originalNode != null) {
                return this.originalNode.getProto();
            }
            return null;
        }

        public NodeInst getOriginal() {
            return this.originalNode;
        }

        @Override
        public String getTypeName() {
            if (this.original != null) {
                return this.original.getName();
            }
            if (this.originalNode != null) {
                return this.originalNode.getProto().getName();
            }
            return null;
        }

        @Override
        public List<PlacementFrame.PlacementPort> getPorts() {
            return this.ports;
        }

        public int getTechBits() {
            return this.techBits;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public String toString() {
            if (this.originalNode != null) {
                return this.originalNode.describe(false);
            }
            String name = this.original.describe(false);
            if (this.nodeName != null) {
                name = name + "[" + this.nodeName + "]";
            }
            if (this.getTechBits() != 0) {
                name = name + "(" + this.getTechBits() + ")";
            }
            return name;
        }
    }
}

