/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.result;

import java.util.Arrays;

public class Permutation {
    private int[] perm;

    public Permutation(int size2) {
        int[] permutation = new int[size2];
        for (int i = 0; i < size2; ++i) {
            permutation[i] = i;
        }
        this.perm = permutation;
    }

    public Permutation(int[] permutation) {
        this.perm = (int[])permutation.clone();
    }

    public Permutation(Permutation p) {
        this.perm = (int[])p.perm.clone();
    }

    public int getPermTo(int i) {
        return this.perm[i];
    }

    public int getPermFrom(int val) {
        int i;
        for (i = 0; i < this.perm.length && this.perm[i] != val; ++i) {
        }
        return i;
    }

    public boolean isIdentity() {
        for (int i = 0; i < this.perm.length; ++i) {
            if (this.perm[i] == i) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.perm.length;
    }

    public void set(int entry, int to2) {
        this.perm[entry] = to2;
    }

    public Permutation product(Permutation h) {
        Permutation g = this;
        return Permutation.product(g, h);
    }

    public static Permutation product(Permutation g, Permutation h) {
        int size2 = g.size();
        assert (h.size() == size2);
        Permutation newperm = new Permutation(size2);
        for (int i = 0; i < size2; ++i) {
            newperm.set(i, h.getPermTo(g.getPermTo(i)));
        }
        return newperm;
    }

    public Permutation inverse() {
        int[] invMap = new int[this.perm.length];
        for (int i = 0; i < this.perm.length; ++i) {
            invMap[this.perm[i]] = i;
        }
        return new Permutation(invMap);
    }

    public String toString() {
        return Arrays.toString(this.perm);
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof Permutation) {
            Permutation p = (Permutation)arg0;
            return Arrays.equals(p.perm, this.perm);
        }
        return false;
    }
}

