/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BoundsBuilder
extends AbstractShapeBuilder {
    private int intMinX;
    private int intMinY;
    private int intMaxX;
    private int intMaxY;
    private double doubleMinX;
    private double doubleMinY;
    private double doubleMaxX;
    private double doubleMaxY;
    private boolean hasIntBounds;
    private boolean hasDoubleBounds;

    public BoundsBuilder(CellBackup cellBackup) {
        this.setup(cellBackup, null, false, true, false, null);
        this.clear();
    }

    public void clear() {
        this.hasDoubleBounds = false;
        this.hasIntBounds = false;
    }

    public boolean genBoundsEasy(ImmutableArcInst a, int[] intCoords) {
        ArcProto protoType;
        if (this.getMemoization().isHardArc(a.arcId)) {
            return false;
        }
        int gridExtendOverMin = (int)a.getGridExtendOverMin();
        int minLayerExtend = gridExtendOverMin + (protoType = this.getTechPool().getArcProto(a.protoId)).getMinLayerGridExtend();
        if (minLayerExtend == 0) {
            assert (protoType.getNumArcLayers() == 1);
            int x1 = (int)a.tailLocation.getGridX();
            int y1 = (int)a.tailLocation.getGridY();
            int x2 = (int)a.headLocation.getGridX();
            int y2 = (int)a.headLocation.getGridY();
            if (x1 <= x2) {
                intCoords[0] = x1;
                intCoords[2] = x2;
            } else {
                intCoords[0] = x2;
                intCoords[2] = x1;
            }
            if (y1 <= y2) {
                intCoords[1] = y1;
                intCoords[3] = y2;
            } else {
                intCoords[1] = y2;
                intCoords[3] = y1;
            }
        } else {
            boolean tailExtended = false;
            if (a.isTailExtended()) {
                short shrinkT = this.getShrinkage().get(a.tailNodeId);
                if (shrinkT == 0) {
                    tailExtended = true;
                } else if (shrinkT != 1) {
                    return false;
                }
            }
            boolean headExtended = false;
            if (a.isHeadExtended()) {
                short shrinkH = this.getShrinkage().get(a.headNodeId);
                if (shrinkH == 0) {
                    headExtended = true;
                } else if (shrinkH != 1) {
                    return false;
                }
            }
            a.makeGridBoxInt(intCoords, tailExtended, headExtended, gridExtendOverMin + protoType.getMaxLayerGridExtend());
        }
        return true;
    }

    public boolean genBoundsEasy(ImmutableNodeInst n, int[] intCoords) {
        double[] angles;
        TechPool techPool = this.getTechPool();
        PrimitiveNode pn = techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId);
        Technology tech = pn.getTechnology();
        ERectangle full = pn.getFullRectangle();
        long gridWidth = n.size.getGridX() + full.getGridWidth();
        long gridHeight = n.size.getGridY() + full.getGridHeight();
        if (gridWidth == 0L && gridHeight == 0L) {
            intCoords[0] = intCoords[2] = (int)n.anchor.getGridX();
            intCoords[1] = intCoords[3] = (int)n.anchor.getGridY();
            return true;
        }
        if (!(!(tech instanceof Artwork) || pn != techPool.getArtwork().circleNode && pn != techPool.getArtwork().thickCircleNode || (angles = n.getArcDegrees())[0] == 0.0 && angles[1] == 0.0)) {
            return false;
        }
        if (tech instanceof Schematics && pn == techPool.getSchematics().busPinNode) {
            return false;
        }
        if (pn.isWipeOn1or2() && !this.getMemoization().hasExports(n) && this.getMemoization().pinUseCount(n)) {
            intCoords[0] = intCoords[2] = (int)n.anchor.getGridX();
            intCoords[1] = intCoords[3] = (int)n.anchor.getGridY();
            return true;
        }
        if (pn.isHoldsOutline() && n.getTrace() != null) {
            return false;
        }
        int w2 = (int)(gridWidth >> 1);
        int h2 = (int)(gridHeight >> 1);
        if (n.orient.isManhattan()) {
            intCoords[0] = -w2;
            intCoords[1] = -h2;
            intCoords[2] = w2;
            intCoords[3] = h2;
            n.orient.rectangleBounds(intCoords);
        } else {
            Rectangle2D.Double mbb = new Rectangle2D.Double();
            n.orient.rectangleBounds(-w2, -h2, w2, h2, 0.0, 0.0, mbb);
            intCoords[0] = GenMath.floorInt(mbb.getMinX());
            intCoords[1] = GenMath.floorInt(mbb.getMinY());
            intCoords[2] = -intCoords[0];
            intCoords[3] = -intCoords[1];
        }
        intCoords[0] = intCoords[0] + (int)n.anchor.getGridX();
        intCoords[1] = intCoords[1] + (int)n.anchor.getGridY();
        intCoords[2] = intCoords[2] + (int)n.anchor.getGridX();
        intCoords[3] = intCoords[3] + (int)n.anchor.getGridY();
        return true;
    }

    public ERectangle makeBounds() {
        if (!this.hasDoubleBounds) {
            if (!this.hasIntBounds) {
                return null;
            }
            int iw = this.intMaxX - this.intMinX;
            int ih = this.intMaxY - this.intMinY;
            return ERectangle.fromGrid(this.intMinX, this.intMinY, iw >= 0 ? (long)iw : (long)this.intMaxX - (long)this.intMinX, ih >= 0 ? (long)ih : (long)this.intMaxY - (long)this.intMinY);
        }
        if (this.hasIntBounds) {
            if ((double)this.intMinX < this.doubleMinX) {
                this.doubleMinX = this.intMinX;
            }
            if ((double)this.intMinY < this.doubleMinY) {
                this.doubleMinY = this.intMinY;
            }
            if ((double)this.intMaxX > this.doubleMaxX) {
                this.doubleMaxX = this.intMaxX;
            }
            if ((double)this.intMaxY > this.doubleMaxY) {
                this.doubleMaxY = this.intMaxY;
            }
            this.hasIntBounds = false;
        }
        long longMinX = GenMath.floorLong(this.doubleMinX);
        long longMaxX = GenMath.ceilLong(this.doubleMaxX);
        long longMinY = GenMath.floorLong(this.doubleMinY);
        long longMaxY = GenMath.ceilLong(this.doubleMaxY);
        return ERectangle.fromGrid(longMinX, longMinY, longMaxX - longMinX, longMaxY - longMinY);
    }

    public boolean makeBounds(EPoint anchor, Rectangle2D.Double visBounds) {
        double h;
        double w;
        double y;
        double x2;
        if (!this.hasDoubleBounds) {
            if (this.hasIntBounds) {
                x2 = this.intMinX;
                y = this.intMinY;
                int iw = this.intMaxX - this.intMinX;
                w = iw >= 0 ? (double)iw : (double)((long)this.intMaxX - (long)this.intMinX);
                int ih = this.intMaxY - this.intMinY;
                h = ih >= 0 ? (double)ih : (double)((long)this.intMaxY - (long)this.intMinY);
            } else {
                x2 = anchor.getGridX();
                y = anchor.getGridY();
                h = 0.0;
                w = 0.0;
            }
        } else {
            if (this.hasIntBounds) {
                if ((double)this.intMinX < this.doubleMinX) {
                    this.doubleMinX = this.intMinX;
                }
                if ((double)this.intMinY < this.doubleMinY) {
                    this.doubleMinY = this.intMinY;
                }
                if ((double)this.intMaxX > this.doubleMaxX) {
                    this.doubleMaxX = this.intMaxX;
                }
                if ((double)this.intMaxY > this.doubleMaxY) {
                    this.doubleMaxY = this.intMaxY;
                }
                this.hasIntBounds = false;
            }
            x2 = GenMath.floorLong(this.doubleMinX);
            y = GenMath.floorLong(this.doubleMinY);
            w = (double)GenMath.ceilLong(this.doubleMaxX) - x2;
            h = (double)GenMath.ceilLong(this.doubleMaxY) - y;
        }
        x2 = DBMath.gridToLambda(x2);
        y = DBMath.gridToLambda(y);
        w = DBMath.gridToLambda(w);
        h = DBMath.gridToLambda(h);
        if (x2 == visBounds.getX() && y == visBounds.getY() && w == visBounds.getWidth() && h == visBounds.getHeight()) {
            return false;
        }
        visBounds.setRect(x2, y, w, h);
        return true;
    }

    @Override
    public void addDoublePoly(int numPoints, Poly.Type style, Layer layer, EGraphics graphicsOverride, PrimitivePort pp) {
        if (style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) {
            Point2D.Double p0 = new Point2D.Double(this.doubleCoords[0], this.doubleCoords[1]);
            Point2D.Double p1 = new Point2D.Double(this.doubleCoords[2], this.doubleCoords[3]);
            Point2D.Double p2 = new Point2D.Double(this.doubleCoords[4], this.doubleCoords[5]);
            Rectangle2D bounds = GenMath.arcBBox(p1, p2, p0);
            if (!this.hasDoubleBounds) {
                this.doubleMinY = Double.POSITIVE_INFINITY;
                this.doubleMinX = Double.POSITIVE_INFINITY;
                this.doubleMaxY = Double.NEGATIVE_INFINITY;
                this.doubleMaxX = Double.NEGATIVE_INFINITY;
                this.hasDoubleBounds = true;
            }
            if (bounds.getMinX() < this.doubleMinX) {
                this.doubleMinX = bounds.getMinX();
            }
            if (bounds.getMaxX() > this.doubleMaxX) {
                this.doubleMaxX = bounds.getMaxX();
            }
            if (bounds.getMinY() < this.doubleMinY) {
                this.doubleMinY = bounds.getMinY();
            }
            if (bounds.getMaxY() > this.doubleMaxY) {
                this.doubleMaxY = bounds.getMaxY();
            }
            return;
        }
        if (!this.hasDoubleBounds) {
            assert (numPoints > 0);
            this.doubleMinX = this.doubleMaxX = this.doubleCoords[0];
            this.doubleMinY = this.doubleMaxY = this.doubleCoords[1];
            this.hasDoubleBounds = true;
        }
        if (style == Poly.Type.CIRCLE || style == Poly.Type.THICKCIRCLE || style == Poly.Type.DISC) {
            double cX = this.doubleCoords[0];
            double cY = this.doubleCoords[1];
            double radius = Point2D.distance(cX, cY, this.doubleCoords[2], this.doubleCoords[3]);
            if (cX - radius < this.doubleMinX) {
                this.doubleMinX = cX - radius;
            }
            if (cX + radius > this.doubleMaxX) {
                this.doubleMaxX = cX + radius;
            }
            if (cY - radius < this.doubleMinY) {
                this.doubleMinY = cY - radius;
            }
            if (cY + radius > this.doubleMaxY) {
                this.doubleMaxY = cY + radius;
            }
            return;
        }
        for (int i = 0; i < numPoints; ++i) {
            double x2 = this.doubleCoords[i * 2];
            double y = this.doubleCoords[i * 2 + 1];
            if (x2 < this.doubleMinX) {
                this.doubleMinX = x2;
            }
            if (x2 > this.doubleMaxX) {
                this.doubleMaxX = x2;
            }
            if (y < this.doubleMinY) {
                this.doubleMinY = y;
            }
            if (!(y > this.doubleMaxY)) continue;
            this.doubleMaxY = y;
        }
    }

    @Override
    public void addIntPoly(int numPoints, Poly.Type style, Layer layer, EGraphics graphicsOverride, PrimitivePort pp) {
        int y;
        int x2;
        int i = 0;
        if (!this.hasIntBounds) {
            x2 = this.intCoords[0];
            y = this.intCoords[1];
            this.intMinX = x2;
            this.intMinY = y;
            this.intMaxX = x2;
            this.intMaxY = y;
            this.hasIntBounds = true;
            i = 1;
        }
        while (i < numPoints) {
            x2 = this.intCoords[i * 2];
            y = this.intCoords[i * 2 + 1];
            if (x2 < this.intMinX) {
                this.intMinX = x2;
            }
            if (x2 > this.intMinY) {
                this.intMinY = x2;
            }
            if (y < this.intMinY) {
                this.intMinY = y;
            }
            if (y > this.intMaxY) {
                this.intMaxY = y;
            }
            ++i;
        }
    }

    @Override
    public void addIntBox(int[] coords, Layer layer) {
        if (!this.hasIntBounds) {
            this.intMinX = coords[0];
            this.intMinY = coords[1];
            this.intMaxX = coords[2];
            this.intMaxY = coords[3];
            this.hasIntBounds = true;
        } else {
            if (coords[0] < this.intMinX) {
                this.intMinX = coords[0];
            }
            if (coords[2] > this.intMaxX) {
                this.intMaxX = coords[2];
            }
            if (coords[1] < this.intMinY) {
                this.intMinY = coords[1];
            }
            if (coords[3] > this.intMaxY) {
                this.intMaxY = coords[3];
            }
        }
    }
}

