/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.simulation.Simulation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;

public class Silos
extends Topology {
    private static final int MAXSTR = 79;
    private static final int MAXNAME = 12;
    public static final Variable.Key SILOS_NODE_NAME_KEY = Variable.newKey("SIM_silos_node_name");
    public static final Variable.Key SILOS_GLOBAL_NAME_KEY = Variable.newKey("SIM_silos_global_name");
    public static final Variable.Key SILOS_BEHAVIOR_FILE_KEY = Variable.newKey("SIM_silos_behavior_file");
    public static final Variable.Key SILOS_MODEL_KEY = Variable.newKey("SC_silos");
    private SilosPreferences localPrefs;
    private static final int JORD = 0;
    private static final int K = 1;
    private static final int Q = 2;
    private static final int QB = 3;
    private static final int CK = 4;
    private static final int PRE = 5;
    private static final int CLR = 6;

    Silos(SilosPreferences sp) {
        this.localPrefs = sp;
    }

    protected void start() {
        this.setOutputWidth(79, true);
        this.setContinuationString("+");
        this.writeWidthLimited("\n$ CELL " + this.topCell.describe(false) + " FROM LIBRARY " + this.topCell.getLibrary().getName() + "\n");
        this.emitCopyright("$ ", "");
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.writeWidthLimited("$ CELL CREATED ON " + TextUtils.formatDate(this.topCell.getCreationDate()) + "\n");
            this.writeWidthLimited("$ VERSION " + this.topCell.getVersion() + "\n");
            this.writeWidthLimited("$ LAST REVISED " + TextUtils.formatDate(this.topCell.getRevisionDate()) + "\n");
            this.writeWidthLimited("$ SILOS netlist written by Electric VLSI Design System, version " + Version.getVersion() + "\n");
            this.writeWidthLimited("$ WRITTEN ON " + TextUtils.formatDate(new Date()) + "\n");
        } else {
            this.writeWidthLimited("$ SILOS netlist written by Electric VLSI Design System\n");
        }
        Iterator<NodeInst> it = this.topCell.getNodes();
        while (it.hasNext()) {
            PrimitiveNode.Function nodetype;
            NodeInst ni = it.next();
            if (ni.isCellInstance() || (nodetype = ni.getFunction()) != PrimitiveNode.Function.SOURCE) continue;
            Variable var = ni.getVar(SILOS_GLOBAL_NAME_KEY);
            String name = "";
            if (var != null) {
                name = var.getObject().toString();
                this.writeWidthLimited(".GLOBAL " + this.convertSpecialNames(name) + "\n");
            }
            if ((var = ni.getVar(Spice.SPICE_MODEL_KEY)) == null) {
                this.reportError("Unspecified source:");
                this.writeWidthLimited("$$$$$ Unspecified source: \n");
                continue;
            }
            boolean clktype = false;
            String msg = var.getObject().toString();
            String line = "";
            int lastChr = 0;
            block6: for (int i = 0; i < msg.length() && (lastChr = (int)msg.charAt(i)) != 47; ++i) {
                switch (lastChr) {
                    case 103: {
                        line = name + " .CLK ";
                        clktype = true;
                        continue block6;
                    }
                    case 104: {
                        line = name + " .CLK 0 S1 $ HIGH LEVEL";
                        continue block6;
                    }
                    case 108: {
                        line = name + " .CLK 0 S0 $ LOW LEVEL";
                    }
                }
            }
            if (lastChr == 47 && clktype) {
                line = line + msg.substring(msg.indexOf(47) + 1);
            }
            this.writeWidthLimited(line + "\n");
        }
    }

    protected void done() {
    }

    protected void writeCellTopology(Cell cell, Topology.CellNetInfo cni, VarContext context, Topology.MyCellInfo info) {
        PortProto pp;
        Nodable no;
        Variable var;
        Cell oCell;
        Iterator<Cell> it = cell.getCellGroup().getCells();
        while (it.hasNext()) {
            oCell = it.next();
            var = oCell.getVar(SILOS_BEHAVIOR_FILE_KEY);
            if (var == null) continue;
            String headerPath = TextUtils.getFilePath(cell.getLibrary().getLibFile());
            String fileName = headerPath + var.getObject().toString();
            File test = new File(fileName);
            if (!test.exists()) {
                this.reportError("Cannot find SILOS behavior file " + fileName + " on " + cell);
                continue;
            }
            try {
                String line;
                FileReader fr = new FileReader(test);
                BufferedReader br = new BufferedReader(fr);
                while ((line = br.readLine()) != null) {
                    this.writeWidthLimited(line + "\n");
                }
                br.close();
                fr.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        it = cell.getCellGroup().getCells();
        while (it.hasNext()) {
            oCell = it.next();
            var = oCell.getVar(SILOS_MODEL_KEY);
            if (var == null || !(var.getObject() instanceof String[])) continue;
            String[] model = (String[])var.getObject();
            for (int i = 0; i < model.length; ++i) {
                this.writeWidthLimited(model[i] + "\n");
            }
            this.writeWidthLimited("\n");
            return;
        }
        Netlist netList = cni.getNetList();
        if (cell != this.topCell) {
            this.writeWidthLimited("\n");
            String name = cni.getParameterizedName();
            if (name.length() > 12) {
                String msg = ".MACRO name " + name + " is too long;";
                name = name.substring(0, 12);
                msg = msg + " truncated to " + name;
                this.reportWarning(msg);
            }
            this.writeWidthLimited(".MACRO " + this.convertName(name));
            Iterator<Topology.CellAggregateSignal> it2 = cni.getCellAggregateSignals();
            while (it2.hasNext()) {
                Topology.CellAggregateSignal cas = it2.next();
                if (cas.getExport() == null || cas.isSupply()) continue;
                this.writeWidthLimited(" " + this.convertSubscripts(cas.getNameWithIndices()));
            }
            this.writeWidthLimited("\n");
        } else {
            this.writeWidthLimited("\n");
        }
        Iterator<Nodable> nIt = netList.getNodables();
        while (nIt.hasNext()) {
            no = nIt.next();
            if (!no.isCellInstance()) continue;
            String nodeName = this.parameterizedName(no, context);
            Topology.CellNetInfo subCni = this.getCellNetInfo(nodeName);
            this.writeWidthLimited("(" + no.getName() + " " + this.convertName(nodeName));
            Iterator<Topology.CellAggregateSignal> sIt = subCni.getCellAggregateSignals();
            while (sIt.hasNext()) {
                int high;
                Topology.CellAggregateSignal cas = sIt.next();
                if (cas.isSupply() || (pp = cas.getExport()) == null) continue;
                int low = cas.getLowIndex();
                if (low > (high = cas.getHighIndex())) {
                    Network net = netList.getNetwork(no, pp, cas.getExportIndex());
                    Topology.CellSignal cs = cni.getCellSignal(net);
                    this.writeWidthLimited(" " + cs.getName());
                    continue;
                }
                int total = high - low + 1;
                Topology.CellSignal[] outerSignalList = new Topology.CellSignal[total];
                for (int j = low; j <= high; ++j) {
                    Topology.CellSignal cInnerSig = cas.getSignal(j - low);
                    Network net = netList.getNetwork(no, cas.getExport(), cInnerSig.getExportIndex());
                    outerSignalList[j - low] = cni.getCellSignal(net);
                }
                this.writeBus(outerSignalList, low, high, cas.isDescending(), cas.getName(), cni.getPowerNet(), cni.getGroundNet());
            }
            this.writeWidthLimited("\n");
        }
        nIt = netList.getNodables();
        while (nIt.hasNext()) {
            NodeInst ni;
            PrimitiveNode.Function nodeType;
            no = nIt.next();
            if (no.isCellInstance() || (nodeType = this.getPrimitiveType(ni = (NodeInst)no)) == PrimitiveNode.Function.UNKNOWN) continue;
            if (nodeType.isFET()) {
                this.writeWidthLimited(this.getNodeInstName(ni));
                this.writeWidthLimited(" ");
                this.writeWidthLimited(this.getPrimitiveName(ni, false));
                Iterator<PortProto> pIt = ni.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto pp2 = pIt.next();
                    this.writeWidthLimited(this.getPortProtoName(cell == this.topCell, null, ni, pp2, cell, netList, cni));
                }
                this.writeWidthLimited("\n");
                continue;
            }
            if (nodeType.isFlipFlop()) {
                this.writeWidthLimited(this.getNodeInstName(ni));
                this.writeWidthLimited(" ");
                this.writeWidthLimited(this.getPrimitiveName(ni, false));
                this.writeFlipFlop(cell == this.topCell, ni, cell, nodeType, netList, cni);
                continue;
            }
            if (nodeType == PrimitiveNode.Function.METER || nodeType == PrimitiveNode.Function.SOURCE) {
                if (cell == this.topCell) continue;
                this.reportWarning("WARNING: Global Clock in a sub-cell");
                continue;
            }
            if (nodeType == PrimitiveNode.Function.GATEAND || nodeType == PrimitiveNode.Function.GATEOR || nodeType == PrimitiveNode.Function.GATEXOR || nodeType == PrimitiveNode.Function.BUFFER) {
                PortProto outPP = null;
                Iterator<PortProto> pIt = ni.getProto().getPorts();
                while (pIt.hasNext()) {
                    pp = pIt.next();
                    if (pp.getCharacteristic() != PortCharacteristic.OUT) continue;
                    this.writeWidthLimited(this.getPortProtoName(cell == this.topCell, null, ni, pp, cell, netList, cni));
                    outPP = pp;
                    Connection con = null;
                    Iterator<Connection> aIt = ni.getConnections();
                    while (aIt.hasNext()) {
                        Connection c = aIt.next();
                        if (c.getPortInst().getPortProto() != pp) continue;
                        con = c;
                        break;
                    }
                    boolean negated = false;
                    if (con != null && con.isNegated()) {
                        negated = true;
                    }
                    this.writeWidthLimited(" " + this.getPrimitiveName(ni, negated));
                    break;
                }
                if (outPP == null) {
                    this.reportError("Could not find an output connection on " + ni.getProto().getName());
                }
                this.writeWidthLimited(this.getRiseTime(ni));
                this.writeWidthLimited(this.getFallTime(ni));
                Iterator<Connection> aIt = ni.getConnections();
                while (aIt.hasNext()) {
                    Connection con = aIt.next();
                    PortProto pp3 = con.getPortInst().getPortProto();
                    if (pp3 == outPP) continue;
                    this.writeWidthLimited(this.getPortProtoName(cell == this.topCell, con, ni, pp3, cell, netList, cni));
                }
                this.writeWidthLimited("\n");
                continue;
            }
            if (nodeType == PrimitiveNode.Function.CAPAC) {
                Iterator<Connection> aIt = ni.getConnections();
                if (!aIt.hasNext()) continue;
                Connection con = aIt.next();
                pp = con.getPortInst().getPortProto();
                this.writeWidthLimited(this.getPortProtoName(cell == this.topCell, null, ni, pp, cell, netList, cni));
                this.writeWidthLimited(" " + this.getPrimitiveName(ni, false));
                double j = this.getCapacitanceInMicroFarads(ni, context);
                if (j >= 0.0) {
                    this.writeWidthLimited(" " + TextUtils.formatDouble(j, 0));
                } else {
                    this.reportWarning("Warning: capacitor with no value on " + ni);
                }
                this.writeWidthLimited("\n");
                continue;
            }
            if (nodeType != PrimitiveNode.Function.RESIST) continue;
        }
        if (cell != this.topCell) {
            this.writeWidthLimited(".EOM\n");
        }
    }

    private void writeBus(Topology.CellSignal[] outerSignalList, int lowIndex, int highIndex, boolean descending, String name, Network pwrNet, Network gndNet) {
        int j;
        boolean breakBus = false;
        for (j = lowIndex + 1; j <= highIndex; ++j) {
            Topology.CellSignal oCs;
            int k;
            Topology.CellSignal cs = outerSignalList[j - lowIndex];
            for (k = lowIndex; k < j && cs != (oCs = outerSignalList[k - lowIndex]); ++k) {
            }
            if (k < j) break;
        }
        if (j <= highIndex) {
            breakBus = true;
        } else {
            String lastnetname = null;
            for (j = lowIndex; j <= highIndex; ++j) {
                int openSquare;
                Topology.CellSignal wl = outerSignalList[j - lowIndex];
                String thisnetname = wl.getName();
                if (wl.getExport() != null && (!wl.isDescending() ? descending : !descending) || (openSquare = thisnetname.indexOf(91)) < 0) break;
                if (j > lowIndex) {
                    int lastIndex;
                    int thisIndex;
                    int li;
                    for (li = 0; li < lastnetname.length() && thisnetname.charAt(li) == lastnetname.charAt(li) && lastnetname.charAt(li) != '['; ++li) {
                    }
                    if (lastnetname.charAt(li) != '[' || thisnetname.charAt(li) != '[' || (thisIndex = TextUtils.atoi(thisnetname.substring(li + 1))) != (lastIndex = TextUtils.atoi(lastnetname.substring(li + 1))) + 1) break;
                }
                lastnetname = thisnetname;
            }
            if (j <= highIndex) {
                breakBus = true;
            }
        }
        this.writeWidthLimited(" ");
        if (breakBus) {
            int start = lowIndex;
            int end = highIndex;
            int order = 1;
            if (descending) {
                start = highIndex;
                end = lowIndex;
                order = -1;
            }
            int k = start;
            while (true) {
                if (k != start) {
                    this.writeWidthLimited("-");
                }
                Topology.CellSignal cs = outerSignalList[k - lowIndex];
                this.writeWidthLimited(cs.getName());
                if (k != end) {
                    k += order;
                    continue;
                }
                break;
            }
        } else {
            Topology.CellSignal lastCs = outerSignalList[0];
            String lastNetName = lastCs.getName();
            int openSquare = lastNetName.indexOf(91);
            Topology.CellSignal cs = outerSignalList[highIndex - lowIndex];
            String netName = cs.getName();
            int i = netName.indexOf(91);
            if (i < 0) {
                this.writeWidthLimited(netName);
            } else {
                int first;
                this.writeWidthLimited(netName.substring(0, i));
                if (descending) {
                    first = TextUtils.atoi(netName.substring(i + 1));
                    int second = TextUtils.atoi(lastNetName.substring(openSquare + 1));
                    this.writeWidthLimited("[" + first + ":" + second + "]");
                } else {
                    first = TextUtils.atoi(netName.substring(i + 1));
                    int second = TextUtils.atoi(lastNetName.substring(openSquare + 1));
                    this.writeWidthLimited("[" + second + ":" + first + "]");
                }
            }
        }
    }

    private String getPrimitiveName(NodeInst ni, boolean neg) {
        PrimitiveNode.Function f = this.getPrimitiveType(ni);
        if (f.isNTypeTransistor()) {
            return ".NMOS";
        }
        if (f.isPTypeTransistor()) {
            return ".PMOS";
        }
        if (f == PrimitiveNode.Function.BUFFER) {
            if (neg) {
                return ".INV";
            }
            return ".BUF";
        }
        if (f == PrimitiveNode.Function.GATEXOR) {
            if (neg) {
                return ".XNOR";
            }
            return ".XOR";
        }
        if (f == PrimitiveNode.Function.GATEAND) {
            if (neg) {
                return ".NAND";
            }
            return ".NAND";
        }
        if (f == PrimitiveNode.Function.GATEOR) {
            if (neg) {
                return ".NOR";
            }
            return ".OR";
        }
        if (f == PrimitiveNode.Function.RESIST) {
            return ".RES";
        }
        if (f == PrimitiveNode.Function.CAPAC) {
            return ".CAP";
        }
        if (f == PrimitiveNode.Function.FLIPFLOPRSMS || f == PrimitiveNode.Function.FLIPFLOPRSP) {
            return ".SRPEFF";
        }
        if (f == PrimitiveNode.Function.FLIPFLOPRSN) {
            return ".SRNEFF";
        }
        if (f == PrimitiveNode.Function.FLIPFLOPJKMS || f == PrimitiveNode.Function.FLIPFLOPJKP) {
            return ".JKPEFF";
        }
        if (f == PrimitiveNode.Function.FLIPFLOPJKN) {
            return ".JKNEFF";
        }
        if (f == PrimitiveNode.Function.FLIPFLOPDMS || f == PrimitiveNode.Function.FLIPFLOPDP) {
            return ".DPEFF";
        }
        if (f == PrimitiveNode.Function.FLIPFLOPDN) {
            return ".DNEFF";
        }
        if (f == PrimitiveNode.Function.FLIPFLOPTMS || f == PrimitiveNode.Function.FLIPFLOPTP) {
            return ".TPEFF";
        }
        if (f == PrimitiveNode.Function.FLIPFLOPTN) {
            return ".TNEFF";
        }
        return this.convertName(ni.getProto().getName());
    }

    private PrimitiveNode.Function getPrimitiveType(NodeInst ni) {
        if (ni.isCellInstance()) {
            return null;
        }
        PrimitiveNode.Function func = ni.getFunction();
        if (func.isPTypeTransistor()) {
            return PrimitiveNode.Function.TRAPMOS;
        }
        if (func.isNTypeTransistor()) {
            return PrimitiveNode.Function.TRANMOS;
        }
        if (func == PrimitiveNode.Function.GATEAND || func == PrimitiveNode.Function.GATEOR || func == PrimitiveNode.Function.GATEXOR || func == PrimitiveNode.Function.BUFFER || func == PrimitiveNode.Function.RESIST || func == PrimitiveNode.Function.CAPAC || func == PrimitiveNode.Function.SOURCE || func == PrimitiveNode.Function.METER || func == PrimitiveNode.Function.FLIPFLOPRSMS || func == PrimitiveNode.Function.FLIPFLOPRSP || func == PrimitiveNode.Function.FLIPFLOPRSN || func == PrimitiveNode.Function.FLIPFLOPJKMS || func == PrimitiveNode.Function.FLIPFLOPJKP || func == PrimitiveNode.Function.FLIPFLOPJKN || func == PrimitiveNode.Function.FLIPFLOPDMS || func == PrimitiveNode.Function.FLIPFLOPDP || func == PrimitiveNode.Function.FLIPFLOPDN || func == PrimitiveNode.Function.FLIPFLOPTMS || func == PrimitiveNode.Function.FLIPFLOPTP || func == PrimitiveNode.Function.FLIPFLOPTN) {
            return func;
        }
        return PrimitiveNode.Function.UNKNOWN;
    }

    private String getNodeInstName(NodeInst ni) {
        Variable var = ni.getVar(SILOS_NODE_NAME_KEY);
        if (var != null) {
            return var.describe(-1);
        }
        String name = ni.getName();
        if (name.length() > 0) {
            if (Character.isLetter(name.charAt(0))) {
                return name;
            }
            if (name.charAt(0) == '[') {
                return this.convertSubscripts(name);
            }
        }
        return "U" + name;
    }

    private String getPortProtoName(boolean top, Connection con, NodeInst ni, PortProto pp, Cell np, Netlist netList, Topology.CellNetInfo cni) {
        PortInst pi;
        if (pp.isPower() || pp.isGround()) {
            return "";
        }
        if (con == null) {
            Iterator<Connection> it = ni.getConnections();
            while (it.hasNext()) {
                Connection c = it.next();
                pi = c.getPortInst();
                if (pi.getPortProto() != pp) continue;
                con = c;
            }
        }
        boolean negated = false;
        if (con != null && con.isNegated() && pp.getCharacteristic() == PortCharacteristic.IN) {
            negated = true;
        }
        Network net = null;
        if (con != null) {
            net = netList.getNetwork(con.getArc(), 0);
        } else {
            pi = ni.findPortInstFromProto(pp);
            net = netList.getNetwork(pi);
        }
        if (net != null) {
            Topology.CellSignal cs = cni.getCellSignal(net);
            StringBuffer infstr = new StringBuffer();
            infstr.append(" ");
            if (negated) {
                infstr.append("-");
            }
            infstr.append(cs.getName());
            return infstr.toString();
        }
        return " .SKIP";
    }

    private String getRiseTime(NodeInst ni) {
        Variable var = ni.getVar(Simulation.RISE_DELAY_KEY);
        if (var != null) {
            return var.describe(-1);
        }
        return "";
    }

    private String getFallTime(NodeInst ni) {
        Variable var = ni.getVar(Simulation.FALL_DELAY_KEY);
        if (var != null) {
            return var.describe(-1);
        }
        return "";
    }

    private double getCapacitanceInMicroFarads(NodeInst ni, VarContext context) {
        Variable var = ni.getVar(Schematics.SCHEM_CAPACITANCE);
        if (var != null) {
            String cap = context.evalVar(var).toString();
            int lastChar = 0;
            int len = cap.length();
            if (len > 0) {
                lastChar = cap.charAt(len - 1);
            }
            if (lastChar == 102 || lastChar == 70) {
                cap = cap.substring(0, len - 1);
            }
            double farads = VarContext.objectToDouble(cap, 0.0);
            double microFarads = farads * 1000000.0;
            return microFarads;
        }
        return -1.0;
    }

    private void writeFlipFlop(boolean top, NodeInst ni, Cell np, PrimitiveNode.Function type, Netlist netList, Topology.CellNetInfo cni) {
        String[] portNames = new String[7];
        Iterator<PortProto> it = ni.getProto().getPorts();
        for (int i = 0; i < 7 && it.hasNext(); ++i) {
            PortProto pp = it.next();
            portNames[i] = this.getPortProtoName(top, null, ni, pp, np, netList, cni);
        }
        if (portNames[5].equals(" .SKIP") && portNames[6].equals(" .SKIP")) {
            portNames[6] = "";
            portNames[5] = "";
        }
        if (type == PrimitiveNode.Function.FLIPFLOPDMS) {
            this.writeWidthLimited(portNames[4] + portNames[0] + portNames[5] + portNames[6] + " /" + portNames[2] + portNames[3]);
        } else {
            this.writeWidthLimited(portNames[4] + portNames[0] + portNames[1] + portNames[5] + portNames[6] + " /" + portNames[2] + portNames[3]);
        }
    }

    private String convertSpecialNames(String str) {
        if (str.equals("vdd")) {
            return ".VDD";
        }
        if (str.equals("vss")) {
            return ".VSS";
        }
        if (str.equals("vcc")) {
            return ".VCC";
        }
        if (str.equals("gnd")) {
            return ".GND";
        }
        if (str.equals("low")) {
            return ".GND";
        }
        if (str.equals("hig")) {
            return ".VDD";
        }
        return str;
    }

    private String convertSubscripts(String string) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char chr = string.charAt(i);
            if (chr == '[') {
                sb.append("__");
                continue;
            }
            if (chr == ']') continue;
            sb.append(chr);
        }
        return sb.toString();
    }

    private String convertName(String p) {
        int len = p.length();
        if (len <= 0) {
            return p;
        }
        boolean defined = true;
        for (int i = 0; i < len; ++i) {
            if (Character.isDefined(p.charAt(i))) continue;
            defined = false;
            break;
        }
        if (defined && !TextUtils.isDigit(p.charAt(0))) {
            return p;
        }
        StringBuffer sb = new StringBuffer();
        if (TextUtils.isDigit(p.charAt(0))) {
            sb.append("_");
        }
        for (int i = 0; i < len; ++i) {
            char t = p.charAt(i);
            if (Character.isDefined(t)) {
                sb.append(t);
                continue;
            }
            sb.append("_");
        }
        return sb.toString();
    }

    protected String getSafeCellName(String name) {
        return name;
    }

    protected String getPowerName(Network net) {
        return ".VDD";
    }

    protected String getGroundName(Network net) {
        return ".GND";
    }

    protected String getGlobalName(Global glob) {
        return glob.getName();
    }

    protected boolean isNetworksUseExportedNames() {
        return true;
    }

    protected boolean isLibraryNameAlwaysAddedToCellName() {
        return false;
    }

    protected boolean isAggregateNamesSupported() {
        return true;
    }

    protected boolean isAggregateNameGapsSupported() {
        return false;
    }

    protected boolean isSeparateInputAndOutput() {
        return true;
    }

    protected boolean isCaseSensitive() {
        return true;
    }

    protected String getSafeNetName(String name, boolean bus) {
        return name;
    }

    protected Netlist.ShortResistors getShortResistors() {
        return Netlist.ShortResistors.ALL;
    }

    protected boolean canParameterizeNames() {
        return true;
    }

    public static class SilosPreferences
    extends Output.OutputPreferences {
        public SilosPreferences(boolean factory) {
            super(factory);
        }

        public Output doOutput(Cell cell, VarContext context, String filePath) {
            Silos out = new Silos(this);
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            if (out.writeCell(cell, context)) {
                return out.finishWrite();
            }
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }
}

