/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import java.awt.geom.Rectangle2D;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class PortInst
extends ElectricObject {
    private final NodeInst nodeInst;
    private final PortProto portProto;

    private PortInst(PortProto portProto, NodeInst nodeInst) {
        this.portProto = portProto;
        this.nodeInst = nodeInst;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.nodeInst.getProto() != this.portProto.getParent()) {
            throw new InvalidObjectException("PortInst");
        }
        PortInst pi = this.nodeInst.findPortInstFromProto(this.portProto);
        if (pi == null) {
            throw new InvalidObjectException("PortInst");
        }
        return pi;
    }

    @Override
    public ImmutablePortInst getD() {
        return this.nodeInst.getD().getPortInst(this.portProto.getId());
    }

    @Override
    public void addVar(Variable var) {
        this.nodeInst.addVar(this.portProto.getId(), var);
    }

    @Override
    public void delVar(Variable.Key key) {
        this.nodeInst.delVar(this.portProto.getId(), key);
    }

    public void delVars() {
        this.nodeInst.delVars(this.portProto.getId());
        assert (this.getNumVariables() == 0);
    }

    public static PortInst newInstance(PortProto portProto, NodeInst nodeInst) {
        PortInst pi = new PortInst(portProto, nodeInst);
        return pi;
    }

    public NodeInst getNodeInst() {
        return this.nodeInst;
    }

    public PortProto getPortProto() {
        return this.portProto;
    }

    public final int getPortIndex() {
        return this.portProto.getPortIndex();
    }

    public boolean hasConnections() {
        return this.nodeInst.hasConnections(this.portProto.getChronIndex());
    }

    public Iterator<Connection> getConnections() {
        return this.nodeInst.getConnections(this.portProto.getChronIndex());
    }

    public Iterator<Export> getExports() {
        ArrayList<Export> exports = new ArrayList<Export>();
        Iterator<Export> it = this.nodeInst.getExports();
        while (it.hasNext()) {
            Export e = it.next();
            if (e.getOriginalPort() != this) continue;
            exports.add(e);
        }
        return exports.iterator();
    }

    public PortProto getProtoEquivalent() {
        return this.portProto instanceof Export ? ((Export)this.portProto).getEquivalent() : this.portProto;
    }

    public Rectangle2D getBounds() {
        return this.getPoly().getBounds2D();
    }

    public EPoint getCenter() {
        return this.getPoly().getCenter();
    }

    public Poly getPoly() {
        return this.nodeInst.getShapeOfPort(this.portProto);
    }

    @Override
    public int addDisplayableVariables(Rectangle2D rect, Poly[] polys, int start, EditWindow0 wnd, boolean multipleStrings) {
        if (super.numDisplayableVariables(multipleStrings) == 0) {
            return 0;
        }
        Poly portPoly = this.getPoly();
        int justAdded = super.addDisplayableVariables(portPoly.getBounds2D(), polys, start, wnd, multipleStrings);
        for (int i = 0; i < justAdded; ++i) {
            polys[start + i].setPort(this.getPortProto());
        }
        return justAdded;
    }

    public String describe(boolean withQuotes) {
        String info = this.nodeInst.describe(false) + "." + this.portProto.getName();
        return withQuotes ? "'" + info + "'" : info;
    }

    @Override
    public String toString() {
        return "port " + this.describe(true);
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Poly noPoly;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PortInst no = (PortInst)obj;
        HashSet<Connection> noCheckAgain = new HashSet<Connection>();
        Iterator<Connection> it = this.getConnections();
        while (it.hasNext()) {
            Connection c = it.next();
            boolean found = false;
            Iterator<Connection> noIt = no.getConnections();
            while (noIt.hasNext()) {
                Connection noC = noIt.next();
                if (noCheckAgain.contains(noC) || !c.getLocation().equals(noC.getLocation())) continue;
                found = true;
                noCheckAgain.add(noC);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding port " + this + " found in " + no + " at the location " + c.getLocation() + " \n");
            }
            return false;
        }
        Poly poly = this.getPoly();
        boolean check = poly.compare(noPoly = no.getPoly(), buffer);
        if (!check && buffer != null) {
            buffer.append("No same ports detected in " + this.portProto.getName() + " and " + no.getPortProto().getName() + "\n");
        }
        return check;
    }

    @Override
    public boolean isLinked() {
        try {
            return this.nodeInst != null && this.nodeInst.isLinked() && this.nodeInst.getPortInst(this.getPortIndex()) == this;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public EDatabase getDatabase() {
        return this.nodeInst.getDatabase();
    }

    public Poly computeTextPoly(EditWindow0 wnd, Variable var, Name name) {
        Rectangle2D bounds;
        Poly[] polys;
        Poly poly = null;
        if (var != null && (polys = this.getPolyList(var, (bounds = this.getPoly().getBounds2D()).getCenterX(), bounds.getCenterY(), wnd, false)).length > 0) {
            poly = polys[0];
            poly.transform(this.getNodeInst().rotateOut());
        }
        if (poly != null) {
            poly.setExactTextBounds(wnd, this);
        }
        return poly;
    }
}

