/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.Main;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class ErrorLogger
implements ActionListener,
DatabaseChangeListener {
    private static final int ERRORTYPEGEOM = 1;
    private static final int ERRORTYPEEXPORT = 2;
    private static final int ERRORTYPELINE = 3;
    private static final int ERRORTYPETHICKLINE = 4;
    private static final int ERRORTYPEPOINT = 5;
    private static ErrorLogger currentLogger;
    private static List allLoggers;
    private boolean alreadyExplained;
    private int errorLimit;
    private List allErrors;
    private List allWarnings;
    private int currentLogNumber;
    private boolean limitExceeded;
    private String errorSystem;
    private boolean terminated;
    private boolean persistent;
    private HashMap sortKeysToGroupNames;
    private static String errorNode;

    private ErrorLogger() {
    }

    public static synchronized ErrorLogger newInstance(String system) {
        return ErrorLogger.newInstance(system, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorLogger newInstance(String system, boolean persistent) {
        ErrorLogger logger = new ErrorLogger();
        logger.allErrors = new ArrayList();
        logger.allWarnings = new ArrayList();
        logger.limitExceeded = false;
        logger.currentLogNumber = -1;
        logger.errorSystem = system;
        logger.errorLimit = User.getErrorLimit();
        logger.terminated = false;
        logger.persistent = persistent;
        logger.alreadyExplained = false;
        logger.sortKeysToGroupNames = null;
        List list = allLoggers;
        synchronized (list) {
            if (currentLogger == null) {
                currentLogger = logger;
            }
            allLoggers.add(logger);
        }
        Undo.addDatabaseChangeListener(logger);
        return logger;
    }

    public synchronized MessageLog logError(String message, Cell cell, int sortKey) {
        if (this.terminated && !this.persistent) {
            System.out.println("WARNING: " + this.errorSystem + " already terminated, should not log new error");
        }
        if (this.errorLimit > 0 && this.getNumErrors() >= this.errorLimit) {
            if (!this.limitExceeded) {
                System.out.println("WARNING: more than " + this.errorLimit + " errors found, ignoring the rest");
                this.limitExceeded = true;
            }
            return null;
        }
        MessageLog el = new MessageLog(message, cell, sortKey);
        el.highlights = new ArrayList();
        this.allErrors.add(el);
        this.currentLogNumber = this.allErrors.size() - 1;
        if (this.persistent) {
            WindowFrame.wantToRedoErrorTree();
        }
        return el;
    }

    public synchronized MessageLog logWarning(String message, Cell cell, int sortKey) {
        if (this.terminated && !this.persistent) {
            System.out.println("WARNING: " + this.errorSystem + " already terminated, should not log new warning");
        }
        if (this.errorLimit > 0 && this.getNumWarnings() >= this.errorLimit) {
            if (!this.limitExceeded) {
                System.out.println("WARNING: more than " + this.errorLimit + " warnings found, ignoring the rest");
                this.limitExceeded = true;
            }
            return null;
        }
        WarningLog el = new WarningLog(message, cell, sortKey);
        ((MessageLog)el).highlights = new ArrayList();
        this.allWarnings.add(el);
        if (this.persistent) {
            WindowFrame.wantToRedoErrorTree();
        }
        return el;
    }

    public synchronized boolean findMessage(Cell cell, Geometric geom1, Cell cell2, Geometric geom2, boolean searchInError) {
        if (searchInError) {
            for (int i = 0; i < this.allErrors.size(); ++i) {
                MessageLog el = (MessageLog)this.allErrors.get(i);
                if (!el.findGeometries(geom1, cell, geom2, cell2)) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.allWarnings.size(); ++i) {
                MessageLog el = (MessageLog)this.allWarnings.get(i);
                if (!el.findGeometries(geom1, cell, geom2, cell2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorLogger getCurrent() {
        List list = allLoggers;
        synchronized (list) {
            if (currentLogger == null) {
                return ErrorLogger.newInstance("Unknown");
            }
            return currentLogger;
        }
    }

    public synchronized void clearLogs(Cell cell) {
        MessageLog log;
        ArrayList<MessageLog> trimmedLogs = new ArrayList<MessageLog>();
        Iterator it = this.allErrors.iterator();
        while (it.hasNext()) {
            log = (MessageLog)it.next();
            if (log.logCell == cell) continue;
            trimmedLogs.add(log);
        }
        this.allErrors = trimmedLogs;
        trimmedLogs = new ArrayList();
        it = this.allWarnings.iterator();
        while (it.hasNext()) {
            log = (MessageLog)it.next();
            if (log.logCell == cell) continue;
            trimmedLogs.add(log);
        }
        this.allWarnings = trimmedLogs;
        this.currentLogNumber = this.getNumLogs() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete() {
        if (this.persistent) {
            this.allErrors.clear();
            this.allWarnings.clear();
            this.currentLogNumber = -1;
            WindowFrame.wantToRedoErrorTree();
            return;
        }
        List list = allLoggers;
        synchronized (list) {
            allLoggers.remove(this);
            if (currentLogger == this) {
                currentLogger = allLoggers.size() > 0 ? (ErrorLogger)allLoggers.get(0) : null;
            }
        }
        Undo.removeDatabaseChangeListener(this);
        WindowFrame.wantToRedoErrorTree();
    }

    public void save() {
        MessageLog log;
        PrintStream buffWriter = null;
        String filePath = null;
        try {
            filePath = OpenFile.chooseOutputFile(FileType.TEXT, null, "ErrorLoggerSave.txt");
            if (filePath == null) {
                return;
            }
            buffWriter = new PrintStream(new FileOutputStream(filePath));
        }
        catch (IOException e) {
            System.out.println("Error creating " + filePath);
            return;
        }
        Iterator it = this.allErrors.iterator();
        while (it.hasNext()) {
            log = (MessageLog)it.next();
            buffWriter.println(log.getMessage());
        }
        it = this.allWarnings.iterator();
        while (it.hasNext()) {
            log = (MessageLog)it.next();
            buffWriter.println(log.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String describe() {
        List list = allLoggers;
        synchronized (list) {
            if (currentLogger == this) {
                return this.errorSystem + " [Current]";
            }
        }
        return this.errorSystem;
    }

    public void setGroupName(int sortKey, String groupName) {
        if (this.sortKeysToGroupNames == null) {
            this.sortKeysToGroupNames = new HashMap();
        }
        this.sortKeysToGroupNames.put(new Integer(sortKey), groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void termLogging(boolean explain) {
        MessageLog el;
        int errs = 0;
        Iterator it = this.allErrors.iterator();
        while (it.hasNext()) {
            el = (MessageLog)it.next();
            el.index = ++errs;
        }
        it = this.allWarnings.iterator();
        while (it.hasNext()) {
            el = (MessageLog)it.next();
            el.index = ++errs;
        }
        List list = allLoggers;
        synchronized (list) {
            currentLogger = this;
        }
        if (errs == 0) {
            this.delete();
            return;
        }
        if (errs > 0 && explain && !this.alreadyExplained) {
            this.alreadyExplained = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String extraMsg = "errors/warnings";
                    if (ErrorLogger.this.getNumErrors() == 0) {
                        extraMsg = "warnings";
                    } else if (ErrorLogger.this.getNumWarnings() == 0) {
                        extraMsg = "errors";
                    }
                    String msg = ErrorLogger.this.getInfo();
                    System.out.println(msg);
                    if (ErrorLogger.this.getNumLogs() > 0) {
                        System.out.println("Type > and < to step through " + extraMsg + ", or open the ERRORS view in the explorer");
                    }
                    if (ErrorLogger.this.getNumErrors() > 0 && !Main.BATCHMODE) {
                        JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), msg, ErrorLogger.this.errorSystem + " finished with Errors", 1);
                    }
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WindowFrame.wantToRedoErrorTree();
            }
        });
        this.terminated = true;
    }

    private String getInfo() {
        return this.errorSystem + " found " + this.getNumErrors() + " errors, " + this.getNumWarnings() + " warnings!";
    }

    public synchronized void sortLogs() {
        Collections.sort(this.allErrors, new ErrorLogOrder());
        Collections.sort(this.allWarnings, new ErrorLogOrder());
    }

    public static String reportNextMessage() {
        return ErrorLogger.reportNextMessage(true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String reportNextMessage(boolean showhigh, Geometric[] gPair) {
        ErrorLogger logger;
        List list = allLoggers;
        synchronized (list) {
            if (currentLogger == null) {
                return "No errors to report";
            }
            logger = currentLogger;
        }
        return logger.reportNextMessage_(showhigh, gPair);
    }

    private synchronized String reportNextMessage_(boolean showHigh, Geometric[] gPair) {
        if (this.currentLogNumber < this.getNumLogs() - 1) {
            ++this.currentLogNumber;
        } else {
            if (this.getNumLogs() <= 0) {
                return "No " + this.errorSystem + " errors";
            }
            this.currentLogNumber = 0;
        }
        return this.reportLog(this.currentLogNumber, showHigh, gPair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reportPrevMessage() {
        ErrorLogger logger;
        List list = allLoggers;
        synchronized (list) {
            if (currentLogger == null) {
                return "No errors to report";
            }
            logger = currentLogger;
        }
        return logger.reportPrevMessage_();
    }

    private synchronized String reportPrevMessage_() {
        if (this.currentLogNumber > 0) {
            --this.currentLogNumber;
        } else {
            if (this.getNumLogs() <= 0) {
                return "No " + this.errorSystem + " errors";
            }
            this.currentLogNumber = this.getNumLogs() - 1;
        }
        return this.reportLog(this.currentLogNumber, true, null);
    }

    private synchronized String reportLog(int logNumber, boolean showHigh, Geometric[] gPair) {
        if (logNumber < 0 || logNumber >= this.getNumLogs()) {
            return this.errorSystem + ": no such error or warning " + (logNumber + 1) + ", only " + this.getNumLogs() + " errors.";
        }
        MessageLog el = null;
        String extraMsg = null;
        if (logNumber < this.getNumErrors()) {
            el = (MessageLog)this.allErrors.get(logNumber);
            extraMsg = " error " + (logNumber + 1) + " of " + this.allErrors.size();
        } else {
            el = (MessageLog)this.allWarnings.get(logNumber - this.allErrors.size());
            extraMsg = " warning " + (logNumber + 1 - this.allErrors.size()) + " of " + this.allWarnings.size();
        }
        String message = el.reportLog(showHigh, gPair);
        return this.errorSystem + extraMsg + ": " + message;
    }

    public synchronized int getNumErrors() {
        return this.allErrors.size();
    }

    public synchronized int getNumWarnings() {
        return this.allWarnings.size();
    }

    public synchronized int getNumLogs() {
        return this.getNumWarnings() + this.getNumErrors();
    }

    private synchronized Iterator getLogs() {
        ArrayList copy = new ArrayList();
        Iterator it = this.allErrors.iterator();
        while (it.hasNext()) {
            copy.add(it.next());
        }
        it = this.allWarnings.iterator();
        while (it.hasNext()) {
            copy.add(it.next());
        }
        return copy.iterator();
    }

    private synchronized void deleteLog(MessageLog error) {
        boolean found = this.allErrors.remove(error);
        boolean bl = found = !found ? this.allWarnings.remove(error) : found;
        if (!found) {
            System.out.println(this.errorSystem + ": Does not contain error/warning to delete");
        }
        if (this.currentLogNumber >= this.getNumLogs()) {
            this.currentLogNumber = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllLoggers() {
        ArrayList loggersCopy = new ArrayList();
        List list = allLoggers;
        synchronized (list) {
            loggersCopy.addAll(allLoggers);
        }
        Iterator eit = loggersCopy.iterator();
        while (eit.hasNext()) {
            ErrorLogger log = (ErrorLogger)eit.next();
            log.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultMutableTreeNode getExplorerTree() {
        DefaultMutableTreeNode explorerTree = new DefaultMutableTreeNode(errorNode);
        ArrayList loggersCopy = new ArrayList();
        List list = allLoggers;
        synchronized (list) {
            loggersCopy.addAll(allLoggers);
        }
        Iterator eit = loggersCopy.iterator();
        while (eit.hasNext()) {
            DefaultMutableTreeNode loggerNode;
            ErrorLogger logger = (ErrorLogger)eit.next();
            if (logger.getNumErrors() == 0 && logger.getNumWarnings() == 0) continue;
            DefaultMutableTreeNode groupNode = loggerNode = new DefaultMutableTreeNode(logger);
            int currentSortKey = -1;
            Iterator it = logger.getLogs();
            while (it.hasNext()) {
                MessageLog el = (MessageLog)it.next();
                if (logger.sortKeysToGroupNames != null && currentSortKey != el.sortKey) {
                    currentSortKey = el.sortKey;
                    String groupName = (String)logger.sortKeysToGroupNames.get(new Integer(el.sortKey));
                    if (groupName != null) {
                        groupNode = new DefaultMutableTreeNode(groupName);
                        loggerNode.add(groupNode);
                    } else {
                        groupNode = loggerNode;
                    }
                }
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(el);
                groupNode.add(node);
            }
            explorerTree.add(loggerNode);
        }
        return explorerTree;
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu p = new JPopupMenu();
        JMenuItem m = new JMenuItem("Delete");
        m.addActionListener(this);
        p.add(m);
        m = new JMenuItem("Get Info");
        m.addActionListener(this);
        p.add(m);
        m = new JMenuItem("Save");
        m.addActionListener(this);
        p.add(m);
        m = new JMenuItem("Set Current");
        m.addActionListener(this);
        p.add(m);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem m = (JMenuItem)e.getSource();
            if (m.getText().equals("Delete")) {
                this.delete();
            } else if (m.getText().equals("Save")) {
                this.save();
            } else if (m.getText().equals("Get Info")) {
                System.out.println("ErrorLogger Information: " + this.getInfo());
            } else if (m.getText().equals("Set Current")) {
                List list = allLoggers;
                synchronized (list) {
                    currentLogger = this;
                }
                WindowFrame.wantToRedoErrorTree();
            }
        }
    }

    public void databaseChanged(DatabaseChangeEvent e) {
        boolean changed = false;
        Iterator it = this.getLogs();
        while (it.hasNext()) {
            MessageLog err = (MessageLog)it.next();
            if (err.isValid()) continue;
            this.deleteLog(err);
            changed = true;
        }
        if (changed) {
            WindowFrame.wantToRedoErrorTree();
        }
    }

    static {
        allLoggers = new ArrayList();
        errorNode = "ERRORS";
    }

    private static class ErrorLogOrder
    implements Comparator {
        private ErrorLogOrder() {
        }

        public int compare(Object o1, Object o2) {
            MessageLog el1 = (MessageLog)o1;
            MessageLog el2 = (MessageLog)o2;
            int sortedKey = el1.sortKey - el2.sortKey;
            if (sortedKey == 0) {
                sortedKey = el1.compareTo(el2);
            }
            return sortedKey;
        }
    }

    public static class WarningLog
    extends MessageLog {
        private WarningLog(String message, Cell cell, int sortKey) {
            super(message, cell, sortKey);
        }
    }

    public static class MessageLog
    implements Comparable {
        private String message;
        private int sortKey;
        private int index;
        private Cell logCell;
        private List highlights;

        private MessageLog(String message, Cell cell, int sortKey) {
            this.message = message;
            this.sortKey = sortKey;
            this.logCell = cell;
            this.index = 0;
            this.highlights = new ArrayList();
        }

        public int compareTo(Object o1) {
            MessageLog log1 = (MessageLog)o1;
            return String.CASE_INSENSITIVE_ORDER.compare(this.message, log1.message);
        }

        public void addGeom(Geometric geom, boolean showit, Cell cell, VarContext context) {
            ErrorHighlight eh = new ErrorHighlight();
            eh.type = 1;
            eh.geom = geom;
            eh.showgeom = showit;
            eh.cell = cell;
            eh.context = context;
            this.highlights.add(eh);
        }

        public void addExport(Export pp, boolean showit, Cell cell, VarContext context) {
            ErrorHighlight eh = new ErrorHighlight();
            eh.type = 2;
            eh.pp = pp;
            eh.showgeom = showit;
            eh.cell = cell;
            eh.context = context;
            this.highlights.add(eh);
        }

        public void addLine(double x1, double y1, double x2, double y2, Cell cell) {
            ErrorHighlight eh = new ErrorHighlight();
            eh.type = 3;
            eh.x1 = x1;
            eh.y1 = y1;
            eh.x2 = x2;
            eh.y2 = y2;
            eh.cell = cell;
            eh.context = null;
            this.highlights.add(eh);
        }

        public void addPoly(PolyBase poly, boolean thick, Cell cell) {
            Point2D[] points = poly.getPoints();
            Point2D.Double center = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
            for (int i = 0; i < points.length; ++i) {
                int prev = i - 1;
                if (i == 0) {
                    prev = points.length - 1;
                }
                ErrorHighlight eh = new ErrorHighlight();
                eh.type = thick ? 4 : 3;
                eh.x1 = points[prev].getX();
                eh.y1 = points[prev].getY();
                eh.x2 = points[i].getX();
                eh.y2 = points[i].getY();
                eh.cX = ((Point2D)center).getX();
                eh.cY = ((Point2D)center).getY();
                eh.cell = cell;
                eh.context = null;
                this.highlights.add(eh);
            }
        }

        public void addPoint(double x, double y, Cell cell) {
            ErrorHighlight eh = new ErrorHighlight();
            eh.type = 5;
            eh.x1 = x;
            eh.y1 = y;
            eh.cell = cell;
            eh.context = null;
            this.highlights.add(eh);
        }

        public int getNumGeoms() {
            int total = 0;
            Iterator it = this.highlights.iterator();
            while (it.hasNext()) {
                ErrorHighlight eh = (ErrorHighlight)it.next();
                if (eh.type != 1) continue;
                ++total;
            }
            return total;
        }

        public boolean findGeometries(Geometric geo1, Cell cell1, Geometric geo2, Cell cell2) {
            boolean eh1found = false;
            boolean eh2found = false;
            Iterator it = this.highlights.iterator();
            while (it.hasNext()) {
                ErrorHighlight eh = (ErrorHighlight)it.next();
                if (eh.type != 1) continue;
                if (!eh1found && eh.cell == cell1 && eh.geom == geo1) {
                    eh1found = true;
                }
                if (!eh2found && eh.cell == cell2 && eh.geom == geo2) {
                    eh2found = true;
                }
                if (!eh1found || !eh2found) continue;
                return true;
            }
            return false;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isValid() {
            if (this.logCell == null) {
                return true;
            }
            if (!this.logCell.isLinked()) {
                return false;
            }
            boolean allValid = true;
            Iterator it = this.highlights.iterator();
            while (it.hasNext()) {
                ErrorHighlight erh = (ErrorHighlight)it.next();
                if (erh.isValid()) continue;
                allValid = false;
                break;
            }
            return allValid;
        }

        public String reportLog(boolean showhigh, Geometric[] gPair) {
            ErrorHighlight eh;
            Iterator it;
            if (gPair != null) {
                Geometric geom1 = null;
                Geometric geom2 = null;
                it = this.highlights.iterator();
                while (it.hasNext()) {
                    eh = (ErrorHighlight)it.next();
                    if (eh.type != 1) continue;
                    if (geom1 == null) {
                        geom1 = eh.geom;
                        continue;
                    }
                    if (geom2 != null) continue;
                    geom2 = eh.geom;
                }
                if (geom1 != null) {
                    gPair[0] = geom1;
                }
                if (geom2 != null) {
                    gPair[1] = geom2;
                }
            }
            if (showhigh) {
                Highlighter highlighter = null;
                EditWindow wnd = null;
                it = this.highlights.iterator();
                while (it.hasNext()) {
                    eh = (ErrorHighlight)it.next();
                    Cell cell = eh.cell;
                    if (cell != null) {
                        if (!cell.isLinked()) {
                            return "(cell deleted): " + this.message;
                        }
                        boolean found = false;
                        Iterator it2 = WindowFrame.getWindows();
                        while (it2.hasNext()) {
                            WindowFrame wf = (WindowFrame)it2.next();
                            WindowContent content = wf.getContent();
                            if (!(content instanceof EditWindow) || (wnd = (EditWindow)content).getCell() != cell || (eh.context == null || !eh.context.equals(wnd.getVarContext())) && eh.context != null) continue;
                            wf.getFrame().toFront();
                            found = true;
                            break;
                        }
                        if (!found) {
                            WindowFrame wf = WindowFrame.createEditWindow(cell);
                            wnd = (EditWindow)wf.getContent();
                            wnd.setCell(eh.cell, eh.context);
                        }
                        if (highlighter == null) {
                            highlighter = wnd.getHighlighter();
                            highlighter.clear();
                        }
                    }
                    if (highlighter == null) continue;
                    switch (eh.type) {
                        case 1: {
                            if (!eh.showgeom) break;
                            highlighter.addElectricObject(eh.geom, cell);
                            break;
                        }
                        case 2: {
                            highlighter.addText(eh.pp, cell, null, null);
                            break;
                        }
                        case 3: {
                            highlighter.addLine(new Point2D.Double(eh.x1, eh.y1), new Point2D.Double(eh.x2, eh.y2), cell);
                            break;
                        }
                        case 4: {
                            highlighter.addThickLine(new Point2D.Double(eh.x1, eh.y1), new Point2D.Double(eh.x2, eh.y2), new Point2D.Double(eh.cX, eh.cY), cell);
                            break;
                        }
                        case 5: {
                            double consize = 5.0;
                            highlighter.addLine(new Point2D.Double(eh.x1 - consize, eh.y1 - consize), new Point2D.Double(eh.x1 + consize, eh.y1 + consize), cell);
                            highlighter.addLine(new Point2D.Double(eh.x1 - consize, eh.y1 + consize), new Point2D.Double(eh.x1 + consize, eh.y1 - consize), cell);
                        }
                    }
                }
                if (highlighter != null) {
                    highlighter.ensureHighlightingSeen();
                    highlighter.finished();
                    Rectangle2D hBounds = highlighter.getHighlightedArea(wnd);
                    Rectangle2D shown = wnd.getDisplayedBounds();
                    if (!shown.intersects(hBounds)) {
                        wnd.focusOnHighlighted();
                    }
                }
            }
            return this.message;
        }
    }

    private static class ErrorHighlight {
        int type;
        Geometric geom;
        Export pp;
        boolean showgeom;
        double x1;
        double y1;
        double x2;
        double y2;
        double cX;
        double cY;
        Cell cell;
        VarContext context;

        private ErrorHighlight() {
        }

        public String describe() {
            String msg = this.geom instanceof NodeInst ? "Node " + this.geom.describe(true) : "Arc " + this.geom.describe(true);
            msg = msg + " in " + this.context.getInstPath(".");
            return msg;
        }

        public boolean isValid() {
            if (this.type == 2) {
                return this.pp.isLinked();
            }
            if (this.type == 1) {
                return this.geom.isLinked();
            }
            return this.cell.isLinked();
        }
    }
}

