/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Iterator;

public class StratRandomMatch
extends Strategy {
    private static final Integer CODE_FIRST = new Integer(1);
    private static final Integer CODE_REST = new Integer(2);

    private StratRandomMatch(NccGlobals globals) {
        super(globals);
    }

    private EquivRecord findSmallestActive(Iterator frontier) {
        int minSz = Integer.MAX_VALUE;
        EquivRecord minRec = null;
        while (frontier.hasNext()) {
            int sz;
            EquivRecord r = (EquivRecord)frontier.next();
            if (r.isMismatched() || (sz = r.maxSize()) >= minSz) continue;
            minSz = sz;
            minRec = r;
        }
        return minRec;
    }

    private EquivRecord findSmallestActive() {
        EquivRecord w = this.findSmallestActive(this.globals.getWireLeafEquivRecs().getNotMatched());
        EquivRecord p = this.findSmallestActive(this.globals.getPartLeafEquivRecs().getNotMatched());
        if (p == null) {
            return w;
        }
        if (w == null) {
            return p;
        }
        return p.maxSize() < w.maxSize() ? p : w;
    }

    private LeafList doYourJob() {
        EquivRecord smallest = this.findSmallestActive();
        if (smallest == null) {
            return new LeafList();
        }
        return this.doFor(smallest);
    }

    public Integer doFor(NetObject n) {
        Circuit ckt = n.getParent();
        Iterator ni = ckt.getNetObjs();
        Object first = ni.next();
        return n == first ? CODE_FIRST : CODE_REST;
    }

    public static LeafList doYourJob(NccGlobals globals) {
        StratRandomMatch rm = new StratRandomMatch(globals);
        return rm.doYourJob();
    }
}

