/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.interval;

import java.math.BigDecimal;

public class MutableInterval {
    private double inf;
    private double sup;
    private static final double ULP_EPS = 1.6653345369377348E-16;
    private static final double SCALE_DOWN = 0.9999999999999999;
    private static final double MIN_NORMAL = Double.MIN_NORMAL;
    private static final double ULP_EPS_NORMAL = 1.3361122400059818E-292;
    private static final double MAX_ULP = 1.99584030953472E292;
    private static final long EXACT_LONG = 0x20000000000000L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MutableInterval() {
    }

    public MutableInterval(int x) {
        this.assign(x);
    }

    public MutableInterval(long x) {
        this.assign(x);
    }

    public MutableInterval(double x) {
        this.assign(x);
    }

    public MutableInterval(int inf, int sup) {
        this.assign(inf, sup);
    }

    public MutableInterval(long inf, long sup) {
        this.assign(inf, sup);
    }

    public MutableInterval(double inf, double sup) {
        this.assign(inf, sup);
    }

    public MutableInterval(MutableInterval x) {
        this.assign(x);
    }

    public MutableInterval(String s) {
        this.assign(s);
    }

    public MutableInterval(char[] b) {
        this.assign(b);
    }

    public MutableInterval assign(int x) {
        this.inf = this.sup = (double)x;
        return this;
    }

    public MutableInterval assign(long x) {
        double xd;
        this.inf = this.sup = (xd = (double)x);
        if (Math.abs(x) > 0x20000000000000L) {
            long xx = (long)xd;
            if (xx > x || x == Long.MAX_VALUE) {
                this.inf = MutableInterval.prev(xd);
            } else if (xx < x) {
                this.sup = MutableInterval.next(xd);
            }
        }
        return this;
    }

    public MutableInterval assign(double x) {
        this.inf = this.sup = x;
        if (x == Double.POSITIVE_INFINITY) {
            this.inf = Double.MAX_VALUE;
        } else if (x == Double.NEGATIVE_INFINITY) {
            this.sup = -1.7976931348623157E308;
        } else if (x != x) {
            this.assignEntire();
        }
        return this;
    }

    public MutableInterval assign(int inf, int sup) {
        if (inf <= sup) {
            this.inf = inf;
            this.sup = sup;
        } else {
            this.assignEntire();
        }
        return this;
    }

    public MutableInterval assign(long inf, long sup) {
        if (inf <= sup) {
            this.inf = inf;
            this.sup = sup;
            if (inf < -9007199254740992L || sup > 0x20000000000000L) {
                if ((long)this.inf > inf || inf == Long.MAX_VALUE) {
                    this.inf = MutableInterval.prev(this.inf);
                }
                if ((long)this.sup < sup) {
                    this.sup = MutableInterval.next(this.sup);
                }
            }
        } else {
            this.assignEntire();
        }
        return this;
    }

    public MutableInterval assign(double inf, double sup) {
        if (inf <= sup) {
            this.inf = inf == Double.POSITIVE_INFINITY ? Double.MAX_VALUE : inf;
            this.sup = sup == Double.NEGATIVE_INFINITY ? -1.7976931348623157E308 : sup;
        } else {
            this.assignEntire();
        }
        return this;
    }

    public MutableInterval assign(MutableInterval x) {
        this.inf = x.inf;
        this.sup = x.sup;
        return this;
    }

    public MutableInterval assign(String s) {
        this.parse(s);
        return this;
    }

    public MutableInterval assign(char[] b) {
        this.parse(new String(b));
        return this;
    }

    public MutableInterval clon() {
        try {
            return (MutableInterval)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return new MutableInterval(this.inf, this.sup);
        }
    }

    public MutableInterval assignEntire() {
        this.inf = Double.NEGATIVE_INFINITY;
        this.sup = Double.POSITIVE_INFINITY;
        return this;
    }

    public MutableInterval assignEmpty() {
        this.sup = Double.NaN;
        this.inf = Double.NaN;
        return this;
    }

    public double inf() {
        return this.inf;
    }

    public double sup() {
        return this.sup;
    }

    public boolean isPoint() {
        return this.inf == this.sup;
    }

    public boolean isDegenerate() {
        return this.inf == this.sup;
    }

    public boolean isEmpty() {
        return this.inf != this.inf;
    }

    public boolean isInfinite() {
        return this.inf == Double.NEGATIVE_INFINITY || this.sup == Double.POSITIVE_INFINITY;
    }

    public boolean hasUlpAcc(int n) {
        if (this.isInfinite()) {
            return false;
        }
        double x = this.inf;
        int i = 0;
        while (i++ < n && x < this.sup) {
            x = MutableInterval.next(x);
        }
        return x == this.sup;
    }

    public boolean isEntire() {
        return -this.inf == this.sup && this.sup == Double.POSITIVE_INFINITY;
    }

    public static boolean isExtended() {
        return true;
    }

    public static boolean isNative() {
        return false;
    }

    public double mid() {
        double mid = 0.5 * (this.inf + this.sup);
        if (mid > Double.NEGATIVE_INFINITY && mid < Double.POSITIVE_INFINITY) {
            return mid;
        }
        return -this.inf == this.sup ? 0.0 : 0.5 * this.inf + 0.5 * this.sup;
    }

    public double wid() {
        return MutableInterval.addPosUp(this.sup, -this.inf);
    }

    public double rad() {
        double mid = (this.inf + this.sup) * 0.5;
        if (!(mid > Double.NEGATIVE_INFINITY) || !(mid < Double.POSITIVE_INFINITY)) {
            if (this.inf == Double.NEGATIVE_INFINITY || this.sup == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            mid = 0.5 * this.inf + 0.5 * this.sup;
        }
        return Math.max(MutableInterval.addPosUp(this.sup, -mid), MutableInterval.addPosUp(mid, -this.inf));
    }

    public double mig() {
        return this.inf <= 0.0 && this.sup >= 0.0 ? 0.0 : (this.inf < 0.0 ? -this.sup : this.inf);
    }

    public double mag() {
        return -this.inf > this.sup ? -this.inf : this.sup;
    }

    public MutableInterval abs() {
        if (this.sup <= 0.0) {
            double h = this.sup;
            this.sup = -this.inf;
            this.inf = -h;
        } else if (this.inf < 0.0) {
            if (-this.inf > this.sup) {
                this.sup = -this.inf;
            }
            this.inf = 0.0;
        }
        return this;
    }

    public MutableInterval min(MutableInterval y) {
        if (this.inf != this.inf) {
            return this;
        }
        this.inf = this.inf < y.inf ? this.inf : y.inf;
        this.sup = this.sup < y.sup ? this.sup : y.sup;
        return this;
    }

    public MutableInterval max(MutableInterval y) {
        if (this.inf != this.inf) {
            return this;
        }
        this.inf = this.inf > y.inf ? this.inf : y.inf;
        this.sup = this.sup > y.sup ? this.sup : y.sup;
        return this;
    }

    double dist(MutableInterval x) {
        if (this.isEmpty() || x.isEmpty()) {
            return Double.NaN;
        }
        if (this.inf == x.inf && this.sup == x.sup) {
            return 0.0;
        }
        if (this.isInfinite() || x.isInfinite()) {
            return Double.POSITIVE_INFINITY;
        }
        double dinf = this.inf > x.inf ? MutableInterval.addPosUp(this.inf, -x.inf) : MutableInterval.addPosUp(-this.inf, x.inf);
        double dsup = this.sup > x.sup ? MutableInterval.addPosUp(this.sup, -x.sup) : MutableInterval.addPosUp(-this.sup, x.sup);
        return Math.max(dinf, dsup);
    }

    public MutableInterval intersect(MutableInterval y) {
        double u;
        if (this.isEmpty() || y.isEmpty()) {
            this.inf = Double.NaN;
            this.sup = Double.NaN;
            return this;
        }
        double l = this.inf > y.inf ? this.inf : y.inf;
        double d = u = this.sup < y.sup ? this.sup : y.sup;
        if (l > u) {
            this.inf = Double.NaN;
            this.sup = Double.NaN;
            return this;
        }
        this.inf = l;
        this.sup = u;
        return this;
    }

    public MutableInterval ix(MutableInterval y) {
        return this.intersect(y);
    }

    public MutableInterval interval_hull(MutableInterval y) {
        if (this.isEmpty()) {
            this.inf = y.inf;
            this.sup = y.sup;
            return this;
        }
        if (y.isEmpty()) {
            return this;
        }
        this.inf = this.inf < y.inf ? this.inf : y.inf;
        this.sup = this.sup > y.sup ? this.sup : y.sup;
        return this;
    }

    public MutableInterval interval_hull(double x) {
        if (this.isEmpty()) {
            return this.assign(x);
        }
        if (x != x) {
            return this.assignEntire();
        }
        this.inf = this.inf < x ? this.inf : x;
        this.sup = this.sup > x ? this.sup : x;
        return this;
    }

    public MutableInterval ih(MutableInterval y) {
        return this.interval_hull(y);
    }

    public boolean disjoint(MutableInterval y) {
        return !(this.inf <= y.sup) || !(y.inf <= this.sup);
    }

    public boolean dj(MutableInterval y) {
        return !(this.inf <= y.sup) || !(y.inf <= this.sup);
    }

    public boolean in(long x) {
        double xd = x;
        if (xd >= -9.007199254740992E15 && xd <= 9.007199254740992E15) {
            return this.inf <= xd && xd <= this.sup;
        }
        long xx = (long)xd;
        return (xx > x || x == Long.MAX_VALUE ? this.inf < xd : this.inf <= xd) && (xx < x ? xd < this.sup : xd <= this.sup);
    }

    public boolean in(double y) {
        return y >= this.inf && y <= this.sup;
    }

    public boolean in_interior(MutableInterval y) {
        return this.inf > y.inf && this.sup < y.sup || this.isEmpty();
    }

    public boolean interior(MutableInterval y) {
        return this.in_interior(y);
    }

    public boolean proper_subset(MutableInterval y) {
        return this.inf >= y.inf && this.sup <= y.sup && (this.inf > y.inf || this.sup < y.sup) || this.isEmpty() && !y.isEmpty();
    }

    public boolean subset(MutableInterval y) {
        return y.inf <= this.inf && this.sup <= y.sup || this.isEmpty();
    }

    public boolean proper_superset(MutableInterval y) {
        return this.inf <= y.inf && y.sup <= this.sup && (this.inf < y.inf || y.sup < this.sup) || y.isEmpty() && !this.isEmpty();
    }

    public boolean superset(MutableInterval y) {
        return this.inf <= y.inf && y.sup <= this.sup || y.isEmpty();
    }

    public boolean seq(MutableInterval y) {
        return this.inf == y.inf && this.sup == y.sup || this.isEmpty() && y.isEmpty();
    }

    public boolean sne(MutableInterval y) {
        return !this.seq(y);
    }

    public boolean sge(MutableInterval y) {
        return this.inf >= y.inf && this.sup >= y.sup || this.isEmpty() && y.isEmpty();
    }

    public boolean sgt(MutableInterval y) {
        return this.inf > y.inf && this.sup > y.sup;
    }

    public boolean sle(MutableInterval y) {
        return this.inf <= y.inf && this.sup <= y.sup || this.isEmpty() && y.isEmpty();
    }

    public boolean slt(MutableInterval y) {
        return this.inf < y.inf && this.sup < y.sup;
    }

    public boolean ceq(MutableInterval y) {
        return this.sup <= y.inf && this.inf >= y.sup;
    }

    public boolean cne(MutableInterval y) {
        return !(this.inf <= y.sup) || !(y.inf <= this.sup);
    }

    public boolean cge(MutableInterval y) {
        return this.inf >= y.sup;
    }

    public boolean cgt(MutableInterval y) {
        return this.inf > y.sup;
    }

    public boolean cle(MutableInterval y) {
        return this.sup <= y.inf;
    }

    public boolean clt(MutableInterval y) {
        return this.sup < y.inf;
    }

    public boolean peq(MutableInterval y) {
        return this.inf <= y.sup && this.sup >= y.inf;
    }

    public boolean pne(MutableInterval y) {
        return !(this.sup <= y.inf) || !(this.inf >= y.sup);
    }

    public boolean pge(MutableInterval y) {
        return this.sup >= y.inf;
    }

    public boolean pgt(MutableInterval y) {
        return this.sup > y.inf;
    }

    public boolean ple(MutableInterval y) {
        return this.inf <= y.sup;
    }

    public boolean plt(MutableInterval y) {
        return this.inf < y.sup;
    }

    public MutableInterval negate() {
        double l = this.inf;
        this.inf = -this.sup;
        this.sup = -l;
        return this;
    }

    public MutableInterval add(MutableInterval y) {
        double h;
        double l = this.inf + y.inf;
        if (l - this.inf > y.inf || l - y.inf > this.inf) {
            if (!$assertionsDisabled && !(Math.abs(l) >= 4.450147717014403E-308)) {
                throw new AssertionError();
            }
            double d = l < 0.0 ? (l < -1.3361122400059818E-292 ? l + l * 1.6653345369377348E-16 : l / 0.9999999999999999) : (l = l <= Double.MAX_VALUE ? l * 0.9999999999999999 : Double.MAX_VALUE);
        }
        if ((h = this.sup + y.sup) - this.sup < y.sup || h - y.sup < this.sup) {
            if (!$assertionsDisabled && !(Math.abs(h) >= 4.450147717014403E-308)) {
                throw new AssertionError();
            }
            h = h > 0.0 ? (h > 1.3361122400059818E-292 ? h + h * 1.6653345369377348E-16 : h / 0.9999999999999999) : (h >= -1.7976931348623157E308 ? h * 0.9999999999999999 : -1.7976931348623157E308);
        }
        this.inf = l;
        this.sup = h;
        return this;
    }

    public MutableInterval add(double y) {
        double l = this.inf + y;
        if (l - this.inf > y || l - y > this.inf) {
            if (!$assertionsDisabled && !(Math.abs(l) >= 4.450147717014403E-308)) {
                throw new AssertionError();
            }
            l = l < 0.0 ? (l < -1.3361122400059818E-292 ? l + l * 1.6653345369377348E-16 : l / 0.9999999999999999) : (l <= Double.MAX_VALUE ? l * 0.9999999999999999 : Double.MAX_VALUE);
        } else if (!(l < Double.POSITIVE_INFINITY) && y >= this.sup) {
            l = Double.MAX_VALUE;
        }
        double h = this.sup + y;
        if (h - this.sup < y || h - y < this.sup) {
            if (!$assertionsDisabled && !(Math.abs(h) >= 4.450147717014403E-308)) {
                throw new AssertionError();
            }
            h = h > 0.0 ? (h > 1.3361122400059818E-292 ? h + h * 1.6653345369377348E-16 : h / 0.9999999999999999) : (h >= -1.7976931348623157E308 ? h * 0.9999999999999999 : -1.7976931348623157E308);
        } else if (!(h > Double.NEGATIVE_INFINITY) && y <= this.inf) {
            h = -1.7976931348623157E308;
        }
        this.inf = l;
        this.sup = h;
        return this;
    }

    public MutableInterval sub(MutableInterval y) {
        double h;
        double l = this.inf - y.sup;
        if (this.inf - l < y.sup || l + y.sup > this.inf) {
            if (!$assertionsDisabled && !(Math.abs(l) >= 4.450147717014403E-308)) {
                throw new AssertionError();
            }
            double d = l < 0.0 ? (l < -1.3361122400059818E-292 ? l + l * 1.6653345369377348E-16 : l / 0.9999999999999999) : (l = l <= Double.MAX_VALUE ? l * 0.9999999999999999 : Double.MAX_VALUE);
        }
        if (this.sup - (h = this.sup - y.inf) > y.inf || h + y.inf < this.sup) {
            if (!$assertionsDisabled && !(Math.abs(h) >= 4.450147717014403E-308)) {
                throw new AssertionError();
            }
            h = h > 0.0 ? (h > 1.3361122400059818E-292 ? h + h * 1.6653345369377348E-16 : h / 0.9999999999999999) : (h >= -1.7976931348623157E308 ? h * 0.9999999999999999 : -1.7976931348623157E308);
        }
        this.inf = l;
        this.sup = h;
        return this;
    }

    public MutableInterval sub(double y) {
        double l = this.inf - y;
        if (this.inf - l < y || l + y > this.inf) {
            if (!$assertionsDisabled && !(Math.abs(l) >= 4.450147717014403E-308)) {
                throw new AssertionError();
            }
            l = l < 0.0 ? (l < -1.3361122400059818E-292 ? l + l * 1.6653345369377348E-16 : l / 0.9999999999999999) : (l <= Double.MAX_VALUE ? l * 0.9999999999999999 : Double.MAX_VALUE);
        } else if (!(l < Double.POSITIVE_INFINITY) && y >= this.sup) {
            l = Double.MAX_VALUE;
        }
        double h = this.sup - y;
        if (this.sup - h > y || h + y < this.sup) {
            if (!$assertionsDisabled && !(Math.abs(h) >= 4.450147717014403E-308)) {
                throw new AssertionError();
            }
            h = h > 0.0 ? (h > 1.3361122400059818E-292 ? h + h * 1.6653345369377348E-16 : h / 0.9999999999999999) : (h >= -1.7976931348623157E308 ? h * 0.9999999999999999 : -1.7976931348623157E308);
        } else if (!(h > Double.NEGATIVE_INFINITY) && y <= this.inf) {
            h = -1.7976931348623157E308;
        }
        this.inf = l;
        this.sup = h;
        return this;
    }

    public MutableInterval mul(MutableInterval y) {
        double h;
        double l;
        if (y.inf > 0.0) {
            if (this.inf > 0.0) {
                l = this.inf * y.inf;
                h = this.sup * y.sup;
            } else if (this.sup < 0.0) {
                l = this.inf * y.sup;
                h = this.sup * y.inf;
            } else {
                l = this.inf * y.sup;
                h = this.sup * y.sup;
            }
        } else if (y.sup < 0.0) {
            if (this.inf > 0.0) {
                l = this.sup * y.inf;
                h = this.inf * y.sup;
            } else if (this.sup < 0.0) {
                l = this.sup * y.sup;
                h = this.inf * y.inf;
            } else {
                l = this.sup * y.inf;
                h = this.inf * y.inf;
            }
        } else if (this.inf > 0.0) {
            l = this.sup * y.inf;
            h = this.sup * y.sup;
        } else if (this.sup < 0.0) {
            l = this.inf * y.sup;
            h = this.inf * y.inf;
        } else {
            double ho;
            l = this.sup * y.inf;
            double lo = this.inf * y.sup;
            if (l > lo || lo != lo) {
                l = lo;
            }
            if ((h = this.inf * y.inf) < (ho = this.sup * y.sup) || ho != ho) {
                h = ho;
            }
        }
        if (l > 0.0) {
            l = MutableInterval.prevPos(l);
        } else if (l < 0.0) {
            l = MutableInterval.prevNeg(l);
        } else if (l == 0.0) {
            l = this.inf >= 0.0 && y.inf >= 0.0 || this.sup <= 0.0 && y.sup <= 0.0 ? 0.0 : -4.9E-324;
        } else if (this.inf == this.inf && y.inf == y.inf) {
            return this.assignEntire();
        }
        if (h > 0.0) {
            h = MutableInterval.nextPos(h);
        } else if (h < 0.0) {
            h = MutableInterval.nextNeg(h);
        } else if (h == 0.0) {
            h = this.inf >= 0.0 && y.sup <= 0.0 || this.sup <= 0.0 && y.inf >= 0.0 ? 0.0 : Double.MIN_VALUE;
        } else if (this.inf == this.inf && y.inf == y.inf) {
            return this.assignEntire();
        }
        this.inf = l;
        this.sup = h;
        return this;
    }

    public MutableInterval div(MutableInterval y) {
        double h;
        double l;
        if (y.inf > 0.0) {
            if (this.inf > 0.0) {
                l = this.inf / y.sup;
                h = this.sup / y.inf;
            } else if (this.sup < 0.0) {
                l = this.inf / y.inf;
                h = this.sup / y.sup;
            } else {
                l = this.inf / y.inf;
                h = this.sup / y.inf;
            }
        } else if (y.sup < 0.0) {
            if (this.inf > 0.0) {
                l = this.sup / y.sup;
                h = this.inf / y.inf;
            } else if (this.sup < 0.0) {
                l = this.sup / y.inf;
                h = this.inf / y.sup;
            } else {
                l = this.sup / y.sup;
                h = this.inf / y.sup;
            }
        } else {
            h = Double.NaN;
            l = Double.NaN;
        }
        if (l > 0.0) {
            l = MutableInterval.prevPos(l);
        } else if (l < 0.0) {
            l = MutableInterval.prevNeg(l);
        } else if (l == 0.0) {
            l = this.inf >= 0.0 && y.inf > 0.0 || this.sup <= 0.0 && y.sup < 0.0 ? 0.0 : -4.9E-324;
        } else if (this.inf == this.inf && y.inf == y.inf) {
            return this.assignEntire();
        }
        if (h > 0.0) {
            h = MutableInterval.nextPos(h);
        } else if (h < 0.0) {
            h = MutableInterval.nextNeg(h);
        } else if (h == 0.0) {
            h = this.inf >= 0.0 && y.sup < 0.0 || this.sup <= 0.0 && y.inf > 0.0 ? 0.0 : Double.MIN_VALUE;
        } else if (this.inf == this.inf && y.inf == y.inf) {
            return this.assignEntire();
        }
        this.inf = l;
        this.sup = h;
        return this;
    }

    public MutableInterval exp() {
        double h;
        double l = Math.exp(this.inf);
        if (l > 0.0) {
            l = MutableInterval.prevPos(l);
        }
        if ((h = Math.exp(this.sup)) > 0.0) {
            h = MutableInterval.nextPos(h);
        } else if (h == 0.0) {
            h = Double.MIN_VALUE;
        }
        this.inf = l;
        this.sup = h;
        return this;
    }

    public MutableInterval log() {
        double l = Math.log(this.inf);
        double h = Math.log(this.sup);
        if (l > 0.0) {
            l = MutableInterval.prevPos(l);
        } else if (l < 0.0) {
            l = MutableInterval.prevNeg(l);
        } else if (l != l && h == h) {
            l = Double.NEGATIVE_INFINITY;
        }
        if (h > 0.0) {
            h = MutableInterval.nextPos(h);
        } else if (h < 0.0) {
            h = MutableInterval.nextNeg(h);
        }
        this.inf = l;
        this.sup = h;
        return this;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[EMPTY                                          ]";
        }
        StringBuffer buf = new StringBuffer(49);
        buf.append('[');
        MutableInterval.append(buf, this.inf, false);
        buf.append(',');
        MutableInterval.append(buf, this.sup, true);
        buf.append(']');
        return buf.toString();
    }

    private static void append(StringBuffer buf, double x, boolean isSup) {
        int d = 16;
        if (x == Double.NEGATIVE_INFINITY) {
            buf.append("              -Infinity");
        } else if (x == Double.POSITIVE_INFINITY) {
            buf.append("               Infinity");
        } else if (x == 0.0 && !isSup) {
            buf.append("-.0000000000000000E+000");
        } else if (x == 0.0 && isSup) {
            buf.append("0.0000000000000000E+000");
        } else {
            BigDecimal bx = new BigDecimal(x);
            String s = bx.unscaledValue().abs().toString();
            int drop = 0;
            if (s.length() != 16) {
                drop = s.length() - 16;
                bx = bx.setScale(bx.scale() - drop, isSup ? 2 : 3);
            }
            if ((s = bx.unscaledValue().abs().toString()).length() > 16) {
                if (!($assertionsDisabled || s.length() == 17 && s.charAt(s.length() - 1) == '0')) {
                    throw new AssertionError();
                }
                ++drop;
                bx = bx.setScale(bx.scale() - 1, 7);
                s = bx.unscaledValue().abs().toString();
            }
            buf.append(bx.signum() < 0 ? (char)'-' : '0');
            buf.append('.');
            buf.append(s);
            buf.append('E');
            int exp = 16 - bx.scale();
            if (exp >= 0) {
                buf.append('+');
            } else {
                buf.append('-');
                exp = -exp;
            }
            if (!$assertionsDisabled && exp >= 1000) {
                throw new AssertionError();
            }
            buf.append((char)(48 + exp / 100));
            buf.append((char)(48 + (exp %= 100) / 10));
            buf.append((char)(48 + (exp %= 10)));
        }
    }

    private void parse(String s) {
        if ((s = s.trim()).length() < 2 || s.charAt(0) != '[' || s.charAt(s.length() - 1) != ']') {
            throw new NumberFormatException();
        }
        int comma = s.indexOf(44);
        String ls = s.substring(1, comma < 0 ? s.length() - 1 : comma).trim();
        BigDecimal lb = null;
        if (ls.equals("NaN") || ls.equals("+NaN") || ls.equals("-NaN")) {
            this.inf = Double.NaN;
        } else if (ls.equals("Infinity") || ls.equals("+Infinity")) {
            this.inf = Double.POSITIVE_INFINITY;
        } else if (ls.equals("-Infinity")) {
            this.inf = Double.NEGATIVE_INFINITY;
        } else {
            if (ls.equals("EMPTY")) {
                if (comma >= 0) {
                    throw new NumberFormatException();
                }
                this.assignEmpty();
                return;
            }
            lb = new BigDecimal(ls);
            this.inf = lb.doubleValue();
        }
        if (comma >= 0) {
            String rs = s.substring(comma + 1, s.length() - 1).trim();
            BigDecimal rb = null;
            if (rs.equals("NaN") || rs.equals("+NaN") || rs.equals("-NaN")) {
                this.sup = Double.NaN;
            } else if (rs.equals("Infinity") || rs.equals("+Infinity")) {
                this.sup = Double.POSITIVE_INFINITY;
            } else if (rs.equals("-Infinity")) {
                this.sup = Double.NEGATIVE_INFINITY;
            } else {
                rb = new BigDecimal(rs);
                this.sup = rb.doubleValue();
                if (this.inf >= this.sup && (this.inf > this.sup || lb.compareTo(rb) > 0)) {
                    this.assignEntire();
                    return;
                }
                this.sup = MutableInterval.correct(rb, this.sup, true);
            }
        } else {
            this.sup = MutableInterval.correct(lb, this.inf, true);
        }
        this.inf = MutableInterval.correct(lb, this.inf, false);
        if (this.inf != this.inf || this.sup != this.sup || this.inf > this.sup) {
            this.assignEntire();
            return;
        }
        if (this.inf == Double.POSITIVE_INFINITY) {
            this.inf = Double.MAX_VALUE;
        }
        if (this.sup == Double.NEGATIVE_INFINITY) {
            this.sup = -1.7976931348623157E308;
        }
    }

    private static double correct(BigDecimal b, double d, boolean isSup) {
        if (b == null || Double.isInfinite(d)) {
            return d;
        }
        int diff = b.compareTo(new BigDecimal(d));
        if (isSup) {
            if (diff > 0) {
                d = MutableInterval.next(d);
            }
        } else if (diff < 0) {
            d = MutableInterval.prev(d);
        }
        return d;
    }

    public static double ulp(double d) {
        if (d < 0.0) {
            d = -d;
        }
        if (d < Double.MAX_VALUE) {
            if (d > 1.3361122400059818E-292) {
                return d + d * 1.6653345369377348E-16 - d;
            }
            if (d >= 4.450147717014403E-308) {
                return d / 0.9999999999999999 - d;
            }
            return Double.MIN_VALUE;
        }
        if (d == Double.MAX_VALUE) {
            return 1.99584030953472E292;
        }
        return d;
    }

    public static double prev(double x) {
        if (x <= Double.MIN_NORMAL) {
            if (x < -1.3361122400059818E-292) {
                return x + x * 1.6653345369377348E-16;
            }
            if (x <= -2.2250738585072014E-308) {
                return x / 0.9999999999999999;
            }
            if (x == 0.0) {
                return -4.9E-324;
            }
            return Double.longBitsToDouble(Double.doubleToLongBits(x) + (long)(x > 0.0 ? -1 : 1));
        }
        if (x > Double.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        return x * 0.9999999999999999;
    }

    public static double next(double x) {
        if (x >= -2.2250738585072014E-308) {
            if (x > 1.3361122400059818E-292) {
                return x + x * 1.6653345369377348E-16;
            }
            if (x >= Double.MIN_NORMAL) {
                return x / 0.9999999999999999;
            }
            if (x == 0.0) {
                return Double.MIN_VALUE;
            }
            return Double.longBitsToDouble(Double.doubleToLongBits(x) + (long)(x > 0.0 ? 1 : -1));
        }
        if (x < -1.7976931348623157E308) {
            return -1.7976931348623157E308;
        }
        return x * 0.9999999999999999;
    }

    private static double nextPos(double x) {
        if (!$assertionsDisabled && !(x > 0.0)) {
            throw new AssertionError();
        }
        return x > 1.3361122400059818E-292 ? x + x * 1.6653345369377348E-16 : (x >= Double.MIN_NORMAL ? x / 0.9999999999999999 : Double.longBitsToDouble(Double.doubleToLongBits(x) + 1L));
    }

    private static double nextNeg(double x) {
        if (!$assertionsDisabled && !(x < 0.0)) {
            throw new AssertionError();
        }
        return x <= -2.2250738585072014E-308 ? (x >= -1.7976931348623157E308 ? x * 0.9999999999999999 : -1.7976931348623157E308) : Double.longBitsToDouble(Double.doubleToLongBits(x) - 1L);
    }

    private static double prevPos(double x) {
        if (!$assertionsDisabled && !(x > 0.0)) {
            throw new AssertionError();
        }
        return x >= Double.MIN_NORMAL ? (x <= Double.MAX_VALUE ? x * 0.9999999999999999 : Double.MAX_VALUE) : Double.longBitsToDouble(Double.doubleToLongBits(x) - 1L);
    }

    private static double prevNeg(double x) {
        if (!$assertionsDisabled && !(x < 0.0)) {
            throw new AssertionError();
        }
        return x < -1.3361122400059818E-292 ? x + x * 1.6653345369377348E-16 : (x <= -2.2250738585072014E-308 ? x / 0.9999999999999999 : Double.longBitsToDouble(Double.doubleToLongBits(x) + 1L));
    }

    public static double addUp(double x, double y) {
        double z = x + y;
        if (z - x < y || z - y < x) {
            if (!$assertionsDisabled && !(Math.abs(z) >= 4.450147717014403E-308)) {
                throw new AssertionError();
            }
            return z > 0.0 ? (z > 1.3361122400059818E-292 ? z + z * 1.6653345369377348E-16 : z / 0.9999999999999999) : (z >= -1.7976931348623157E308 ? z * 0.9999999999999999 : -1.7976931348623157E308);
        }
        return z == z || x != x || y != y ? z : Double.POSITIVE_INFINITY;
    }

    public static double addPosUp(double x, double y) {
        double z = x + y;
        if (!$assertionsDisabled && !(z >= 0.0) && z == z) {
            throw new AssertionError();
        }
        if (z - x < y || z - y < x) {
            if (!$assertionsDisabled && !(z >= 4.450147717014403E-308)) {
                throw new AssertionError();
            }
            return z > 1.3361122400059818E-292 ? z + z * 1.6653345369377348E-16 : z / 0.9999999999999999;
        }
        return z;
    }

    static {
        $assertionsDisabled = !MutableInterval.class.desiredAssertionStatus();
    }
}

