/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.sc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.sc.GetNetlist;
import com.sun.electric.tool.sc.SilComp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Place {
    private static final boolean DEBUG = false;
    private static final boolean SORTFLAG = true;
    private static final boolean BALANCEFLAG = false;
    private static final int BALANCELIMIT = 2;
    private static final int VERTICALCOST = 2;
    private static final int BITS_PLACED = 1;
    static final int BITS_EXTRACT = 2;
    private ClusterTree gClusterTree;
    private int currentCost;

    public String placeCells(GetNetlist gnl) {
        SCPlace place;
        if (gnl.curSCCell == null) {
            return "No cell selected";
        }
        gnl.curSCCell.placement = place = new SCPlace();
        place.numInst = 0;
        place.sizeInst = 0;
        place.avgSize = 0;
        place.avgHeight = 0;
        place.numRows = SilComp.getNumberOfRows();
        place.sizeRows = 0;
        place.theRows = new ArrayList();
        place.plist = null;
        place.endList = null;
        List clusters = this.createClusters(gnl.curSCCell);
        int numCl = clusters.size();
        if (numCl == 0) {
            System.out.println("ERROR - No cells found to place.  Aborting.");
            return null;
        }
        ClusterTree nStart = null;
        Iterator it = clusters.iterator();
        while (it.hasNext()) {
            ClusterTree node = new ClusterTree();
            node.cluster = (Cluster)it.next();
            node.parent = null;
            node.next = nStart;
            nStart = node;
            node.lPtr = null;
            node.rPtr = null;
        }
        this.gClusterTree = this.createCTreeRecurse(nStart, gnl.curSCCell);
        this.cTreeAddParents(this.gClusterTree, null);
        place.sizeRows = place.sizeInst / place.numRows;
        this.sortClusterTree(this.gClusterTree, gnl.curSCCell);
        RowList row = new RowList();
        row.start = null;
        row.end = null;
        row.rowNum = 0;
        row.rowSize = 0;
        gnl.curSCCell.placement.theRows.add(row);
        this.createPlaceList(this.gClusterTree, gnl.curSCCell);
        this.numberPlacement(gnl.curSCCell.placement.theRows);
        this.reorderRows(gnl.curSCCell.placement.theRows);
        return null;
    }

    private void cTreeAddParents(ClusterTree node, ClusterTree parent) {
        if (node == null) {
            return;
        }
        node.parent = parent;
        this.cTreeAddParents(node.lPtr, node);
        this.cTreeAddParents(node.rPtr, node);
    }

    private List createClusters(GetNetlist.SCCell cell) {
        int size = 0;
        int num = 0;
        int height = 0;
        Iterator it = cell.niList.iterator();
        while (it.hasNext()) {
            GetNetlist.SCNiTree iList = (GetNetlist.SCNiTree)it.next();
            if (iList.type != 0) continue;
            ++num;
            size = (int)((double)size + iList.size);
            height = (int)((double)height + SilComp.leafCellYSize((Cell)iList.np));
        }
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        if (num == 0) {
            System.out.println("WARNING - No leaf cells found for placement");
            return clusters;
        }
        int avgSize = size / num;
        int avgHeight = height / num;
        cell.placement.numInst = num;
        cell.placement.sizeInst = size;
        cell.placement.avgSize = avgSize;
        cell.placement.avgHeight = avgHeight;
        int i = 0;
        boolean warn = false;
        Iterator it2 = cell.niList.iterator();
        while (it2.hasNext()) {
            GetNetlist.SCNiTree node = (GetNetlist.SCNiTree)it2.next();
            if (node.type != 0) {
                if (node.type != 1) continue;
                warn = true;
                continue;
            }
            Cluster cluster = new Cluster();
            cluster.node = node;
            cluster.size = node.size;
            cluster.number = i++;
            clusters.add(cluster);
        }
        if (warn) {
            System.out.println("WARNING - At least one complex cell found during Create_Clusters");
            System.out.println("        - Probable cause:  Forgot to do 'PULL' command");
        }
        return clusters;
    }

    private ClusterTree createCTreeRecurse(ClusterTree nodes, GetNetlist.SCCell cell) {
        if (nodes == null) {
            return null;
        }
        if (nodes.next == null) {
            return nodes;
        }
        List connectList = this.cTreeNumConnects(nodes, cell);
        ClusterTree nStart = this.cTreePair(nodes, connectList);
        return this.createCTreeRecurse(nStart, cell);
    }

    private List cTreeNumConnects(ClusterTree nodes, GetNetlist.SCCell cell) {
        ArrayList<ClConnect> connections = new ArrayList<ClConnect>();
        int nodeNum = 0;
        while (nodes != null) {
            ClusterTree nextnode = nodes.next;
            while (nextnode != null) {
                this.setExtNodesByCTree(nodes, nodeNum += 2);
                int common = this.countExtNodes(nextnode, nodeNum);
                if (common != 0) {
                    ClConnect newCon = new ClConnect(nodes, nextnode, common);
                    connections.add(newCon);
                }
                nextnode = nextnode.next;
            }
            nodes = nodes.next;
        }
        Collections.sort(connections, new ConnectsByCount());
        return connections;
    }

    private void setExtNodesByCTree(ClusterTree node, int marker) {
        if (node == null) {
            return;
        }
        this.setExtNodesByCTree(node.lPtr, marker);
        if (node.cluster != null) {
            GetNetlist.SCNiPort port = node.cluster.node.ports;
            while (port != null) {
                port.extNode.flags = marker;
                port = port.next;
            }
        }
        this.setExtNodesByCTree(node.rPtr, marker);
    }

    private int countExtNodes(ClusterTree node, int marker) {
        if (node == null) {
            return 0;
        }
        int count = this.countExtNodes(node.lPtr, marker);
        if (node.cluster != null) {
            GetNetlist.SCNiPort port = node.cluster.node.ports;
            while (port != null) {
                if (port.extNode.flags == marker) {
                    ++count;
                }
                port = port.next;
            }
        }
        return count += this.countExtNodes(node.rPtr, marker);
    }

    private ClusterTree cTreePair(ClusterTree nodes, List connectList) {
        ClusterTree tPtr = nodes;
        while (tPtr != null) {
            tPtr.bits &= 0xFFFFFFFE;
            tPtr = tPtr.next;
        }
        ClusterTree newStart = null;
        if (connectList.size() > 0) {
            int i = 0;
            while (i < connectList.size()) {
                ClConnect connect = (ClConnect)connectList.get(i);
                if ((connect.node[0].bits & 1) != 0 || (connect.node[1].bits & 1) != 0) {
                    ++i;
                    continue;
                }
                ClConnect bConnect = this.bestPair(connectList, i);
                ClusterTree newNode = new ClusterTree();
                newNode.cluster = null;
                newNode.bits = 0;
                newNode.parent = null;
                newNode.lPtr = bConnect.node[0];
                newNode.lPtr.parent = newNode;
                bConnect.node[0].bits |= 1;
                newNode.rPtr = bConnect.node[1];
                newNode.rPtr.parent = newNode;
                bConnect.node[1].bits |= 1;
                newNode.next = newStart;
                newStart = newNode;
                connectList.remove(bConnect);
            }
        } else {
            ClusterTree newNode = new ClusterTree();
            newNode.cluster = null;
            newNode.bits = 0;
            newNode.parent = null;
            newNode.lPtr = nodes;
            newNode.lPtr.parent = newNode;
            nodes.bits |= 1;
            newNode.rPtr = nodes.next;
            newNode.rPtr.parent = newNode;
            nodes.next.bits |= 1;
            newNode.next = newStart;
            newStart = newNode;
        }
        ClusterTree tPtr2 = nodes;
        while (tPtr2 != null) {
            if ((tPtr2.bits & 1) == 0) {
                ClusterTree newNode = new ClusterTree();
                newNode.cluster = null;
                newNode.bits = 0;
                newNode.parent = null;
                newNode.lPtr = tPtr2;
                newNode.lPtr.parent = newNode;
                tPtr2.bits |= 1;
                newNode.rPtr = null;
                newNode.next = newStart;
                newStart = newNode;
            }
            tPtr2 = tPtr2.next;
        }
        return newStart;
    }

    private ClConnect bestPair(List connectList, int index) {
        ArrayList<Temp> sList = new ArrayList<Temp>();
        ClConnect connect = (ClConnect)connectList.get(index);
        for (int oIndex = index; oIndex < connectList.size(); ++oIndex) {
            ClConnect nConnect = (ClConnect)connectList.get(oIndex);
            if (nConnect.count < connect.count) break;
            if ((nConnect.node[0].bits & 1) != 0 || (nConnect.node[1].bits & 1) != 0) continue;
            for (int i = 0; i < 2; ++i) {
                Temp nList = null;
                Iterator it = sList.iterator();
                while (it.hasNext()) {
                    Temp nl = (Temp)it.next();
                    if (nl.node != nConnect.node[i]) continue;
                    nList = nl;
                    break;
                }
                if (nList != null) {
                    ++nList.count;
                    continue;
                }
                nList = new Temp();
                nList.node = nConnect.node[i];
                nList.count = 1;
                nList.ref = nConnect;
                sList.add(nList);
            }
        }
        Temp best = null;
        Iterator it = sList.iterator();
        while (it.hasNext()) {
            Temp nList = (Temp)it.next();
            if (best != null && nList.count > best.count) continue;
            best = nList;
        }
        return best.ref;
    }

    private void sortClusterTree(ClusterTree cTree, GetNetlist.SCCell cell) {
        NBTrunk trunks = null;
        GetNetlist.ExtNode enode = cell.exNodes;
        while (enode != null) {
            NBTrunk newTrunk = new NBTrunk();
            newTrunk.ext_node = enode;
            newTrunk.minX = 0.0;
            newTrunk.maxX = 0.0;
            newTrunk.next = trunks;
            trunks = newTrunk;
            enode.ptr = newTrunk;
            enode = enode.next;
        }
        this.currentCost = this.costClusterTree(this.gClusterTree, trunks, cell);
        this.sortSwapperTopDown(cTree, trunks, cell);
        this.sortSwapperBottomUp(cTree, trunks, cell);
    }

    private void sortSwapperTopDown(ClusterTree cTree, NBTrunk trunks, GetNetlist.SCCell cell) {
        if (cTree == null) {
            return;
        }
        if (cTree.lPtr != null && cTree.rPtr != null) {
            this.switchSubtrees(cTree);
            int cost2 = this.costClusterTree(this.gClusterTree, trunks, cell);
            if (this.currentCost < cost2) {
                this.switchSubtrees(cTree);
            } else {
                this.currentCost = cost2;
            }
        }
        this.sortSwapperTopDown(cTree.lPtr, trunks, cell);
        this.sortSwapperTopDown(cTree.rPtr, trunks, cell);
    }

    private void sortSwapperBottomUp(ClusterTree cTree, NBTrunk trunks, GetNetlist.SCCell cell) {
        if (cTree == null) {
            return;
        }
        this.sortSwapperBottomUp(cTree.lPtr, trunks, cell);
        this.sortSwapperBottomUp(cTree.rPtr, trunks, cell);
        if (cTree.lPtr != null && cTree.rPtr != null) {
            this.switchSubtrees(cTree);
            int cost2 = this.costClusterTree(this.gClusterTree, trunks, cell);
            if (this.currentCost < cost2) {
                this.switchSubtrees(cTree);
            } else {
                this.currentCost = cost2;
            }
        }
    }

    private void switchSubtrees(ClusterTree node) {
        if (node == null) {
            return;
        }
        ClusterTree temp = node.lPtr;
        node.lPtr = node.rPtr;
        node.rPtr = temp;
        this.switchSubtrees(node.lPtr);
        this.switchSubtrees(node.rPtr);
    }

    private int costClusterTree(ClusterTree cTree, NBTrunk trunks, GetNetlist.SCCell cell) {
        NBTrunk nTrunk = trunks;
        while (nTrunk != null) {
            nTrunk.minX = -1.0;
            nTrunk.maxX = -1.0;
            nTrunk = nTrunk.next;
        }
        double pos = this.costClusterTree2(cTree, trunks, 0.0);
        int cost = 0;
        NBTrunk nTrunk2 = trunks;
        while (nTrunk2 != null) {
            if (!(nTrunk2.minX < 0.0)) {
                cost = (int)((double)cost + (nTrunk2.maxX - nTrunk2.minX));
            }
            nTrunk2 = nTrunk2.next;
        }
        GetNetlist.SCPort pport = cell.ports;
        while (pport != null) {
            NBTrunk nTrunk3;
            if ((pport.bits & 0xF) != 0 && (nTrunk3 = (NBTrunk)pport.node.ports.extNode.ptr) != null) {
                int row;
                if ((pport.bits & 1) != 0 && (row = (int)(nTrunk3.maxX / (double)cell.placement.sizeRows)) + 1 < cell.placement.numRows) {
                    cost += (cell.placement.numRows - row - 1) * cell.placement.avgHeight * 2;
                }
                if ((pport.bits & 2) != 0 && (row = (int)(nTrunk3.minX / (double)cell.placement.sizeRows)) != 0) {
                    cost += row * cell.placement.avgHeight * 2;
                }
            }
            pport = pport.next;
        }
        return cost;
    }

    private double costClusterTree2(ClusterTree cTree, NBTrunk trunks, double pos) {
        if (cTree == null) {
            return pos;
        }
        pos = this.costClusterTree2(cTree.lPtr, trunks, pos);
        if (cTree.cluster != null) {
            GetNetlist.SCNiPort port = cTree.cluster.node.ports;
            while (port != null) {
                NBTrunk nTrunk = (NBTrunk)port.extNode.ptr;
                if (nTrunk != null) {
                    if (nTrunk.minX < 0.0) {
                        nTrunk.minX = pos + port.xPos;
                    }
                    nTrunk.maxX = pos + port.xPos;
                }
                port = port.next;
            }
            pos += cTree.cluster.size;
        }
        return this.costClusterTree2(cTree.rPtr, trunks, pos);
    }

    private void createPlaceList(ClusterTree cTree, GetNetlist.SCCell cell) {
        if (cTree == null) {
            return;
        }
        this.createPlaceList(cTree.lPtr, cell);
        if (cTree.cluster != null) {
            this.addClusterToRow(cTree.cluster, cell.placement.theRows, cell.placement);
        }
        this.createPlaceList(cTree.rPtr, cell);
    }

    private void addClusterToRow(Cluster cluster, List theRows, SCPlace place) {
        if (cluster.node.type != 0) {
            return;
        }
        NBPlace newPlace = new NBPlace();
        newPlace.cell = cluster.node;
        newPlace.xPos = 0.0;
        cluster.node.tp = newPlace;
        newPlace.next = null;
        newPlace.last = place.endList;
        if (place.endList == null) {
            place.plist = place.endList = newPlace;
        } else {
            place.endList.next = newPlace;
            place.endList = newPlace;
        }
        RowList row = (RowList)theRows.get(theRows.size() - 1);
        double oldCondition = place.sizeRows - row.rowSize;
        double newCondition = (double)place.sizeRows - ((double)row.rowSize + cluster.node.size);
        if (row.rowNum + 1 < place.numRows && Math.abs(oldCondition) < Math.abs(newCondition)) {
            RowList row2 = new RowList();
            row2.start = null;
            row2.end = null;
            row2.rowNum = row.rowNum + 1;
            row2.rowSize = 0;
            theRows.add(row2);
            row = row2;
        }
        if (row.rowNum % 2 != 0) {
            if (row.end == null) {
                row.end = newPlace;
            }
            row.start = newPlace;
        } else {
            if (row.start == null) {
                row.start = newPlace;
            }
            row.end = newPlace;
        }
        row.rowSize = (int)((double)row.rowSize + cluster.node.size);
    }

    private void netBalance(GetNetlist.SCCell cell) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        int i = 0;
        NBTrunk sameTrunk = null;
        do {
            Channel newChan = new Channel();
            newChan.number = i;
            NBTrunk trunks = null;
            NBTrunk oldTrunk = null;
            GetNetlist.ExtNode nList = cell.exNodes;
            while (nList != null) {
                NBTrunk nTrunk = new NBTrunk();
                nTrunk.ext_node = nList;
                nTrunk.minX = 0.0;
                nTrunk.maxX = 0.0;
                nTrunk.same = null;
                if (sameTrunk == null) {
                    nList.ptr = nTrunk;
                } else {
                    sameTrunk.same = nTrunk;
                    sameTrunk = sameTrunk.next;
                }
                nTrunk.next = null;
                if (oldTrunk == null) {
                    trunks = oldTrunk = nTrunk;
                } else {
                    oldTrunk.next = nTrunk;
                    oldTrunk = nTrunk;
                }
                nList = nList.next;
            }
            newChan.trunks = trunks;
            channels.add(newChan);
            sameTrunk = trunks;
        } while (++i + 1 < cell.placement.numRows);
        this.nBAllCells(cell, channels);
        this.nBRebalanceRows(cell.placement.theRows, cell.placement);
        this.numberPlacement(cell.placement.theRows);
    }

    private void nBAllCells(GetNetlist.SCCell cell, List channels) {
        Iterator it = cell.niList.iterator();
        while (it.hasNext()) {
            GetNetlist.SCNiTree iList = (GetNetlist.SCNiTree)it.next();
            if (iList.type != 0) continue;
            this.nBDoCell((NBPlace)iList.tp, channels, cell);
        }
    }

    private void nBDoCell(NBPlace place, List channels, GetNetlist.SCCell cell) {
        int cost;
        int nPos;
        if (place == null) {
            return;
        }
        List theRows = cell.placement.theRows;
        int minCost = this.nBCost(theRows, channels, cell);
        int pos = 0;
        NBPlace oldLast = place.last;
        NBPlace oldNext = place.next;
        this.nBRemove(place, theRows);
        NBPlace nPlace = oldLast;
        for (nPos = -1; nPos >= -2 && nPlace != null; --nPos) {
            this.nBInsertBefore(place, nPlace, theRows);
            cost = this.nBCost(theRows, channels, cell);
            if (cost < minCost) {
                minCost = cost;
                pos = nPos;
            }
            this.nBRemove(place, theRows);
            nPlace = nPlace.last;
        }
        nPlace = oldNext;
        for (nPos = 1; nPos < 2 && nPlace != null; ++nPos) {
            this.nBInsertAfter(place, nPlace, theRows);
            cost = this.nBCost(theRows, channels, cell);
            if (cost < minCost) {
                minCost = cost;
                pos = nPos;
            }
            this.nBRemove(place, theRows);
            nPlace = nPlace.next;
        }
        if (pos > 0) {
            while (pos-- > 1) {
                oldNext = oldNext.next;
            }
            this.nBInsertAfter(place, oldNext, theRows);
        } else if (pos < 0) {
            while (pos++ < -1) {
                oldLast = oldLast.last;
            }
            this.nBInsertBefore(place, oldLast, theRows);
        } else if (oldLast != null) {
            this.nBInsertAfter(place, oldLast, theRows);
        } else {
            this.nBInsertBefore(place, oldNext, theRows);
        }
    }

    private int nBCost(List theRows, List channels, GetNetlist.SCCell cell) {
        NBTrunk nTrunk;
        Channel nChan;
        Iterator it = channels.iterator();
        while (it.hasNext()) {
            nChan = (Channel)it.next();
            NBTrunk nTrunk2 = nChan.trunks;
            while (nTrunk2 != null) {
                nTrunk2.minX = Double.MAX_VALUE;
                nTrunk2.maxX = Double.MIN_VALUE;
                nTrunk2 = nTrunk2.next;
            }
        }
        int chanPos = 0;
        nChan = (Channel)channels.get(chanPos);
        boolean above = true;
        int dis = 0;
        int rowNum = 0;
        int maxRowSize = cell.placement.sizeRows + (cell.placement.avgSize >> 1);
        RowList rows = (RowList)theRows.get(0);
        NBPlace nPlace = rows.start;
        while (nPlace != null) {
            if (rowNum % 2 != 0) {
                if ((double)dis - nPlace.cell.size < 0.0 && rowNum + 1 < cell.placement.numRows) {
                    ++rowNum;
                    dis = 0;
                    if (above ^= true) {
                        nChan = (Channel)channels.get(++chanPos);
                    }
                }
            } else if ((double)dis + nPlace.cell.size > (double)maxRowSize && rowNum + 1 < cell.placement.numRows) {
                ++rowNum;
                dis = maxRowSize;
                if (above ^= true) {
                    nChan = (Channel)channels.get(++chanPos);
                }
            }
            GetNetlist.SCNiPort port = nPlace.cell.ports;
            while (port != null) {
                nTrunk = (NBTrunk)port.extNode.ptr;
                if (nTrunk != null) {
                    for (int i = nChan.number; i != 0; --i) {
                        nTrunk = nTrunk.same;
                    }
                    if (nTrunk.minX == Double.MAX_VALUE && !above && nTrunk.same != null) {
                        nTrunk = nTrunk.same;
                    }
                    double pos = 0.0;
                    pos = rowNum % 2 != 2 ? (double)dis - port.xPos : (double)dis + port.xPos;
                    nTrunk.minX = Math.min(nTrunk.minX, pos);
                    nTrunk.maxX = Math.max(nTrunk.maxX, pos);
                }
                port = port.next;
            }
            dis = rowNum % 2 != 2 ? (int)((double)dis - nPlace.cell.size) : (int)((double)dis + nPlace.cell.size);
            nPlace = nPlace.next;
        }
        int cost = 0;
        Iterator it2 = channels.iterator();
        while (it2.hasNext()) {
            nChan = (Channel)it2.next();
            nTrunk = nChan.trunks;
            while (nTrunk != null) {
                if (nTrunk.minX != Double.MAX_VALUE) {
                    cost = (int)((double)cost + Math.abs(nTrunk.maxX - nTrunk.minX));
                }
                nTrunk = nTrunk.next;
            }
        }
        NBTrunk nTrunk3 = ((Channel)channels.get((int)0)).trunks;
        while (nTrunk3 != null) {
            NBTrunk fTrunk = null;
            int fCount = 0;
            int count = 0;
            NBTrunk sTrunk = nTrunk3;
            while (sTrunk != null) {
                if (sTrunk.minX != Double.MAX_VALUE) {
                    double fMinX = 0.0;
                    double fMaxX = 0.0;
                    if (fTrunk == null) {
                        fTrunk = sTrunk;
                        fMinX = sTrunk.minX;
                        fMaxX = sTrunk.maxX;
                        fCount = count;
                    } else {
                        cost += (count - fCount) * cell.placement.avgHeight * 2;
                        fCount = count;
                        if (fMaxX < sTrunk.minX) {
                            cost = (int)((double)cost + Math.abs(sTrunk.minX - fMaxX));
                            fMaxX = sTrunk.maxX;
                        } else if (fMinX > sTrunk.maxX) {
                            cost = (int)((double)cost + Math.abs(fMinX - sTrunk.maxX));
                            fMinX = sTrunk.minX;
                        } else {
                            if (fMinX > sTrunk.minX) {
                                fMinX = sTrunk.minX;
                            }
                            if (fMaxX < sTrunk.maxX) {
                                fMaxX = sTrunk.maxX;
                            }
                        }
                    }
                }
                ++count;
                sTrunk = sTrunk.same;
            }
            nTrunk3 = nTrunk3.next;
        }
        return cost;
    }

    private void nBRemove(NBPlace place, List theRows) {
        NBPlace oldNext = place.next;
        NBPlace oldLast = place.last;
        if (place.last != null) {
            place.last.next = oldNext;
        }
        if (place.next != null) {
            place.next.last = oldLast;
        }
        Iterator it = theRows.iterator();
        while (it.hasNext()) {
            RowList row = (RowList)it.next();
            if (row.start == place) {
                row.start = row.rowNum % 2 != 0 ? oldLast : oldNext;
            }
            if (row.end != place) continue;
            if (row.rowNum % 2 != 2) {
                row.end = oldNext;
                continue;
            }
            row.end = oldLast;
        }
    }

    private void nBInsertBefore(NBPlace place, NBPlace oldPlace, List theRows) {
        place.next = oldPlace;
        if (oldPlace != null) {
            place.last = oldPlace.last;
            if (oldPlace.last != null) {
                oldPlace.last.next = place;
            }
            oldPlace.last = place;
        } else {
            place.last = null;
        }
        Iterator it = theRows.iterator();
        while (it.hasNext()) {
            RowList row = (RowList)it.next();
            if (row.start == oldPlace && row.rowNum % 2 == 0) {
                row.start = place;
            }
            if (row.end != oldPlace || row.rowNum % 2 == 0) continue;
            row.end = place;
        }
    }

    private void nBInsertAfter(NBPlace place, NBPlace oldPlace, List theRows) {
        place.last = oldPlace;
        if (oldPlace != null) {
            place.next = oldPlace.next;
            if (oldPlace.next != null) {
                oldPlace.next.last = place;
            }
            oldPlace.next = place;
        } else {
            place.next = null;
        }
        RowList rows = (RowList)theRows.get(0);
        Iterator it = theRows.iterator();
        while (it.hasNext()) {
            RowList row = (RowList)it.next();
            if (row.start == oldPlace && row.rowNum % 2 != 0) {
                row.start = place;
            }
            if (row.end != oldPlace || rows.rowNum % 2 != 0) continue;
            row.end = place;
        }
    }

    private void nBRebalanceRows(List theRows, SCPlace place) {
        int maxRowSize = place.sizeRows + (place.avgSize >> 1);
        int rowPos = 0;
        RowList rows = (RowList)theRows.get(rowPos);
        rows.rowSize = 0;
        NBPlace nPlace = rows.start;
        while (nPlace != null) {
            if (rows.rowNum + 1 < place.numRows && (double)rows.rowSize + nPlace.cell.size > (double)maxRowSize) {
                rows = (RowList)theRows.get(++rowPos);
                rows.rowSize = 0;
                if (rows.rowNum % 2 != 0) {
                    rows.end = nPlace;
                } else {
                    rows.start = nPlace;
                }
            }
            rows.rowSize = (int)((double)rows.rowSize + nPlace.cell.size);
            if (rows.rowNum % 2 != 0) {
                rows.start = nPlace;
            } else {
                rows.end = nPlace;
            }
            nPlace = nPlace.next;
        }
    }

    private void numberPlacement(List theRows) {
        Iterator it = theRows.iterator();
        block0: while (it.hasNext()) {
            RowList row = (RowList)it.next();
            int xPos = 0;
            NBPlace nPlace = row.start;
            while (nPlace != null) {
                nPlace.xPos = xPos;
                xPos = (int)((double)xPos + nPlace.cell.size);
                if (nPlace == row.end) continue block0;
                if (row.rowNum % 2 != 0) {
                    nPlace = nPlace.last;
                    continue;
                }
                nPlace = nPlace.next;
            }
        }
    }

    private void reorderRows(List theRows) {
        Iterator it = theRows.iterator();
        while (it.hasNext()) {
            RowList row = (RowList)it.next();
            if (row.rowNum % 2 != 0) {
                NBPlace place = row.start;
                while (place != null) {
                    NBPlace tPlace = place.next;
                    place.next = place.last;
                    place.last = tPlace;
                    if (place == row.end) break;
                    place = place.next;
                }
                row.start.last = null;
                row.end.next = null;
                continue;
            }
            row.start.last = null;
            row.end.next = null;
        }
    }

    private void showPlacement(List theRows) {
        Iterator it = theRows.iterator();
        while (it.hasNext()) {
            RowList row = (RowList)it.next();
            System.out.println("For Row #" + row.rowNum + ", size " + row.rowSize + ":");
            NBPlace inst = row.start;
            while (inst != row.end) {
                System.out.println("    " + inst.xPos + "    " + inst.cell.name);
                if (row.rowNum % 2 != 0) {
                    inst = inst.last;
                    continue;
                }
                inst = inst.next;
            }
            System.out.println("    " + inst.xPos + "    " + inst.cell.name);
        }
    }

    private void printClusterTree(ClusterTree node, int level) {
        int j;
        if (node == null) {
            return;
        }
        this.printClusterTree(node.lPtr, level + 1);
        int i = level << 2;
        StringBuffer sb = new StringBuffer();
        for (j = 0; j < i; ++j) {
            sb.append(" ");
        }
        if (node.cluster != null) {
            sb.append("Cell " + node.cluster.node.name);
        } else {
            sb.append(level + "**");
            i = 36 - (level << 2);
            for (j = 0; j < i; ++j) {
                sb.append(" ");
            }
        }
        System.out.println(sb.toString());
        this.printClusterTree(node.rPtr, level + 1);
    }

    private static class Temp {
        ClusterTree node;
        int count;
        ClConnect ref;

        private Temp() {
        }
    }

    private static class ConnectsByCount
    implements Comparator {
        private ConnectsByCount() {
        }

        public int compare(Object o1, Object o2) {
            ClConnect c1 = (ClConnect)o1;
            ClConnect c2 = (ClConnect)o2;
            return c2.count - c1.count;
        }
    }

    private static class NBTrunk {
        GetNetlist.ExtNode ext_node;
        double minX;
        double maxX;
        NBTrunk same;
        NBTrunk next;

        private NBTrunk() {
        }
    }

    private static class Channel {
        int number;
        NBTrunk trunks;

        private Channel() {
        }
    }

    static class NBPlace {
        GetNetlist.SCNiTree cell;
        double xPos;
        NBPlace last;
        NBPlace next;

        NBPlace() {
        }
    }

    static class RowList {
        NBPlace start;
        NBPlace end;
        int rowNum;
        int rowSize;

        RowList() {
        }
    }

    private static class ClConnect {
        ClusterTree[] node = new ClusterTree[2];
        int count;

        private ClConnect(ClusterTree ct0, ClusterTree ct1, int c) {
            this.node[0] = ct0;
            this.node[1] = ct1;
            this.count = c;
        }
    }

    private static class ClusterTree {
        Cluster cluster;
        int bits;
        ClusterTree parent;
        ClusterTree next;
        ClusterTree lPtr;
        ClusterTree rPtr;

        private ClusterTree() {
        }
    }

    private static class Cluster {
        GetNetlist.SCNiTree node;
        int number;
        double size;

        private Cluster() {
        }
    }

    static class SCPlace {
        int numInst;
        int sizeInst;
        int avgSize;
        int avgHeight;
        int numRows;
        int sizeRows;
        List theRows;
        NBPlace plist;
        NBPlace endList;

        SCPlace() {
        }
    }
}

