/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.user.User;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VerticalRoute {
    private PortProto startPort;
    private PortProto endPort;
    private SpecifiedRoute specifiedRoute;
    private List allSpecifiedRoutes;
    private ArcProto startArc;
    private ArcProto endArc;
    private ArcProto[] startArcs;
    private ArcProto[] endArcs;
    private boolean specificationSucceeded;
    private int searchNumber;
    private static final int SEARCHLIMIT = 3000;
    private static final boolean DEBUG = false;
    private static final boolean DEBUGSEARCH = false;
    private static final boolean DEBUGTERSE = false;

    private VerticalRoute(PortProto startPort, PortProto endPort, ArcProto startArc, ArcProto endArc, ArcProto[] startArcs, ArcProto[] endArcs) {
        this.startPort = startPort;
        this.endPort = endPort;
        if (startPort.getBasePort().getParent() == Generic.tech.universalPinNode && endPort.getBasePort().getParent() == Generic.tech.universalPinNode || startPort.getBasePort().getParent() == Generic.tech.invisiblePinNode && endPort.getBasePort().getParent() == Generic.tech.invisiblePinNode) {
            startArc = endArc = User.getUserTool().getCurrentArcProto();
            endArcs = new ArcProto[]{startArc};
            startArcs = endArcs;
        }
        this.startArc = startArc;
        this.endArc = endArc;
        this.startArcs = this.copyArcArray(startArcs);
        this.endArcs = this.copyArcArray(endArcs);
        this.specifiedRoute = null;
        this.allSpecifiedRoutes = null;
        this.specificationSucceeded = false;
    }

    public static VerticalRoute newRoute(PortProto startPort, PortProto endPort) {
        ArcProto[] startArcs = startPort.getBasePort().getConnections();
        ArcProto[] endArcs = endPort.getBasePort().getConnections();
        VerticalRoute vr = new VerticalRoute(startPort, endPort, null, null, startArcs, endArcs);
        vr.specificationSucceeded = vr.specifyRoute();
        return vr;
    }

    public static VerticalRoute newRoute(PortProto startPort, ArcProto endArc) {
        ArcProto[] startArcs = startPort.getBasePort().getConnections();
        ArcProto[] endArcs = new ArcProto[]{endArc};
        VerticalRoute vr = new VerticalRoute(startPort, null, null, endArc, startArcs, endArcs);
        vr.specificationSucceeded = vr.specifyRoute();
        return vr;
    }

    public ArcProto getStartArc() {
        return this.startArc;
    }

    public ArcProto getEndArc() {
        return this.endArc;
    }

    public boolean isSpecificationSucceeded() {
        return this.specificationSucceeded;
    }

    private ArcProto[] copyArcArray(ArcProto[] arcs) {
        ArcProto[] copy = new ArcProto[arcs.length];
        for (int i = 0; i < arcs.length; ++i) {
            ArcProto arc = arcs[i];
            if (arc == Generic.tech.universal_arc && User.getUserTool().getCurrentArcProto() != Generic.tech.universal_arc) {
                arc = null;
            }
            if (arc == Generic.tech.invisible_arc && User.getUserTool().getCurrentArcProto() != Generic.tech.invisible_arc) {
                arc = null;
            }
            if (arc == Generic.tech.unrouted_arc && User.getUserTool().getCurrentArcProto() != Generic.tech.unrouted_arc) {
                arc = null;
            }
            if (arc != null && arc.isNotUsed()) {
                arc = null;
            }
            copy[i] = arc;
        }
        return copy;
    }

    private boolean specifyRoute() {
        if (this.endArcs == null || this.startArcs == null) {
            System.out.println("VerticalRoute: invalid start or end point");
            return false;
        }
        return this.specifyRoute(this.startArcs, this.endArcs);
    }

    public void buildRoute(Route route, Cell cell, RouteElementPort startRE, RouteElementPort endRE, Point2D startLoc, Point2D endLoc, Point2D location) {
        double width;
        if (this.specifiedRoute == null) {
            System.out.println("Error: Trying to build VerticalRoute without a call to specifyRoute() first");
            return;
        }
        if (this.specifiedRoute.size() == 0) {
            return;
        }
        if (startRE != null && !route.contains(startRE)) {
            route.add(startRE);
        }
        if (endRE != null && !route.contains(endRE)) {
            route.add(endRE);
        }
        int arcAngle = 0;
        if (startRE != null && startLoc.getX() == location.getX() && startLoc.getY() != location.getY()) {
            arcAngle = 900;
        }
        Route vertRoute = this.buildRoute(cell, location, new Dimension2D.Double(-1.0, -1.0), arcAngle);
        if (startRE != null) {
            if (route.replacePin(startRE, vertRoute.getStart())) {
                route.remove(startRE);
                if (route.getStart() == startRE) {
                    route.setStart(vertRoute.getStart());
                }
            } else {
                width = Router.getArcWidthToUse(startRE, this.startArc);
                RouteElementArc arc1 = RouteElementArc.newArc(cell, this.startArc, width, startRE, vertRoute.getStart(), startLoc, location, null, null, null);
                route.add(arc1);
            }
        }
        if (endRE != null) {
            if (route.replacePin(endRE, vertRoute.getEnd())) {
                route.remove(endRE);
                if (route.getEnd() == endRE) {
                    route.setEnd(vertRoute.getEnd());
                }
            } else {
                width = Router.getArcWidthToUse(endRE, this.endArc);
                RouteElementArc arc2 = RouteElementArc.newArc(cell, this.endArc, width, endRE, vertRoute.getEnd(), endLoc, location, null, null, null);
                route.add(arc2);
            }
        } else if (route.getEnd() == null) {
            route.setEnd(vertRoute.getEnd());
        }
        Dimension2D size = Router.getContactSize(vertRoute.getStart(), vertRoute.getEnd());
        Iterator it = vertRoute.iterator();
        while (it.hasNext()) {
            RouteElement re = (RouteElement)it.next();
            if (re instanceof RouteElementPort) {
                ((RouteElementPort)re).setNodeSize(size);
            }
            if (route.contains(re)) continue;
            route.add(re);
        }
    }

    public Route buildRoute(Cell cell, Point2D location, Dimension2D contactSize, int arcAngle) {
        if (this.specifiedRoute == null) {
            System.out.println("Error: Trying to build VerticalRoute without a call to specifyRoute() first");
            return null;
        }
        Route route = new Route();
        if (this.specifiedRoute.size() == 0) {
            return route;
        }
        PrimitivePort pp = (PrimitivePort)this.specifiedRoute.remove(0);
        RouteElementPort node = RouteElementPort.newNode(cell, pp.getParent(), pp, location, contactSize.getWidth(), contactSize.getHeight());
        route.add(node);
        route.setStart(node);
        route.setEnd(node);
        Iterator it = this.specifiedRoute.iterator();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            PrimitivePort port = (PrimitivePort)it.next();
            RouteElementPort newNode = RouteElementPort.newNode(cell, port.getParent(), port, location, contactSize.getWidth(), contactSize.getHeight());
            route.add(newNode);
            route.setEnd(newNode);
            double arcWidth = Router.getArcWidthToUse(node, ap);
            RouteElementArc arc = RouteElementArc.newArc(cell, ap, arcWidth, node, newNode, location, location, null, null, null);
            arc.setArcAngle(arcAngle);
            route.add(arc);
            node = newNode;
        }
        return route;
    }

    private boolean specifyRoute(ArcProto[] startArcs, ArcProto[] endArcs) {
        SpecifiedRoute r;
        this.specifiedRoute = new SpecifiedRoute();
        this.allSpecifiedRoutes = new ArrayList();
        this.startArc = null;
        this.endArc = null;
        for (int i = 0; i < startArcs.length; ++i) {
            for (int j = 0; j < endArcs.length; ++j) {
                ArcProto startArc = startArcs[i];
                ArcProto endArc = endArcs[j];
                if (startArc == null || endArc == null) continue;
                this.specifiedRoute.clear();
                this.specifiedRoute.startArc = startArc;
                this.specifiedRoute.endArc = endArc;
                this.searchNumber = 0;
                this.findConnectingPorts(startArc, endArc, new StringBuffer());
            }
        }
        if (this.allSpecifiedRoutes.size() == 0) {
            return false;
        }
        this.specifiedRoute = (SpecifiedRoute)this.allSpecifiedRoutes.get(0);
        ArrayList<SpecifiedRoute> zeroLengthRoutes = new ArrayList<SpecifiedRoute>();
        for (int i = 0; i < this.allSpecifiedRoutes.size(); ++i) {
            r = (SpecifiedRoute)this.allSpecifiedRoutes.get(i);
            if (r.size() < this.specifiedRoute.size()) {
                this.specifiedRoute = r;
            }
            if (r.size() != 0) continue;
            zeroLengthRoutes.add(r);
        }
        if (zeroLengthRoutes.size() > 0) {
            Iterator it = zeroLengthRoutes.iterator();
            while (it.hasNext()) {
                r = (SpecifiedRoute)it.next();
                if (r.startArc != User.getUserTool().getCurrentArcProto()) continue;
                this.specifiedRoute = r;
            }
        }
        this.allSpecifiedRoutes.clear();
        this.startArc = this.specifiedRoute.startArc;
        this.endArc = this.specifiedRoute.endArc;
        return true;
    }

    private void findConnectingPorts(ArcProto startArc, ArcProto endArc, StringBuffer ds) {
        PrimitivePort pp;
        Iterator portsIt;
        PrimitiveNode pn;
        if (this.specifiedRoute.size() > this.getShortestRouteLength()) {
            return;
        }
        if (startArc == endArc) {
            this.saveRoute(this.specifiedRoute);
            return;
        }
        ds.append("  ");
        if (this.searchNumber > 3000) {
            return;
        }
        if (this.searchNumber == 3000) {
            System.out.println("Search limit reached in VerticalRoute");
            ++this.searchNumber;
            return;
        }
        ++this.searchNumber;
        Technology tech = startArc.getTechnology();
        Iterator nodesIt = tech.getNodes();
        while (nodesIt.hasNext()) {
            pn = (PrimitiveNode)nodesIt.next();
            if (pn.getFunction() != PrimitiveNode.Function.CONTACT) continue;
            portsIt = pn.getPorts();
            while (portsIt.hasNext()) {
                pp = (PrimitivePort)portsIt.next();
                if (!pp.connectsTo(startArc) || !pp.connectsTo(endArc)) continue;
                this.specifiedRoute.add(pp);
                this.saveRoute(this.specifiedRoute);
                return;
            }
        }
        nodesIt = tech.getNodes();
        while (nodesIt.hasNext()) {
            pn = (PrimitiveNode)nodesIt.next();
            if (pn.getFunction() != PrimitiveNode.Function.CONTACT) continue;
            portsIt = pn.getPorts();
            while (portsIt.hasNext()) {
                pp = (PrimitivePort)portsIt.next();
                if (!pp.connectsTo(startArc) || pp == this.startPort || pp == this.endPort || this.specifiedRoute.contains(pp)) continue;
                int prePortSize = this.specifiedRoute.size();
                this.specifiedRoute.add(pp);
                int preArcSize = this.specifiedRoute.size();
                ArcProto[] arcs = pp.getConnections();
                for (int i = 0; i < arcs.length; ++i) {
                    ArcProto tryarc = arcs[i];
                    if (tryarc == Generic.tech.universal_arc || tryarc == Generic.tech.invisible_arc || tryarc == Generic.tech.unrouted_arc || tryarc.isNotUsed() || tryarc == startArc || tryarc == this.startArc || this.specifiedRoute.contains(tryarc)) continue;
                    this.specifiedRoute.add(tryarc);
                    this.findConnectingPorts(tryarc, endArc, ds);
                    while (this.specifiedRoute.size() > preArcSize) {
                        this.specifiedRoute.remove(this.specifiedRoute.size() - 1);
                    }
                }
                while (this.specifiedRoute.size() > prePortSize) {
                    this.specifiedRoute.remove(this.specifiedRoute.size() - 1);
                }
            }
        }
    }

    private void saveRoute(SpecifiedRoute route) {
        int shortestLength = this.getShortestRouteLength();
        if (route.size() > shortestLength) {
            return;
        }
        SpecifiedRoute loggedRoute = new SpecifiedRoute();
        loggedRoute.startArc = route.startArc;
        loggedRoute.endArc = route.endArc;
        loggedRoute.addAll(route);
        this.allSpecifiedRoutes.add(loggedRoute);
        boolean trim = true;
        while (trim) {
            Iterator it = null;
            it = this.allSpecifiedRoutes.iterator();
            while (it.hasNext()) {
                SpecifiedRoute r = (SpecifiedRoute)it.next();
                if (r.size() <= shortestLength) continue;
                this.allSpecifiedRoutes.remove(r);
                break;
            }
            if (it.hasNext()) continue;
            trim = false;
        }
    }

    private int getShortestRouteLength() {
        if (this.allSpecifiedRoutes.size() == 0) {
            return Integer.MAX_VALUE;
        }
        SpecifiedRoute r = (SpecifiedRoute)this.allSpecifiedRoutes.get(0);
        return r.size();
    }

    private static class SpecifiedRoute
    extends ArrayList {
        ArcProto startArc;
        ArcProto endArc;

        private SpecifiedRoute() {
        }

        void printRoute() {
            for (int k = 0; k < this.size(); ++k) {
                System.out.println("   " + k + ": " + this.get(k));
            }
        }
    }
}

