/* ps1.c -- higher level functions */

/*  Copyright (C) 2001  Susan Bassein
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <math.h>
#include "dap_make.h"
#include "externs.h"
#include "ps.h"

#define LEFT 144.0
#define BOTTOM 144.0
#define PORTWIDTH 324.0
#define PORTHEIGHT 324.0
#define LANDWIDTH 324.0
#define LANDHEIGHT 324.0

extern char *pict_newstr(char *str);

static double arint(double x)
{
double i;

if (fabs(i = rint(x)) == 0.0)
	return 0.0;
else
	return i;
}

void pict_maketick(tick *t, double num, char *label, double len)
{
t->tick_num = num;
t->tick_lab = pict_newstr(label);
t->tick_len = len;
}

static void yaxis(pict *p, tick ytick[], int nyticks, double xpos, double ypos,
			double side, int marks)
{
int ny;
char tpos[3];
char npos[3];
double lablen;
double txtang;
int lab1len;
int labslen;

if (side > 0.0)
	{
	strcpy(tpos, "cb");
	strcpy(npos, "rm");
	}
else
	{
	strcpy(tpos, "ct");
	strcpy(npos, "lm");
	}
for (labslen = 0, ny = 0; ny < nyticks - 1; ny++)
	{
	lab1len = strlen(ytick[ny].tick_lab);
	if (lab1len > labslen)
		labslen = lab1len;
	}
ny = nyticks - 1;
lablen = (1.5 * side - 0.5) * ytick[ny].tick_len;
txtang = 0.0;
if (ny >= 1 && ytick[0].tick_num <= ytick[ny].tick_num &&
		ytick[ny].tick_num <= ytick[ny - 1].tick_num)
	{
	lablen += side * 3.5 * ((double) labslen) * ytick[ny].tick_len;
	txtang = 90.0;
	}
if (side > 0.0 || marks)
	pict_text(p, ytick[ny].tick_lab, ypos - lablen, ytick[ny].tick_num, txtang, tpos);
while (--ny >= 0)
	{
	pict_point(p, ypos, ytick[ny].tick_num);
	pict_point(p, ypos + side * ytick[ny].tick_len, ytick[ny].tick_num);
	pict_point(p, ypos, ytick[ny].tick_num);
	if (side > 0.0 || marks)
		pict_text(p, ytick[ny].tick_lab,
			ypos - (1.5 * side - 0.5) * ytick[ny].tick_len,
			ytick[ny].tick_num, 0.0, npos);
	}
pict_point(p, ypos, xpos);
}

static void xaxis(pict *p, tick xtick[], int nxticks, double xpos, double ypos,
			double side, int marks)
{
int nx;
char tpos[3];
double lablen;

strcpy(tpos, "lt");
nx = nxticks - 1;
lablen = side * xtick[nx].tick_len;
if (nx >= 1 && xtick[0].tick_num <= xtick[nx].tick_num &&
                xtick[nx].tick_num <= xtick[nx - 1].tick_num)
	{
	tpos[0] = 'c';
	lablen += 10.0 * xtick[nx].tick_len;
	}
if (side > 0.0)
	pict_text(p, xtick[nx].tick_lab, xtick[nx].tick_num, xpos - lablen, 0.0, tpos);
while (--nx >= 0)
	{
	pict_point(p, xtick[nx].tick_num, xpos);
	if (side > 0.0 || marks)
		pict_point(p, xtick[nx].tick_num, xpos + side * xtick[nx].tick_len);
	pict_point(p, xtick[nx].tick_num, xpos);
	if (side > 0.0)
		pict_text(p, xtick[nx].tick_lab, xtick[nx].tick_num,
			xpos - side * xtick[nx].tick_len, 0.0, "ct");
	}
pict_point(p, ypos, xpos);
}

void pict_axes(pict *p, tick xtick[], int nxticks, tick ytick[], int nyticks,
		char style[], double bpos, double lpos, double tpos, double rpos)
{
double xpos, ypos;
int rmarks, tmarks;

xpos = 0.0;
ypos = 0.0;
rmarks = 0;
tmarks = 0;
if (style[0] == '#' || style[0] == 'B')
	tmarks = 1;
if (style[1] == '#' || style[1] == 'B')
	rmarks = 1;
if (style[0] != 'b' && style[1] != 'b' &&
		style[0] != 'B' && style[1] != 'B')
	{
	switch (style[0])
		{
	case '-':
	case '0':
		xpos = bpos;
		break;
	case '#':
	case '+':
		xpos = tpos;
		break;
	case 'n':
		xpos = 0.0;
		break;
		}
	switch (style[1])
		{
	case '-':
	case '0':
		ypos = lpos;
		break;
	case '#':
	case '+':
		ypos = rpos;
		break;
	case 'n':
		ypos = 0.0;
		break;
		}
	switch (style[0])
		{
	case '-':
	case '0':
		xaxis(p, xtick, nxticks, bpos, ypos, 1.0, tmarks);
		break;
	case '+':
	case '#':
		xaxis(p, xtick, nxticks, tpos, ypos, -1.0, tmarks);
		break;
	case 'n':
		break;
		}
	switch (style[1])
		{
	case '-':
	case '0':
		yaxis(p, ytick, nyticks, xpos, lpos, 1.0, rmarks);
		break;
	case '+':
	case '#':
		yaxis(p, ytick, nyticks, xpos, rpos, -1.0, rmarks);
		break;
	case 'n':
		break;
		}
	}
else if (style[0] != 'b' && style[0] != 'B')
	{
	switch (style[0])
		{
	case '-':
	case '0':
		yaxis(p, ytick, nyticks, bpos, lpos, 1.0, rmarks);
		xaxis(p, xtick, nxticks, bpos, lpos, 1.0, tmarks);
		xaxis(p, xtick, nxticks, bpos, rpos, 1.0, tmarks);
		yaxis(p, ytick, nyticks, bpos, rpos, -1.0, rmarks);
		break;
	case '+':
	case '#':
		yaxis(p, ytick, nyticks, tpos, lpos, 1.0, rmarks);
		xaxis(p, xtick, nxticks, tpos, lpos, -1.0, tmarks);
		xaxis(p, xtick, nxticks, tpos, rpos, -1.0, tmarks);
		yaxis(p, ytick, nyticks, tpos, rpos, -1.0, rmarks);
		break;
	case 'n':
		fputs("(axes) Can't have double y-axes and no x-axis.\n", stderr);
		exit(1);
		}
	}
else if (style[1] != 'b' && style[1] != 'B')
	{
	switch (style[1])
		{
	case '-':
	case '0':
		xaxis(p, xtick, nxticks, bpos, lpos, 1.0, tmarks);
		yaxis(p, ytick, nyticks, bpos, lpos, 1.0, rmarks);
		yaxis(p, ytick, nyticks, tpos, lpos, 1.0, rmarks);
		xaxis(p, xtick, nxticks, tpos, lpos, -1.0, tmarks);
		break;
	case '+':
	case '#':
		xaxis(p, xtick, nxticks, bpos, rpos, 1.0, tmarks);
		yaxis(p, ytick, nyticks, bpos, rpos, -1.0, rmarks);
		yaxis(p, ytick, nyticks, tpos, rpos, -1.0, rmarks);
		xaxis(p, xtick, nxticks, tpos, rpos, -1.0, tmarks);
		break;
	case 'n':
		fputs("(axes) Can't have double x-axes and no y-axis.\n", stderr);
		exit(1);
		}
	}
else
	{
	yaxis(p, ytick, nyticks, bpos, lpos, 1.0, rmarks);
	xaxis(p, xtick, nxticks, bpos, rpos, 1.0, tmarks);
	yaxis(p, ytick, nyticks, tpos, rpos, -1.0, rmarks);
	xaxis(p, xtick, nxticks, tpos, lpos, -1.0, tmarks);
	}
}

static void ticks(tick ticks[], double min, double space, double ticklen,
		char *form, int nticks, double labpos, char *alab, double (*tfunct)())
{
int n;
static char *lab;
double coord;

if (!form)
	{
	fputs("(ticks) No format.\n", stderr);
	exit(1);
	}
if (!lab)
	lab = dap_malloc(dap_maxtxt + 1, "dap_maxtxt");
for (n = 0; n < nticks - 1; n++)
	{
	coord = min + space * (double) n;
	if (tfunct)
		sprintf(lab, form, (*tfunct)(coord));
	else
		sprintf(lab, form, coord);
	pict_maketick(ticks + n, coord, lab, ticklen);
	}
pict_maketick(ticks + n, labpos, alab, ticklen);
}

double pict_autoaxes(pict *p, char *xlab, char *ylab, char *axspec,
	double (*xfunct)(), double (*yfunct)(), char *caption, int autopos)
{
pict *pp;
int totpts;
double xspace, yspace;
double xlen, ylen;
double minx, maxx, miny, maxy;
double minx1, maxx1;
int nxticks, nyticks;
tick *xticks;
tick *yticks;
double xticklen;
double yticklen;
char xform[10], yform[10];
char as[3];
double lpos, rpos, bpos, tpos;
double xlabpos, ylabpos;
double captoff;
double width, height;
int lexpand, rexpand;

minx = 0.0;
maxx = 0.0;
miny = 0.0;
maxy = 0.0;
lpos = 0.0;
rpos = 0.0;
bpos = 0.0;
tpos = 0.0;
xlabpos = 0.0;
ylabpos = 0.0;
captoff = 0.0;
xticks = (tick *) dap_malloc(sizeof(tick) * dap_maxntxt, "dap_maxntxt");
yticks = (tick *) dap_malloc(sizeof(tick) * dap_maxntxt, "dap_maxntxt");
if (axspec && axspec[0])
	{
	as[0] = axspec[0];
	if (axspec[1])
		as[1] = axspec[1];
	else
		as[1] = '0';
	as[2] = '\0';
	}
else
	strcpy(as, "00");
for (pp = p, totpts = 0; pp && pp->pict_next; pp = pp->pict_next)
	{
	if (pp->pict_npts)
		{
		if (pp == p || minx > pp->pict_minx)
			minx = pp->pict_minx;
		if (pp == p || miny > pp->pict_miny)
			miny = pp->pict_miny;
		if (pp == p || maxx < pp->pict_maxx)
			maxx = pp->pict_maxx;
		if (pp == p || maxy < pp->pict_maxy)
			maxy = pp->pict_maxy;
		totpts += pp->pict_npts;
		}
	}
if (!totpts)
	{
	fprintf(stderr, "(autoaxes) No points.\n");
	exit(1);
	}
minx1 = minx;
maxx1 = maxx;
if (minx > 0.0)
	minx = 0.0;
if (miny > 0.0)
	miny = 0.0;
if (maxx < 0.0)
	maxx = 0.0;
if (maxy < 0.0)
	maxy = 0.0;
xlen = 1e5 / (maxx - minx);
minx = arint(xlen * minx) / xlen;
maxx = arint(xlen * maxx) / xlen;
ylen = 1e5 / (maxy - miny);
miny = arint(ylen * miny) / ylen;
maxy = arint(ylen * maxy) / ylen;
xlen = maxx - minx;
if (xlen >= 1.0)
        {
        for (xspace = 1.0; 10.0 * xspace < xlen; xspace *= 10.0)
                ; 
        xspace *= ceil(xlen / xspace) / 10.0;
        }
else            
        {
        for (xspace = 0.1; 0.1 * xspace > xlen; xspace *= 0.1)
                ;
        xspace *= ceil(xlen / xspace) / 10.0;
        }
ylen = maxy - miny;
if (ylen >= 1.0)
        {
        for (yspace = 1.0; 10.0 * yspace < ylen; yspace *= 10.0)
                ;
        yspace *= ceil(ylen / yspace) / 10.0;
        }
else
        {
        for (yspace = 0.1; 0.1 * yspace > ylen; yspace *= 0.1)
                ;
        yspace *= ceil(ylen / yspace) / 10.0;
        }
if (xspace == rint(xspace))
	strcpy(xform, "%.0f");
else if (10.0 * xspace == rint(10.0 * xspace))
	strcpy(xform, "%.1f");
else
	strcpy(xform, "%.2f");
if (yspace == rint(yspace))
	strcpy(yform, "%.0f");
else if (10.0 * yspace == rint(10.0 * yspace))
	strcpy(yform, "%.1f");
else
	strcpy(yform, "%.2f");
if (minx < minx1)
	minx = xspace * floor(minx / xspace);
else
	minx = xspace * (floor(minx / xspace) - 1.0);
lexpand = (minx + xspace <= minx1);
miny = yspace * floor(miny / yspace);
if (maxx > maxx1)
	maxx = xspace * ceil(maxx / xspace);
else
	maxx = xspace * (ceil(maxx / xspace) + 1.0);
rexpand = (maxx - xspace >= maxx1);
maxy = yspace * ceil(maxy / yspace);
xticklen = (maxy - miny) / 100.0;
yticklen = (maxx - minx) / 100.0;
nxticks = 2 + (int) rint((maxx - minx) / xspace) - lexpand - rexpand;
nyticks = 2 + (int) rint((maxy - miny) / yspace);
if (as[0] == 'b' || as[0] == 'B')
	{
	bpos = miny;
	tpos = maxy;
	xlabpos = 0.5 * (minx + maxx);
	captoff = (maxy - miny) / 5.0;
	}
else if (as[0] != 'n')
	{
	switch (as[0])
		{
	case '-':
		bpos = miny;
		xlabpos = 0.5 * (minx + maxx);
		captoff = (maxy - miny) / 5.0;
		break;
	case '+':
	case '#':
		tpos = maxy;
		xlabpos = 0.5 * (minx + maxx);
		captoff = (maxy - miny) / 5.0;
		break;
	case '0':
		bpos = 0.0;
		xlabpos = maxx + xspace;
		captoff = (maxy - miny) / 10.0;
		break;
	default:
		fprintf(stderr, "(autoaxes) Bad axis specification: %s\n", axspec);
		exit(1);
		}
	}
if (as[1] == 'b' || as[1] == 'B')
	{
	lpos = minx;
	rpos = maxx;
	ylabpos = 0.5 * (miny + maxy);
	}
else if (as[1] != 'n')
	{
	switch (as[1])
		{
	case '-':
		lpos = minx;
		ylabpos = 0.5 * (miny + maxy);
		break;
	case '+':
	case '#':
		rpos = maxx;
		ylabpos = 0.5 * (miny + maxy);
		break;
	case '0':
		lpos = 0.0;
		ylabpos = maxy + yspace;
		break;
	default:
		fprintf(stderr, "(autoaxes) Bad axis specification: %s\n", axspec);
		exit(1);
		}
	}
if (lexpand)
	ticks(xticks, minx + xspace, xspace, xticklen, xform, nxticks, xlabpos, xlab, xfunct);
else
	ticks(xticks, minx, xspace, xticklen, xform, nxticks, xlabpos, xlab, xfunct);
ticks(yticks, miny, yspace, yticklen, yform, nyticks, ylabpos, ylab, yfunct);
pict_axes(pp, xticks, nxticks, yticks, nyticks, as, bpos, lpos, tpos, rpos);
pict_text(pp, caption, 0.5 * (minx + maxx), miny - captoff, 0.0, "ct ");
if (autopos)
	{
	if (autopos == PORTRAIT)
		{
		width = PORTWIDTH;
		height = PORTHEIGHT;
		}
	else
		{
		width = LANDWIDTH;
		height = LANDHEIGHT;
		}
	pict_scale(p, 0.5 * (minx + maxx), 0.5 * (miny + maxy),
			width / (maxx - minx), height / (maxy - miny));
	pict_translate(p, LEFT + 0.5 * (width - (minx + maxx)),
			BOTTOM + 0.5 * (height - (miny + maxy)));
	xspace *= width / (maxx - minx);
	yspace *= width / (maxy - miny);
	}
dap_free(xticks);
dap_free(yticks);
return sqrt(xspace * xspace + yspace * yspace);
}
