// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/conversation_model.proto

#include "google/cloud/dialogflow_es/internal/conversation_models_connection_impl.h"
#include "google/cloud/dialogflow_es/internal/conversation_models_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<dialogflow_es::ConversationModelsRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<dialogflow_es::ConversationModelsRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<dialogflow_es::ConversationModelsBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<dialogflow_es::ConversationModelsConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<dialogflow_es::ConversationModelsConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<dialogflow_es::ConversationModelsPollingPolicyOption>()
      ->clone();
}

}  // namespace

ConversationModelsConnectionImpl::ConversationModelsConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<dialogflow_es_internal::ConversationModelsStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), ConversationModelsConnection::options())) {}

future<StatusOr<google::cloud::dialogflow::v2::ConversationModel>>
ConversationModelsConnectionImpl::CreateConversationModel(
    google::cloud::dialogflow::v2::CreateConversationModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dialogflow::v2::ConversationModel>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dialogflow::v2::CreateConversationModelRequest const&
              request) {
        return stub->AsyncCreateConversationModel(cq, std::move(context),
                                                  options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dialogflow::v2::ConversationModel>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateConversationModel(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::dialogflow::v2::ConversationModel>
ConversationModelsConnectionImpl::GetConversationModel(
    google::cloud::dialogflow::v2::GetConversationModelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetConversationModel(request),
      [this](grpc::ClientContext& context,
             google::cloud::dialogflow::v2::GetConversationModelRequest const&
                 request) {
        return stub_->GetConversationModel(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::dialogflow::v2::ConversationModel>
ConversationModelsConnectionImpl::ListConversationModels(
    google::cloud::dialogflow::v2::ListConversationModelsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListConversationModels(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dialogflow::v2::ConversationModel>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dialogflow_es::ConversationModelsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dialogflow::v2::ListConversationModelsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::dialogflow::v2::
                       ListConversationModelsRequest const& request) {
              return stub->ListConversationModels(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dialogflow::v2::ListConversationModelsResponse r) {
        std::vector<google::cloud::dialogflow::v2::ConversationModel> result(
            r.conversation_models().size());
        auto& messages = *r.mutable_conversation_models();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<
    google::cloud::dialogflow::v2::DeleteConversationModelOperationMetadata>>
ConversationModelsConnectionImpl::DeleteConversationModel(
    google::cloud::dialogflow::v2::DeleteConversationModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dialogflow::v2::DeleteConversationModelOperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dialogflow::v2::DeleteConversationModelRequest const&
              request) {
        return stub->AsyncDeleteConversationModel(cq, std::move(context),
                                                  options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dialogflow::v2::
              DeleteConversationModelOperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteConversationModel(request),
      polling_policy(*current), __func__);
}

future<StatusOr<
    google::cloud::dialogflow::v2::DeployConversationModelOperationMetadata>>
ConversationModelsConnectionImpl::DeployConversationModel(
    google::cloud::dialogflow::v2::DeployConversationModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dialogflow::v2::DeployConversationModelOperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dialogflow::v2::DeployConversationModelRequest const&
              request) {
        return stub->AsyncDeployConversationModel(cq, std::move(context),
                                                  options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dialogflow::v2::
              DeployConversationModelOperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeployConversationModel(request),
      polling_policy(*current), __func__);
}

future<StatusOr<
    google::cloud::dialogflow::v2::UndeployConversationModelOperationMetadata>>
ConversationModelsConnectionImpl::UndeployConversationModel(
    google::cloud::dialogflow::v2::UndeployConversationModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dialogflow::v2::
          UndeployConversationModelOperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dialogflow::v2::UndeployConversationModelRequest const&
              request) {
        return stub->AsyncUndeployConversationModel(cq, std::move(context),
                                                    options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dialogflow::v2::
              UndeployConversationModelOperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UndeployConversationModel(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::dialogflow::v2::ConversationModelEvaluation>
ConversationModelsConnectionImpl::GetConversationModelEvaluation(
    google::cloud::dialogflow::v2::GetConversationModelEvaluationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetConversationModelEvaluation(request),
      [this](grpc::ClientContext& context,
             google::cloud::dialogflow::v2::
                 GetConversationModelEvaluationRequest const& request) {
        return stub_->GetConversationModelEvaluation(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::dialogflow::v2::ConversationModelEvaluation>
ConversationModelsConnectionImpl::ListConversationModelEvaluations(
    google::cloud::dialogflow::v2::ListConversationModelEvaluationsRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListConversationModelEvaluations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dialogflow::v2::ConversationModelEvaluation>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dialogflow_es::ConversationModelsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dialogflow::v2::
              ListConversationModelEvaluationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::dialogflow::v2::
                       ListConversationModelEvaluationsRequest const& request) {
              return stub->ListConversationModelEvaluations(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dialogflow::v2::ListConversationModelEvaluationsResponse
             r) {
        std::vector<google::cloud::dialogflow::v2::ConversationModelEvaluation>
            result(r.conversation_model_evaluations().size());
        auto& messages = *r.mutable_conversation_model_evaluations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationModelEvaluation>>
ConversationModelsConnectionImpl::CreateConversationModelEvaluation(
    google::cloud::dialogflow::v2::
        CreateConversationModelEvaluationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dialogflow::v2::ConversationModelEvaluation>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dialogflow::v2::
              CreateConversationModelEvaluationRequest const& request) {
        return stub->AsyncCreateConversationModelEvaluation(
            cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dialogflow::v2::ConversationModelEvaluation>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateConversationModelEvaluation(request),
      polling_policy(*current), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
