// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/admin/v1/datastore_admin.proto

#include "google/cloud/datastore/admin/v1/internal/datastore_admin_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace datastore_admin_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DatastoreAdminTracingConnection::DatastoreAdminTracingConnection(
    std::shared_ptr<datastore_admin_v1::DatastoreAdminConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::datastore::admin::v1::ExportEntitiesResponse>>
DatastoreAdminTracingConnection::ExportEntities(
    google::datastore::admin::v1::ExportEntitiesRequest const& request) {
  auto span = internal::MakeSpan(
      "datastore_admin_v1::DatastoreAdminConnection::ExportEntities");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ExportEntities(request));
}

future<StatusOr<google::datastore::admin::v1::ImportEntitiesMetadata>>
DatastoreAdminTracingConnection::ImportEntities(
    google::datastore::admin::v1::ImportEntitiesRequest const& request) {
  auto span = internal::MakeSpan(
      "datastore_admin_v1::DatastoreAdminConnection::ImportEntities");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ImportEntities(request));
}

future<StatusOr<google::datastore::admin::v1::Index>>
DatastoreAdminTracingConnection::CreateIndex(
    google::datastore::admin::v1::CreateIndexRequest const& request) {
  auto span = internal::MakeSpan(
      "datastore_admin_v1::DatastoreAdminConnection::CreateIndex");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateIndex(request));
}

future<StatusOr<google::datastore::admin::v1::Index>>
DatastoreAdminTracingConnection::DeleteIndex(
    google::datastore::admin::v1::DeleteIndexRequest const& request) {
  auto span = internal::MakeSpan(
      "datastore_admin_v1::DatastoreAdminConnection::DeleteIndex");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteIndex(request));
}

StatusOr<google::datastore::admin::v1::Index>
DatastoreAdminTracingConnection::GetIndex(
    google::datastore::admin::v1::GetIndexRequest const& request) {
  auto span = internal::MakeSpan(
      "datastore_admin_v1::DatastoreAdminConnection::GetIndex");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIndex(request));
}

StreamRange<google::datastore::admin::v1::Index>
DatastoreAdminTracingConnection::ListIndexes(
    google::datastore::admin::v1::ListIndexesRequest request) {
  auto span = internal::MakeSpan(
      "datastore_admin_v1::DatastoreAdminConnection::ListIndexes");
  internal::OTelScope scope(span);
  auto sr = child_->ListIndexes(std::move(request));
  return internal::MakeTracedStreamRange<google::datastore::admin::v1::Index>(
      std::move(span), std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<datastore_admin_v1::DatastoreAdminConnection>
MakeDatastoreAdminTracingConnection(
    std::shared_ptr<datastore_admin_v1::DatastoreAdminConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DatastoreAdminTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_admin_v1_internal
}  // namespace cloud
}  // namespace google
