// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_service.proto

#include "google/cloud/contentwarehouse/v1/document_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace contentwarehouse_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

DocumentServiceConnectionIdempotencyPolicy::
    ~DocumentServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<DocumentServiceConnectionIdempotencyPolicy>
DocumentServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<DocumentServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::CreateDocument(
    google::cloud::contentwarehouse::v1::CreateDocumentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::GetDocument(
    google::cloud::contentwarehouse::v1::GetDocumentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::UpdateDocument(
    google::cloud::contentwarehouse::v1::UpdateDocumentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::DeleteDocument(
    google::cloud::contentwarehouse::v1::DeleteDocumentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::SearchDocuments(
    google::cloud::contentwarehouse::v1::SearchDocumentsRequest) {  // NOLINT
  return Idempotency::kNonIdempotent;
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::LockDocument(
    google::cloud::contentwarehouse::v1::LockDocumentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::FetchAcl(
    google::cloud::contentwarehouse::v1::FetchAclRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DocumentServiceConnectionIdempotencyPolicy::SetAcl(
    google::cloud::contentwarehouse::v1::SetAclRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<DocumentServiceConnectionIdempotencyPolicy>
MakeDefaultDocumentServiceConnectionIdempotencyPolicy() {
  return std::make_unique<DocumentServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1
}  // namespace cloud
}  // namespace google
