// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/biglake/v1/metastore.proto

#include "google/cloud/bigquery/biglake/v1/internal/metastore_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace bigquery_biglake_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

MetastoreServiceTracingStub::MetastoreServiceTracingStub(
    std::shared_ptr<MetastoreServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceTracingStub::CreateCatalog(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::CreateCatalogRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "CreateCatalog");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateCatalog(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceTracingStub::DeleteCatalog(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::DeleteCatalogRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "DeleteCatalog");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteCatalog(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceTracingStub::GetCatalog(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::GetCatalogRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "GetCatalog");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetCatalog(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::ListCatalogsResponse>
MetastoreServiceTracingStub::ListCatalogs(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::ListCatalogsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "ListCatalogs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListCatalogs(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceTracingStub::CreateDatabase(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::CreateDatabaseRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "CreateDatabase");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateDatabase(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceTracingStub::DeleteDatabase(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::DeleteDatabaseRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "DeleteDatabase");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteDatabase(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceTracingStub::UpdateDatabase(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::UpdateDatabaseRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "UpdateDatabase");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateDatabase(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceTracingStub::GetDatabase(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::GetDatabaseRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "GetDatabase");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetDatabase(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::ListDatabasesResponse>
MetastoreServiceTracingStub::ListDatabases(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::ListDatabasesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "ListDatabases");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListDatabases(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceTracingStub::CreateTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::CreateTableRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "CreateTable");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateTable(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceTracingStub::DeleteTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::DeleteTableRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "DeleteTable");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteTable(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceTracingStub::UpdateTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::UpdateTableRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "UpdateTable");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateTable(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceTracingStub::RenameTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::RenameTableRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "RenameTable");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RenameTable(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceTracingStub::GetTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::GetTableRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "GetTable");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetTable(context, request));
}

StatusOr<google::cloud::bigquery::biglake::v1::ListTablesResponse>
MetastoreServiceTracingStub::ListTables(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::ListTablesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.biglake.v1.MetastoreService", "ListTables");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListTables(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<MetastoreServiceStub> MakeMetastoreServiceTracingStub(
    std::shared_ptr<MetastoreServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<MetastoreServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_biglake_v1_internal
}  // namespace cloud
}  // namespace google
