// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/endpoint_service.proto

#include "google/cloud/aiplatform/v1/endpoint_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EndpointServiceClient::EndpointServiceClient(
    std::shared_ptr<EndpointServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
EndpointServiceClient::~EndpointServiceClient() = default;

future<StatusOr<google::cloud::aiplatform::v1::Endpoint>>
EndpointServiceClient::CreateEndpoint(
    std::string const& parent,
    google::cloud::aiplatform::v1::Endpoint const& endpoint, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateEndpointRequest request;
  request.set_parent(parent);
  *request.mutable_endpoint() = endpoint;
  return connection_->CreateEndpoint(request);
}

future<StatusOr<google::cloud::aiplatform::v1::Endpoint>>
EndpointServiceClient::CreateEndpoint(
    std::string const& parent,
    google::cloud::aiplatform::v1::Endpoint const& endpoint,
    std::string const& endpoint_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateEndpointRequest request;
  request.set_parent(parent);
  *request.mutable_endpoint() = endpoint;
  request.set_endpoint_id(endpoint_id);
  return connection_->CreateEndpoint(request);
}

future<StatusOr<google::cloud::aiplatform::v1::Endpoint>>
EndpointServiceClient::CreateEndpoint(
    google::cloud::aiplatform::v1::CreateEndpointRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEndpoint(request);
}

StatusOr<google::cloud::aiplatform::v1::Endpoint>
EndpointServiceClient::GetEndpoint(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetEndpointRequest request;
  request.set_name(name);
  return connection_->GetEndpoint(request);
}

StatusOr<google::cloud::aiplatform::v1::Endpoint>
EndpointServiceClient::GetEndpoint(
    google::cloud::aiplatform::v1::GetEndpointRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEndpoint(request);
}

StreamRange<google::cloud::aiplatform::v1::Endpoint>
EndpointServiceClient::ListEndpoints(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListEndpointsRequest request;
  request.set_parent(parent);
  return connection_->ListEndpoints(request);
}

StreamRange<google::cloud::aiplatform::v1::Endpoint>
EndpointServiceClient::ListEndpoints(
    google::cloud::aiplatform::v1::ListEndpointsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEndpoints(std::move(request));
}

StatusOr<google::cloud::aiplatform::v1::Endpoint>
EndpointServiceClient::UpdateEndpoint(
    google::cloud::aiplatform::v1::Endpoint const& endpoint,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateEndpointRequest request;
  *request.mutable_endpoint() = endpoint;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateEndpoint(request);
}

StatusOr<google::cloud::aiplatform::v1::Endpoint>
EndpointServiceClient::UpdateEndpoint(
    google::cloud::aiplatform::v1::UpdateEndpointRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEndpoint(request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
EndpointServiceClient::DeleteEndpoint(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteEndpointRequest request;
  request.set_name(name);
  return connection_->DeleteEndpoint(request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
EndpointServiceClient::DeleteEndpoint(
    google::cloud::aiplatform::v1::DeleteEndpointRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEndpoint(request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeployModelResponse>>
EndpointServiceClient::DeployModel(
    std::string const& endpoint,
    google::cloud::aiplatform::v1::DeployedModel const& deployed_model,
    std::map<std::string, std::int32_t> const& traffic_split, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeployModelRequest request;
  request.set_endpoint(endpoint);
  *request.mutable_deployed_model() = deployed_model;
  *request.mutable_traffic_split() = {traffic_split.begin(),
                                      traffic_split.end()};
  return connection_->DeployModel(request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeployModelResponse>>
EndpointServiceClient::DeployModel(
    google::cloud::aiplatform::v1::DeployModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeployModel(request);
}

future<StatusOr<google::cloud::aiplatform::v1::UndeployModelResponse>>
EndpointServiceClient::UndeployModel(
    std::string const& endpoint, std::string const& deployed_model_id,
    std::map<std::string, std::int32_t> const& traffic_split, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UndeployModelRequest request;
  request.set_endpoint(endpoint);
  request.set_deployed_model_id(deployed_model_id);
  *request.mutable_traffic_split() = {traffic_split.begin(),
                                      traffic_split.end()};
  return connection_->UndeployModel(request);
}

future<StatusOr<google::cloud::aiplatform::v1::UndeployModelResponse>>
EndpointServiceClient::UndeployModel(
    google::cloud::aiplatform::v1::UndeployModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeployModel(request);
}

future<StatusOr<google::cloud::aiplatform::v1::MutateDeployedModelResponse>>
EndpointServiceClient::MutateDeployedModel(
    std::string const& endpoint,
    google::cloud::aiplatform::v1::DeployedModel const& deployed_model,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::MutateDeployedModelRequest request;
  request.set_endpoint(endpoint);
  *request.mutable_deployed_model() = deployed_model;
  *request.mutable_update_mask() = update_mask;
  return connection_->MutateDeployedModel(request);
}

future<StatusOr<google::cloud::aiplatform::v1::MutateDeployedModelResponse>>
EndpointServiceClient::MutateDeployedModel(
    google::cloud::aiplatform::v1::MutateDeployedModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->MutateDeployedModel(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
