// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/accessapproval/v1/accessapproval.proto

#include "google/cloud/accessapproval/v1/access_approval_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace accessapproval_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AccessApprovalConnectionIdempotencyPolicy::
    ~AccessApprovalConnectionIdempotencyPolicy() = default;

std::unique_ptr<AccessApprovalConnectionIdempotencyPolicy>
AccessApprovalConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<AccessApprovalConnectionIdempotencyPolicy>(*this);
}

Idempotency AccessApprovalConnectionIdempotencyPolicy::ListApprovalRequests(
    google::cloud::accessapproval::v1::ListApprovalRequestsMessage) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AccessApprovalConnectionIdempotencyPolicy::GetApprovalRequest(
    google::cloud::accessapproval::v1::GetApprovalRequestMessage const&) {
  return Idempotency::kIdempotent;
}

Idempotency AccessApprovalConnectionIdempotencyPolicy::ApproveApprovalRequest(
    google::cloud::accessapproval::v1::ApproveApprovalRequestMessage const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AccessApprovalConnectionIdempotencyPolicy::DismissApprovalRequest(
    google::cloud::accessapproval::v1::DismissApprovalRequestMessage const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
AccessApprovalConnectionIdempotencyPolicy::InvalidateApprovalRequest(
    google::cloud::accessapproval::v1::
        InvalidateApprovalRequestMessage const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
AccessApprovalConnectionIdempotencyPolicy::GetAccessApprovalSettings(
    google::cloud::accessapproval::v1::
        GetAccessApprovalSettingsMessage const&) {
  return Idempotency::kIdempotent;
}

Idempotency
AccessApprovalConnectionIdempotencyPolicy::UpdateAccessApprovalSettings(
    google::cloud::accessapproval::v1::
        UpdateAccessApprovalSettingsMessage const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
AccessApprovalConnectionIdempotencyPolicy::DeleteAccessApprovalSettings(
    google::cloud::accessapproval::v1::
        DeleteAccessApprovalSettingsMessage const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
AccessApprovalConnectionIdempotencyPolicy::GetAccessApprovalServiceAccount(
    google::cloud::accessapproval::v1::
        GetAccessApprovalServiceAccountMessage const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<AccessApprovalConnectionIdempotencyPolicy>
MakeDefaultAccessApprovalConnectionIdempotencyPolicy() {
  return std::make_unique<AccessApprovalConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accessapproval_v1
}  // namespace cloud
}  // namespace google
