// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/websecurityscanner/v1/web_security_scanner.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBSECURITYSCANNER_V1_WEB_SECURITY_SCANNER_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBSECURITYSCANNER_V1_WEB_SECURITY_SCANNER_CONNECTION_H

#include "google/cloud/websecurityscanner/v1/internal/web_security_scanner_retry_traits.h"
#include "google/cloud/websecurityscanner/v1/web_security_scanner_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/websecurityscanner/v1/web_security_scanner.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace websecurityscanner_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `WebSecurityScannerConnection`.
class WebSecurityScannerRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<WebSecurityScannerRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `WebSecurityScannerConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class WebSecurityScannerLimitedErrorCountRetryPolicy
    : public WebSecurityScannerRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit WebSecurityScannerLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  WebSecurityScannerLimitedErrorCountRetryPolicy(
      WebSecurityScannerLimitedErrorCountRetryPolicy&& rhs) noexcept
      : WebSecurityScannerLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {
  }
  WebSecurityScannerLimitedErrorCountRetryPolicy(
      WebSecurityScannerLimitedErrorCountRetryPolicy const& rhs) noexcept
      : WebSecurityScannerLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {
  }

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<WebSecurityScannerRetryPolicy> clone() const override {
    return std::make_unique<WebSecurityScannerLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = WebSecurityScannerRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      websecurityscanner_v1_internal::WebSecurityScannerRetryTraits>
      impl_;
};

/**
 * A retry policy for `WebSecurityScannerConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class WebSecurityScannerLimitedTimeRetryPolicy
    : public WebSecurityScannerRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit WebSecurityScannerLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  WebSecurityScannerLimitedTimeRetryPolicy(
      WebSecurityScannerLimitedTimeRetryPolicy&& rhs) noexcept
      : WebSecurityScannerLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  WebSecurityScannerLimitedTimeRetryPolicy(
      WebSecurityScannerLimitedTimeRetryPolicy const& rhs) noexcept
      : WebSecurityScannerLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<WebSecurityScannerRetryPolicy> clone() const override {
    return std::make_unique<WebSecurityScannerLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = WebSecurityScannerRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      websecurityscanner_v1_internal::WebSecurityScannerRetryTraits>
      impl_;
};

/**
 * The `WebSecurityScannerConnection` object for `WebSecurityScannerClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `WebSecurityScannerClient`. This allows users to inject custom
 * behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `WebSecurityScannerClient`.
 *
 * To create a concrete instance, see `MakeWebSecurityScannerConnection()`.
 *
 * For mocking, see
 * `websecurityscanner_v1_mocks::MockWebSecurityScannerConnection`.
 */
class WebSecurityScannerConnection {
 public:
  virtual ~WebSecurityScannerConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::websecurityscanner::v1::ScanConfig>
  CreateScanConfig(
      google::cloud::websecurityscanner::v1::CreateScanConfigRequest const&
          request);

  virtual Status DeleteScanConfig(
      google::cloud::websecurityscanner::v1::DeleteScanConfigRequest const&
          request);

  virtual StatusOr<google::cloud::websecurityscanner::v1::ScanConfig>
  GetScanConfig(
      google::cloud::websecurityscanner::v1::GetScanConfigRequest const&
          request);

  virtual StreamRange<google::cloud::websecurityscanner::v1::ScanConfig>
  ListScanConfigs(
      google::cloud::websecurityscanner::v1::ListScanConfigsRequest request);

  virtual StatusOr<google::cloud::websecurityscanner::v1::ScanConfig>
  UpdateScanConfig(
      google::cloud::websecurityscanner::v1::UpdateScanConfigRequest const&
          request);

  virtual StatusOr<google::cloud::websecurityscanner::v1::ScanRun> StartScanRun(
      google::cloud::websecurityscanner::v1::StartScanRunRequest const&
          request);

  virtual StatusOr<google::cloud::websecurityscanner::v1::ScanRun> GetScanRun(
      google::cloud::websecurityscanner::v1::GetScanRunRequest const& request);

  virtual StreamRange<google::cloud::websecurityscanner::v1::ScanRun>
  ListScanRuns(
      google::cloud::websecurityscanner::v1::ListScanRunsRequest request);

  virtual StatusOr<google::cloud::websecurityscanner::v1::ScanRun> StopScanRun(
      google::cloud::websecurityscanner::v1::StopScanRunRequest const& request);

  virtual StreamRange<google::cloud::websecurityscanner::v1::CrawledUrl>
  ListCrawledUrls(
      google::cloud::websecurityscanner::v1::ListCrawledUrlsRequest request);

  virtual StatusOr<google::cloud::websecurityscanner::v1::Finding> GetFinding(
      google::cloud::websecurityscanner::v1::GetFindingRequest const& request);

  virtual StreamRange<google::cloud::websecurityscanner::v1::Finding>
  ListFindings(
      google::cloud::websecurityscanner::v1::ListFindingsRequest request);

  virtual StatusOr<
      google::cloud::websecurityscanner::v1::ListFindingTypeStatsResponse>
  ListFindingTypeStats(
      google::cloud::websecurityscanner::v1::ListFindingTypeStatsRequest const&
          request);
};

/**
 * A factory function to construct an object of type
 * `WebSecurityScannerConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * WebSecurityScannerClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `WebSecurityScannerConnection`. Expected options are any of the
 * types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::websecurityscanner_v1::WebSecurityScannerPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `WebSecurityScannerConnection`
 * created by this function.
 */
std::shared_ptr<WebSecurityScannerConnection> MakeWebSecurityScannerConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace websecurityscanner_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBSECURITYSCANNER_V1_WEB_SECURITY_SCANNER_CONNECTION_H
