// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

#include "google/cloud/spanner/admin/internal/instance_admin_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace spanner_admin_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

InstanceAdminTracingConnection::InstanceAdminTracingConnection(
    std::shared_ptr<spanner_admin::InstanceAdminConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::spanner::admin::instance::v1::InstanceConfig>
InstanceAdminTracingConnection::ListInstanceConfigs(
    google::spanner::admin::instance::v1::ListInstanceConfigsRequest request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::ListInstanceConfigs");
  internal::OTelScope scope(span);
  auto sr = child_->ListInstanceConfigs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::spanner::admin::instance::v1::InstanceConfig>(std::move(span),
                                                            std::move(sr));
}

StatusOr<google::spanner::admin::instance::v1::InstanceConfig>
InstanceAdminTracingConnection::GetInstanceConfig(
    google::spanner::admin::instance::v1::GetInstanceConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::GetInstanceConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInstanceConfig(request));
}

future<StatusOr<google::spanner::admin::instance::v1::InstanceConfig>>
InstanceAdminTracingConnection::CreateInstanceConfig(
    google::spanner::admin::instance::v1::CreateInstanceConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::CreateInstanceConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateInstanceConfig(request));
}

StatusOr<google::longrunning::Operation>
InstanceAdminTracingConnection::CreateInstanceConfig(
    NoAwaitTag,
    google::spanner::admin::instance::v1::CreateInstanceConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::CreateInstanceConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateInstanceConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::spanner::admin::instance::v1::InstanceConfig>>
InstanceAdminTracingConnection::CreateInstanceConfig(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::CreateInstanceConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateInstanceConfig(operation));
}

future<StatusOr<google::spanner::admin::instance::v1::InstanceConfig>>
InstanceAdminTracingConnection::UpdateInstanceConfig(
    google::spanner::admin::instance::v1::UpdateInstanceConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::UpdateInstanceConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateInstanceConfig(request));
}

StatusOr<google::longrunning::Operation>
InstanceAdminTracingConnection::UpdateInstanceConfig(
    NoAwaitTag,
    google::spanner::admin::instance::v1::UpdateInstanceConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::UpdateInstanceConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateInstanceConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::spanner::admin::instance::v1::InstanceConfig>>
InstanceAdminTracingConnection::UpdateInstanceConfig(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::UpdateInstanceConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateInstanceConfig(operation));
}

Status InstanceAdminTracingConnection::DeleteInstanceConfig(
    google::spanner::admin::instance::v1::DeleteInstanceConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::DeleteInstanceConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteInstanceConfig(request));
}

StreamRange<google::longrunning::Operation>
InstanceAdminTracingConnection::ListInstanceConfigOperations(
    google::spanner::admin::instance::v1::ListInstanceConfigOperationsRequest
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::ListInstanceConfigOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListInstanceConfigOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StreamRange<google::spanner::admin::instance::v1::Instance>
InstanceAdminTracingConnection::ListInstances(
    google::spanner::admin::instance::v1::ListInstancesRequest request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::ListInstances");
  internal::OTelScope scope(span);
  auto sr = child_->ListInstances(std::move(request));
  return internal::MakeTracedStreamRange<
      google::spanner::admin::instance::v1::Instance>(std::move(span),
                                                      std::move(sr));
}

StreamRange<google::spanner::admin::instance::v1::InstancePartition>
InstanceAdminTracingConnection::ListInstancePartitions(
    google::spanner::admin::instance::v1::ListInstancePartitionsRequest
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::ListInstancePartitions");
  internal::OTelScope scope(span);
  auto sr = child_->ListInstancePartitions(std::move(request));
  return internal::MakeTracedStreamRange<
      google::spanner::admin::instance::v1::InstancePartition>(std::move(span),
                                                               std::move(sr));
}

StatusOr<google::spanner::admin::instance::v1::Instance>
InstanceAdminTracingConnection::GetInstance(
    google::spanner::admin::instance::v1::GetInstanceRequest const& request) {
  auto span =
      internal::MakeSpan("spanner_admin::InstanceAdminConnection::GetInstance");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInstance(request));
}

future<StatusOr<google::spanner::admin::instance::v1::Instance>>
InstanceAdminTracingConnection::CreateInstance(
    google::spanner::admin::instance::v1::CreateInstanceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::CreateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateInstance(request));
}

StatusOr<google::longrunning::Operation>
InstanceAdminTracingConnection::CreateInstance(
    NoAwaitTag,
    google::spanner::admin::instance::v1::CreateInstanceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::CreateInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::spanner::admin::instance::v1::Instance>>
InstanceAdminTracingConnection::CreateInstance(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::CreateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateInstance(operation));
}

future<StatusOr<google::spanner::admin::instance::v1::Instance>>
InstanceAdminTracingConnection::UpdateInstance(
    google::spanner::admin::instance::v1::UpdateInstanceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::UpdateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateInstance(request));
}

StatusOr<google::longrunning::Operation>
InstanceAdminTracingConnection::UpdateInstance(
    NoAwaitTag,
    google::spanner::admin::instance::v1::UpdateInstanceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::UpdateInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::spanner::admin::instance::v1::Instance>>
InstanceAdminTracingConnection::UpdateInstance(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::UpdateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateInstance(operation));
}

Status InstanceAdminTracingConnection::DeleteInstance(
    google::spanner::admin::instance::v1::DeleteInstanceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::DeleteInstance");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteInstance(request));
}

StatusOr<google::iam::v1::Policy> InstanceAdminTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy> InstanceAdminTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
InstanceAdminTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

StatusOr<google::spanner::admin::instance::v1::InstancePartition>
InstanceAdminTracingConnection::GetInstancePartition(
    google::spanner::admin::instance::v1::GetInstancePartitionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::GetInstancePartition");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInstancePartition(request));
}

future<StatusOr<google::spanner::admin::instance::v1::InstancePartition>>
InstanceAdminTracingConnection::CreateInstancePartition(
    google::spanner::admin::instance::v1::CreateInstancePartitionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::CreateInstancePartition");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateInstancePartition(request));
}

StatusOr<google::longrunning::Operation>
InstanceAdminTracingConnection::CreateInstancePartition(
    NoAwaitTag,
    google::spanner::admin::instance::v1::CreateInstancePartitionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::CreateInstancePartition");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateInstancePartition(NoAwaitTag{}, request));
}

future<StatusOr<google::spanner::admin::instance::v1::InstancePartition>>
InstanceAdminTracingConnection::CreateInstancePartition(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::CreateInstancePartition");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateInstancePartition(operation));
}

Status InstanceAdminTracingConnection::DeleteInstancePartition(
    google::spanner::admin::instance::v1::DeleteInstancePartitionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::DeleteInstancePartition");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteInstancePartition(request));
}

future<StatusOr<google::spanner::admin::instance::v1::InstancePartition>>
InstanceAdminTracingConnection::UpdateInstancePartition(
    google::spanner::admin::instance::v1::UpdateInstancePartitionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::UpdateInstancePartition");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateInstancePartition(request));
}

StatusOr<google::longrunning::Operation>
InstanceAdminTracingConnection::UpdateInstancePartition(
    NoAwaitTag,
    google::spanner::admin::instance::v1::UpdateInstancePartitionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::UpdateInstancePartition");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->UpdateInstancePartition(NoAwaitTag{}, request));
}

future<StatusOr<google::spanner::admin::instance::v1::InstancePartition>>
InstanceAdminTracingConnection::UpdateInstancePartition(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::UpdateInstancePartition");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateInstancePartition(operation));
}

StreamRange<google::longrunning::Operation>
InstanceAdminTracingConnection::ListInstancePartitionOperations(
    google::spanner::admin::instance::v1::ListInstancePartitionOperationsRequest
        request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::"
      "ListInstancePartitionOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListInstancePartitionOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::spanner::admin::instance::v1::MoveInstanceResponse>>
InstanceAdminTracingConnection::MoveInstance(
    google::spanner::admin::instance::v1::MoveInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::MoveInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->MoveInstance(request));
}

StatusOr<google::longrunning::Operation>
InstanceAdminTracingConnection::MoveInstance(
    NoAwaitTag,
    google::spanner::admin::instance::v1::MoveInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::MoveInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->MoveInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::spanner::admin::instance::v1::MoveInstanceResponse>>
InstanceAdminTracingConnection::MoveInstance(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "spanner_admin::InstanceAdminConnection::MoveInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->MoveInstance(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<spanner_admin::InstanceAdminConnection>
MakeInstanceAdminTracingConnection(
    std::shared_ptr<spanner_admin::InstanceAdminConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<InstanceAdminTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace spanner_admin_internal
}  // namespace cloud
}  // namespace google
