// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/model_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_MODEL_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_MODEL_TRACING_CONNECTION_H

#include "google/cloud/retail/v2/model_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace retail_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ModelServiceTracingConnection : public retail_v2::ModelServiceConnection {
 public:
  ~ModelServiceTracingConnection() override = default;

  explicit ModelServiceTracingConnection(
      std::shared_ptr<retail_v2::ModelServiceConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::retail::v2::Model>> CreateModel(
      google::cloud::retail::v2::CreateModelRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateModel(
      NoAwaitTag,
      google::cloud::retail::v2::CreateModelRequest const& request) override;

  future<StatusOr<google::cloud::retail::v2::Model>> CreateModel(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::retail::v2::Model> GetModel(
      google::cloud::retail::v2::GetModelRequest const& request) override;

  StatusOr<google::cloud::retail::v2::Model> PauseModel(
      google::cloud::retail::v2::PauseModelRequest const& request) override;

  StatusOr<google::cloud::retail::v2::Model> ResumeModel(
      google::cloud::retail::v2::ResumeModelRequest const& request) override;

  Status DeleteModel(
      google::cloud::retail::v2::DeleteModelRequest const& request) override;

  StreamRange<google::cloud::retail::v2::Model> ListModels(
      google::cloud::retail::v2::ListModelsRequest request) override;

  StatusOr<google::cloud::retail::v2::Model> UpdateModel(
      google::cloud::retail::v2::UpdateModelRequest const& request) override;

  future<StatusOr<google::cloud::retail::v2::TuneModelResponse>> TuneModel(
      google::cloud::retail::v2::TuneModelRequest const& request) override;

  StatusOr<google::longrunning::Operation> TuneModel(
      NoAwaitTag,
      google::cloud::retail::v2::TuneModelRequest const& request) override;

  future<StatusOr<google::cloud::retail::v2::TuneModelResponse>> TuneModel(
      google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<retail_v2::ModelServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<retail_v2::ModelServiceConnection>
MakeModelServiceTracingConnection(
    std::shared_ptr<retail_v2::ModelServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_MODEL_TRACING_CONNECTION_H
