// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkconnectivity/v1/policy_based_routing.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_INTERNAL_POLICY_BASED_ROUTING_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_INTERNAL_POLICY_BASED_ROUTING_CONNECTION_IMPL_H

#include "google/cloud/networkconnectivity/v1/internal/policy_based_routing_retry_traits.h"
#include "google/cloud/networkconnectivity/v1/internal/policy_based_routing_stub.h"
#include "google/cloud/networkconnectivity/v1/policy_based_routing_connection.h"
#include "google/cloud/networkconnectivity/v1/policy_based_routing_connection_idempotency_policy.h"
#include "google/cloud/networkconnectivity/v1/policy_based_routing_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace networkconnectivity_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class PolicyBasedRoutingServiceConnectionImpl
    : public networkconnectivity_v1::PolicyBasedRoutingServiceConnection {
 public:
  ~PolicyBasedRoutingServiceConnectionImpl() override = default;

  PolicyBasedRoutingServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<
          networkconnectivity_v1_internal::PolicyBasedRoutingServiceStub>
          stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
  ListPolicyBasedRoutes(
      google::cloud::networkconnectivity::v1::ListPolicyBasedRoutesRequest
          request) override;

  StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
  GetPolicyBasedRoute(
      google::cloud::networkconnectivity::v1::GetPolicyBasedRouteRequest const&
          request) override;

  future<StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>
  CreatePolicyBasedRoute(
      google::cloud::networkconnectivity::v1::
          CreatePolicyBasedRouteRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreatePolicyBasedRoute(
      NoAwaitTag, google::cloud::networkconnectivity::v1::
                      CreatePolicyBasedRouteRequest const& request) override;

  future<StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>
  CreatePolicyBasedRoute(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
  DeletePolicyBasedRoute(
      google::cloud::networkconnectivity::v1::
          DeletePolicyBasedRouteRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeletePolicyBasedRoute(
      NoAwaitTag, google::cloud::networkconnectivity::v1::
                      DeletePolicyBasedRouteRequest const& request) override;

  future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
  DeletePolicyBasedRoute(
      google::longrunning::Operation const& operation) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<
      networkconnectivity_v1_internal::PolicyBasedRoutingServiceStub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkconnectivity_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_INTERNAL_POLICY_BASED_ROUTING_CONNECTION_IMPL_H
