// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

#include "google/cloud/migrationcenter/v1/internal/migration_center_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace migrationcenter_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

MigrationCenterTracingConnection::MigrationCenterTracingConnection(
    std::shared_ptr<migrationcenter_v1::MigrationCenterConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::migrationcenter::v1::Asset>
MigrationCenterTracingConnection::ListAssets(
    google::cloud::migrationcenter::v1::ListAssetsRequest request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::ListAssets");
  internal::OTelScope scope(span);
  auto sr = child_->ListAssets(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::migrationcenter::v1::Asset>(std::move(span),
                                                 std::move(sr));
}

StatusOr<google::cloud::migrationcenter::v1::Asset>
MigrationCenterTracingConnection::GetAsset(
    google::cloud::migrationcenter::v1::GetAssetRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::GetAsset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAsset(request));
}

StatusOr<google::cloud::migrationcenter::v1::Asset>
MigrationCenterTracingConnection::UpdateAsset(
    google::cloud::migrationcenter::v1::UpdateAssetRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdateAsset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateAsset(request));
}

StatusOr<google::cloud::migrationcenter::v1::BatchUpdateAssetsResponse>
MigrationCenterTracingConnection::BatchUpdateAssets(
    google::cloud::migrationcenter::v1::BatchUpdateAssetsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::BatchUpdateAssets");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->BatchUpdateAssets(request));
}

Status MigrationCenterTracingConnection::DeleteAsset(
    google::cloud::migrationcenter::v1::DeleteAssetRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteAsset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteAsset(request));
}

Status MigrationCenterTracingConnection::BatchDeleteAssets(
    google::cloud::migrationcenter::v1::BatchDeleteAssetsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::BatchDeleteAssets");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->BatchDeleteAssets(request));
}

StatusOr<google::cloud::migrationcenter::v1::ReportAssetFramesResponse>
MigrationCenterTracingConnection::ReportAssetFrames(
    google::cloud::migrationcenter::v1::ReportAssetFramesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::ReportAssetFrames");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ReportAssetFrames(request));
}

StatusOr<google::cloud::migrationcenter::v1::AggregateAssetsValuesResponse>
MigrationCenterTracingConnection::AggregateAssetsValues(
    google::cloud::migrationcenter::v1::AggregateAssetsValuesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::AggregateAssetsValues");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->AggregateAssetsValues(request));
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
MigrationCenterTracingConnection::CreateImportJob(
    google::cloud::migrationcenter::v1::CreateImportJobRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateImportJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateImportJob(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::CreateImportJob(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreateImportJobRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateImportJob");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateImportJob(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
MigrationCenterTracingConnection::CreateImportJob(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateImportJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateImportJob(operation));
}

StreamRange<google::cloud::migrationcenter::v1::ImportJob>
MigrationCenterTracingConnection::ListImportJobs(
    google::cloud::migrationcenter::v1::ListImportJobsRequest request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::ListImportJobs");
  internal::OTelScope scope(span);
  auto sr = child_->ListImportJobs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::migrationcenter::v1::ImportJob>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::migrationcenter::v1::ImportJob>
MigrationCenterTracingConnection::GetImportJob(
    google::cloud::migrationcenter::v1::GetImportJobRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::GetImportJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetImportJob(request));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeleteImportJob(
    google::cloud::migrationcenter::v1::DeleteImportJobRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteImportJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteImportJob(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::DeleteImportJob(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeleteImportJobRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteImportJob");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteImportJob(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeleteImportJob(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteImportJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteImportJob(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
MigrationCenterTracingConnection::UpdateImportJob(
    google::cloud::migrationcenter::v1::UpdateImportJobRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdateImportJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateImportJob(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::UpdateImportJob(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::UpdateImportJobRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdateImportJob");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateImportJob(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
MigrationCenterTracingConnection::UpdateImportJob(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdateImportJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateImportJob(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::ValidateImportJob(
    google::cloud::migrationcenter::v1::ValidateImportJobRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::ValidateImportJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ValidateImportJob(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::ValidateImportJob(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::ValidateImportJobRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::ValidateImportJob");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->ValidateImportJob(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::ValidateImportJob(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::ValidateImportJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ValidateImportJob(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::RunImportJob(
    google::cloud::migrationcenter::v1::RunImportJobRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::RunImportJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RunImportJob(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::RunImportJob(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::RunImportJobRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::RunImportJob");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->RunImportJob(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::RunImportJob(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::RunImportJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RunImportJob(operation));
}

StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>
MigrationCenterTracingConnection::GetImportDataFile(
    google::cloud::migrationcenter::v1::GetImportDataFileRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::GetImportDataFile");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetImportDataFile(request));
}

StreamRange<google::cloud::migrationcenter::v1::ImportDataFile>
MigrationCenterTracingConnection::ListImportDataFiles(
    google::cloud::migrationcenter::v1::ListImportDataFilesRequest request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::ListImportDataFiles");
  internal::OTelScope scope(span);
  auto sr = child_->ListImportDataFiles(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::migrationcenter::v1::ImportDataFile>(std::move(span),
                                                          std::move(sr));
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>>
MigrationCenterTracingConnection::CreateImportDataFile(
    google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateImportDataFile");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateImportDataFile(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::CreateImportDataFile(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateImportDataFile");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateImportDataFile(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>>
MigrationCenterTracingConnection::CreateImportDataFile(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateImportDataFile");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateImportDataFile(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeleteImportDataFile(
    google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteImportDataFile");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteImportDataFile(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::DeleteImportDataFile(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteImportDataFile");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteImportDataFile(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeleteImportDataFile(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteImportDataFile");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteImportDataFile(operation));
}

StreamRange<google::cloud::migrationcenter::v1::Group>
MigrationCenterTracingConnection::ListGroups(
    google::cloud::migrationcenter::v1::ListGroupsRequest request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::ListGroups");
  internal::OTelScope scope(span);
  auto sr = child_->ListGroups(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::migrationcenter::v1::Group>(std::move(span),
                                                 std::move(sr));
}

StatusOr<google::cloud::migrationcenter::v1::Group>
MigrationCenterTracingConnection::GetGroup(
    google::cloud::migrationcenter::v1::GetGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::GetGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetGroup(request));
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterTracingConnection::CreateGroup(
    google::cloud::migrationcenter::v1::CreateGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateGroup(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::CreateGroup(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreateGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterTracingConnection::CreateGroup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateGroup(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterTracingConnection::UpdateGroup(
    google::cloud::migrationcenter::v1::UpdateGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdateGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateGroup(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::UpdateGroup(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::UpdateGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdateGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterTracingConnection::UpdateGroup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdateGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateGroup(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeleteGroup(
    google::cloud::migrationcenter::v1::DeleteGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteGroup(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::DeleteGroup(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeleteGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeleteGroup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteGroup(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterTracingConnection::AddAssetsToGroup(
    google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::AddAssetsToGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AddAssetsToGroup(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::AddAssetsToGroup(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::AddAssetsToGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->AddAssetsToGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterTracingConnection::AddAssetsToGroup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::AddAssetsToGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->AddAssetsToGroup(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterTracingConnection::RemoveAssetsFromGroup(
    google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::RemoveAssetsFromGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->RemoveAssetsFromGroup(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::RemoveAssetsFromGroup(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::RemoveAssetsFromGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->RemoveAssetsFromGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterTracingConnection::RemoveAssetsFromGroup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::RemoveAssetsFromGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->RemoveAssetsFromGroup(operation));
}

StreamRange<google::cloud::migrationcenter::v1::ErrorFrame>
MigrationCenterTracingConnection::ListErrorFrames(
    google::cloud::migrationcenter::v1::ListErrorFramesRequest request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::ListErrorFrames");
  internal::OTelScope scope(span);
  auto sr = child_->ListErrorFrames(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::migrationcenter::v1::ErrorFrame>(std::move(span),
                                                      std::move(sr));
}

StatusOr<google::cloud::migrationcenter::v1::ErrorFrame>
MigrationCenterTracingConnection::GetErrorFrame(
    google::cloud::migrationcenter::v1::GetErrorFrameRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::GetErrorFrame");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetErrorFrame(request));
}

StreamRange<google::cloud::migrationcenter::v1::Source>
MigrationCenterTracingConnection::ListSources(
    google::cloud::migrationcenter::v1::ListSourcesRequest request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::ListSources");
  internal::OTelScope scope(span);
  auto sr = child_->ListSources(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::migrationcenter::v1::Source>(std::move(span),
                                                  std::move(sr));
}

StatusOr<google::cloud::migrationcenter::v1::Source>
MigrationCenterTracingConnection::GetSource(
    google::cloud::migrationcenter::v1::GetSourceRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::GetSource");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSource(request));
}

future<StatusOr<google::cloud::migrationcenter::v1::Source>>
MigrationCenterTracingConnection::CreateSource(
    google::cloud::migrationcenter::v1::CreateSourceRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateSource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSource(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::CreateSource(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreateSourceRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateSource");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateSource(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::Source>>
MigrationCenterTracingConnection::CreateSource(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateSource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSource(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::Source>>
MigrationCenterTracingConnection::UpdateSource(
    google::cloud::migrationcenter::v1::UpdateSourceRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdateSource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSource(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::UpdateSource(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::UpdateSourceRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdateSource");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateSource(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::Source>>
MigrationCenterTracingConnection::UpdateSource(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdateSource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSource(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeleteSource(
    google::cloud::migrationcenter::v1::DeleteSourceRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteSource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSource(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::DeleteSource(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeleteSourceRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteSource");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteSource(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeleteSource(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteSource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSource(operation));
}

StreamRange<google::cloud::migrationcenter::v1::PreferenceSet>
MigrationCenterTracingConnection::ListPreferenceSets(
    google::cloud::migrationcenter::v1::ListPreferenceSetsRequest request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::ListPreferenceSets");
  internal::OTelScope scope(span);
  auto sr = child_->ListPreferenceSets(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::migrationcenter::v1::PreferenceSet>(std::move(span),
                                                         std::move(sr));
}

StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>
MigrationCenterTracingConnection::GetPreferenceSet(
    google::cloud::migrationcenter::v1::GetPreferenceSetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::GetPreferenceSet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetPreferenceSet(request));
}

future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
MigrationCenterTracingConnection::CreatePreferenceSet(
    google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreatePreferenceSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreatePreferenceSet(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::CreatePreferenceSet(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreatePreferenceSet");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreatePreferenceSet(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
MigrationCenterTracingConnection::CreatePreferenceSet(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreatePreferenceSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreatePreferenceSet(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
MigrationCenterTracingConnection::UpdatePreferenceSet(
    google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdatePreferenceSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdatePreferenceSet(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::UpdatePreferenceSet(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdatePreferenceSet");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdatePreferenceSet(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
MigrationCenterTracingConnection::UpdatePreferenceSet(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdatePreferenceSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdatePreferenceSet(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeletePreferenceSet(
    google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeletePreferenceSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeletePreferenceSet(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::DeletePreferenceSet(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeletePreferenceSet");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeletePreferenceSet(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeletePreferenceSet(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeletePreferenceSet");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeletePreferenceSet(operation));
}

StatusOr<google::cloud::migrationcenter::v1::Settings>
MigrationCenterTracingConnection::GetSettings(
    google::cloud::migrationcenter::v1::GetSettingsRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::GetSettings");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSettings(request));
}

future<StatusOr<google::cloud::migrationcenter::v1::Settings>>
MigrationCenterTracingConnection::UpdateSettings(
    google::cloud::migrationcenter::v1::UpdateSettingsRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdateSettings");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSettings(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::UpdateSettings(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::UpdateSettingsRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdateSettings");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateSettings(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::Settings>>
MigrationCenterTracingConnection::UpdateSettings(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::UpdateSettings");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSettings(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::ReportConfig>>
MigrationCenterTracingConnection::CreateReportConfig(
    google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateReportConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateReportConfig(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::CreateReportConfig(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateReportConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateReportConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::ReportConfig>>
MigrationCenterTracingConnection::CreateReportConfig(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateReportConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateReportConfig(operation));
}

StatusOr<google::cloud::migrationcenter::v1::ReportConfig>
MigrationCenterTracingConnection::GetReportConfig(
    google::cloud::migrationcenter::v1::GetReportConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::GetReportConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetReportConfig(request));
}

StreamRange<google::cloud::migrationcenter::v1::ReportConfig>
MigrationCenterTracingConnection::ListReportConfigs(
    google::cloud::migrationcenter::v1::ListReportConfigsRequest request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::ListReportConfigs");
  internal::OTelScope scope(span);
  auto sr = child_->ListReportConfigs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::migrationcenter::v1::ReportConfig>(std::move(span),
                                                        std::move(sr));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeleteReportConfig(
    google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteReportConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteReportConfig(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::DeleteReportConfig(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteReportConfig");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteReportConfig(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeleteReportConfig(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteReportConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteReportConfig(operation));
}

future<StatusOr<google::cloud::migrationcenter::v1::Report>>
MigrationCenterTracingConnection::CreateReport(
    google::cloud::migrationcenter::v1::CreateReportRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateReport");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateReport(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::CreateReport(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreateReportRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateReport");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateReport(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::Report>>
MigrationCenterTracingConnection::CreateReport(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::CreateReport");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateReport(operation));
}

StatusOr<google::cloud::migrationcenter::v1::Report>
MigrationCenterTracingConnection::GetReport(
    google::cloud::migrationcenter::v1::GetReportRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::GetReport");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetReport(request));
}

StreamRange<google::cloud::migrationcenter::v1::Report>
MigrationCenterTracingConnection::ListReports(
    google::cloud::migrationcenter::v1::ListReportsRequest request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::ListReports");
  internal::OTelScope scope(span);
  auto sr = child_->ListReports(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::migrationcenter::v1::Report>(std::move(span),
                                                  std::move(sr));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeleteReport(
    google::cloud::migrationcenter::v1::DeleteReportRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteReport");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteReport(request));
}

StatusOr<google::longrunning::Operation>
MigrationCenterTracingConnection::DeleteReport(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeleteReportRequest const& request) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteReport");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteReport(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterTracingConnection::DeleteReport(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "migrationcenter_v1::MigrationCenterConnection::DeleteReport");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteReport(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<migrationcenter_v1::MigrationCenterConnection>
MakeMigrationCenterTracingConnection(
    std::shared_ptr<migrationcenter_v1::MigrationCenterConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<MigrationCenterTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace migrationcenter_v1_internal
}  // namespace cloud
}  // namespace google
