// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/environment.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_ENVIRONMENTS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_ENVIRONMENTS_TRACING_CONNECTION_H

#include "google/cloud/dialogflow_cx/environments_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class EnvironmentsTracingConnection
    : public dialogflow_cx::EnvironmentsConnection {
 public:
  ~EnvironmentsTracingConnection() override = default;

  explicit EnvironmentsTracingConnection(
      std::shared_ptr<dialogflow_cx::EnvironmentsConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::dialogflow::cx::v3::Environment> ListEnvironments(
      google::cloud::dialogflow::cx::v3::ListEnvironmentsRequest request)
      override;

  StatusOr<google::cloud::dialogflow::cx::v3::Environment> GetEnvironment(
      google::cloud::dialogflow::cx::v3::GetEnvironmentRequest const& request)
      override;

  future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
  CreateEnvironment(
      google::cloud::dialogflow::cx::v3::CreateEnvironmentRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateEnvironment(
      NoAwaitTag,
      google::cloud::dialogflow::cx::v3::CreateEnvironmentRequest const&
          request) override;

  future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
  CreateEnvironment(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
  UpdateEnvironment(
      google::cloud::dialogflow::cx::v3::UpdateEnvironmentRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpdateEnvironment(
      NoAwaitTag,
      google::cloud::dialogflow::cx::v3::UpdateEnvironmentRequest const&
          request) override;

  future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
  UpdateEnvironment(google::longrunning::Operation const& operation) override;

  Status DeleteEnvironment(
      google::cloud::dialogflow::cx::v3::DeleteEnvironmentRequest const&
          request) override;

  StreamRange<google::cloud::dialogflow::cx::v3::Environment>
  LookupEnvironmentHistory(
      google::cloud::dialogflow::cx::v3::LookupEnvironmentHistoryRequest
          request) override;

  future<StatusOr<google::cloud::dialogflow::cx::v3::RunContinuousTestResponse>>
  RunContinuousTest(
      google::cloud::dialogflow::cx::v3::RunContinuousTestRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> RunContinuousTest(
      NoAwaitTag,
      google::cloud::dialogflow::cx::v3::RunContinuousTestRequest const&
          request) override;

  future<StatusOr<google::cloud::dialogflow::cx::v3::RunContinuousTestResponse>>
  RunContinuousTest(google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::dialogflow::cx::v3::ContinuousTestResult>
  ListContinuousTestResults(
      google::cloud::dialogflow::cx::v3::ListContinuousTestResultsRequest
          request) override;

  future<StatusOr<google::cloud::dialogflow::cx::v3::DeployFlowResponse>>
  DeployFlow(google::cloud::dialogflow::cx::v3::DeployFlowRequest const&
                 request) override;

  StatusOr<google::longrunning::Operation> DeployFlow(
      NoAwaitTag,
      google::cloud::dialogflow::cx::v3::DeployFlowRequest const& request)
      override;

  future<StatusOr<google::cloud::dialogflow::cx::v3::DeployFlowResponse>>
  DeployFlow(google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<dialogflow_cx::EnvironmentsConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<dialogflow_cx::EnvironmentsConnection>
MakeEnvironmentsTracingConnection(
    std::shared_ptr<dialogflow_cx::EnvironmentsConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_ENVIRONMENTS_TRACING_CONNECTION_H
