// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/instant_snapshots/v1/instant_snapshots.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INSTANT_SNAPSHOTS_V1_INTERNAL_INSTANT_SNAPSHOTS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INSTANT_SNAPSHOTS_V1_INTERNAL_INSTANT_SNAPSHOTS_TRACING_CONNECTION_H

#include "google/cloud/compute/instant_snapshots/v1/instant_snapshots_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_instant_snapshots_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class InstantSnapshotsTracingConnection
    : public compute_instant_snapshots_v1::InstantSnapshotsConnection {
 public:
  ~InstantSnapshotsTracingConnection() override = default;

  explicit InstantSnapshotsTracingConnection(
      std::shared_ptr<compute_instant_snapshots_v1::InstantSnapshotsConnection>
          child);

  Options options() override { return child_->options(); }

  StreamRange<std::pair<
      std::string, google::cloud::cpp::compute::v1::InstantSnapshotsScopedList>>
  AggregatedListInstantSnapshots(
      google::cloud::cpp::compute::instant_snapshots::v1::
          AggregatedListInstantSnapshotsRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteInstantSnapshot(
      google::cloud::cpp::compute::instant_snapshots::v1::
          DeleteInstantSnapshotRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> DeleteInstantSnapshot(
      NoAwaitTag, google::cloud::cpp::compute::instant_snapshots::v1::
                      DeleteInstantSnapshotRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteInstantSnapshot(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StatusOr<google::cloud::cpp::compute::v1::InstantSnapshot> GetInstantSnapshot(
      google::cloud::cpp::compute::instant_snapshots::v1::
          GetInstantSnapshotRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Policy> GetIamPolicy(
      google::cloud::cpp::compute::instant_snapshots::v1::
          GetIamPolicyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertInstantSnapshot(
      google::cloud::cpp::compute::instant_snapshots::v1::
          InsertInstantSnapshotRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> InsertInstantSnapshot(
      NoAwaitTag, google::cloud::cpp::compute::instant_snapshots::v1::
                      InsertInstantSnapshotRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertInstantSnapshot(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StreamRange<google::cloud::cpp::compute::v1::InstantSnapshot>
  ListInstantSnapshots(google::cloud::cpp::compute::instant_snapshots::v1::
                           ListInstantSnapshotsRequest request) override;

  StatusOr<google::cloud::cpp::compute::v1::Policy> SetIamPolicy(
      google::cloud::cpp::compute::instant_snapshots::v1::
          SetIamPolicyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetLabels(
      google::cloud::cpp::compute::instant_snapshots::v1::
          SetLabelsRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> SetLabels(
      NoAwaitTag, google::cloud::cpp::compute::instant_snapshots::v1::
                      SetLabelsRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetLabels(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
  TestIamPermissions(google::cloud::cpp::compute::instant_snapshots::v1::
                         TestIamPermissionsRequest const& request) override;

 private:
  std::shared_ptr<compute_instant_snapshots_v1::InstantSnapshotsConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<compute_instant_snapshots_v1::InstantSnapshotsConnection>
MakeInstantSnapshotsTracingConnection(
    std::shared_ptr<compute_instant_snapshots_v1::InstantSnapshotsConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instant_snapshots_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INSTANT_SNAPSHOTS_V1_INTERNAL_INSTANT_SNAPSHOTS_TRACING_CONNECTION_H
