// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/core.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_INTERNAL_CLOUD_CONTROLS_PARTNER_CORE_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_INTERNAL_CLOUD_CONTROLS_PARTNER_CORE_TRACING_CONNECTION_H

#include "google/cloud/cloudcontrolspartner/v1/cloud_controls_partner_core_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class CloudControlsPartnerCoreTracingConnection
    : public cloudcontrolspartner_v1::CloudControlsPartnerCoreConnection {
 public:
  ~CloudControlsPartnerCoreTracingConnection() override = default;

  explicit CloudControlsPartnerCoreTracingConnection(
      std::shared_ptr<
          cloudcontrolspartner_v1::CloudControlsPartnerCoreConnection>
          child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::cloudcontrolspartner::v1::Workload> GetWorkload(
      google::cloud::cloudcontrolspartner::v1::GetWorkloadRequest const&
          request) override;

  StreamRange<google::cloud::cloudcontrolspartner::v1::Workload> ListWorkloads(
      google::cloud::cloudcontrolspartner::v1::ListWorkloadsRequest request)
      override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::Customer> GetCustomer(
      google::cloud::cloudcontrolspartner::v1::GetCustomerRequest const&
          request) override;

  StreamRange<google::cloud::cloudcontrolspartner::v1::Customer> ListCustomers(
      google::cloud::cloudcontrolspartner::v1::ListCustomersRequest request)
      override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::EkmConnections>
  GetEkmConnections(
      google::cloud::cloudcontrolspartner::v1::GetEkmConnectionsRequest const&
          request) override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::PartnerPermissions>
  GetPartnerPermissions(
      google::cloud::cloudcontrolspartner::v1::
          GetPartnerPermissionsRequest const& request) override;

  StreamRange<google::cloud::cloudcontrolspartner::v1::AccessApprovalRequest>
  ListAccessApprovalRequests(
      google::cloud::cloudcontrolspartner::v1::ListAccessApprovalRequestsRequest
          request) override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::Partner> GetPartner(
      google::cloud::cloudcontrolspartner::v1::GetPartnerRequest const& request)
      override;

 private:
  std::shared_ptr<cloudcontrolspartner_v1::CloudControlsPartnerCoreConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<cloudcontrolspartner_v1::CloudControlsPartnerCoreConnection>
MakeCloudControlsPartnerCoreTracingConnection(
    std::shared_ptr<cloudcontrolspartner_v1::CloudControlsPartnerCoreConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_INTERNAL_CLOUD_CONTROLS_PARTNER_CORE_TRACING_CONNECTION_H
