// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/apikeys/v2/apikeys.proto

#include "google/cloud/apikeys/v2/internal/api_keys_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace apikeys_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ApiKeysTracingConnection::ApiKeysTracingConnection(
    std::shared_ptr<apikeys_v2::ApiKeysConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::api::apikeys::v2::Key>>
ApiKeysTracingConnection::CreateKey(
    google::api::apikeys::v2::CreateKeyRequest const& request) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::CreateKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateKey(request));
}

StatusOr<google::longrunning::Operation> ApiKeysTracingConnection::CreateKey(
    NoAwaitTag, google::api::apikeys::v2::CreateKeyRequest const& request) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::CreateKey");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateKey(NoAwaitTag{}, request));
}

future<StatusOr<google::api::apikeys::v2::Key>>
ApiKeysTracingConnection::CreateKey(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::CreateKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateKey(operation));
}

StreamRange<google::api::apikeys::v2::Key> ApiKeysTracingConnection::ListKeys(
    google::api::apikeys::v2::ListKeysRequest request) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::ListKeys");
  internal::OTelScope scope(span);
  auto sr = child_->ListKeys(std::move(request));
  return internal::MakeTracedStreamRange<google::api::apikeys::v2::Key>(
      std::move(span), std::move(sr));
}

StatusOr<google::api::apikeys::v2::Key> ApiKeysTracingConnection::GetKey(
    google::api::apikeys::v2::GetKeyRequest const& request) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::GetKey");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetKey(request));
}

StatusOr<google::api::apikeys::v2::GetKeyStringResponse>
ApiKeysTracingConnection::GetKeyString(
    google::api::apikeys::v2::GetKeyStringRequest const& request) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::GetKeyString");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetKeyString(request));
}

future<StatusOr<google::api::apikeys::v2::Key>>
ApiKeysTracingConnection::UpdateKey(
    google::api::apikeys::v2::UpdateKeyRequest const& request) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::UpdateKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateKey(request));
}

StatusOr<google::longrunning::Operation> ApiKeysTracingConnection::UpdateKey(
    NoAwaitTag, google::api::apikeys::v2::UpdateKeyRequest const& request) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::UpdateKey");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateKey(NoAwaitTag{}, request));
}

future<StatusOr<google::api::apikeys::v2::Key>>
ApiKeysTracingConnection::UpdateKey(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::UpdateKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateKey(operation));
}

future<StatusOr<google::api::apikeys::v2::Key>>
ApiKeysTracingConnection::DeleteKey(
    google::api::apikeys::v2::DeleteKeyRequest const& request) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::DeleteKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteKey(request));
}

StatusOr<google::longrunning::Operation> ApiKeysTracingConnection::DeleteKey(
    NoAwaitTag, google::api::apikeys::v2::DeleteKeyRequest const& request) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::DeleteKey");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteKey(NoAwaitTag{}, request));
}

future<StatusOr<google::api::apikeys::v2::Key>>
ApiKeysTracingConnection::DeleteKey(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::DeleteKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteKey(operation));
}

future<StatusOr<google::api::apikeys::v2::Key>>
ApiKeysTracingConnection::UndeleteKey(
    google::api::apikeys::v2::UndeleteKeyRequest const& request) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::UndeleteKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UndeleteKey(request));
}

StatusOr<google::longrunning::Operation> ApiKeysTracingConnection::UndeleteKey(
    NoAwaitTag, google::api::apikeys::v2::UndeleteKeyRequest const& request) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::UndeleteKey");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UndeleteKey(NoAwaitTag{}, request));
}

future<StatusOr<google::api::apikeys::v2::Key>>
ApiKeysTracingConnection::UndeleteKey(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::UndeleteKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UndeleteKey(operation));
}

StatusOr<google::api::apikeys::v2::LookupKeyResponse>
ApiKeysTracingConnection::LookupKey(
    google::api::apikeys::v2::LookupKeyRequest const& request) {
  auto span = internal::MakeSpan("apikeys_v2::ApiKeysConnection::LookupKey");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->LookupKey(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<apikeys_v2::ApiKeysConnection> MakeApiKeysTracingConnection(
    std::shared_ptr<apikeys_v2::ApiKeysConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<ApiKeysTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apikeys_v2_internal
}  // namespace cloud
}  // namespace google
