// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test_request_id.proto

#include "generator/integration_tests/golden/v1/request_id_connection.h"
#include "generator/integration_tests/golden/v1/internal/request_id_connection_impl.h"
#include "generator/integration_tests/golden/v1/internal/request_id_option_defaults.h"
#include "generator/integration_tests/golden/v1/internal/request_id_stub_factory.h"
#include "generator/integration_tests/golden/v1/internal/request_id_tracing_connection.h"
#include "generator/integration_tests/golden/v1/request_id_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace golden_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RequestIdServiceConnection::~RequestIdServiceConnection() = default;

StatusOr<google::test::requestid::v1::Foo>
RequestIdServiceConnection::CreateFoo(
    google::test::requestid::v1::CreateFooRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::test::requestid::v1::Foo>>
RequestIdServiceConnection::RenameFoo(
    google::test::requestid::v1::RenameFooRequest const&) {
  return google::cloud::make_ready_future<
    StatusOr<google::test::requestid::v1::Foo>>(
    Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
RequestIdServiceConnection::RenameFoo(
    NoAwaitTag,
    google::test::requestid::v1::RenameFooRequest const&) {
  return StatusOr<google::longrunning::Operation>(
    Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::test::requestid::v1::Foo>>
RequestIdServiceConnection::RenameFoo(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
    StatusOr<google::test::requestid::v1::Foo>>(
    Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::test::requestid::v1::Foo> RequestIdServiceConnection::ListFoos(
    google::test::requestid::v1::ListFoosRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::test::requestid::v1::Foo>>();
}

future<StatusOr<google::test::requestid::v1::Foo>>
RequestIdServiceConnection::AsyncCreateFoo(
    google::test::requestid::v1::CreateFooRequest const&) {
  return google::cloud::make_ready_future<
    StatusOr<google::test::requestid::v1::Foo>>(
    Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<RequestIdServiceConnection> MakeRequestIdServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
      UnifiedCredentialsOptionList,
      RequestIdServicePolicyOptionList>(options, __func__);
  options = golden_v1_internal::RequestIdServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = golden_v1_internal::CreateDefaultRequestIdServiceStub(
    std::move(auth), options);
  return golden_v1_internal::MakeRequestIdServiceTracingConnection(
      std::make_shared<golden_v1_internal::RequestIdServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1
}  // namespace cloud
}  // namespace google
