// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test.proto

#include "generator/integration_tests/golden/v1/internal/golden_thing_admin_rest_stub.h"
#include "google/cloud/common_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/rest_stub_helpers.h"
#include "google/cloud/status_or.h"
#include <generator/integration_tests/test.pb.h>
#include <google/longrunning/operations.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DefaultGoldenThingAdminRestStub::DefaultGoldenThingAdminRestStub(Options options)
    : service_(rest_internal::MakePooledRestClient(
          options.get<EndpointOption>(), options)),
      operations_(rest_internal::MakePooledRestClient(
          options.get<rest_internal::LongrunningEndpointOption>(), options)),
      options_(std::move(options)) {}

DefaultGoldenThingAdminRestStub::DefaultGoldenThingAdminRestStub(
    std::shared_ptr<rest_internal::RestClient> service,
    std::shared_ptr<rest_internal::RestClient> operations,
    Options options)
    : service_(std::move(service)),
      operations_(std::move(operations)),
      options_(std::move(options)) {}

StatusOr<google::test::admin::database::v1::ListDatabasesResponse>
DefaultGoldenThingAdminRestStub::ListDatabases(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::ListDatabasesRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  query_params.push_back({"page_size", std::to_string(request.page_size())});
  query_params.push_back({"page_token", request.page_token()});
  query_params = rest_internal::TrimEmptyQueryParameters(std::move(query_params));
  return rest_internal::Get<google::test::admin::database::v1::ListDatabasesResponse>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.parent(), "/", "databases"), std::move(query_params));
}

future<StatusOr<google::longrunning::Operation>>
DefaultGoldenThingAdminRestStub::AsyncCreateDatabase(
      CompletionQueue& cq,
      std::unique_ptr<rest_internal::RestContext> rest_context,
      google::cloud::internal::ImmutableOptions options,
      google::test::admin::database::v1::CreateDatabaseRequest const& request) {
  promise<StatusOr<google::longrunning::Operation>> p;
  future<StatusOr<google::longrunning::Operation>> f = p.get_future();
  std::thread t{[](
          auto p, auto service, auto request, auto rest_context, auto options) {
      std::vector<std::pair<std::string, std::string>> query_params;
      p.set_value(rest_internal::Post<google::longrunning::Operation>(
          *service, *rest_context, request,
          false,
          absl::StrCat("/", rest_internal::DetermineApiVersion("v1", *options), "/", request.parent(), "/", "databases"), std::move(query_params)));
    },
    std::move(p), service_, request, std::move(rest_context),
    std::move(options)};
  return f.then([t = std::move(t), cq](auto f) mutable {
    cq.RunAsync([t = std::move(t)]() mutable {
      t.join();
    });
    return f.get();
  });
}

StatusOr<google::longrunning::Operation>
DefaultGoldenThingAdminRestStub::CreateDatabase(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::CreateDatabaseRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Post<google::longrunning::Operation>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.parent(), "/", "databases"), std::move(query_params));
}

StatusOr<google::test::admin::database::v1::Database>
DefaultGoldenThingAdminRestStub::GetDatabase(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::GetDatabaseRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Get<google::test::admin::database::v1::Database>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.name()), std::move(query_params));
}

future<StatusOr<google::longrunning::Operation>>
DefaultGoldenThingAdminRestStub::AsyncUpdateDatabaseDdl(
      CompletionQueue& cq,
      std::unique_ptr<rest_internal::RestContext> rest_context,
      google::cloud::internal::ImmutableOptions options,
      google::test::admin::database::v1::UpdateDatabaseDdlRequest const& request) {
  promise<StatusOr<google::longrunning::Operation>> p;
  future<StatusOr<google::longrunning::Operation>> f = p.get_future();
  std::thread t{[](
          auto p, auto service, auto request, auto rest_context, auto options) {
      std::vector<std::pair<std::string, std::string>> query_params;
      p.set_value(rest_internal::Patch<google::longrunning::Operation>(
          *service, *rest_context, request,
          false,
          absl::StrCat("/", rest_internal::DetermineApiVersion("v1", *options), "/", request.database(), "/", "ddl"), std::move(query_params)));
    },
    std::move(p), service_, request, std::move(rest_context),
    std::move(options)};
  return f.then([t = std::move(t), cq](auto f) mutable {
    cq.RunAsync([t = std::move(t)]() mutable {
      t.join();
    });
    return f.get();
  });
}

StatusOr<google::longrunning::Operation>
DefaultGoldenThingAdminRestStub::UpdateDatabaseDdl(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::UpdateDatabaseDdlRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Patch<google::longrunning::Operation>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.database(), "/", "ddl"), std::move(query_params));
}

Status DefaultGoldenThingAdminRestStub::DropDatabase(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::DropDatabaseRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Delete<google::cloud::rest_internal::EmptyResponseType>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.database()), std::move(query_params));
}

StatusOr<google::test::admin::database::v1::GetDatabaseDdlResponse>
DefaultGoldenThingAdminRestStub::GetDatabaseDdl(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::GetDatabaseDdlRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Get<google::test::admin::database::v1::GetDatabaseDdlResponse>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.database(), "/", "ddl"), std::move(query_params));
}

StatusOr<google::iam::v1::Policy>
DefaultGoldenThingAdminRestStub::SetIamPolicy(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::iam::v1::SetIamPolicyRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Post<google::iam::v1::Policy>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.resource(), ":setIamPolicy"), std::move(query_params));
}

StatusOr<google::iam::v1::Policy>
DefaultGoldenThingAdminRestStub::GetIamPolicy(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::iam::v1::GetIamPolicyRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Post<google::iam::v1::Policy>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.resource(), ":getIamPolicy"), std::move(query_params));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DefaultGoldenThingAdminRestStub::TestIamPermissions(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::iam::v1::TestIamPermissionsRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Post<google::iam::v1::TestIamPermissionsResponse>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.resource(), ":testIamPermissions"), std::move(query_params));
}

future<StatusOr<google::longrunning::Operation>>
DefaultGoldenThingAdminRestStub::AsyncCreateBackup(
      CompletionQueue& cq,
      std::unique_ptr<rest_internal::RestContext> rest_context,
      google::cloud::internal::ImmutableOptions options,
      google::test::admin::database::v1::CreateBackupRequest const& request) {
  promise<StatusOr<google::longrunning::Operation>> p;
  future<StatusOr<google::longrunning::Operation>> f = p.get_future();
  std::thread t{[](
          auto p, auto service, auto request, auto rest_context, auto options) {
      std::vector<std::pair<std::string, std::string>> query_params;
  query_params.push_back({"backup_id", request.backup_id()});
  query_params = rest_internal::TrimEmptyQueryParameters(std::move(query_params));
      p.set_value(rest_internal::Post<google::longrunning::Operation>(
          *service, *rest_context, request.backup(),
          false,
          absl::StrCat("/", rest_internal::DetermineApiVersion("v1", *options), "/", request.parent(), "/", "backups"), std::move(query_params)));
    },
    std::move(p), service_, request, std::move(rest_context),
    std::move(options)};
  return f.then([t = std::move(t), cq](auto f) mutable {
    cq.RunAsync([t = std::move(t)]() mutable {
      t.join();
    });
    return f.get();
  });
}

StatusOr<google::longrunning::Operation>
DefaultGoldenThingAdminRestStub::CreateBackup(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::CreateBackupRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  query_params.push_back({"backup_id", request.backup_id()});
  query_params = rest_internal::TrimEmptyQueryParameters(std::move(query_params));
  return rest_internal::Post<google::longrunning::Operation>(
      *service_, rest_context, request.backup(), false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.parent(), "/", "backups"), std::move(query_params));
}

StatusOr<google::test::admin::database::v1::Backup>
DefaultGoldenThingAdminRestStub::GetBackup(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::GetBackupRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Get<google::test::admin::database::v1::Backup>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.name()), std::move(query_params));
}

StatusOr<google::test::admin::database::v1::Backup>
DefaultGoldenThingAdminRestStub::UpdateBackup(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::UpdateBackupRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Patch<google::test::admin::database::v1::Backup>(
      *service_, rest_context, request.backup(), false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.backup().name()), std::move(query_params));
}

Status DefaultGoldenThingAdminRestStub::DeleteBackup(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::DeleteBackupRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Delete<google::cloud::rest_internal::EmptyResponseType>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.name()), std::move(query_params));
}

StatusOr<google::test::admin::database::v1::ListBackupsResponse>
DefaultGoldenThingAdminRestStub::ListBackups(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::ListBackupsRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  query_params.push_back({"filter", request.filter()});
  query_params.push_back({"page_size", std::to_string(request.page_size())});
  query_params.push_back({"page_token", request.page_token()});
  query_params = rest_internal::TrimEmptyQueryParameters(std::move(query_params));
  return rest_internal::Get<google::test::admin::database::v1::ListBackupsResponse>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.parent(), "/", "backups"), std::move(query_params));
}

future<StatusOr<google::longrunning::Operation>>
DefaultGoldenThingAdminRestStub::AsyncRestoreDatabase(
      CompletionQueue& cq,
      std::unique_ptr<rest_internal::RestContext> rest_context,
      google::cloud::internal::ImmutableOptions options,
      google::test::admin::database::v1::RestoreDatabaseRequest const& request) {
  promise<StatusOr<google::longrunning::Operation>> p;
  future<StatusOr<google::longrunning::Operation>> f = p.get_future();
  std::thread t{[](
          auto p, auto service, auto request, auto rest_context, auto options) {
      std::vector<std::pair<std::string, std::string>> query_params;
      p.set_value(rest_internal::Post<google::longrunning::Operation>(
          *service, *rest_context, request,
          false,
          absl::StrCat("/", rest_internal::DetermineApiVersion("v1", *options), "/", request.parent(), "/", "databases", ":restore"), std::move(query_params)));
    },
    std::move(p), service_, request, std::move(rest_context),
    std::move(options)};
  return f.then([t = std::move(t), cq](auto f) mutable {
    cq.RunAsync([t = std::move(t)]() mutable {
      t.join();
    });
    return f.get();
  });
}

StatusOr<google::longrunning::Operation>
DefaultGoldenThingAdminRestStub::RestoreDatabase(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::RestoreDatabaseRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  return rest_internal::Post<google::longrunning::Operation>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.parent(), "/", "databases", ":restore"), std::move(query_params));
}

StatusOr<google::test::admin::database::v1::ListDatabaseOperationsResponse>
DefaultGoldenThingAdminRestStub::ListDatabaseOperations(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::ListDatabaseOperationsRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  query_params.push_back({"filter", request.filter()});
  query_params.push_back({"page_size", std::to_string(request.page_size())});
  query_params.push_back({"page_token", request.page_token()});
  query_params = rest_internal::TrimEmptyQueryParameters(std::move(query_params));
  return rest_internal::Get<google::test::admin::database::v1::ListDatabaseOperationsResponse>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.parent(), "/", "databaseOperations"), std::move(query_params));
}

StatusOr<google::test::admin::database::v1::ListBackupOperationsResponse>
DefaultGoldenThingAdminRestStub::ListBackupOperations(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::test::admin::database::v1::ListBackupOperationsRequest const& request) {
  std::vector<std::pair<std::string, std::string>> query_params;
  query_params.push_back({"filter", request.filter()});
  query_params.push_back({"page_size", std::to_string(request.page_size())});
  query_params.push_back({"page_token", request.page_token()});
  query_params = rest_internal::TrimEmptyQueryParameters(std::move(query_params));
  return rest_internal::Get<google::test::admin::database::v1::ListBackupOperationsResponse>(
      *service_, rest_context, request, false,
      absl::StrCat("/", rest_internal::DetermineApiVersion("v1", options), "/", request.parent(), "/", "backupOperations"), std::move(query_params));
}

future<StatusOr<google::test::admin::database::v1::Database>>
DefaultGoldenThingAdminRestStub::AsyncGetDatabase(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::test::admin::database::v1::GetDatabaseRequest const& request) {
  promise<StatusOr<google::test::admin::database::v1::Database>> p;
  future<StatusOr<google::test::admin::database::v1::Database>> f = p.get_future();
  std::thread t{[](
          auto p, auto service, auto request, auto rest_context, auto options) {
      std::vector<std::pair<std::string, std::string>> query_params;
      p.set_value(rest_internal::Get<google::test::admin::database::v1::Database>(
          *service, *rest_context, request, false,
          absl::StrCat("/", rest_internal::DetermineApiVersion("v1", *options), "/", request.name()), std::move(query_params)));
    },
    std::move(p), service_, request, std::move(rest_context),
    std::move(options)};
  return f.then([t = std::move(t), cq](auto f) mutable {
    cq.RunAsync([t = std::move(t)]() mutable {
      t.join();
    });
    return f.get();
  });
}

future<Status>
DefaultGoldenThingAdminRestStub::AsyncDropDatabase(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::test::admin::database::v1::DropDatabaseRequest const& request) {
  promise<StatusOr<google::protobuf::Empty>> p;
  future<StatusOr<google::protobuf::Empty>> f = p.get_future();
  std::thread t{[](
          auto p, auto service, auto request, auto rest_context, auto options) {
      std::vector<std::pair<std::string, std::string>> query_params;
      p.set_value(rest_internal::Delete<google::protobuf::Empty>(
          *service, *rest_context, request, false,
          absl::StrCat("/", rest_internal::DetermineApiVersion("v1", *options), "/", request.database()), std::move(query_params)));
    },
    std::move(p), service_, request, std::move(rest_context),
    std::move(options)};
  return f.then([t = std::move(t), cq](auto f) mutable {
    cq.RunAsync([t = std::move(t)]() mutable {
      t.join();
    });
    return f.get().status();
  });
}

future<StatusOr<google::longrunning::Operation>>
DefaultGoldenThingAdminRestStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  promise<StatusOr<google::longrunning::Operation>> p;
  future<StatusOr<google::longrunning::Operation>> f = p.get_future();
  std::thread t{[](auto p, auto operations, auto request, auto rest_context, auto options) {
      p.set_value(rest_internal::Get<google::longrunning::Operation>(
          *operations, *rest_context, request, false,
          absl::StrCat("/", rest_internal::DetermineApiVersion("v1", *options) ,"/", request.name())));
    },
    std::move(p), operations_, request, std::move(rest_context),
    std::move(options)};
  return f.then([t = std::move(t), cq](auto f) mutable {
    cq.RunAsync([t = std::move(t)]() mutable {
      t.join();
    });
    return f.get();
  });
}

future<Status>
DefaultGoldenThingAdminRestStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  promise<StatusOr<google::protobuf::Empty>> p;
  future<StatusOr<google::protobuf::Empty>> f = p.get_future();
  std::thread t{[](auto p, auto operations, auto request, auto rest_context, auto options) {
      p.set_value(rest_internal::Post<google::protobuf::Empty>(
          *operations, *rest_context, request, false,
          absl::StrCat("/", rest_internal::DetermineApiVersion("v1", *options) ,"/", request.name(), ":cancel")));
    },
    std::move(p), operations_, request, std::move(rest_context),
    std::move(options)};
  return f.then([t = std::move(t), cq](auto f) mutable {
    cq.RunAsync([t = std::move(t)]() mutable {
      t.join();
    });
    return f.get().status();
  });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google
