// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllLogTargetLogForwardOKCode is the HTTP code returned for type ReplaceAllLogTargetLogForwardOK
const ReplaceAllLogTargetLogForwardOKCode int = 200

/*
ReplaceAllLogTargetLogForwardOK All Log Target lines replaced

swagger:response replaceAllLogTargetLogForwardOK
*/
type ReplaceAllLogTargetLogForwardOK struct {

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewReplaceAllLogTargetLogForwardOK creates ReplaceAllLogTargetLogForwardOK with default headers values
func NewReplaceAllLogTargetLogForwardOK() *ReplaceAllLogTargetLogForwardOK {

	return &ReplaceAllLogTargetLogForwardOK{}
}

// WithPayload adds the payload to the replace all log target log forward o k response
func (o *ReplaceAllLogTargetLogForwardOK) WithPayload(payload models.LogTargets) *ReplaceAllLogTargetLogForwardOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target log forward o k response
func (o *ReplaceAllLogTargetLogForwardOK) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetLogForwardOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllLogTargetLogForwardAcceptedCode is the HTTP code returned for type ReplaceAllLogTargetLogForwardAccepted
const ReplaceAllLogTargetLogForwardAcceptedCode int = 202

/*
ReplaceAllLogTargetLogForwardAccepted Configuration change accepted and reload requested

swagger:response replaceAllLogTargetLogForwardAccepted
*/
type ReplaceAllLogTargetLogForwardAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewReplaceAllLogTargetLogForwardAccepted creates ReplaceAllLogTargetLogForwardAccepted with default headers values
func NewReplaceAllLogTargetLogForwardAccepted() *ReplaceAllLogTargetLogForwardAccepted {

	return &ReplaceAllLogTargetLogForwardAccepted{}
}

// WithReloadID adds the reloadId to the replace all log target log forward accepted response
func (o *ReplaceAllLogTargetLogForwardAccepted) WithReloadID(reloadID string) *ReplaceAllLogTargetLogForwardAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all log target log forward accepted response
func (o *ReplaceAllLogTargetLogForwardAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all log target log forward accepted response
func (o *ReplaceAllLogTargetLogForwardAccepted) WithPayload(payload models.LogTargets) *ReplaceAllLogTargetLogForwardAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target log forward accepted response
func (o *ReplaceAllLogTargetLogForwardAccepted) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetLogForwardAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllLogTargetLogForwardBadRequestCode is the HTTP code returned for type ReplaceAllLogTargetLogForwardBadRequest
const ReplaceAllLogTargetLogForwardBadRequestCode int = 400

/*
ReplaceAllLogTargetLogForwardBadRequest Bad request

swagger:response replaceAllLogTargetLogForwardBadRequest
*/
type ReplaceAllLogTargetLogForwardBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllLogTargetLogForwardBadRequest creates ReplaceAllLogTargetLogForwardBadRequest with default headers values
func NewReplaceAllLogTargetLogForwardBadRequest() *ReplaceAllLogTargetLogForwardBadRequest {

	return &ReplaceAllLogTargetLogForwardBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all log target log forward bad request response
func (o *ReplaceAllLogTargetLogForwardBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllLogTargetLogForwardBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all log target log forward bad request response
func (o *ReplaceAllLogTargetLogForwardBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all log target log forward bad request response
func (o *ReplaceAllLogTargetLogForwardBadRequest) WithPayload(payload *models.Error) *ReplaceAllLogTargetLogForwardBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target log forward bad request response
func (o *ReplaceAllLogTargetLogForwardBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetLogForwardBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllLogTargetLogForwardDefault General Error

swagger:response replaceAllLogTargetLogForwardDefault
*/
type ReplaceAllLogTargetLogForwardDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllLogTargetLogForwardDefault creates ReplaceAllLogTargetLogForwardDefault with default headers values
func NewReplaceAllLogTargetLogForwardDefault(code int) *ReplaceAllLogTargetLogForwardDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllLogTargetLogForwardDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all log target log forward default response
func (o *ReplaceAllLogTargetLogForwardDefault) WithStatusCode(code int) *ReplaceAllLogTargetLogForwardDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all log target log forward default response
func (o *ReplaceAllLogTargetLogForwardDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all log target log forward default response
func (o *ReplaceAllLogTargetLogForwardDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllLogTargetLogForwardDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all log target log forward default response
func (o *ReplaceAllLogTargetLogForwardDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all log target log forward default response
func (o *ReplaceAllLogTargetLogForwardDefault) WithPayload(payload *models.Error) *ReplaceAllLogTargetLogForwardDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target log forward default response
func (o *ReplaceAllLogTargetLogForwardDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetLogForwardDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
