// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceHTTPRequestRuleBackendOKCode is the HTTP code returned for type ReplaceHTTPRequestRuleBackendOK
const ReplaceHTTPRequestRuleBackendOKCode int = 200

/*
ReplaceHTTPRequestRuleBackendOK HTTP Request Rule replaced

swagger:response replaceHttpRequestRuleBackendOK
*/
type ReplaceHTTPRequestRuleBackendOK struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPRequestRule `json:"body,omitempty"`
}

// NewReplaceHTTPRequestRuleBackendOK creates ReplaceHTTPRequestRuleBackendOK with default headers values
func NewReplaceHTTPRequestRuleBackendOK() *ReplaceHTTPRequestRuleBackendOK {

	return &ReplaceHTTPRequestRuleBackendOK{}
}

// WithPayload adds the payload to the replace Http request rule backend o k response
func (o *ReplaceHTTPRequestRuleBackendOK) WithPayload(payload *models.HTTPRequestRule) *ReplaceHTTPRequestRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http request rule backend o k response
func (o *ReplaceHTTPRequestRuleBackendOK) SetPayload(payload *models.HTTPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPRequestRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPRequestRuleBackendAcceptedCode is the HTTP code returned for type ReplaceHTTPRequestRuleBackendAccepted
const ReplaceHTTPRequestRuleBackendAcceptedCode int = 202

/*
ReplaceHTTPRequestRuleBackendAccepted Configuration change accepted and reload requested

swagger:response replaceHttpRequestRuleBackendAccepted
*/
type ReplaceHTTPRequestRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPRequestRule `json:"body,omitempty"`
}

// NewReplaceHTTPRequestRuleBackendAccepted creates ReplaceHTTPRequestRuleBackendAccepted with default headers values
func NewReplaceHTTPRequestRuleBackendAccepted() *ReplaceHTTPRequestRuleBackendAccepted {

	return &ReplaceHTTPRequestRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace Http request rule backend accepted response
func (o *ReplaceHTTPRequestRuleBackendAccepted) WithReloadID(reloadID string) *ReplaceHTTPRequestRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Http request rule backend accepted response
func (o *ReplaceHTTPRequestRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Http request rule backend accepted response
func (o *ReplaceHTTPRequestRuleBackendAccepted) WithPayload(payload *models.HTTPRequestRule) *ReplaceHTTPRequestRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http request rule backend accepted response
func (o *ReplaceHTTPRequestRuleBackendAccepted) SetPayload(payload *models.HTTPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPRequestRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPRequestRuleBackendBadRequestCode is the HTTP code returned for type ReplaceHTTPRequestRuleBackendBadRequest
const ReplaceHTTPRequestRuleBackendBadRequestCode int = 400

/*
ReplaceHTTPRequestRuleBackendBadRequest Bad request

swagger:response replaceHttpRequestRuleBackendBadRequest
*/
type ReplaceHTTPRequestRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPRequestRuleBackendBadRequest creates ReplaceHTTPRequestRuleBackendBadRequest with default headers values
func NewReplaceHTTPRequestRuleBackendBadRequest() *ReplaceHTTPRequestRuleBackendBadRequest {

	return &ReplaceHTTPRequestRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http request rule backend bad request response
func (o *ReplaceHTTPRequestRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPRequestRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http request rule backend bad request response
func (o *ReplaceHTTPRequestRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http request rule backend bad request response
func (o *ReplaceHTTPRequestRuleBackendBadRequest) WithPayload(payload *models.Error) *ReplaceHTTPRequestRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http request rule backend bad request response
func (o *ReplaceHTTPRequestRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPRequestRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPRequestRuleBackendNotFoundCode is the HTTP code returned for type ReplaceHTTPRequestRuleBackendNotFound
const ReplaceHTTPRequestRuleBackendNotFoundCode int = 404

/*
ReplaceHTTPRequestRuleBackendNotFound The specified resource was not found

swagger:response replaceHttpRequestRuleBackendNotFound
*/
type ReplaceHTTPRequestRuleBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPRequestRuleBackendNotFound creates ReplaceHTTPRequestRuleBackendNotFound with default headers values
func NewReplaceHTTPRequestRuleBackendNotFound() *ReplaceHTTPRequestRuleBackendNotFound {

	return &ReplaceHTTPRequestRuleBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http request rule backend not found response
func (o *ReplaceHTTPRequestRuleBackendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPRequestRuleBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http request rule backend not found response
func (o *ReplaceHTTPRequestRuleBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http request rule backend not found response
func (o *ReplaceHTTPRequestRuleBackendNotFound) WithPayload(payload *models.Error) *ReplaceHTTPRequestRuleBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http request rule backend not found response
func (o *ReplaceHTTPRequestRuleBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPRequestRuleBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceHTTPRequestRuleBackendDefault General Error

swagger:response replaceHttpRequestRuleBackendDefault
*/
type ReplaceHTTPRequestRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPRequestRuleBackendDefault creates ReplaceHTTPRequestRuleBackendDefault with default headers values
func NewReplaceHTTPRequestRuleBackendDefault(code int) *ReplaceHTTPRequestRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceHTTPRequestRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace HTTP request rule backend default response
func (o *ReplaceHTTPRequestRuleBackendDefault) WithStatusCode(code int) *ReplaceHTTPRequestRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace HTTP request rule backend default response
func (o *ReplaceHTTPRequestRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace HTTP request rule backend default response
func (o *ReplaceHTTPRequestRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPRequestRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace HTTP request rule backend default response
func (o *ReplaceHTTPRequestRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace HTTP request rule backend default response
func (o *ReplaceHTTPRequestRuleBackendDefault) WithPayload(payload *models.Error) *ReplaceHTTPRequestRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace HTTP request rule backend default response
func (o *ReplaceHTTPRequestRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPRequestRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
